/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CapturingInClosureCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J&\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "checkFieldInExactlyOnceLambdaInitialization", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "nameElement", "getCalleeDescriptorAndParameter", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getCaptureKind", "Lorg/jetbrains/kotlin/types/expressions/CaptureKind;", "variableParent", "isArgument", "", "isCapturedVariable", "isCatchBlockParameter", "isCrossinlineParameter", "isExactlyOnceContract", "isExactlyOnceParameter", "function", "parameter", "isForLoopParameter", "isLhsOfAssignment", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isValInWhen", "frontend"})
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        VariableDescriptor variableDescriptor;
        Object obj;
        ResolvedCall<?> variableResolvedCall;
        ResolvedCall<?> resolvedCall3;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ResolvedCall<?> resolvedCall4 = resolvedCall2;
        if (!(resolvedCall4 instanceof VariableAsFunctionResolvedCall)) {
            resolvedCall4 = null;
        }
        if ((resolvedCall3 = (VariableAsFunctionResolvedCall)((Object)resolvedCall4)) == null || (resolvedCall3 = resolvedCall3.getVariableCall()) == null) {
            resolvedCall3 = variableResolvedCall = resolvedCall2;
        }
        if (!((obj = variableResolvedCall.getResultingDescriptor()) instanceof VariableDescriptor)) {
            obj = null;
        }
        if ((variableDescriptor = (VariableDescriptor)obj) != null) {
            this.checkCapturingInClosure(variableDescriptor, context2.getTrace(), context2.getScope());
            this.checkFieldInExactlyOnceLambdaInitialization(variableDescriptor, context2.getTrace(), context2.getScope().getOwnerDescriptor(), reportOn);
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable2, BindingTrace trace, LexicalScope scope2) {
        DeclarationDescriptor declarationDescriptor = variable2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"variable.containingDeclaration");
        DeclarationDescriptor variableParent = declarationDescriptor;
        DeclarationDescriptor scopeContainer = scope2.getOwnerDescriptor();
        if (this.isCapturedVariable(variableParent, scopeContainer) && (CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable2)) != CaptureKind.NOT_INLINE) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable2, this.getCaptureKind(bindingContext, scopeContainer, variableParent, variable2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFieldInExactlyOnceLambdaInitialization(VariableDescriptor variable2, BindingTrace trace, DeclarationDescriptor scopeContainer, PsiElement nameElement) {
        void callee;
        if (!(variable2 instanceof PropertyDescriptor) || !(scopeContainer instanceof AnonymousFunctionDescriptor) || ((PropertyDescriptor)variable2).isVar()) {
            return;
        }
        PsiElement psiElement = nameElement;
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        if (!this.isLhsOfAssignment((KtExpression)psiElement)) {
            return;
        }
        PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!(psiElement2 instanceof KtFunction)) {
            psiElement2 = null;
        }
        KtFunction ktFunction = (KtFunction)psiElement2;
        if (ktFunction == null) {
            return;
        }
        KtFunction scopeDeclaration = ktFunction;
        if (!(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof ConstructorDescriptor) && !(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof PropertyDescriptor)) {
            return;
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        if (!this.isExactlyOnceContract(bindingContext, scopeDeclaration)) {
            return;
        }
        if ((CaptureKind)((Object)trace.getBindingContext().get(BindingContext.CAPTURED_IN_CLOSURE, variable2)) == CaptureKind.NOT_INLINE) {
            return;
        }
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext2, scopeDeclaration);
        if (pair == null) {
            return;
        }
        Pair<CallableDescriptor, ValueParameterDescriptor> pair2 = pair;
        CallableDescriptor callableDescriptor = (CallableDescriptor)pair2.component1();
        ValueParameterDescriptor param = (ValueParameterDescriptor)pair2.component2();
        if (!(callee instanceof FunctionDescriptor)) {
            return;
        }
        if (!((FunctionDescriptor)callee).isInline() || param.isCrossinline() || !InlineUtil.isInlineParameter(param)) {
            trace.report(Errors.CAPTURED_VAL_INITIALIZATION.on((KtExpression)nameElement, variable2));
        }
    }

    private final boolean isLhsOfAssignment(KtExpression nameElement) {
        PsiElement psiElement = nameElement.getParent();
        if (!(psiElement instanceof KtBinaryExpression)) {
            psiElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression parent2 = ktBinaryExpression;
        return Intrinsics.areEqual((Object)parent2.getOperationToken(), (Object)KtTokens.EQ) && Intrinsics.areEqual((Object)parent2.getLeft(), (Object)nameElement);
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)scopeContainer, (Object)variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"variableParent.containingDeclaration");
            ClassifierDescriptorWithTypeParameters classDescriptor2 = classifierDescriptorWithTypeParameters;
            if (Intrinsics.areEqual((Object)scopeContainer, (Object)classDescriptor2)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)scopeContainer).getContainingDeclaration(), (Object)classDescriptor2)) {
                return false;
            }
        }
        return true;
    }

    private final CaptureKind getCaptureKind(BindingContext context2, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent, VariableDescriptor variable2) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return CaptureKind.NOT_INLINE;
        }
        PsiElement psiElement = scopeDeclaration;
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        if (InlineUtil.isInlinedArgument((KtFunction)psiElement, context2, false) && !this.isCrossinlineParameter(context2, (KtFunction)scopeDeclaration)) {
            DeclarationDescriptor declarationDescriptor = scopeContainer.getContainingDeclaration();
            if (declarationDescriptor == null) {
                String string2 = "parent is null for " + scopeContainer;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"scopeContainer.containin\u2026ull for $scopeContainer\")");
            DeclarationDescriptor scopeContainerParent = declarationDescriptor;
            return !this.isCapturedVariable(variableParent, scopeContainerParent) || this.getCaptureKind(context2, scopeContainerParent, variableParent, variable2) == CaptureKind.INLINE_ONLY ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE;
        }
        boolean exactlyOnceContract = this.isExactlyOnceContract(context2, (KtFunction)scopeDeclaration);
        if (!exactlyOnceContract) {
            return CaptureKind.NOT_INLINE;
        }
        return this.isArgument(variable2, variableParent) || CapturingInClosureCheckerKt.findDestructuredVariable(variable2, variableParent) != null || this.isForLoopParameter(variable2) || this.isCatchBlockParameter(variable2) || this.isValInWhen(variable2) ? CaptureKind.NOT_INLINE : CaptureKind.EXACTLY_ONCE_EFFECT;
    }

    private final boolean isArgument(VariableDescriptor variable2, DeclarationDescriptor variableParent) {
        return variable2 instanceof ValueParameterDescriptor && variableParent instanceof CallableDescriptor && ((CallableDescriptor)variableParent).getValueParameters().contains(variable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValInWhen(VariableDescriptor variable2) {
        VariableDescriptor variableDescriptor = variable2;
        if (!(variableDescriptor instanceof LocalVariableDescriptor)) {
            variableDescriptor = null;
        }
        LocalVariableDescriptor localVariableDescriptor = (LocalVariableDescriptor)variableDescriptor;
        SourceElement sourceElement = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        if (!(sourceElement instanceof KotlinSourceElement)) {
            sourceElement = null;
        }
        KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
        Object object = kotlinSourceElement;
        if (kotlinSourceElement == null) return false;
        KtElement ktElement = ((KotlinSourceElement)object).getPsi();
        object = ktElement;
        if (ktElement == null) return false;
        Object psi = object;
        PsiElement psiElement = psi.getParent();
        if (!(psiElement instanceof KtWhenExpression)) {
            psiElement = null;
        }
        KtWhenExpression ktWhenExpression = (KtWhenExpression)psiElement;
        if (ktWhenExpression == null) return false;
        KtWhenExpression ktWhenExpression2 = ktWhenExpression;
        boolean bl = false;
        boolean bl2 = false;
        KtWhenExpression it = ktWhenExpression2;
        boolean bl3 = false;
        if (!Intrinsics.areEqual((Object)it.getSubjectVariable(), (Object)psi)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCatchBlockParameter(VariableDescriptor variable2) {
        VariableDescriptor variableDescriptor = variable2;
        if (!(variableDescriptor instanceof LocalVariableDescriptor)) {
            variableDescriptor = null;
        }
        LocalVariableDescriptor localVariableDescriptor = (LocalVariableDescriptor)variableDescriptor;
        SourceElement sourceElement = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        if (!(sourceElement instanceof KotlinSourceElement)) {
            sourceElement = null;
        }
        KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
        Object object = kotlinSourceElement;
        if (kotlinSourceElement == null) return false;
        KtElement ktElement = ((KotlinSourceElement)object).getPsi();
        object = ktElement;
        if (ktElement == null) return false;
        Object psi = object;
        PsiElement psiElement = psi.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi.parent");
        PsiElement psiElement2 = psiElement.getParent();
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement2;
        boolean bl3 = false;
        if (!(it instanceof KtCatchClause)) return false;
        KtParameterList ktParameterList = ((KtCatchClause)it).getParameterList();
        Object object2 = ktParameterList;
        if (ktParameterList == null) return false;
        List<KtParameter> list2 = ((KtParameterList)object2).getParameters();
        object2 = list2;
        if (list2 == null) return false;
        if (!CollectionsKt.contains((Iterable)((Iterable)object2), (Object)psi)) return false;
        return true;
    }

    private final boolean isForLoopParameter(VariableDescriptor variable2) {
        Object object;
        VariableDescriptor variableDescriptor = variable2;
        if (!(variableDescriptor instanceof LocalVariableDescriptor)) {
            variableDescriptor = null;
        }
        LocalVariableDescriptor localVariableDescriptor = (LocalVariableDescriptor)variableDescriptor;
        SourceElement sourceElement = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        if (!(sourceElement instanceof KotlinSourceElement)) {
            sourceElement = null;
        }
        if ((object = (KotlinSourceElement)sourceElement) == null || (object = ((KotlinSourceElement)object).getPsi()) == null) {
            return false;
        }
        Object psi = object;
        if (psi.getParent() instanceof KtForExpression) {
            PsiElement psiElement = psi.getParent();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
            }
            KtForExpression forExpression = (KtForExpression)psiElement;
            return Intrinsics.areEqual((Object)forExpression.getLoopParameter(), (Object)psi);
        }
        if (psi.getParent() instanceof KtDestructuringDeclaration) {
            PsiElement psiElement = psi.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi.parent");
            PsiElement psiElement2 = psiElement.getParent();
            if (!(psiElement2 instanceof KtParameter)) {
                psiElement2 = null;
            }
            KtParameter ktParameter = (KtParameter)psiElement2;
            if (ktParameter == null) {
                return false;
            }
            KtParameter parameter = ktParameter;
            PsiElement psiElement3 = parameter.getParent();
            if (!(psiElement3 instanceof KtForExpression)) {
                psiElement3 = null;
            }
            KtForExpression ktForExpression = (KtForExpression)psiElement3;
            if (ktForExpression == null) {
                return false;
            }
            KtForExpression forExpression = ktForExpression;
            return Intrinsics.areEqual((Object)forExpression.getLoopParameter(), (Object)parameter);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExactlyOnceParameter(DeclarationDescriptor function2, VariableDescriptor parameter) {
        Iterator iterator2;
        block6: {
            void $this$filterIsInstanceTo$iv$iv;
            if (!(function2 instanceof CallableDescriptor)) {
                return false;
            }
            if (!(parameter instanceof ValueParameterDescriptor)) {
                return false;
            }
            Object object = (AbstractContractProvider)((CallableDescriptor)function2).getUserData(ContractProviderKey.INSTANCE);
            if (object == null || (object = ((AbstractContractProvider)object).getContractDescription()) == null) {
                return false;
            }
            Object contractDescription = object;
            Iterable $this$filterIsInstance$iv = ((ContractDescription)contractDescription).getEffects();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CallsEffectDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean bl = false;
            iterable = iterable2;
            boolean bl2 = false;
            for (Iterator iterator3 : iterable) {
                CallsEffectDeclaration it = (CallsEffectDeclaration)((Object)iterator3);
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getVariableReference().getDescriptor(), (Object)((ValueParameterDescriptor)parameter).getOriginal())) continue;
                iterator2 = iterator3;
                break block6;
            }
            iterator2 = null;
        }
        CallsEffectDeclaration callsEffectDeclaration = (CallsEffectDeclaration)((Object)iterator2);
        if (callsEffectDeclaration == null) {
            return false;
        }
        CallsEffectDeclaration effect = callsEffectDeclaration;
        return effect.getKind() == EventOccurrencesRange.EXACTLY_ONCE;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExactlyOnceContract(BindingContext bindingContext, KtFunction argument) {
        void descriptor2;
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext, argument);
        if (pair == null) {
            return false;
        }
        Pair<CallableDescriptor, ValueParameterDescriptor> pair2 = pair;
        CallableDescriptor callableDescriptor = (CallableDescriptor)pair2.component1();
        ValueParameterDescriptor parameter = (ValueParameterDescriptor)pair2.component2();
        return this.isExactlyOnceParameter((DeclarationDescriptor)descriptor2, parameter);
    }

    private final Pair<CallableDescriptor, ValueParameterDescriptor> getCalleeDescriptorAndParameter(BindingContext bindingContext, KtFunction argument) {
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent(argument);
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"KtPsiUtil.getParentCallI\u2026(argument) ?: return null");
        KtExpression call2 = ktExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        Call call3 = resolvedCall3.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call3, (String)"resolvedCall.call");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(call3, argument);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(valueArgument2);
        if (!(argumentMapping instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
        if (argumentMatch == null) {
            return null;
        }
        ArgumentMatch mapping2 = argumentMatch;
        ValueParameterDescriptor parameter = mapping2.getValueParameter();
        return TuplesKt.to((Object)descriptor2, (Object)parameter);
    }

    private final boolean isCrossinlineParameter(BindingContext bindingContext, KtFunction argument) {
        Object object = this.getCalleeDescriptorAndParameter(bindingContext, argument);
        return object != null && (object = (ValueParameterDescriptor)object.getSecond()) != null && object.isCrossinline();
    }
}

