/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/PolymorphicSignatureCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "polymorphicSignatureFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class PolymorphicSignatureCallChecker
implements CallChecker {
    @JvmField
    @NotNull
    public static final FqName polymorphicSignatureFqName;
    @NotNull
    public static final PolymorphicSignatureCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.PolymorphicSignature)) {
            return;
        }
        if (!resolvedCall2.getResultingDescriptor().getAnnotations().hasAnnotation(polymorphicSignatureFqName)) {
            return;
        }
        List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
        if (list2 == null) {
            return;
        }
        for (ResolvedValueArgument valueArgument : list2) {
            if (!(valueArgument instanceof VarargValueArgument)) continue;
            for (ValueArgument argument : ((VarargValueArgument)valueArgument).getArguments()) {
                LeafPsiElement spread;
                if (argument.getSpreadElement() == null) {
                    continue;
                }
                DiagnosticFactory0<PsiElement> diagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitSpreadOnSignaturePolymorphicCall) ? ErrorsJvm.SPREAD_ON_SIGNATURE_POLYMORPHIC_CALL_ERROR : ErrorsJvm.SPREAD_ON_SIGNATURE_POLYMORPHIC_CALL;
                context2.getTrace().report(diagnostic.on(spread));
            }
        }
    }

    private PolymorphicSignatureCallChecker() {
    }

    static {
        PolymorphicSignatureCallChecker polymorphicSignatureCallChecker;
        INSTANCE = polymorphicSignatureCallChecker = new PolymorphicSignatureCallChecker();
        polymorphicSignatureFqName = new FqName("java.lang.invoke.MethodHandle.PolymorphicSignature");
    }
}

