/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.convertors.ByteReader;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0086\b\u00f8\u0001\u0000J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u001dH\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0017\u0010&\u001a\u00020'2\b\u0010#\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010(R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\nR \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/MyByteReader;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteReader;", "ins", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "currentMaxSize", "", "getCurrentMaxSize", "()J", "setCurrentMaxSize", "(J)V", "getIns", "()Ljava/io/InputStream;", "isEof", "", "()Z", "offset", "getOffset", "setOffset", "sizeLimits", "", "Lorg/jetbrains/kotlin/wasm/ir/convertors/MyByteReader$SizeLimit;", "getSizeLimits", "()Ljava/util/List;", "setSizeLimits", "(Ljava/util/List;)V", "limitSize", "", "size", "", "reason", "", "block", "Lkotlin/Function0;", "read", "amount", "readByte", "", "readBytes", "", "(Ljava/lang/Integer;)[B", "SizeLimit", "wasm.ir"})
public final class MyByteReader
extends ByteReader {
    private long offset;
    @NotNull
    private List<SizeLimit> sizeLimits;
    private long currentMaxSize;
    @NotNull
    private final InputStream ins;

    public final long getOffset() {
        return this.offset;
    }

    public final void setOffset(long l) {
        this.offset = l;
    }

    @NotNull
    public final List<SizeLimit> getSizeLimits() {
        return this.sizeLimits;
    }

    public final void setSizeLimits(@NotNull List<SizeLimit> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.sizeLimits = list2;
    }

    public final long getCurrentMaxSize() {
        return this.currentMaxSize;
    }

    public final void setCurrentMaxSize(long l) {
        this.currentMaxSize = l;
    }

    @Override
    public boolean isEof() {
        String string2 = "Not implemented";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @Override
    @NotNull
    public ByteReader read(int amount) {
        String string2 = "Not implemented";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    public final void limitSize(int size, @NotNull String reason, @NotNull Function0<Unit> block) {
        int $i$f$limitSize = 0;
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long maxSize = this.getOffset() + (long)size;
        this.getSizeLimits().add(new SizeLimit(maxSize, reason));
        this.setCurrentMaxSize(maxSize);
        block.invoke();
        boolean bl = this.getOffset() == this.getCurrentMaxSize();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Ending size-limited block \"" + reason + "\". We haven't read all " + size + " bytes.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        CollectionsKt.removeLast(this.getSizeLimits());
        this.setCurrentMaxSize(((SizeLimit)CollectionsKt.last(this.getSizeLimits())).getMaxSize());
    }

    @Override
    public byte readByte() {
        int b = this.ins.read();
        if (b == -1) {
            String string2 = "UnexpectedEnd";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        long l = this.offset;
        this.offset = l + 1L;
        if (this.offset > this.currentMaxSize) {
            String string3 = "Reading bytes past limit " + this.currentMaxSize + " Reason: " + ((SizeLimit)CollectionsKt.last(this.sizeLimits)).getReason();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return (byte)b;
    }

    @Override
    @NotNull
    public byte[] readBytes(@Nullable Integer amount) {
        int n = amount != null ? 1 : 0;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = 0;
        if (n == 0) {
            boolean bl2 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        n = amount;
        byte[] byArray = new byte[n];
        n2 = 0;
        while (n2 < n) {
            byte by;
            n3 = n2;
            int n4 = n2++;
            byte[] byArray2 = byArray;
            boolean bl3 = false;
            byArray2[n4] = by = this.readByte();
        }
        return byArray;
    }

    @NotNull
    public final InputStream getIns() {
        return this.ins;
    }

    public MyByteReader(@NotNull InputStream ins) {
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        this.ins = ins;
        this.sizeLimits = CollectionsKt.mutableListOf((Object[])new SizeLimit[]{new SizeLimit(Long.MAX_VALUE, "Root")});
        this.currentMaxSize = Long.MAX_VALUE;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/MyByteReader$SizeLimit;", "", "maxSize", "", "reason", "", "(JLjava/lang/String;)V", "getMaxSize", "()J", "getReason", "()Ljava/lang/String;", "wasm.ir"})
    public static final class SizeLimit {
        private final long maxSize;
        @NotNull
        private final String reason;

        public final long getMaxSize() {
            return this.maxSize;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        public SizeLimit(long maxSize, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.maxSize = maxSize;
            this.reason = reason;
        }
    }
}

