/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.wasm.ir.WasmData;
import org.jetbrains.kotlin.wasm.ir.WasmDataMode;
import org.jetbrains.kotlin.wasm.ir.WasmElement;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmLimits;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmMemory;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.WasmNamedModuleField;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmRtt;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.convertors.ByteWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\u00152\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0016\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u00020(H\u0002J\u0010\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u000208H\u0002J\u000e\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;J\u0010\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020>H\u0002J\u000e\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020AJ(\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00150FH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bG\u0010HJ\u0010\u0010I\u001a\u00020\u00152\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u00020PH\u0002J\u000e\u0010Q\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020RJ\u0010\u0010S\u001a\u00020\u00152\u0006\u0010T\u001a\u00020\u0010H\u0002J\u0006\u0010U\u001a\u00020\u0015J\u0014\u0010V\u001a\u00020\u00152\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00150FJ\u0014\u0010X\u001a\u00020\u0015*\u00020\b2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0012\u0010[\u001a\u00020\u0015*\u00020\b2\u0006\u0010\\\u001a\u00020\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006]"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToBinary;", "", "outputStream", "Ljava/io/OutputStream;", "module", "Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "(Ljava/io/OutputStream;Lorg/jetbrains/kotlin/wasm/ir/WasmModule;)V", "b", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "getB", "()Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "setB", "(Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;)V", "getModule", "()Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "index", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "getIndex", "(Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;)I", "appendBlockType", "", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$BlockType;", "appendCode", "function", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;", "appendData", "wasmData", "Lorg/jetbrains/kotlin/wasm/ir/WasmData;", "appendDefinedFunction", "appendElement", "element", "Lorg/jetbrains/kotlin/wasm/ir/WasmElement;", "appendExport", "export", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "appendExpr", "expr", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "appendFunctionTypeDeclaration", "appendGlobal", "c", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "appendHeapType", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "appendImmediate", "x", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "appendImportedFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Imported;", "appendInstr", "instr", "appendLimits", "limits", "Lorg/jetbrains/kotlin/wasm/ir/WasmLimits;", "appendLocalReference", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "appendMemory", "memory", "Lorg/jetbrains/kotlin/wasm/ir/WasmMemory;", "appendModuleFieldReference", "field", "Lorg/jetbrains/kotlin/wasm/ir/WasmNamedModuleField;", "appendSection", "id", "Lkotlin/UShort;", "content", "Lkotlin/Function0;", "appendSection-jKO663s", "(SLkotlin/jvm/functions/Function0;)V", "appendStartFunction", "startFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "appendStructTypeDeclaration", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "appendTable", "table", "Lorg/jetbrains/kotlin/wasm/ir/WasmTable;", "appendType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "appendVectorSize", "size", "appendWasmModule", "withVarUInt32PayloadSizePrepended", "fn", "writeString", "str", "", "writeVarUInt32", "v", "wasm.ir"})
public final class WasmIrToBinary {
    @NotNull
    private ByteWriter b;
    @NotNull
    private final WasmModule module;

    @NotNull
    public final ByteWriter getB() {
        return this.b;
    }

    public final void setB(@NotNull ByteWriter byteWriter) {
        Intrinsics.checkNotNullParameter((Object)byteWriter, (String)"<set-?>");
        this.b = byteWriter;
    }

    public final void appendWasmModule() {
        this.b.writeUInt32-WZ4Q5Ns(1836278016);
        this.b.writeUInt32-WZ4Q5Ns(1);
        WasmModule wasmModule = this.module;
        boolean bl = false;
        boolean bl2 = false;
        WasmModule $this$with = wasmModule;
        boolean bl3 = false;
        this.appendSection-jKO663s((short)1, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmTypeDeclaration it;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getFunctionTypes().size() + this.$this_with.getStructs().size());
                Iterable $this$forEach$iv = this.$this_with.getFunctionTypes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (WasmFunctionType)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendFunctionTypeDeclaration(this.this$0, it);
                }
                $this$forEach$iv = this.$this_with.getStructs();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (WasmStructDeclaration)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendStructTypeDeclaration(this.this$0, (WasmStructDeclaration)it);
                }
            }
        }));
        this.appendSection-jKO663s((short)2, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getImportsInOrder().size());
                Iterable $this$forEach$iv = this.$this_with.getImportsInOrder();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmNamedModuleField it = (WasmNamedModuleField)element$iv;
                    boolean bl = false;
                    WasmNamedModuleField wasmNamedModuleField = it;
                    if (wasmNamedModuleField instanceof WasmFunction.Imported) {
                        WasmIrToBinary.access$appendImportedFunction(this.this$0, (WasmFunction.Imported)it);
                        continue;
                    }
                    if (wasmNamedModuleField instanceof WasmMemory) {
                        WasmIrToBinary.access$appendMemory(this.this$0, (WasmMemory)it);
                        continue;
                    }
                    if (wasmNamedModuleField instanceof WasmTable) {
                        WasmIrToBinary.access$appendTable(this.this$0, (WasmTable)it);
                        continue;
                    }
                    if (wasmNamedModuleField instanceof WasmGlobal) {
                        WasmIrToBinary.access$appendGlobal(this.this$0, (WasmGlobal)it);
                        continue;
                    }
                    String string2 = "Unknown import kind " + Reflection.getOrCreateKotlinClass(it.getClass());
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
        }));
        this.appendSection-jKO663s((short)3, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getDefinedFunctions().size());
                Iterable $this$forEach$iv = this.$this_with.getDefinedFunctions();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendDefinedFunction(this.this$0, it);
                }
            }
        }));
        this.appendSection-jKO663s((short)4, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getTables().size());
                Iterable $this$forEach$iv = this.$this_with.getTables();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmTable it = (WasmTable)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendTable(this.this$0, it);
                }
            }
        }));
        this.appendSection-jKO663s((short)5, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getMemories().size());
                Iterable $this$forEach$iv = this.$this_with.getMemories();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmMemory it = (WasmMemory)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendMemory(this.this$0, it);
                }
            }
        }));
        this.appendSection-jKO663s((short)6, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getGlobals().size());
                Iterable $this$forEach$iv = this.$this_with.getGlobals();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmGlobal it = (WasmGlobal)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendGlobal(this.this$0, it);
                }
            }
        }));
        this.appendSection-jKO663s((short)7, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getExports().size());
                Iterable $this$forEach$iv = this.$this_with.getExports();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmExport it = (WasmExport)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendExport(this.this$0, it);
                }
            }
        }));
        if ($this$with.getStartFunction() != null) {
            this.appendSection-jKO663s((short)8, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
                final /* synthetic */ WasmModule $this_with;
                final /* synthetic */ WasmIrToBinary this$0;
                {
                    this.$this_with = wasmModule;
                    this.this$0 = wasmIrToBinary;
                    super(0);
                }

                public final void invoke() {
                    WasmIrToBinary.access$appendStartFunction(this.this$0, this.$this_with.getStartFunction());
                }
            }));
        }
        this.appendSection-jKO663s((short)9, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getElements().size());
                Iterable $this$forEach$iv = this.$this_with.getElements();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmElement it = (WasmElement)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendElement(this.this$0, it);
                }
            }
        }));
        if ($this$with.getDataCount()) {
            this.appendSection-jKO663s((short)12, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
                final /* synthetic */ WasmModule $this_with;
                final /* synthetic */ WasmIrToBinary this$0;
                {
                    this.$this_with = wasmModule;
                    this.this$0 = wasmIrToBinary;
                    super(0);
                }

                public final void invoke() {
                    int n = this.$this_with.getData().size();
                    boolean bl = false;
                    this.this$0.getB().writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl((int)n));
                }
            }));
        }
        this.appendSection-jKO663s((short)10, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getDefinedFunctions().size());
                Iterable $this$forEach$iv = this.$this_with.getDefinedFunctions();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendCode(this.this$0, it);
                }
            }
        }));
        this.appendSection-jKO663s((short)11, (Function0<Unit>)((Function0)new Function0<Unit>($this$with, this){
            final /* synthetic */ WasmModule $this_with;
            final /* synthetic */ WasmIrToBinary this$0;
            {
                this.$this_with = wasmModule;
                this.this$0 = wasmIrToBinary;
                super(0);
            }

            public final void invoke() {
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getData().size());
                Iterable $this$forEach$iv = this.$this_with.getData();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmData it = (WasmData)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendData(this.this$0, it);
                }
            }
        }));
    }

    private final void appendInstr(WasmInstr instr) {
        int opcode = instr.getOperator().getOpcode();
        if (opcode > 255) {
            this.b.writeByte((byte)(opcode >>> 8));
            this.b.writeByte((byte)(opcode & 0xFF));
        } else {
            this.b.writeByte((byte)opcode);
        }
        Iterable $this$forEach$iv = instr.getImmediates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmImmediate it = (WasmImmediate)element$iv;
            boolean bl = false;
            this.appendImmediate(it);
        }
    }

    private final void appendImmediate(WasmImmediate x) {
        block3: {
            WasmImmediate wasmImmediate;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                block9: {
                                                                    block8: {
                                                                        block7: {
                                                                            block6: {
                                                                                block5: {
                                                                                    block4: {
                                                                                        block2: {
                                                                                            wasmImmediate = x;
                                                                                            if (!(wasmImmediate instanceof WasmImmediate.ConstI32)) break block2;
                                                                                            this.b.writeVarInt32(((WasmImmediate.ConstI32)x).getValue());
                                                                                            break block3;
                                                                                        }
                                                                                        if (!(wasmImmediate instanceof WasmImmediate.ConstI64)) break block4;
                                                                                        this.b.writeVarInt64(((WasmImmediate.ConstI64)x).getValue());
                                                                                        break block3;
                                                                                    }
                                                                                    if (!(wasmImmediate instanceof WasmImmediate.ConstF32)) break block5;
                                                                                    this.b.writeUInt32-WZ4Q5Ns(((WasmImmediate.ConstF32)x).getRawBits-pVg5ArA());
                                                                                    break block3;
                                                                                }
                                                                                if (!(wasmImmediate instanceof WasmImmediate.ConstF64)) break block6;
                                                                                this.b.writeUInt64-VKZWuLQ(((WasmImmediate.ConstF64)x).getRawBits-s-VKNKU());
                                                                                break block3;
                                                                            }
                                                                            if (!(wasmImmediate instanceof WasmImmediate.SymbolI32)) break block7;
                                                                            this.b.writeVarInt32(((Number)((WasmImmediate.SymbolI32)x).getValue().getOwner()).intValue());
                                                                            break block3;
                                                                        }
                                                                        if (!(wasmImmediate instanceof WasmImmediate.MemArg)) break block8;
                                                                        this.b.writeVarUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)x).getAlign-pVg5ArA());
                                                                        this.b.writeVarUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)x).getOffset-pVg5ArA());
                                                                        break block3;
                                                                    }
                                                                    if (!(wasmImmediate instanceof WasmImmediate.BlockType)) break block9;
                                                                    this.appendBlockType((WasmImmediate.BlockType)x);
                                                                    break block3;
                                                                }
                                                                if (!(wasmImmediate instanceof WasmImmediate.FuncIdx)) break block10;
                                                                this.appendModuleFieldReference(((WasmImmediate.FuncIdx)x).getValue().getOwner());
                                                                break block3;
                                                            }
                                                            if (!(wasmImmediate instanceof WasmImmediate.LocalIdx)) break block11;
                                                            this.appendLocalReference(((WasmImmediate.LocalIdx)x).getValue().getOwner());
                                                            break block3;
                                                        }
                                                        if (!(wasmImmediate instanceof WasmImmediate.GlobalIdx)) break block12;
                                                        this.appendModuleFieldReference(((WasmImmediate.GlobalIdx)x).getValue().getOwner());
                                                        break block3;
                                                    }
                                                    if (!(wasmImmediate instanceof WasmImmediate.TypeIdx)) break block13;
                                                    this.appendModuleFieldReference(((WasmImmediate.TypeIdx)x).getValue().getOwner());
                                                    break block3;
                                                }
                                                if (!(wasmImmediate instanceof WasmImmediate.MemoryIdx)) break block14;
                                                this.appendModuleFieldReference(((WasmImmediate.MemoryIdx)x).getValue().getOwner());
                                                break block3;
                                            }
                                            if (!(wasmImmediate instanceof WasmImmediate.DataIdx)) break block15;
                                            this.writeVarUInt32(this.b, ((WasmImmediate.DataIdx)x).getValue());
                                            break block3;
                                        }
                                        if (!(wasmImmediate instanceof WasmImmediate.TableIdx)) break block16;
                                        this.writeVarUInt32(this.b, ((WasmImmediate.TableIdx)x).getValue());
                                        break block3;
                                    }
                                    if (!(wasmImmediate instanceof WasmImmediate.LabelIdx)) break block17;
                                    this.writeVarUInt32(this.b, ((WasmImmediate.LabelIdx)x).getValue());
                                    break block3;
                                }
                                if (!(wasmImmediate instanceof WasmImmediate.LabelIdxVector)) break block18;
                                this.writeVarUInt32(this.b, ((WasmImmediate.LabelIdxVector)x).getValue().size());
                                Iterator<Integer> iterator2 = ((WasmImmediate.LabelIdxVector)x).getValue().iterator();
                                while (iterator2.hasNext()) {
                                    int target = ((Number)iterator2.next()).intValue();
                                    this.writeVarUInt32(this.b, target);
                                }
                                break block3;
                            }
                            if (!(wasmImmediate instanceof WasmImmediate.ElemIdx)) break block19;
                            this.appendModuleFieldReference(((WasmImmediate.ElemIdx)x).getValue());
                            break block3;
                        }
                        if (!(wasmImmediate instanceof WasmImmediate.ValTypeVector)) break block20;
                        this.writeVarUInt32(this.b, ((WasmImmediate.ValTypeVector)x).getValue().size());
                        for (WasmType type2 : ((WasmImmediate.ValTypeVector)x).getValue()) {
                            this.appendType(type2);
                        }
                        break block3;
                    }
                    if (!(wasmImmediate instanceof WasmImmediate.StructType)) break block21;
                    this.appendModuleFieldReference(((WasmImmediate.StructType)x).getValue().getOwner());
                    break block3;
                }
                if (!(wasmImmediate instanceof WasmImmediate.StructFieldIdx)) break block22;
                this.writeVarUInt32(this.b, ((Number)((WasmImmediate.StructFieldIdx)x).getValue().getOwner()).intValue());
                break block3;
            }
            if (!(wasmImmediate instanceof WasmImmediate.HeapType)) break block3;
            this.appendHeapType(((WasmImmediate.HeapType)x).getValue());
        }
    }

    private final void appendSection-jKO663s(short id, Function0<Unit> content) {
        this.b.writeVarUInt7-xj2QHRw(id);
        this.withVarUInt32PayloadSizePrepended((Function0<Unit>)((Function0)new Function0<Unit>(content){
            final /* synthetic */ Function0 $content;

            public final void invoke() {
                this.$content.invoke();
            }
            {
                this.$content = function0;
                super(0);
            }
        }));
    }

    public final void withVarUInt32PayloadSizePrepended(@NotNull Function0<Unit> fn) {
        ByteWriter newWriter;
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        ByteWriter previousWriter = this.b;
        this.b = newWriter = this.b.createTemp();
        fn.invoke();
        this.b = previousWriter;
        this.writeVarUInt32(this.b, newWriter.getWritten());
        this.b.write(newWriter);
    }

    private final void appendVectorSize(int size) {
        this.writeVarUInt32(this.b, size);
    }

    private final void appendFunctionTypeDeclaration(WasmFunctionType type2) {
        WasmType it;
        this.b.writeVarInt7((byte)-32);
        this.writeVarUInt32(this.b, type2.getParameterTypes().size());
        Iterable $this$forEach$iv = type2.getParameterTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmType)element$iv;
            boolean bl = false;
            this.appendType(it);
        }
        this.writeVarUInt32(this.b, type2.getResultTypes().size());
        $this$forEach$iv = type2.getResultTypes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmType)element$iv;
            boolean bl = false;
            this.appendType(it);
        }
    }

    private final void appendBlockType(WasmImmediate.BlockType type2) {
        block3: {
            WasmImmediate.BlockType blockType;
            block2: {
                blockType = type2;
                if (!(blockType instanceof WasmImmediate.BlockType.Function)) break block2;
                this.appendModuleFieldReference(((WasmImmediate.BlockType.Function)type2).getType());
                break block3;
            }
            if (!(blockType instanceof WasmImmediate.BlockType.Value)) break block3;
            WasmType wasmType = ((WasmImmediate.BlockType.Value)type2).getType();
            if (wasmType == null) {
                this.b.writeVarInt7((byte)-64);
            } else {
                this.appendType(((WasmImmediate.BlockType.Value)type2).getType());
            }
        }
    }

    private final void appendStructTypeDeclaration(WasmStructDeclaration type2) {
        this.b.writeVarInt7((byte)-33);
        this.writeVarUInt32(this.b, type2.getFields().size());
        Iterable $this$forEach$iv = type2.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmStructFieldDeclaration it = (WasmStructFieldDeclaration)element$iv;
            boolean bl = false;
            this.appendType(it.getType());
            this.b.writeVarUInt1(it.isMutable());
        }
    }

    public final int getIndex(@NotNull WasmFunctionType $this$index) {
        Intrinsics.checkNotNullParameter((Object)$this$index, (String)"$this$index");
        return this.module.getFunctionTypes().indexOf($this$index);
    }

    private final void appendLimits(WasmLimits limits) {
        this.b.writeVarUInt1(limits.getMaxSize-0hXNFcg() != null);
        this.b.writeVarUInt32-WZ4Q5Ns(limits.getMinSize-pVg5ArA());
        if (limits.getMaxSize-0hXNFcg() != null) {
            this.b.writeVarUInt32-WZ4Q5Ns(limits.getMaxSize-0hXNFcg().unbox-impl());
        }
    }

    private final void appendImportedFunction(WasmFunction.Imported function2) {
        this.writeString(this.b, function2.getImportPair().getModuleName());
        this.writeString(this.b, function2.getImportPair().getDeclarationName());
        this.b.writeByte((byte)0);
        this.writeVarUInt32(this.b, this.getIndex(function2.getType()));
    }

    private final void appendDefinedFunction(WasmFunction.Defined function2) {
        this.writeVarUInt32(this.b, this.getIndex(function2.getType()));
    }

    private final void appendTable(WasmTable table) {
        if (table.getImportPair() != null) {
            this.writeString(this.b, table.getImportPair().getModuleName());
            this.writeString(this.b, table.getImportPair().getDeclarationName());
            this.b.writeByte((byte)1);
        }
        this.b.writeVarInt7(table.getElementType().getCode());
        this.appendLimits(table.getLimits());
    }

    private final void appendMemory(WasmMemory memory) {
        if (memory.getImportPair() != null) {
            this.writeString(this.b, memory.getImportPair().getModuleName());
            this.writeString(this.b, memory.getImportPair().getDeclarationName());
            this.b.writeByte((byte)2);
        }
        this.appendLimits(memory.getLimits());
    }

    private final void appendGlobal(WasmGlobal c) {
        if (c.getImportPair() != null) {
            this.writeString(this.b, c.getImportPair().getModuleName());
            this.writeString(this.b, c.getImportPair().getDeclarationName());
            this.b.writeByte((byte)3);
            this.appendType(c.getType());
            this.b.writeVarUInt1(c.isMutable());
            return;
        }
        this.appendType(c.getType());
        this.b.writeVarUInt1(c.isMutable());
        this.appendExpr((Iterable<WasmInstr>)c.getInit());
    }

    private final void appendExpr(Iterable<WasmInstr> expr) {
        Iterable<WasmInstr> $this$forEach$iv = expr;
        boolean $i$f$forEach = false;
        Iterator<WasmInstr> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            WasmInstr element$iv;
            WasmInstr it = element$iv = iterator2.next();
            boolean bl = false;
            this.appendInstr(it);
        }
        this.appendInstr(new WasmInstr(WasmOp.END, null, 2, null));
    }

    private final void appendExport(WasmExport<?> export) {
        this.writeString(this.b, export.getName());
        this.b.writeByte(export.getKind());
        this.appendModuleFieldReference((WasmNamedModuleField)export.getField());
    }

    private final void appendStartFunction(WasmFunction startFunction) {
        this.appendModuleFieldReference(startFunction);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendElement(WasmElement element) {
        block13: {
            WasmElement.Mode mode;
            Function0<Unit> $fun$writeTypeOrKind$2;
            Function0<Unit> $fun$writeElements$1;
            boolean isFuncIndices;
            block14: {
                block12: {
                    List list2;
                    block11: {
                        boolean bl;
                        Iterable $this$all$iv = element.getValues();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                WasmTable.Value it = (WasmTable.Value)element$iv;
                                boolean bl2 = false;
                                if (it instanceof WasmTable.Value.Function) continue;
                                bl = false;
                                break block11;
                            }
                            bl = isFuncIndices = true;
                        }
                    }
                    if (isFuncIndices) {
                        void $this$mapTo$iv$iv;
                        Object element$iv;
                        Iterable $this$map$iv = element.getValues();
                        boolean $i$f$map = false;
                        element$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            WasmTable.Value value2 = (WasmTable.Value)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            void v1 = it;
                            if (v1 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.wasm.ir.WasmTable.Value.Function");
                            }
                            Integer n = ((WasmTable.Value.Function)v1).getFunction().getOwner().getId();
                            Intrinsics.checkNotNull((Object)n);
                            Integer n2 = (int)n;
                            collection.add(n2);
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = null;
                    }
                    List funcIndices = list2;
                    $fun$writeElements$1 = new Function0<Unit>(this, element, funcIndices){
                        final /* synthetic */ WasmIrToBinary this$0;
                        final /* synthetic */ WasmElement $element;
                        final /* synthetic */ List $funcIndices;

                        public final void invoke() {
                            WasmIrToBinary.access$appendVectorSize(this.this$0, this.$element.getValues().size());
                            if (this.$funcIndices != null) {
                                Iterable $this$forEach$iv = this.$funcIndices;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    int it = ((Number)element$iv).intValue();
                                    boolean bl = false;
                                    this.this$0.writeVarUInt32(this.this$0.getB(), it);
                                }
                            } else {
                                Iterable $this$forEach$iv = this.$element.getValues();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    WasmTable.Value it = (WasmTable.Value)element$iv;
                                    boolean bl = false;
                                    WasmTable.Value value2 = it;
                                    if (value2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.wasm.ir.WasmTable.Value.Expression");
                                    }
                                    WasmIrToBinary.access$appendExpr(this.this$0, ((WasmTable.Value.Expression)value2).getExpr());
                                }
                            }
                        }
                        {
                            this.this$0 = wasmIrToBinary;
                            this.$element = wasmElement;
                            this.$funcIndices = list2;
                            super(0);
                        }
                    };
                    $fun$writeTypeOrKind$2 = new Function0<Unit>(this, isFuncIndices, element){
                        final /* synthetic */ WasmIrToBinary this$0;
                        final /* synthetic */ boolean $isFuncIndices;
                        final /* synthetic */ WasmElement $element;

                        public final void invoke() {
                            if (this.$isFuncIndices) {
                                this.this$0.getB().writeByte((byte)0);
                            } else {
                                this.this$0.appendType(this.$element.getType());
                            }
                        }
                        {
                            this.this$0 = wasmIrToBinary;
                            this.$isFuncIndices = bl;
                            this.$element = wasmElement;
                            super(0);
                        }
                    };
                    mode = element.getMode();
                    if (!Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Passive.INSTANCE)) break block12;
                    this.b.writeByte(isFuncIndices ? (byte)1 : 5);
                    $fun$writeTypeOrKind$2.invoke();
                    $fun$writeElements$1.invoke();
                    break block13;
                }
                if (!(mode instanceof WasmElement.Mode.Active)) break block14;
                Integer n = ((WasmElement.Mode.Active)mode).getTable().getId();
                Intrinsics.checkNotNull((Object)n);
                int tableId = n;
                if (tableId == 0 && isFuncIndices) {
                    this.b.writeByte((byte)0);
                    this.appendExpr((Iterable<WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
                } else if (isFuncIndices) {
                    this.b.writeByte((byte)2);
                    this.appendModuleFieldReference(((WasmElement.Mode.Active)mode).getTable());
                    this.appendExpr((Iterable<WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
                    $fun$writeTypeOrKind$2.invoke();
                } else {
                    this.b.writeByte((byte)6);
                    this.appendModuleFieldReference(((WasmElement.Mode.Active)mode).getTable());
                    this.appendExpr((Iterable<WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
                    $fun$writeTypeOrKind$2.invoke();
                }
                $fun$writeElements$1.invoke();
                break block13;
            }
            if (!Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Declarative.INSTANCE)) break block13;
            this.b.writeByte(isFuncIndices ? (byte)3 : 7);
            $fun$writeTypeOrKind$2.invoke();
            $fun$writeElements$1.invoke();
        }
    }

    private final void appendCode(WasmFunction.Defined function2) {
        this.withVarUInt32PayloadSizePrepended((Function0<Unit>)((Function0)new Function0<Unit>(this, function2){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmFunction.Defined $function;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                int n;
                void $this$count$iv;
                Iterable iterable = this.$function.getLocals();
                ByteWriter byteWriter = this.this$0.getB();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    void var3_5;
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        WasmLocal it22 = (WasmLocal)element$iv;
                        boolean bl = false;
                        if (!(!it22.isParameter())) continue;
                        int it22 = ++count$iv;
                        boolean bl2 = false;
                        if (it22 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = var3_5;
                }
                int n2 = n;
                wasmIrToBinary.writeVarUInt32(byteWriter, n2);
                Iterable $this$forEach$iv = this.$function.getLocals();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmLocal local2 = (WasmLocal)element$iv;
                    boolean bl = false;
                    if (local2.isParameter()) continue;
                    this.this$0.getB().writeVarUInt32-WZ4Q5Ns(1);
                    this.this$0.appendType(local2.getType());
                }
                WasmIrToBinary.access$appendExpr(this.this$0, this.$function.getInstructions());
            }
            {
                this.this$0 = wasmIrToBinary;
                this.$function = defined;
                super(0);
            }
        }));
    }

    private final void appendData(WasmData wasmData) {
        WasmDataMode mode = wasmData.getMode();
        if (mode instanceof WasmDataMode.Active) {
            if (((WasmDataMode.Active)mode).getMemoryIdx() == 0) {
                this.b.writeByte((byte)0);
            } else {
                this.b.writeByte((byte)2);
                this.writeVarUInt32(this.b, ((WasmDataMode.Active)mode).getMemoryIdx());
            }
            this.appendExpr((Iterable<WasmInstr>)((WasmDataMode.Active)mode).getOffset());
        } else if (Intrinsics.areEqual((Object)mode, (Object)WasmDataMode.Passive.INSTANCE)) {
            this.b.writeByte((byte)1);
        }
        this.writeVarUInt32(this.b, wasmData.getBytes().length);
        this.b.writeBytes(wasmData.getBytes());
    }

    public final void appendHeapType(@NotNull WasmHeapType type2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        WasmHeapType wasmHeapType = type2;
        if (wasmHeapType instanceof WasmHeapType.Simple) {
            n = ((WasmHeapType.Simple)type2).getCode();
        } else if (wasmHeapType instanceof WasmHeapType.Type) {
            Integer n2 = ((WasmHeapType.Type)type2).getType().getOwner().getId();
            Intrinsics.checkNotNull((Object)n2);
            n = n2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int code = n;
        this.b.writeVarInt32(code);
    }

    public final void appendType(@NotNull WasmType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.b.writeVarInt7(type2.getCode());
        if (type2 instanceof WasmRefType) {
            this.appendHeapType(((WasmRefType)type2).getHeapType());
        }
        if (type2 instanceof WasmRefNullType) {
            this.appendHeapType(((WasmRefNullType)type2).getHeapType());
        }
        if (type2 instanceof WasmRtt) {
            this.writeVarUInt32(this.b, ((WasmRtt)type2).getDepth());
            this.appendHeapType(((WasmRtt)type2).getHeapType());
        }
    }

    public final void appendLocalReference(@NotNull WasmLocal local2) {
        Intrinsics.checkNotNullParameter((Object)local2, (String)"local");
        this.writeVarUInt32(this.b, local2.getId());
    }

    public final void appendModuleFieldReference(@NotNull WasmNamedModuleField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Integer n = field.getId();
        if (n == null) {
            String string2 = Reflection.getOrCreateKotlinClass(field.getClass()) + ' ' + field.getName() + " ID is unlinked";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        int id = n;
        this.writeVarUInt32(this.b, id);
    }

    public final void writeVarUInt32(@NotNull ByteWriter $this$writeVarUInt32, int v) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarUInt32, (String)"$this$writeVarUInt32");
        int n = v;
        boolean bl = false;
        $this$writeVarUInt32.writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl((int)n));
    }

    private final void writeString(ByteWriter $this$writeString, String str) {
        String string2 = str;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        this.writeVarUInt32($this$writeString, bytes.length);
        $this$writeString.writeBytes(bytes);
    }

    @NotNull
    public final WasmModule getModule() {
        return this.module;
    }

    public WasmIrToBinary(@NotNull OutputStream outputStream2, @NotNull WasmModule module2) {
        Intrinsics.checkNotNullParameter((Object)outputStream2, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        this.b = new ByteWriter.OutputStream(outputStream2);
    }

    public static final /* synthetic */ void access$appendVectorSize(WasmIrToBinary $this, int size) {
        $this.appendVectorSize(size);
    }

    public static final /* synthetic */ void access$appendFunctionTypeDeclaration(WasmIrToBinary $this, WasmFunctionType type2) {
        $this.appendFunctionTypeDeclaration(type2);
    }

    public static final /* synthetic */ void access$appendStructTypeDeclaration(WasmIrToBinary $this, WasmStructDeclaration type2) {
        $this.appendStructTypeDeclaration(type2);
    }

    public static final /* synthetic */ void access$appendImportedFunction(WasmIrToBinary $this, WasmFunction.Imported function2) {
        $this.appendImportedFunction(function2);
    }

    public static final /* synthetic */ void access$appendMemory(WasmIrToBinary $this, WasmMemory memory) {
        $this.appendMemory(memory);
    }

    public static final /* synthetic */ void access$appendTable(WasmIrToBinary $this, WasmTable table) {
        $this.appendTable(table);
    }

    public static final /* synthetic */ void access$appendGlobal(WasmIrToBinary $this, WasmGlobal c) {
        $this.appendGlobal(c);
    }

    public static final /* synthetic */ void access$appendDefinedFunction(WasmIrToBinary $this, WasmFunction.Defined function2) {
        $this.appendDefinedFunction(function2);
    }

    public static final /* synthetic */ void access$appendExport(WasmIrToBinary $this, WasmExport export) {
        $this.appendExport(export);
    }

    public static final /* synthetic */ void access$appendStartFunction(WasmIrToBinary $this, WasmFunction startFunction) {
        $this.appendStartFunction(startFunction);
    }

    public static final /* synthetic */ void access$appendElement(WasmIrToBinary $this, WasmElement element) {
        $this.appendElement(element);
    }

    public static final /* synthetic */ void access$appendCode(WasmIrToBinary $this, WasmFunction.Defined function2) {
        $this.appendCode(function2);
    }

    public static final /* synthetic */ void access$appendData(WasmIrToBinary $this, WasmData wasmData) {
        $this.appendData(wasmData);
    }

    public static final /* synthetic */ void access$appendExpr(WasmIrToBinary $this, Iterable expr) {
        $this.appendExpr(expr);
    }
}

