/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.optimizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.optimizations.FoldConstantLowering;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0003$%&B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J.\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010#\u001a\u00020\u0014*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "floatSpecial", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "buildIrConstant", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "v", "", "coerceToDouble", "irConst", "constToString", "", "const", "fromFloatConstSafe", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "tryFoldingBinaryOps", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "tryFoldingBuiltinBinaryOps", "tryFoldingUnaryOps", "typeConstructorName", "BinaryOp", "Companion", "PrimitiveType", "ir.backend.common"})
public final class FoldConstantLowering
extends IrElementTransformerVoid
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    private final boolean floatSpecial;
    @NotNull
    private static final PrimitiveType<Integer> INT = new PrimitiveType("Int");
    @NotNull
    private static final PrimitiveType<Long> LONG = new PrimitiveType("Long");
    @NotNull
    private static final PrimitiveType<Double> DOUBLE = new PrimitiveType("Double");
    @NotNull
    private static final PrimitiveType<Float> FLOAT = new PrimitiveType("Float");
    @NotNull
    private static final HashMap<BinaryOp, Function2<Object, Object, Object>> BINARY_OP_TO_EVALUATOR = new HashMap();

    public FoldConstantLowering(@NotNull CommonBackendContext context2, boolean floatSpecial) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.floatSpecial = floatSpecial;
    }

    public /* synthetic */ FoldConstantLowering(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    private final IrConst<?> fromFloatConstSafe(int startOffset, int endOffset, IrType type2, Object v) {
        IrConst irConst;
        if (!this.floatSpecial) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.float(startOffset, endOffset, type2, ((Number)v).floatValue());
        } else if (v instanceof Float) {
            irConst = IrConstImpl.Companion.float(startOffset, endOffset, type2, ((Number)v).floatValue());
        } else if (v instanceof Double) {
            irConst = IrConstImpl.Companion.double(startOffset, endOffset, type2, ((Number)v).doubleValue());
        } else {
            String string2 = "Unexpected constant type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return irConst;
    }

    private final IrConst<?> buildIrConstant(int startOffset, int endOffset, IrType type2, Object v) {
        IrConst irConst;
        IrType constType = IrTypesKt.makeNotNull(type2);
        if (IrTypePredicatesKt.isInt(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)v).intValue());
        } else if (IrTypePredicatesKt.isChar(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
            }
            irConst = IrConstImpl.Companion.char(startOffset, endOffset, constType, ((Character)v).charValue());
        } else if (IrTypePredicatesKt.isBoolean(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            irConst = IrConstImpl.Companion.boolean(startOffset, endOffset, constType, (Boolean)v);
        } else if (IrTypePredicatesKt.isByte(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)v).byteValue());
        } else if (IrTypePredicatesKt.isShort(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)v).shortValue());
        } else if (IrTypePredicatesKt.isLong(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)v).longValue());
        } else if (IrTypePredicatesKt.isDouble(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            irConst = IrConstImpl.Companion.double(startOffset, endOffset, constType, ((Number)v).doubleValue());
        } else if (IrTypePredicatesKt.isFloat(constType)) {
            irConst = this.fromFloatConstSafe(startOffset, endOffset, type2, v);
        } else if (IrTypePredicatesKt.isString(constType)) {
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            irConst = IrConstImpl.Companion.string(startOffset, endOffset, constType, (String)v);
        } else {
            throw new IllegalArgumentException("Unexpected IrCall return type");
        }
        return irConst;
    }

    private final IrExpression tryFoldingUnaryOps(IrCall call2) {
        Object object;
        IrConst irConst;
        Object object2 = call2.getDispatchReceiver();
        IrConst irConst2 = irConst = object2 instanceof IrConst ? (IrConst)object2 : null;
        if (irConst == null) {
            return call2;
        }
        IrConst operand = irConst;
        object2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"call.symbol.owner.name.toString()");
        Object operationName = object2;
        if (Intrinsics.areEqual((Object)operationName, (Object)"toString")) {
            object = this.constToString(operand);
        } else {
            if (Intrinsics.areEqual((Object)operationName, (Object)"toFloat") && this.floatSpecial) {
                return call2;
            }
            String string2 = operand.getKind().toString();
            Object t = operand.getValue();
            Intrinsics.checkNotNull(t);
            Object object3 = ConstantExpressionEvaluatorKt.evaluateUnary((String)operationName, string2, t);
            if (object3 == null) {
                return call2;
            }
            object = object3;
        }
        String evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final IrConst<?> coerceToDouble(IrConst<?> irConst) {
        if (!this.floatSpecial) {
            return irConst;
        }
        if (Intrinsics.areEqual(irConst.getKind(), (Object)IrConstKind.Float.INSTANCE)) {
            IrConst<?> irConst2 = irConst;
            boolean bl = false;
            boolean bl2 = false;
            IrConst<?> $this$coerceToDouble_u24lambda_u2d0 = irConst2;
            boolean bl3 = false;
            String string2 = String.valueOf($this$coerceToDouble_u24lambda_u2d0.getValue());
            boolean bl4 = false;
            return new IrConstImpl<Double>($this$coerceToDouble_u24lambda_u2d0.getStartOffset(), $this$coerceToDouble_u24lambda_u2d0.getEndOffset(), this.context.getIrBuiltIns().getDoubleType(), IrConstKind.Double.INSTANCE, Double.parseDouble(string2));
        }
        return irConst;
    }

    private final String typeConstructorName(IrType $this$typeConstructorName) {
        IrSimpleType irSimpleType = (IrSimpleType)$this$typeConstructorName;
        boolean bl = false;
        boolean bl2 = false;
        IrSimpleType $this$typeConstructorName_u24lambda_u2d2 = irSimpleType;
        boolean bl3 = false;
        IrClassSymbol irClassSymbol = (IrClassSymbol)$this$typeConstructorName_u24lambda_u2d2.getClassifier();
        boolean bl4 = false;
        boolean bl5 = false;
        IrClassSymbol $this$typeConstructorName_u24lambda_u2d2_u24lambda_u2d1 = irClassSymbol;
        boolean bl6 = false;
        String string2 = ((IrClass)$this$typeConstructorName_u24lambda_u2d2_u24lambda_u2d1.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"owner.name.asString()");
        return string2;
    }

    private final IrExpression tryFoldingBinaryOps(IrCall call2) {
        IrConst irConst;
        IrExpression irExpression = call2.getDispatchReceiver();
        IrConst irConst2 = irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (irConst == null) {
            return call2;
        }
        IrConst<?> lhs = this.coerceToDouble(irConst);
        Object object = call2.getValueArgument(0);
        IrExpression irExpression2 = irExpression = object instanceof IrConst ? (IrConst)object : null;
        if (irExpression == null) {
            return call2;
        }
        IrConst<?> rhs = this.coerceToDouble((IrConst<?>)irExpression);
        try {
            String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"call.symbol.owner.name.toString()");
            String string3 = string2;
            String string4 = lhs.getKind().toString();
            string2 = lhs.getValue();
            Intrinsics.checkNotNull((Object)string2);
            String string5 = string2;
            String string6 = this.typeConstructorName(((IrSimpleFunction)call2.getSymbol().getOwner()).getValueParameters().get(0).getType());
            string2 = rhs.getValue();
            Intrinsics.checkNotNull((Object)string2);
            object = ConstantExpressionEvaluatorKt.evaluateBinary(string3, string4, string5, string6, string2);
            if (object == null) {
                return call2;
            }
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final IrExpression tryFoldingBuiltinBinaryOps(IrCall call2) {
        IrConst irConst;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)call2.getSymbol().getOwner());
        if (!Intrinsics.areEqual((Object)(fqName2 == null ? null : fqName2.parent()), (Object)IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN())) {
            return call2;
        }
        IrExpression irExpression = call2.getValueArgument(0);
        IrConst irConst2 = irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (irConst == null) {
            return call2;
        }
        IrConst lhs = irConst;
        Object object = call2.getValueArgument(1);
        IrExpression irExpression2 = irExpression = object instanceof IrConst ? (IrConst)object : null;
        if (irExpression == null) {
            return call2;
        }
        IrExpression rhs = irExpression;
        try {
            Object object2;
            String string2 = lhs.getKind().toString();
            String string3 = ((IrConst)rhs).getKind().toString();
            String string4 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"call.symbol.owner.name.toString()");
            Function2<Object, Object, Object> function2 = BINARY_OP_TO_EVALUATOR.get(new BinaryOp(string2, string3, string4));
            if (function2 == null) {
                return call2;
            }
            Function2<Object, Object, Object> evaluator = object2 = function2;
            object2 = lhs.getValue();
            Intrinsics.checkNotNull(object2);
            Object object3 = object2;
            object2 = ((IrConst)rhs).getValue();
            Intrinsics.checkNotNull(object2);
            object = evaluator.invoke(object3, object2);
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated = object;
        return this.buildIrConstant(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), evaluated);
    }

    private final String constToString(IrConst<?> irConst) {
        boolean bl;
        IrConstKind<?> kind;
        if (this.floatSpecial) {
            kind = irConst.getKind();
            if (kind instanceof IrConstKind.Float) {
                float f;
                float f2 = f = ((Number)((IrConstKind.Float)kind).valueOf(irConst)).floatValue();
                bl = false;
                if (!Float.isInfinite(f2)) {
                    boolean bl2 = false;
                    if ((float)Math.floor(f) == f) {
                        return String.valueOf((int)f);
                    }
                }
            } else if (kind instanceof IrConstKind.Double) {
                double d;
                double d2 = d = ((Number)((IrConstKind.Double)kind).valueOf(irConst)).doubleValue();
                boolean bl3 = false;
                if (!Double.isInfinite(d2)) {
                    bl = false;
                    if (Math.floor(d) == d) {
                        return String.valueOf((long)d);
                    }
                }
            }
        }
        if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
            kind = irConst.getKind();
            if (kind instanceof IrConstKind.Byte) {
                byte by = ((Number)((IrConstKind.Byte)kind).valueOf(irConst)).byteValue();
                boolean bl4 = false;
                return UByte.toString-impl((byte)UByte.constructor-impl((byte)by));
            }
            if (kind instanceof IrConstKind.Short) {
                short s = ((Number)((IrConstKind.Short)kind).valueOf(irConst)).shortValue();
                boolean bl5 = false;
                return UShort.toString-impl((short)UShort.constructor-impl((short)s));
            }
            if (kind instanceof IrConstKind.Int) {
                int n = ((Number)((IrConstKind.Int)kind).valueOf(irConst)).intValue();
                boolean bl6 = false;
                return Integer.toUnsignedString(UInt.constructor-impl((int)n));
            }
            if (kind instanceof IrConstKind.Long) {
                long l = ((Number)((IrConstKind.Long)kind).valueOf(irConst)).longValue();
                bl = false;
                return Long.toUnsignedString(ULong.constructor-impl((long)l));
            }
        }
        return String.valueOf(irConst.getValue());
    }

    @Override
    @ExperimentalUnsignedTypes
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ FoldConstantLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                return expression2.getExtensionReceiver() != null ? (IrExpression)expression2 : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 0 ? FoldConstantLowering.access$tryFoldingUnaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 1 ? FoldConstantLowering.access$tryFoldingBinaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() == null && expression2.getValueArgumentsCount() == 2 ? FoldConstantLowering.access$tryFoldingBuiltinBinaryOps(this.this$0, expression2) : (IrExpression)expression2)));
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                boolean bl = false;
                List folded = new ArrayList<E>();
                for (IrExpression next : expression2.getArguments()) {
                    Collection collection;
                    IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
                    if (!(next instanceof IrConst)) {
                        collection = folded;
                        boolean bl2 = false;
                        collection.add(next);
                        continue;
                    }
                    if (!(last instanceof IrConst)) {
                        collection = folded;
                        IrConstImpl<String> irConstImpl = IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), FoldConstantLowering.access$getContext$p(this.this$0).getIrBuiltIns().getStringType(), FoldConstantLowering.access$constToString(this.this$0, (IrConst)next));
                        boolean bl3 = false;
                        collection.add(irConstImpl);
                        continue;
                    }
                    folded.set(folded.size() - 1, IrConstImpl.Companion.string(((IrConst)last).getStartOffset(), next.getEndOffset(), FoldConstantLowering.access$getContext$p(this.this$0).getIrBuiltIns().getStringType(), Intrinsics.stringPlus((String)FoldConstantLowering.access$constToString(this.this$0, (IrConst)last), (Object)FoldConstantLowering.access$constToString(this.this$0, (IrConst)next))));
                }
                Object object = CollectionsKt.singleOrNull((List)folded);
                IrConst irConst = object instanceof IrConst ? (IrConst)object : null;
                return irConst == null ? (IrExpression)new IrStringConcatenationImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), folded) : (IrExpression)irConst;
            }

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                IrExpression argument = expression2.getArgument();
                return argument instanceof IrConst && expression2.getOperator() == IrTypeOperator.IMPLICIT_INTEGER_COERCION ? (IrExpression)FoldConstantLowering.access$buildIrConstant(this.this$0, expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), ((IrConst)argument).getValue()) : (IrExpression)expression2;
            }
        });
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingUnaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingUnaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBinaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBuiltinBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBuiltinBinaryOps(call2);
    }

    public static final /* synthetic */ CommonBackendContext access$getContext$p(FoldConstantLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$constToString(FoldConstantLowering $this, IrConst irConst) {
        return $this.constToString(irConst);
    }

    public static final /* synthetic */ IrConst access$buildIrConstant(FoldConstantLowering $this, int startOffset, int endOffset, IrType type2, Object v) {
        return $this.buildIrConstant(startOffset, endOffset, type2, v);
    }

    static {
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "less", Companion.1.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "lessOrEqual", Companion.2.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greater", Companion.3.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greaterOrEqual", Companion.4.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "ieee754equals", Companion.5.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "less", Companion.6.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "lessOrEqual", Companion.7.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greater", Companion.8.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greaterOrEqual", Companion.9.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "ieee754equals", Companion.10.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "less", Companion.11.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "lessOrEqual", Companion.12.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greater", Companion.13.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greaterOrEqual", Companion.14.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "EQEQ", Companion.15.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "less", Companion.16.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "lessOrEqual", Companion.17.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greater", Companion.18.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greaterOrEqual", Companion.19.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "EQEQ", Companion.20.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$BinaryOp;", "", "lhsType", "", "rhsType", "operatorName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLhsType", "()Ljava/lang/String;", "getOperatorName", "getRhsType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.backend.common"})
    private static final class BinaryOp {
        @NotNull
        private final String lhsType;
        @NotNull
        private final String rhsType;
        @NotNull
        private final String operatorName;

        public BinaryOp(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
            Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
            Intrinsics.checkNotNullParameter((Object)operatorName, (String)"operatorName");
            this.lhsType = lhsType;
            this.rhsType = rhsType;
            this.operatorName = operatorName;
        }

        @NotNull
        public final String getLhsType() {
            return this.lhsType;
        }

        @NotNull
        public final String getRhsType() {
            return this.rhsType;
        }

        @NotNull
        public final String getOperatorName() {
            return this.operatorName;
        }

        @NotNull
        public final String component1() {
            return this.lhsType;
        }

        @NotNull
        public final String component2() {
            return this.rhsType;
        }

        @NotNull
        public final String component3() {
            return this.operatorName;
        }

        @NotNull
        public final BinaryOp copy(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
            Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
            Intrinsics.checkNotNullParameter((Object)operatorName, (String)"operatorName");
            return new BinaryOp(lhsType, rhsType, operatorName);
        }

        public static /* synthetic */ BinaryOp copy$default(BinaryOp binaryOp, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = binaryOp.lhsType;
            }
            if ((n & 2) != 0) {
                string3 = binaryOp.rhsType;
            }
            if ((n & 4) != 0) {
                string4 = binaryOp.operatorName;
            }
            return binaryOp.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "BinaryOp(lhsType=" + this.lhsType + ", rhsType=" + this.rhsType + ", operatorName=" + this.operatorName + ')';
        }

        public int hashCode() {
            int result2 = this.lhsType.hashCode();
            result2 = result2 * 31 + this.rhsType.hashCode();
            result2 = result2 * 31 + this.operatorName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BinaryOp)) {
                return false;
            }
            BinaryOp binaryOp = (BinaryOp)other;
            if (!Intrinsics.areEqual((Object)this.lhsType, (Object)binaryOp.lhsType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rhsType, (Object)binaryOp.rhsType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.operatorName, (Object)binaryOp.operatorName);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$PrimitiveType;", "T", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.backend.common"})
    private static final class PrimitiveType<T> {
        @NotNull
        private final String name;

        public PrimitiveType(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final PrimitiveType<T> copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new PrimitiveType<T>(name);
        }

        public static /* synthetic */ PrimitiveType copy$default(PrimitiveType primitiveType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = primitiveType.name;
            }
            return primitiveType.copy(string2);
        }

        @NotNull
        public String toString() {
            return "PrimitiveType(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrimitiveType)) {
                return false;
            }
            PrimitiveType primitiveType = (PrimitiveType)other;
            return Intrinsics.areEqual((Object)this.name, (Object)primitiveType.name);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00010\u0006H\u0002RV\u0010\u0003\u001aJ\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u00060\u0004j$\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$Companion;", "", "()V", "BINARY_OP_TO_EVALUATOR", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$BinaryOp;", "Lkotlin/Function2;", "Lkotlin/collections/HashMap;", "DOUBLE", "Lorg/jetbrains/kotlin/backend/common/lower/optimizations/FoldConstantLowering$PrimitiveType;", "", "FLOAT", "", "INT", "", "LONG", "", "registerBuiltinBinaryOp", "", "T", "operandType", "operatorName", "", "f", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> void registerBuiltinBinaryOp(PrimitiveType<T> operandType, String operatorName, Function2<? super T, ? super T, ? extends Object> f) {
            Map map = BINARY_OP_TO_EVALUATOR;
            BinaryOp binaryOp = new BinaryOp(operandType.getName(), operandType.getName(), operatorName);
            boolean bl = false;
            map.put(binaryOp, f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

