/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\u0013*\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u001dH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000bR\u0018\u0010\f\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/VarargLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isArrayOf", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;)Z", "isEmptyArray", "createBuilder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "startOffset", "", "endOffset", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "addVararg", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilder;", "Companion", "backend.jvm"})
final class VarargLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private static final Set<String> PRIMITIVE_ARRAY_OF_NAMES;

    public VarargLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
        if (IrUtilsKt.isAnnotationClass(AdditionalIrUtilsKt.getConstructedClass(constructor2))) {
            return expression2;
        }
        return super.visitConstructorCall(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        IrFunctionSymbol function2 = (IrFunctionSymbol)expression2.getSymbol();
        int n = 0;
        int n2 = expression2.getValueArgumentsCount();
        if (n < n2) {
            do {
                IrValueParameter parameter;
                int i;
                if (expression2.getValueArgument(i = n++) != null || (parameter = function2.getOwner().getValueParameters().get(i)).getVarargElementType() == null || IrUtilsKt.hasDefaultValue(parameter)) continue;
                IrType arrayType = IrTypesKt.makeNotNull(IrTypeUtilsKt.substitute(parameter.getType(), IrUtilsKt.getTypeSubstitutionMap(expression2)));
                expression2.putValueArgument(i, IrArrayBuilderKt.irArrayOf$default(VarargLowering.createBuilder$default(this, 0, 0, 3, null), arrayType, null, 2, null));
            } while (n < n2);
        }
        if (this.isArrayOf(function2)) {
            IrExpression irExpression2 = expression2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression2);
            irExpression = irExpression2;
        } else {
            irExpression = this.isEmptyArray(function2) ? IrArrayBuilderKt.irArrayOf$default(this.createBuilder(expression2.getStartOffset(), expression2.getEndOffset()), expression2.getType(), null, 2, null) : (IrExpression)expression2;
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        void $this$irArray$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JvmIrBuilder jvmIrBuilder = this.createBuilder(expression2.getStartOffset(), expression2.getEndOffset());
        IrType arrayType$iv = expression2.getType();
        boolean $i$f$irArray = false;
        IrArrayBuilder irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
        boolean bl = false;
        boolean bl2 = false;
        IrArrayBuilder $this$irArray_u24lambda_u2d0$iv = irArrayBuilder;
        boolean bl3 = false;
        IrArrayBuilder $this$visitVararg_u24lambda_u2d0 = $this$irArray_u24lambda_u2d0$iv;
        boolean bl4 = false;
        this.addVararg($this$visitVararg_u24lambda_u2d0, expression2);
        return irArrayBuilder.build();
    }

    private final void addVararg(IrArrayBuilder $this$addVararg, IrVararg expression2) {
        for (IrVarargElement element : expression2.getElements()) {
            IrVarargElement irVarargElement = element;
            if (irVarargElement instanceof IrExpression) {
                $this$addVararg.unaryPlus((IrExpression)((IrExpression)element).transform((IrElementTransformer)this, (Object)null));
                continue;
            }
            if (irVarargElement instanceof IrSpreadElement) {
                IrExpression spread = ((IrSpreadElement)element).getExpression();
                if (spread instanceof IrFunctionAccessExpression && this.isArrayOf((IrFunctionSymbol)((IrFunctionAccessExpression)spread).getSymbol())) {
                    IrExpression irExpression = ((IrFunctionAccessExpression)spread).getValueArgument(0);
                    if (irExpression == null) continue;
                    IrExpression argument = irExpression;
                    if (argument instanceof IrVararg) {
                        this.addVararg($this$addVararg, (IrVararg)argument);
                        continue;
                    }
                }
                $this$addVararg.addSpread((IrExpression)spread.transform((IrElementTransformer)this, (Object)null));
                continue;
            }
            String string2 = Intrinsics.stringPlus((String)"Unexpected IrVarargElement subclass: ", (Object)element);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    private final JvmIrBuilder createBuilder(int startOffset, int endOffset) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder(this.context, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
    }

    static /* synthetic */ JvmIrBuilder createBuilder$default(VarargLowering varargLowering, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return varargLowering.createBuilder(n, n2);
    }

    private final boolean isArrayOf(IrFunctionSymbol $this$isArrayOf) {
        return VarargLowering.Companion.isArrayOf($this$isArrayOf.getOwner());
    }

    private final boolean isEmptyArray(IrFunctionSymbol $this$isEmptyArray) {
        IrDeclarationParent irDeclarationParent;
        IrPackageFragment irPackageFragment;
        return Intrinsics.areEqual((Object)$this$isEmptyArray.getOwner().getName().asString(), (Object)"emptyArray") && Intrinsics.areEqual((Object)((irPackageFragment = (irDeclarationParent = $this$isEmptyArray.getOwner().getParent()) instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null) == null ? null : irPackageFragment.getFqName()), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Object object;
        Enum type2;
        boolean bl;
        Collection collection;
        Enum[] $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PrimitiveType[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (Enum item$iv$iv : $this$mapTo$iv$iv) {
            void var9_13 = item$iv$iv;
            collection = destination$iv$iv;
            bl = false;
            object = type2.name();
            collection.add(object);
        }
        $this$map$iv = UnsignedType.values();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((Enum[])$this$map$iv).length);
        $i$f$mapTo = false;
        Enum[] enumArray = $this$mapTo$iv$iv;
        int n = enumArray.length;
        for (int string4 = 0; string4 < n; ++string4) {
            void type3;
            Enum item$iv$iv;
            type2 = item$iv$iv = enumArray[string4];
            object = destination$iv$iv;
            bl = false;
            String string2 = type3.getTypeName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.typeName.asString()");
            String string3 = string2;
            object.add(string3);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object e : $this$mapTo$iv$iv) {
            void name;
            String string4 = (String)e;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = Intrinsics.stringPlus((String)CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)name), (Object)"ArrayOf");
            collection.add(object);
        }
        PRIMITIVE_ARRAY_OF_NAMES = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/VarargLowering$Companion;", "", "()V", "ARRAY_OF_NAME", "", "PRIMITIVE_ARRAY_OF_NAMES", "", "isArrayOf", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "backend.jvm"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isArrayOf(IrFunction $this$isArrayOf) {
            IrPackageFragment irPackageFragment;
            IrDeclarationParent directParent = $this$isArrayOf.getParent();
            if (directParent instanceof IrClass) {
                IrPackageFragment irPackageFragment2 = IrUtilsKt.getPackageFragment(directParent);
                if (irPackageFragment2 == null) {
                    return false;
                }
                irPackageFragment = irPackageFragment2;
            } else {
                if (!(directParent instanceof IrPackageFragment)) return false;
                irPackageFragment = (IrPackageFragment)directParent;
            }
            IrPackageFragment parent2 = irPackageFragment;
            if (!Intrinsics.areEqual((Object)parent2.getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
            String string2 = $this$isArrayOf.getName().asString();
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            if (!PRIMITIVE_ARRAY_OF_NAMES.contains(it)) {
                if (!Intrinsics.areEqual((Object)it, (Object)"arrayOf")) return false;
            }
            boolean bl4 = true;
            if (!bl4) return false;
            if ($this$isArrayOf.getExtensionReceiverParameter() != null) return false;
            if ($this$isArrayOf.getDispatchReceiverParameter() != null) return false;
            if ($this$isArrayOf.getValueParameters().size() != 1) return false;
            if (!AdditionalIrUtilsKt.isVararg($this$isArrayOf.getValueParameters().get(0))) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

