/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.lower.WasmSignature;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J9\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmSignature;", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "extensionReceiverType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "valueParametersType", "", "returnType", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/ir/types/IrType;Ljava/util/List;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getExtensionReceiverType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getReturnType", "getValueParametersType", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.wasm"})
public final class WasmSignature {
    @NotNull
    private final Name name;
    @Nullable
    private final IrType extensionReceiverType;
    @NotNull
    private final List<IrType> valueParametersType;
    @NotNull
    private final IrType returnType;

    public WasmSignature(@NotNull Name name, @Nullable IrType extensionReceiverType, @NotNull List<? extends IrType> valueParametersType, @NotNull IrType returnType2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(valueParametersType, (String)"valueParametersType");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        this.name = name;
        this.extensionReceiverType = extensionReceiverType;
        this.valueParametersType = valueParametersType;
        this.returnType = returnType2;
    }

    @NotNull
    public final Name getName() {
        return this.name;
    }

    @Nullable
    public final IrType getExtensionReceiverType() {
        return this.extensionReceiverType;
    }

    @NotNull
    public final List<IrType> getValueParametersType() {
        return this.valueParametersType;
    }

    @NotNull
    public final IrType getReturnType() {
        return this.returnType;
    }

    @NotNull
    public String toString() {
        String string2;
        IrType irType = this.extensionReceiverType;
        if (irType == null) {
            string2 = "";
        } else {
            IrType irType2 = irType;
            boolean bl = false;
            boolean bl2 = false;
            IrType it = irType2;
            boolean bl3 = false;
            String string3 = "(er: " + RenderIrElementKt.render(it) + ") ";
            string2 = string3 == null ? "" : string3;
        }
        String er = string2;
        String parameters2 = CollectionsKt.joinToString$default((Iterable)this.valueParametersType, (CharSequence)", ", null, null, (int)0, null, (Function1)toString.parameters.1.INSTANCE, (int)30, null);
        return '[' + er + this.name + '(' + parameters2 + ") -> " + RenderIrElementKt.render(this.returnType) + ']';
    }

    @NotNull
    public final Name component1() {
        return this.name;
    }

    @Nullable
    public final IrType component2() {
        return this.extensionReceiverType;
    }

    @NotNull
    public final List<IrType> component3() {
        return this.valueParametersType;
    }

    @NotNull
    public final IrType component4() {
        return this.returnType;
    }

    @NotNull
    public final WasmSignature copy(@NotNull Name name, @Nullable IrType extensionReceiverType, @NotNull List<? extends IrType> valueParametersType, @NotNull IrType returnType2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(valueParametersType, (String)"valueParametersType");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        return new WasmSignature(name, extensionReceiverType, valueParametersType, returnType2);
    }

    public static /* synthetic */ WasmSignature copy$default(WasmSignature wasmSignature, Name name, IrType irType, List list2, IrType irType2, int n, Object object) {
        if ((n & 1) != 0) {
            name = wasmSignature.name;
        }
        if ((n & 2) != 0) {
            irType = wasmSignature.extensionReceiverType;
        }
        if ((n & 4) != 0) {
            list2 = wasmSignature.valueParametersType;
        }
        if ((n & 8) != 0) {
            irType2 = wasmSignature.returnType;
        }
        return wasmSignature.copy(name, irType, list2, irType2);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + (this.extensionReceiverType == null ? 0 : this.extensionReceiverType.hashCode());
        result2 = result2 * 31 + ((Object)this.valueParametersType).hashCode();
        result2 = result2 * 31 + this.returnType.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WasmSignature)) {
            return false;
        }
        WasmSignature wasmSignature = (WasmSignature)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)wasmSignature.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extensionReceiverType, (Object)wasmSignature.extensionReceiverType)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.valueParametersType, wasmSignature.valueParametersType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.returnType, (Object)wasmSignature.returnType);
    }
}

