/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.deserialization.AbstractAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.SuspendTypeUtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0002J3\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J5\u00100\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J\u0018\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.J\u000e\u00105\u001a\u0002062\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u0002062\u0006\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.J\u0010\u00107\u001a\u00020*2\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u001dH\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u00103\u001a\u000204H\u0002J\f\u0010?\u001a\u00020@*\u00020AH\u0002J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b*\u0006\u0012\u0002\b\u00030CR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00140\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00140\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "annotationDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "parent", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;Ljava/util/List;Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;)V", "getAnnotationDeserializer", "()Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "ownTypeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getOwnTypeParameters", "()Ljava/util/List;", "getParent", "()Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "typeParameterDescriptors", "", "", "typeParameterNames", "", "getTypeTable", "()Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "computeClassifier", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "fqNameIndex", "createSuspendFunctionType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "functionTypeConstructor", "arguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "isNullable", "", "attributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "(Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;ZLorg/jetbrains/kotlin/fir/types/ConeAttributes;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "createSuspendFunctionTypeForBasicCase", "simpleType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeArgument", "typeArgumentProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "typeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "typeParameterId", "typeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierLookupTag;", "convertVariance", "Lorg/jetbrains/kotlin/types/Variance;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Variance;", "typeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "fir-deserialization"})
public final class FirTypeDeserializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @NotNull
    private final AbstractAnnotationDeserializer annotationDeserializer;
    @Nullable
    private final FirTypeDeserializer parent;
    @NotNull
    private final Map<Integer, FirTypeParameterSymbol> typeParameterDescriptors;
    @NotNull
    private final Map<String, FirTypeParameterSymbol> typeParameterNames;

    /*
     * WARNING - void declaration
     */
    public FirTypeDeserializer(@NotNull FirSession session2, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull AbstractAnnotationDeserializer annotationDeserializer, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @Nullable FirTypeDeserializer parent2) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)annotationDeserializer, (String)"annotationDeserializer");
        Intrinsics.checkNotNullParameter(typeParameterProtos, (String)"typeParameterProtos");
        this.session = session2;
        this.nameResolver = nameResolver2;
        this.typeTable = typeTable;
        this.annotationDeserializer = annotationDeserializer;
        this.parent = parent2;
        Collection collection = typeParameterProtos;
        boolean bl = false;
        if (!collection.isEmpty()) {
            map = new LinkedHashMap();
        } else {
            boolean bl2 = false;
            map = MapsKt.emptyMap();
        }
        this.typeParameterDescriptors = map;
        collection = typeParameterProtos;
        bl = false;
        if (!collection.isEmpty()) {
            boolean bl3;
            Object object;
            Object object2;
            boolean bl4;
            boolean bl5 = false;
            this.typeParameterNames = new LinkedHashMap();
            LinkedHashMap result2 = (LinkedHashMap)this.typeParameterDescriptors;
            boolean bl6 = false;
            List builders = new ArrayList();
            for (ProtoBuf.TypeParameter proto : typeParameterProtos) {
                if (!proto.hasId()) continue;
                Name name = NameResolverUtilKt.getName(this.nameResolver, proto.getName());
                Object object3 = new FirTypeParameterSymbol();
                boolean bl7 = false;
                bl4 = false;
                FirTypeParameterSymbol it = object3;
                boolean bl8 = false;
                Map<String, FirTypeParameterSymbol> map2 = this.typeParameterNames;
                object2 = name.asString();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"name.asString()");
                boolean bl9 = false;
                map2.put((String)object2, it);
                FirTypeParameterSymbol symbol2 = object3;
                object3 = builders;
                object = new FirTypeParameterBuilder();
                bl4 = false;
                bl3 = false;
                FirTypeParameterBuilder $this$_init__u24lambda_u2d1 = object;
                boolean bl10 = false;
                $this$_init__u24lambda_u2d1.setSession(this.getSession());
                $this$_init__u24lambda_u2d1.setOrigin(FirDeclarationOrigin.Library.INSTANCE);
                $this$_init__u24lambda_u2d1.setName(name);
                $this$_init__u24lambda_u2d1.setSymbol(symbol2);
                object2 = proto.getVariance();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.variance");
                $this$_init__u24lambda_u2d1.setVariance(this.convertVariance((ProtoBuf.TypeParameter.Variance)object2));
                $this$_init__u24lambda_u2d1.setReified(proto.getReified());
                bl4 = false;
                object3.add(object);
                object3 = result2;
                object = proto.getId();
                bl4 = false;
                object3.put(object, symbol2);
            }
            Iterator<ProtoBuf.TypeParameter> iterator2 = typeParameterProtos.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                void $this$mapTo$iv;
                int index2 = n++;
                ProtoBuf.TypeParameter proto = iterator2.next();
                FirTypeParameterBuilder builder2 = (FirTypeParameterBuilder)builders.get(index2);
                object = builder2;
                bl4 = false;
                bl3 = false;
                FirTypeParameterBuilder $this$_init__u24lambda_u2d4 = object;
                boolean bl11 = false;
                object2 = proto.getUpperBoundList();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.upperBoundList");
                object2 = (Iterable)object2;
                Collection destination$iv = $this$_init__u24lambda_u2d4.getBounds();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv;
                    Collection collection2 = destination$iv;
                    boolean bl12 = false;
                    boolean $i$f$buildResolvedTypeRef = false;
                    boolean bl13 = false;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                    boolean bl14 = false;
                    boolean bl15 = false;
                    FirResolvedTypeRefBuilder $this$lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = firResolvedTypeRefBuilder;
                    boolean bl16 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    $this$lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.setType(this.type((ProtoBuf.Type)it));
                    FirResolvedTypeRef firResolvedTypeRef = firResolvedTypeRefBuilder.build();
                    collection2.add(firResolvedTypeRef);
                }
                FirDeclarationUtilKt.addDefaultBoundIfNecessary$default($this$_init__u24lambda_u2d4, false, 1, null);
                ((FirTypeParameterBuilder)object).build();
            }
        } else {
            this.typeParameterNames = MapsKt.emptyMap();
        }
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    @NotNull
    public final AbstractAnnotationDeserializer getAnnotationDeserializer() {
        return this.annotationDeserializer;
    }

    @Nullable
    public final FirTypeDeserializer getParent() {
        return this.parent;
    }

    @NotNull
    public final List<FirTypeParameterSymbol> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    private final ConeClassLikeLookupTag computeClassifier(int fqNameIndex) {
        try {
            ClassId classId = NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex);
            boolean bl = false;
            boolean bl2 = false;
            ClassId it = classId;
            boolean bl3 = false;
            ClassId classId2 = !it.isLocal() ? classId : null;
            ClassId id = classId2 == null ? StandardClassIds.INSTANCE.getAny() : classId2;
            return new ConeClassLikeLookupTagImpl(id);
        }
        catch (Throwable e) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Looking up for ", (Object)NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex)), e);
        }
    }

    @NotNull
    public final ConeKotlinType type(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        List<FirAnnotationCall> annotations2 = this.annotationDeserializer.loadTypeAnnotations(proto, this.nameResolver);
        ConeAttributes attributes = FirTypeUtilsKt.computeTypeAttributes$default(annotations2, null, 1, null);
        return this.type(proto, attributes);
    }

    @NotNull
    public final ConeKotlinType type(@NotNull ProtoBuf.Type proto, @NotNull ConeAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            ConeLookupTagBasedType lowerBound = this.simpleType(proto, attributes);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.typeTable);
            Intrinsics.checkNotNull((Object)type2);
            ConeLookupTagBasedType upperBound = this.simpleType(type2, attributes);
            Intrinsics.checkNotNull((Object)lowerBound);
            ConeKotlinType coneKotlinType = lowerBound;
            Intrinsics.checkNotNull((Object)upperBound);
            return new ConeFlexibleType(coneKotlinType, upperBound);
        }
        ConeLookupTagBasedType coneLookupTagBasedType = this.simpleType(proto, attributes);
        return coneLookupTagBasedType == null ? (ConeKotlinType)new ConeClassErrorType(new ConeSimpleDiagnostic("?!id:0", DiagnosticKind.DeserializationError)) : (ConeKotlinType)coneLookupTagBasedType;
    }

    private final ConeTypeParameterLookupTag typeParameterSymbol(int typeParameterId) {
        ConeTypeParameterLookupTag coneTypeParameterLookupTag;
        Object object = this.typeParameterDescriptors.get(typeParameterId);
        ConeTypeParameterLookupTag coneTypeParameterLookupTag2 = coneTypeParameterLookupTag = object == null ? null : ((FirTypeParameterSymbol)object).toLookupTag();
        return coneTypeParameterLookupTag == null ? ((object = this.parent) == null ? null : super.typeParameterSymbol(typeParameterId)) : coneTypeParameterLookupTag;
    }

    private final Variance convertVariance(ProtoBuf.TypeParameter.Variance $this$convertVariance) {
        Variance variance;
        ProtoBuf.TypeParameter.Variance variance2 = $this$convertVariance;
        int n = WhenMappings.$EnumSwitchMapping$0[variance2.ordinal()];
        switch (n) {
            case 1: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 2: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.INVARIANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> typeParameters(@NotNull FirClassLikeSymbol<?> $this$typeParameters) {
        List list2;
        FirTypeParameterRefsOwner firTypeParameterRefsOwner;
        Intrinsics.checkNotNullParameter($this$typeParameters, (String)"<this>");
        Object object = $this$typeParameters.getFir();
        FirTypeParameterRefsOwner firTypeParameterRefsOwner2 = firTypeParameterRefsOwner = object instanceof FirTypeParameterRefsOwner ? (FirTypeParameterRefsOwner)object : null;
        if (firTypeParameterRefsOwner == null) {
            list2 = null;
        } else {
            object = firTypeParameterRefsOwner.getTypeParameters();
            if (object == null) {
                list2 = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    FirTypeParameterSymbol firTypeParameterSymbol = it.getSymbol();
                    collection.add(firTypeParameterSymbol);
                }
                list2 = (List)destination$iv$iv;
            }
        }
        firTypeParameterRefsOwner = list2;
        boolean bl = false;
        Object object2 = firTypeParameterRefsOwner;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConeLookupTagBasedType simpleType(@NotNull ProtoBuf.Type proto, @NotNull ConeAttributes attributes) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        ConeClassifierLookupTag coneClassifierLookupTag = this.typeSymbol(proto);
        if (coneClassifierLookupTag == null) {
            return null;
        }
        ConeClassifierLookupTag constructor2 = coneClassifierLookupTag;
        if (constructor2 instanceof ConeTypeParameterLookupTag) {
            return new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)constructor2, proto.getNullable(), null, 4, null);
        }
        if (!(constructor2 instanceof ConeClassLikeLookupTag)) {
            return null;
        }
        Iterable $this$map$iv = FirTypeDeserializer.simpleType$collectAllArguments(proto, this);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeTypeProjection coneTypeProjection = this.typeArgument((ProtoBuf.Type.Argument)p0);
            collection.add(coneTypeProjection);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray22 = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ConeTypeProjection[] arguments2 = coneTypeProjectionArray;
        Boolean $i$f$toTypedArray22 = Flags.SUSPEND_TYPE.get(proto.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$toTypedArray22, (String)"SUSPEND_TYPE.get(proto.flags)");
        ConeClassLikeType simpleType2 = $i$f$toTypedArray22 != false ? this.createSuspendFunctionType((ConeClassLikeLookupTag)constructor2, arguments2, proto.getNullable(), attributes) : (ConeClassLikeType)new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)constructor2, arguments2, proto.getNullable(), attributes);
        object = ProtoTypeTableUtilKt.abbreviatedType(proto, this.typeTable);
        if (object == null) {
            return simpleType2;
        }
        Object abbreviatedTypeProto = object;
        return this.simpleType((ProtoBuf.Type)abbreviatedTypeProto, attributes);
    }

    private final ConeClassLikeType createSuspendFunctionTypeForBasicCase(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments2, boolean isNullable, ConeAttributes attributes) {
        ConeClassLikeType coneClassLikeType;
        Object object = ArraysKt.getOrNull((Object[])arguments2, (int)(ArraysKt.getLastIndex((Object[])arguments2) - 1));
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType continuationType = coneClassLikeType;
        if (!FirTypeDeserializer.createSuspendFunctionTypeForBasicCase$isContinuation(continuationType)) {
            return new ConeClassLikeTypeImpl(functionTypeConstructor, arguments2, isNullable, attributes);
        }
        ConeKotlinTypeProjection suspendReturnType = (ConeKotlinTypeProjection)ArraysKt.single((Object[])continuationType.getTypeArguments());
        List valueParameters2 = ArraysKt.dropLast((Object[])arguments2, (int)2);
        FunctionClassKind kind = FunctionClassKind.SuspendFunction;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)valueParameters2, (Object)suspendReturnType);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(new ClassId(kind.getPackageFqName(), kind.numberedClassName(valueParameters2.size()))), coneTypeProjectionArray, isNullable, attributes);
    }

    private final ConeClassLikeType createSuspendFunctionType(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments2, boolean isNullable, ConeAttributes attributes) {
        ConeClassLikeType result2;
        ConeClassLikeType coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(functionTypeConstructor, this.session);
        Intrinsics.checkNotNull(firClassLikeSymbol);
        FirBasedSymbol $this$firUnsafe$iv = firClassLikeSymbol;
        boolean $i$f$firUnsafe = false;
        Object fir$iv = $this$firUnsafe$iv.getFir();
        boolean bl = fir$iv instanceof FirTypeParameterRefsOwner;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypeParameterRefsOwner.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType$default((FirElement)fir$iv, null, 1, null);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        int n = ((FirTypeParameterRefsOwner)((FirElement)fir$iv)).getTypeParameters().size() - arguments2.length;
        switch (n) {
            case 0: {
                coneClassLikeType = this.createSuspendFunctionTypeForBasicCase(functionTypeConstructor, arguments2, isNullable, attributes);
                break;
            }
            case 1: {
                ConeClassLikeTypeImpl coneClassLikeTypeImpl;
                int arity = arguments2.length - 1;
                if (arity >= 0) {
                    FunctionClassKind kind = FunctionClassKind.SuspendFunction;
                    coneClassLikeTypeImpl = new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(new ClassId(kind.getPackageFqName(), kind.numberedClassName(arity))), arguments2, isNullable, attributes);
                } else {
                    coneClassLikeTypeImpl = null;
                }
                coneClassLikeType = coneClassLikeTypeImpl;
                break;
            }
            default: {
                coneClassLikeType = null;
            }
        }
        ConeClassLikeType coneClassLikeType2 = result2 = coneClassLikeType;
        return coneClassLikeType2 == null ? (ConeClassLikeType)new ConeClassErrorType(new ConeSimpleDiagnostic(Intrinsics.stringPlus((String)"Bad suspend function in metadata with constructor: ", (Object)functionTypeConstructor), DiagnosticKind.DeserializationError)) : coneClassLikeType2;
    }

    private final ConeClassifierLookupTag typeSymbol(ProtoBuf.Type proto) {
        String name;
        FirTypeParameterSymbol firTypeParameterSymbol;
        return proto.hasClassName() ? (ConeClassifierLookupTag)this.computeClassifier(proto.getClassName()) : (proto.hasTypeAliasName() ? (ConeClassifierLookupTag)this.computeClassifier(proto.getTypeAliasName()) : (proto.hasTypeParameter() ? (ConeClassifierLookupTag)this.typeParameterSymbol(proto.getTypeParameter()) : (proto.hasTypeParameterName() ? (ConeClassifierLookupTag)((firTypeParameterSymbol = this.typeParameterNames.get(name = this.nameResolver.getString(proto.getTypeParameterName()))) == null ? null : firTypeParameterSymbol.toLookupTag()) : null)));
    }

    private final ConeTypeProjection typeArgument(ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return ConeStarProjection.INSTANCE;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"typeArgumentProto.projection");
        Variance variance = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.typeTable);
        if (type2 == null) {
            return new ConeClassErrorType(new ConeSimpleDiagnostic("No type recorded", DiagnosticKind.DeserializationError));
        }
        ProtoBuf.Type type3 = type2;
        ConeKotlinType coneType = this.type(type3);
        return ConeTypeUtilsKt.toTypeProjection(coneType, variance);
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type $this$simpleType_u24collectAllArguments, FirTypeDeserializer this$0) {
        Object object = $this$simpleType_u24collectAllArguments.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(object, (String)"argumentList");
        Collection collection = (Collection)object;
        object = ProtoTypeTableUtilKt.outerType($this$simpleType_u24collectAllArguments, this$0.typeTable);
        object = object == null ? null : FirTypeDeserializer.simpleType$collectAllArguments((ProtoBuf.Type)object, this$0);
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object2));
    }

    private static final boolean createSuspendFunctionTypeForBasicCase$isContinuation(ConeClassLikeType $this$createSuspendFunctionTypeForBasicCase_u24isContinuation) {
        if ($this$createSuspendFunctionTypeForBasicCase_u24isContinuation.getTypeArguments().length != 1) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$createSuspendFunctionTypeForBasicCase_u24isContinuation.getLookupTag().getClassId(), (Object)SuspendTypeUtilsKt.getCONTINUATION_INTERFACE_CLASS_ID());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.TypeParameter.Variance.values().length];
            nArray[ProtoBuf.TypeParameter.Variance.IN.ordinal()] = 1;
            nArray[ProtoBuf.TypeParameter.Variance.OUT.ordinal()] = 2;
            nArray[ProtoBuf.TypeParameter.Variance.INV.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

