/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.DceKt;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.JsCode;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.MutableController;
import org.jetbrains.kotlin.ir.backend.js.lower.MoveBodilessDeclarationsToSeparatePlaceKt;
import org.jetbrains.kotlin.ir.backend.js.lower.TestGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.PersistentApiKt;
import org.jetbrains.kotlin.ir.declarations.StageController;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u00a8\u0001\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u00172\b\b\u0002\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017\u001a\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$\u00a8\u0006%"}, d2={"compile", "Lorg/jetbrains/kotlin/ir/backend/js/CompilerResult;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "mainModule", "Lorg/jetbrains/kotlin/ir/backend/js/MainModule;", "analyzer", "Lorg/jetbrains/kotlin/analyzer/AbstractAnalyzerWithCompilerReport;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "allDependencies", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolveResult;", "friendDependencies", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "mainArguments", "", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "generateFullJs", "", "generateDceJs", "dceDriven", "es6mode", "multiModule", "relativeRequirePath", "propertyLazyInitialization", "generateJsCode", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "nameTables", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "backend.js"})
public final class CompilerKt {
    @NotNull
    public static final CompilerResult compile(@NotNull Project project, @NotNull MainModule mainModule, @NotNull AbstractAnalyzerWithCompilerReport analyzer2, @NotNull CompilerConfiguration configuration, @NotNull PhaseConfig phaseConfig, @NotNull KotlinLibraryResolveResult allDependencies, @NotNull List<? extends KotlinLibrary> friendDependencies, @Nullable List<String> mainArguments, @NotNull Set<FqName> exportedDeclarations, boolean generateFullJs, boolean generateDceJs, boolean dceDriven, boolean es6mode, boolean multiModule, boolean relativeRequirePath, boolean propertyLazyInitialization) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
        Intrinsics.checkNotNullParameter((Object)analyzer2, (String)"analyzer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter((Object)allDependencies, (String)"allDependencies");
        Intrinsics.checkNotNullParameter(friendDependencies, (String)"friendDependencies");
        Intrinsics.checkNotNullParameter(exportedDeclarations, (String)"exportedDeclarations");
        PersistentApiKt.setStageController(new StageController(0, 1, null));
        IrFactory irFactory = dceDriven ? (IrFactory)PersistentIrFactory.INSTANCE : (IrFactory)IrFactoryImpl.INSTANCE;
        IrModuleInfo irModuleInfo = KlibKt.loadIr(project, mainModule, analyzer2, configuration, allDependencies, friendDependencies, irFactory);
        IrModuleFragment moduleFragment = irModuleInfo.component1();
        List dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker deserializer = irModuleInfo.component5();
        ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf((Object)moduleFragment));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List allModules2 = list2;
        JsIrBackendContext context2 = new JsIrBackendContext(moduleDescriptor, irBuiltIns, symbolTable, (IrModuleFragment)CollectionsKt.first((List)allModules2), exportedDeclarations, configuration, false, es6mode, propertyLazyInitialization, irFactory, 64, null);
        List irProviders = CollectionsKt.listOf((Object)deserializer);
        new ExternalDependenciesGenerator(symbolTable, irProviders, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration)).generateUnboundSymbolsAsDependencies();
        deserializer.postProcess();
        SymbolTableKt.noUnboundLeft(symbolTable, "Unbound symbols at the end of linker");
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment module2 = (IrModuleFragment)element$iv;
            boolean bl = false;
            MoveBodilessDeclarationsToSeparatePlaceKt.moveBodilessDeclarationsToSeparatePlace(context2, module2);
        }
        TestGeneratorKt.generateTests(context2, (IrModuleFragment)CollectionsKt.last((List)allModules2));
        if (dceDriven) {
            MutableController controller = new MutableController(context2, JsLoweringPhasesKt.getPirLowerings());
            PersistentApiKt.setStageController(controller);
            controller.setCurrentStage(controller.getLowerings().size() + 1);
            DceKt.eliminateDeadDeclarations(allModules2, context2);
            PersistentApiKt.setStageController(new StageController(controller.getCurrentStage()));
            IrModuleToJsTransformer transformer2 = new IrModuleToJsTransformer(context2, mainArguments, false, null, true, false, multiModule, relativeRequirePath, 12, null);
            return transformer2.generateModule(allModules2);
        }
        CompilerPhaseKt.invokeToplevel((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), phaseConfig, (CommonBackendContext)context2, allModules2);
        IrModuleToJsTransformer transformer3 = new IrModuleToJsTransformer(context2, mainArguments, false, null, generateFullJs, generateDceJs, multiModule, relativeRequirePath, 12, null);
        return transformer3.generateModule(allModules2);
    }

    public static /* synthetic */ CompilerResult compile$default(Project project, MainModule mainModule, AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport, CompilerConfiguration compilerConfiguration, PhaseConfig phaseConfig, KotlinLibraryResolveResult kotlinLibraryResolveResult, List list2, List list3, Set set, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Object object) {
        if ((n & 0x100) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x200) != 0) {
            bl = true;
        }
        if ((n & 0x400) != 0) {
            bl2 = false;
        }
        if ((n & 0x800) != 0) {
            bl3 = false;
        }
        if ((n & 0x1000) != 0) {
            bl4 = false;
        }
        if ((n & 0x2000) != 0) {
            bl5 = false;
        }
        if ((n & 0x4000) != 0) {
            bl6 = false;
        }
        return CompilerKt.compile(project, mainModule, abstractAnalyzerWithCompilerReport, compilerConfiguration, phaseConfig, kotlinLibraryResolveResult, list2, list3, set, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    @NotNull
    public static final String generateJsCode(@NotNull JsIrBackendContext context2, @NotNull IrModuleFragment moduleFragment, @NotNull NameTables nameTables) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter((Object)nameTables, (String)"nameTables");
        MoveBodilessDeclarationsToSeparatePlaceKt.moveBodilessDeclarationsToSeparatePlace(context2, moduleFragment);
        CompilerPhaseKt.invokeToplevel((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), new PhaseConfig(JsLoweringPhasesKt.getJsPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), (CommonBackendContext)context2, CollectionsKt.listOf((Object)moduleFragment));
        IrModuleToJsTransformer transformer2 = new IrModuleToJsTransformer(context2, null, true, nameTables, false, false, false, false, 240, null);
        JsCode jsCode2 = transformer2.generateModule(CollectionsKt.listOf((Object)moduleFragment)).getJsCode();
        Intrinsics.checkNotNull((Object)jsCode2);
        return jsCode2.getMainModule();
    }
}

