/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010#\u001a\u00020\r2\u0006\u0010 \u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\f\u0010'\u001a\u00020\r*\u00020(H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerImpl;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "newNameTables", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;)V", "associatedObjectKeyMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "getAssociatedObjectKey", "irClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "toJsName", "", "backend.js"})
public final class IrNamerImpl
implements IrNamer {
    @NotNull
    private final NameTables newNameTables;
    @NotNull
    private final Map<IrClass, Integer> associatedObjectKeyMap;

    public IrNamerImpl(@NotNull NameTables newNameTables) {
        Intrinsics.checkNotNullParameter((Object)newNameTables, (String)"newNameTables");
        this.newNameTables = newNameTables;
        boolean bl = false;
        this.associatedObjectKeyMap = new LinkedHashMap();
    }

    private final JsName toJsName(String $this$toJsName) {
        return new JsName($this$toJsName);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.toJsName(this.newNameTables.getNameForStaticDeclaration(declaration2));
    }

    @Override
    @Nullable
    public JsName getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        String string2 = this.newNameTables.getNameForLoop(loop2);
        return string2 == null ? null : this.toJsName(string2);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        return this.getNameForStaticDeclaration(IrUtilsKt.getParentAsClass(constructor2));
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        boolean bl = function2.getDispatchReceiverParameter() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.toJsName(this.newNameTables.getNameForMemberFunction(function2));
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        boolean bl = !field.isStatic();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.toJsName(this.newNameTables.getNameForMemberField(field));
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return field.isStatic() || field.getParent() instanceof IrScript ? this.getNameForStaticDeclaration(field) : this.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForValueDeclaration(@NotNull IrValueDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.getNameForStaticDeclaration(klass);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.getNameForStaticDeclaration(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(property2).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.getJsNameOrKotlinName().asString()");
        return this.toJsName(string2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        IrDeclarationParent parent2 = klass.getParent();
        if (klass.isCompanion()) {
            return this.getRefForExternalClass((IrClass)parent2);
        }
        Object object = AnnotationUtilsKt.getJsNameOrKotlinName(klass).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"klass.getJsNameOrKotlinName().identifier");
        String currentClassName = object;
        object = parent2;
        if (object instanceof IrClass) {
            jsNameRef = new JsNameRef(currentClassName, (JsExpression)this.getRefForExternalClass((IrClass)parent2));
        } else if (object instanceof IrPackageFragment) {
            jsNameRef = new JsNameRef(currentClassName);
        } else {
            String string2 = Intrinsics.stringPlus((String)"Unsupported external class parent ", (Object)parent2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return jsNameRef;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        if (AnnotationUtilsKt.isAssociatedObjectAnnotatedAnnotation(irClass2)) {
            Integer n;
            Map<IrClass, Integer> $this$getOrPut$iv = this.associatedObjectKeyMap;
            boolean $i$f$getOrPut = false;
            Integer value$iv = $this$getOrPut$iv.get(irClass2);
            if (value$iv == null) {
                boolean bl = false;
                Integer answer$iv = this.associatedObjectKeyMap.size();
                $this$getOrPut$iv.put(irClass2, answer$iv);
                n = answer$iv;
            } else {
                n = value$iv;
            }
            return n;
        }
        return null;
    }
}

