/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterException;
import org.jetbrains.kotlin.ir.interpreter.stack.Frame;
import org.jetbrains.kotlin.ir.interpreter.stack.InterpreterFrame;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\b\u0010\u001b\u001a\u00020\u0003H\u0002J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u000eJ\b\u0010%\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/FrameContainer;", "", "current", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "(Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;)V", "frameEntryPoint", "", "getFrameEntryPoint", "()Ljava/lang/String;", "setFrameEntryPoint", "(Ljava/lang/String;)V", "innerStack", "", "addAll", "", "variables", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "addSubFrame", "frame", "addVar", "variable", "contains", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getAll", "getTopFrame", "getVariable", "hasReturnValue", "peekReturnValue", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "popReturnValue", "pushReturnValue", "container", "state", "removeSubFrame", "toString", "ir.interpreter"})
final class FrameContainer {
    @Nullable
    private String frameEntryPoint;
    @NotNull
    private final List<Frame> innerStack;

    public FrameContainer(@NotNull Frame current2) {
        Intrinsics.checkNotNullParameter((Object)current2, (String)"current");
        Object[] objectArray = new Frame[]{current2};
        this.innerStack = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public /* synthetic */ FrameContainer(Frame frame, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            frame = new InterpreterFrame(null, null, 3, null);
        }
        this(frame);
    }

    @Nullable
    public final String getFrameEntryPoint() {
        return this.frameEntryPoint;
    }

    public final void setFrameEntryPoint(@Nullable String string2) {
        this.frameEntryPoint = string2;
    }

    private final Frame getTopFrame() {
        return (Frame)CollectionsKt.first(this.innerStack);
    }

    public final void addSubFrame(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.innerStack.add(0, frame);
    }

    public final void removeSubFrame() {
        if (this.getTopFrame().hasReturnValue() && this.innerStack.size() > 1) {
            this.innerStack.get(1).pushReturnValue(this.getTopFrame());
        }
        this.innerStack.remove(0);
    }

    public final void addVar(@NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        this.getTopFrame().addVar(variable2);
    }

    public final void addAll(@NotNull List<Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.getTopFrame().addAll(variables);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Variable> getAll() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.innerStack;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Frame it = (Frame)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getAll();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Variable getVariable(@NotNull IrSymbol symbol2) {
        Variable variable2;
        block2: {
            Variable variable3;
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            Iterable $this$firstNotNullResult$iv = this.innerStack;
            boolean $i$f$firstNotNullResult = false;
            for (Object element$iv : $this$firstNotNullResult$iv) {
                Frame it = (Frame)element$iv;
                boolean bl = false;
                Variable result$iv = it.getVariable(symbol2);
                if (result$iv == null) continue;
                variable3 = result$iv;
                break block2;
            }
            variable3 = variable2 = null;
        }
        if (variable2 == null) {
            throw new InterpreterException(symbol2 + " not found");
        }
        return variable2;
    }

    public final boolean contains(@NotNull IrSymbol symbol2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            Iterable $this$any$iv = this.innerStack;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Frame it = (Frame)element$iv;
                    boolean bl2 = false;
                    if (!it.contains(symbol2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean hasReturnValue() {
        return this.getTopFrame().hasReturnValue();
    }

    public final void pushReturnValue(@NotNull FrameContainer container2) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        this.getTopFrame().pushReturnValue(container2.getTopFrame());
    }

    public final void pushReturnValue(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.getTopFrame().pushReturnValue(state);
    }

    @NotNull
    public final State popReturnValue() {
        return this.getTopFrame().popReturnValue();
    }

    @NotNull
    public final State peekReturnValue() {
        return this.getTopFrame().peekReturnValue();
    }

    @NotNull
    public String toString() {
        String string2 = this.frameEntryPoint;
        return string2 == null ? "Not defined" : string2;
    }

    public FrameContainer() {
        this(null, 1, null);
    }
}

