/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.dce.Context;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\r\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\n\u001a&\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000e0\f*\f\u0012\b\u0012\u00060\rR\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u000e\u001a*\u0010\u0010\u001a\u00020\u0011*\u00060\rR\u00020\u000e2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000e0\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u0018\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u001b\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0007\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u001e\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003\u00a8\u0006 "}, d2={"isSpecialFunction", "", "expr", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "specialFunction", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "asString", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "extractReachableRoots", "", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "Lorg/jetbrains/kotlin/js/dce/Context;", "context", "extractRootsImpl", "", "target", "", "isAmdDefine", "function", "isDefineInlineFunction", "isDefineModule", "isKotlinFunction", "name", "isObjectDefineProperty", "isObjectFunction", "functionName", "isObjectGetOwnPropertyDescriptor", "isTopLevelFunction", "isWrapFunction", "js.dce"})
public final class UtilKt {
    public static final boolean isObjectDefineProperty(@NotNull Context $this$isObjectDefineProperty, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isObjectDefineProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isObjectFunction($this$isObjectDefineProperty, function2, "defineProperty");
    }

    public static final boolean isObjectGetOwnPropertyDescriptor(@NotNull Context $this$isObjectGetOwnPropertyDescriptor, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isObjectGetOwnPropertyDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isObjectFunction($this$isObjectGetOwnPropertyDescriptor, function2, "getOwnPropertyDescriptor");
    }

    public static final boolean isDefineModule(@NotNull Context $this$isDefineModule, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefineModule, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($this$isDefineModule, function2, "defineModule");
    }

    public static final boolean isDefineInlineFunction(@NotNull Context $this$isDefineInlineFunction, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefineInlineFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($this$isDefineInlineFunction, function2, "defineInlineFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.DEFINE_INLINE_FUNCTION);
    }

    public static final boolean isWrapFunction(@NotNull Context $this$isWrapFunction, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isWrapFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($this$isWrapFunction, function2, "wrapFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.WRAP_FUNCTION);
    }

    public static final boolean isObjectFunction(@NotNull Context $this$isObjectFunction, @NotNull JsExpression function2, @NotNull String functionName) {
        Context.Node node;
        HasMetadata hasMetadata;
        Intrinsics.checkNotNullParameter((Object)$this$isObjectFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        if (!(function2 instanceof JsNameRef)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)functionName)) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        JsNameRef jsNameRef = hasMetadata = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        if (hasMetadata == null) {
            return false;
        }
        JsNameRef receiver = hasMetadata;
        if ((hasMetadata = receiver.getName()) == null) {
            node = null;
        } else {
            jsExpression = hasMetadata;
            boolean bl = false;
            boolean bl2 = false;
            JsExpression it = jsExpression;
            boolean bl3 = false;
            node = $this$isObjectFunction.getNodes().get(it);
        }
        if (node != null) {
            return false;
        }
        return Intrinsics.areEqual((Object)receiver.getIdent(), (Object)"Object");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFunction(@NotNull Context $this$isKotlinFunction, @NotNull JsExpression function2, @NotNull String name) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(function2 instanceof JsNameRef)) return false;
        if (!Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)name)) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        if (!(jsExpression instanceof JsNameRef)) return false;
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        Object object = jsNameRef;
        if (object == null) {
            return false;
        }
        JsName jsName2 = jsName = ((JsNameRef)object).getName();
        if (jsName == null) {
            return false;
        }
        Object object2 = jsName;
        JsName receiver = object2;
        object2 = $this$isKotlinFunction.getNodes();
        boolean bl = false;
        object = object2;
        boolean bl2 = false;
        if (!object.containsKey(receiver)) return false;
        object2 = receiver.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"receiver.ident");
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        boolean bl3 = false;
        Object object3 = object2;
        boolean bl4 = false;
        String string2 = ((String)object3).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!Intrinsics.areEqual((Object)string2, (Object)"kotlin")) return false;
        return true;
    }

    public static final boolean isSpecialFunction(@NotNull JsExpression expr, @NotNull SpecialFunction specialFunction) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)((Object)specialFunction), (String)"specialFunction");
        return expr instanceof JsNameRef && ((JsNameRef)expr).getQualifier() == null && ((jsName = ((JsNameRef)expr).getName()) == null ? null : MetadataProperties.getSpecialFunction(jsName)) == specialFunction;
    }

    public static final boolean isAmdDefine(@NotNull Context $this$isAmdDefine, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isAmdDefine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isTopLevelFunction($this$isAmdDefine, function2, "define");
    }

    public static final boolean isTopLevelFunction(@NotNull Context $this$isTopLevelFunction, @NotNull JsExpression function2, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(function2 instanceof JsNameRef) || ((JsNameRef)function2).getQualifier() != null) {
            return false;
        }
        return Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)name) && !CollectionsKt.contains((Iterable)$this$isTopLevelFunction.getNodes().keySet(), (Object)((JsNameRef)function2).getName());
    }

    @Nullable
    public static final JsLocation extractLocation(@NotNull JsNode $this$extractLocation) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$extractLocation, (String)"<this>");
        JsNode jsNode = $this$extractLocation;
        JsLocation jsLocation = jsNode instanceof SourceInfoAwareJsNode ? ((object2 = ((SourceInfoAwareJsNode)$this$extractLocation).getSource()) instanceof JsLocation ? (JsLocation)object2 : null) : (jsNode instanceof JsExpressionStatement ? ((object = ((JsExpressionStatement)$this$extractLocation).getExpression().getSource()) instanceof JsLocation ? (JsLocation)object : null) : null);
        return jsLocation;
    }

    @NotNull
    public static final String asString(@NotNull JsLocation $this$asString) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        String string2 = $this$asString.getFile();
        int n = StringsKt.lastIndexOf$default((CharSequence)$this$asString.getFile(), (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String simpleFileName = string4;
        return simpleFileName + ':' + ($this$asString.getStartLine() + 1);
    }

    @NotNull
    public static final Iterable<Context.Node> extractReachableRoots(@NotNull Iterable<Context.Node> $this$extractReachableRoots, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter($this$extractReachableRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        context2.clearVisited();
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable<Context.Node> $this$forEach$iv = $this$extractReachableRoots;
        boolean $i$f$forEach = false;
        Iterator<Context.Node> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Context.Node element$iv;
            Context.Node it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (!it.getReachable()) continue;
            UtilKt.extractRootsImpl(it.getOriginal(), result2, context2);
        }
        return result2;
    }

    private static final void extractRootsImpl(Context.Node $this$extractRootsImpl, List<Context.Node> target, Context context2) {
        if (!context2.visit($this$extractRootsImpl.getOriginal())) {
            return;
        }
        Context.Node parent2 = $this$extractRootsImpl.getOriginal().getParent();
        if (parent2 == null) {
            Collection collection = target;
            Context.Node node = $this$extractRootsImpl.getOriginal();
            boolean bl = false;
            collection.add(node);
        } else {
            UtilKt.extractRootsImpl(parent2, target, context2);
        }
    }
}

