/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactory;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactoryImpl;", "Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "()V", "javaLangClassType", "getJavaLangClassType", "()Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "boxType", "possiblyPrimitiveType", "createFromString", "representation", "", "createObjectType", "Lorg/jetbrains/kotlin/load/kotlin/JvmType$Object;", "internalName", "createPrimitiveType", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "toString", "type", "descriptors.jvm"})
final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    @NotNull
    public static final JvmTypeFactoryImpl INSTANCE = new JvmTypeFactoryImpl();

    private JvmTypeFactoryImpl() {
    }

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter((Object)possiblyPrimitiveType, (String)"possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            String string2 = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"byFqNameWithoutInnerClasses(possiblyPrimitiveType.jvmPrimitiveType.wrapperFqName).internalName");
            jvmType = this.createObjectType(string2);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        int n;
        Object object;
        JvmPrimitiveType jvmPrimitiveType;
        int n2;
        char firstChar;
        block8: {
            JvmPrimitiveType jvmPrimitiveType2;
            Intrinsics.checkNotNullParameter((Object)representation, (String)"representation");
            CharSequence charSequence = representation;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-JvmTypeFactoryImpl$createFromString$22 = false;
                String $i$a$-assert-JvmTypeFactoryImpl$createFromString$22 = "empty string as JvmType";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmTypeFactoryImpl$createFromString$22));
            }
            firstChar = representation.charAt(0);
            JvmPrimitiveType[] $this$firstOrNull$iv = JvmPrimitiveType.values();
            boolean $i$f$firstOrNull = false;
            JvmPrimitiveType[] jvmPrimitiveTypeArray = $this$firstOrNull$iv;
            n2 = jvmPrimitiveTypeArray.length;
            for (int i = 0; i < n2; ++i) {
                JvmPrimitiveType element$iv;
                JvmPrimitiveType it = element$iv = jvmPrimitiveTypeArray[i];
                boolean bl3 = false;
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                jvmPrimitiveType2 = element$iv;
                break block8;
            }
            jvmPrimitiveType2 = jvmPrimitiveType = null;
        }
        if (jvmPrimitiveType != null) {
            object = jvmPrimitiveType;
            n = 0;
            boolean bl = false;
            JvmPrimitiveType it = object;
            boolean bl4 = false;
            return new JvmType.Primitive(it);
        }
        char c = firstChar;
        if (c == 'V') {
            jvmType = new JvmType.Primitive(null);
        } else if (c == '[') {
            object = representation;
            n = 1;
            boolean bl = false;
            String string2 = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            jvmType = new JvmType.Array(this.createFromString(string2));
        } else {
            boolean bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, (char)';', (boolean)false, (int)2, null);
            n = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string3 = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            String string4 = representation;
            n = 1;
            int n3 = representation.length() - 1;
            n2 = 0;
            String string5 = string4.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jvmType = new JvmType.Object(string5);
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createPrimitiveType(@NotNull PrimitiveType primitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"primitiveType");
        PrimitiveType primitiveType2 = primitiveType;
        int n = WhenMappings.$EnumSwitchMapping$0[primitiveType2.ordinal()];
        switch (n) {
            case 1: {
                jvmType = JvmType.Companion.getBOOLEAN$descriptors_jvm();
                break;
            }
            case 2: {
                jvmType = JvmType.Companion.getCHAR$descriptors_jvm();
                break;
            }
            case 3: {
                jvmType = JvmType.Companion.getBYTE$descriptors_jvm();
                break;
            }
            case 4: {
                jvmType = JvmType.Companion.getSHORT$descriptors_jvm();
                break;
            }
            case 5: {
                jvmType = JvmType.Companion.getINT$descriptors_jvm();
                break;
            }
            case 6: {
                jvmType = JvmType.Companion.getFLOAT$descriptors_jvm();
                break;
            }
            case 7: {
                jvmType = JvmType.Companion.getLONG$descriptors_jvm();
                break;
            }
            case 8: {
                jvmType = JvmType.Companion.getDOUBLE$descriptors_jvm();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName2) {
        Intrinsics.checkNotNullParameter((Object)internalName2, (String)"internalName");
        return new JvmType.Object(internalName2);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            string2 = Intrinsics.stringPlus((String)"[", (Object)this.toString(((JvmType.Array)type2).getElementType()));
        } else if (jvmType instanceof JvmType.Primitive) {
            String string3;
            String string4;
            JvmPrimitiveType jvmPrimitiveType = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            string2 = string4 = jvmPrimitiveType == null ? "V" : ((string3 = jvmPrimitiveType.getDesc()) == null ? "V" : string3);
        } else if (jvmType instanceof JvmType.Object) {
            string2 = 'L' + ((JvmType.Object)type2).getInternalName() + ';';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            nArray[PrimitiveType.CHAR.ordinal()] = 2;
            nArray[PrimitiveType.BYTE.ordinal()] = 3;
            nArray[PrimitiveType.SHORT.ordinal()] = 4;
            nArray[PrimitiveType.INT.ordinal()] = 5;
            nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            nArray[PrimitiveType.LONG.ordinal()] = 7;
            nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

