/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.deserialization;

import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000f\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0011\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "strings", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$StringTable;", "qualifiedNames", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable;", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$StringTable;Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable;)V", "getPackageFqName", "", "index", "", "getQualifiedClassName", "getString", "isLocalClassName", "", "traverseIds", "Lkotlin/Triple;", "", "startingIndex", "metadata"})
public final class NameResolverImpl
implements NameResolver {
    @NotNull
    private final ProtoBuf.StringTable strings;
    @NotNull
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolverImpl(@NotNull ProtoBuf.StringTable strings2, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)qualifiedNames, (String)"qualifiedNames");
        this.strings = strings2;
        this.qualifiedNames = qualifiedNames;
    }

    @Override
    @NotNull
    public String getString(int index2) {
        String string2 = this.strings.getString(index2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"strings.getString(index)");
        return string2;
    }

    @Override
    @NotNull
    public String getQualifiedClassName(int index2) {
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(index2);
        List packageFqNameSegments = (List)triple.component1();
        List relativeClassNameSegments = (List)triple.component2();
        String className2 = CollectionsKt.joinToString$default((Iterable)relativeClassNameSegments, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return packageFqNameSegments.isEmpty() ? className2 : CollectionsKt.joinToString$default((Iterable)packageFqNameSegments, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) + '/' + className2;
    }

    @Override
    public boolean isLocalClassName(int index2) {
        return (Boolean)this.traverseIds(index2).getThird();
    }

    @NotNull
    public final String getPackageFqName(int index2) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)this.traverseIds(index2).getFirst()), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int startingIndex) {
        int index2 = startingIndex;
        LinkedList<String> packageNameSegments = new LinkedList<String>();
        LinkedList<String> relativeClassNameSegments = new LinkedList<String>();
        boolean local2 = false;
        while (index2 != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index2);
            String shortName = this.strings.getString(proto.getShortName());
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind = proto.getKind();
            Intrinsics.checkNotNull((Object)kind);
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind2 = kind;
            int n = WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()];
            switch (n) {
                case 1: {
                    relativeClassNameSegments.addFirst(shortName);
                    break;
                }
                case 2: {
                    packageNameSegments.addFirst(shortName);
                    break;
                }
                case 3: {
                    relativeClassNameSegments.addFirst(shortName);
                    local2 = true;
                }
            }
            index2 = proto.getParentQualifiedName();
        }
        return new Triple(packageNameSegments, relativeClassNameSegments, (Object)local2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.values().length];
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS.ordinal()] = 1;
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE.ordinal()] = 2;
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

