/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.SimplePSIKotlinCallArgument;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NullableVarargArgumentCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class NullableVarargArgumentCallChecker
implements CallChecker {
    @NotNull
    public static final NullableVarargArgumentCallChecker INSTANCE = new NullableVarargArgumentCallChecker();

    private NullableVarargArgumentCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return;
        }
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            this.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), reportOn, context2);
            return;
        }
        if (!(resolvedCall2 instanceof NewResolvedCallImpl)) {
            return;
        }
        for (ResolvedCallArgument argument : ((NewResolvedCallImpl)resolvedCall2).getArgumentMappingByOriginal().values()) {
            for (KotlinCallArgument arg : argument.getArguments()) {
                KotlinType type2;
                KotlinType kotlinType;
                ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo;
                LeafPsiElement leafPsiElement;
                if (!arg.isSpread() || !(arg instanceof SimplePSIKotlinCallArgument) || (leafPsiElement = ((SimplePSIKotlinCallArgument)arg).getValueArgument().getSpreadElement()) == null) continue;
                LeafPsiElement spreadElement = leafPsiElement;
                ReceiverValueWithSmartCastInfo $this$safeAs$iv = ((SimplePSIKotlinCallArgument)arg).getReceiver();
                boolean $i$f$safeAs = false;
                ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo2 = $this$safeAs$iv;
                if (!(receiverValueWithSmartCastInfo2 instanceof ReceiverValueWithSmartCastInfo)) {
                    receiverValueWithSmartCastInfo2 = null;
                }
                if ((receiverValueWithSmartCastInfo = receiverValueWithSmartCastInfo2) == null) continue;
                ReceiverValueWithSmartCastInfo receiver = receiverValueWithSmartCastInfo;
                if (ArgumentsUtilsKt.getStableType(receiver).getConstructor() instanceof TypeVariableTypeConstructor) {
                    KotlinType kotlinType2;
                    KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)context2.getTrace().getBindingContext().get(BindingContext.EXPRESSION_TYPE_INFO, ((SimplePSIKotlinCallArgument)arg).getValueArgument().getArgumentExpression());
                    KotlinType kotlinType3 = kotlinType2 = kotlinTypeInfo == null ? null : kotlinTypeInfo.getType();
                    kotlinType = kotlinType2 == null ? (KotlinType)ArgumentsUtilsKt.getStableType(receiver) : kotlinType2;
                } else {
                    kotlinType = ArgumentsUtilsKt.getStableType(receiver);
                }
                if ((type2 = kotlinType) instanceof FlexibleType || !TypeUtils.isNullableType(type2)) continue;
                context2.getTrace().report(Errors.SPREAD_OF_NULLABLE.on((LeafPsiElement)((PsiElement)spreadElement)));
            }
        }
    }
}

