/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "collectDiagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticFor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "incompatibilityDiagnosticFor", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "ClassifierUsage", "frontend"})
public final class MissingDependencyClassChecker
implements CallChecker {
    @NotNull
    public static final MissingDependencyClassChecker INSTANCE = new MissingDependencyClassChecker();

    private MissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(resultingDescriptor, (String)"resultingDescriptor");
        for (Diagnostic diagnostic : this.collectDiagnostics(reportOn, (CallableDescriptor)resultingDescriptor)) {
            context2.getTrace().report(diagnostic);
        }
        Object object = resultingDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)resultingDescriptor : null;
        DeserializedContainerSource containerSource = object == null ? null : object.getContainerSource();
        if ((object = this.incompatibilityDiagnosticFor(containerSource, reportOn)) != null) {
            Object object2 = object;
            DiagnosticSink diagnosticSink = context2.getTrace();
            boolean bl = false;
            boolean bl2 = false;
            Object p0 = object2;
            boolean bl3 = false;
            diagnosticSink.report((Diagnostic)p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassifierDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 instanceof NotFoundClasses.MockClassDescriptor) {
            return Errors.MISSING_DEPENDENCY_CLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor2));
        }
        return this.incompatibilityDiagnosticFor(descriptor2.getSource(), reportOn);
    }

    private final Diagnostic incompatibilityDiagnosticFor(SourceElement source, PsiElement reportOn) {
        if (source instanceof DeserializedContainerSource) {
            IncompatibleVersionErrorData<?> incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
            if (incompatibility != null) {
                return Errors.INCOMPATIBLE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString(), incompatibility);
            }
            if (((DeserializedContainerSource)source).isPreReleaseInvisible()) {
                return Errors.PRE_RELEASE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.FIR_UNSTABLE) {
                return Errors.FIR_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.IR_UNSTABLE) {
                return Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
        }
        return null;
    }

    private final Set<Diagnostic> collectDiagnostics(PsiElement reportOn, CallableDescriptor descriptor2) {
        boolean bl;
        Annotated annotated;
        Set result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(1);
        Object object = descriptor2.getReturnType();
        if (object != null) {
            annotated = object;
            boolean bl2 = false;
            bl = false;
            Annotated p0 = annotated;
            boolean bl3 = false;
            MissingDependencyClassChecker.collectDiagnostics$consider-2(reportOn, result2, (KotlinType)p0);
        }
        annotated = descriptor2.getExtensionReceiverParameter();
        Object object2 = object = annotated == null ? null : annotated.getValue();
        if (object != null && (annotated = object.getType()) != null) {
            Annotated annotated2 = annotated;
            bl = false;
            boolean p0 = false;
            Annotated p02 = annotated2;
            boolean bl4 = false;
            MissingDependencyClassChecker.collectDiagnostics$consider-2(reportOn, result2, (KotlinType)p02);
        }
        object = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, (String)"descriptor.valueParameters");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl5 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
            MissingDependencyClassChecker.collectDiagnostics$consider-2(reportOn, result2, kotlinType);
        }
        return result2;
    }

    private static final void collectDiagnostics$consider(PsiElement $reportOn, Set<Diagnostic> result2, ClassDescriptor classDescriptor2) {
        ClassDescriptor classDescriptor3;
        Diagnostic diagnostic = INSTANCE.diagnosticFor(classDescriptor2, $reportOn);
        if (diagnostic != null) {
            result2.add(diagnostic);
            return;
        }
        DeclarationDescriptor declarationDescriptor = classDescriptor2.getContainingDeclaration();
        ClassDescriptor classDescriptor4 = classDescriptor3 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor3 != null) {
            declarationDescriptor = classDescriptor3;
            boolean bl = false;
            boolean bl2 = false;
            DeclarationDescriptor p0 = declarationDescriptor;
            boolean bl3 = false;
            MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, (ClassDescriptor)p0);
        }
    }

    private static final void collectDiagnostics$consider-2(PsiElement $reportOn, Set<Diagnostic> result2, KotlinType type2) {
        if (!CallCheckerKt.isComputingDeferredType(INSTANCE, type2)) {
            ClassDescriptor classDescriptor2;
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor3 = classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor2 != null) {
                classifierDescriptor = classDescriptor2;
                boolean bl = false;
                boolean bl2 = false;
                ClassifierDescriptor p0 = classifierDescriptor;
                boolean bl3 = false;
                MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, (ClassDescriptor)p0);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        public static final ClassifierUsage INSTANCE = new ClassifierUsage();

        private ClassifierUsage() {
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            boolean bl;
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Diagnostic diagnostic = INSTANCE.diagnosticFor(targetDescriptor, element);
            if (diagnostic != null) {
                object2 = diagnostic;
                object = context2.getTrace();
                boolean bl2 = false;
                bl = false;
                Object p0 = object2;
                boolean bl3 = false;
                object.report((Diagnostic)p0);
            }
            object2 = targetDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)((Object)targetDescriptor) : null;
            DeserializedContainerSource containerSource = object2 == null ? null : object2.getContainerSource();
            object2 = INSTANCE.incompatibilityDiagnosticFor(containerSource, element);
            if (object2 != null) {
                object = object2;
                DiagnosticSink diagnosticSink = context2.getTrace();
                bl = false;
                boolean bl4 = false;
                Object p0 = object;
                boolean bl5 = false;
                diagnosticSink.report((Diagnostic)p0);
            }
        }
    }
}

