/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LanguageVersionSettingsProvider;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001f\u001a\u00020\u0014*\u00020\u00192\u0006\u0010 \u001a\u00020\u0016H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lcom/intellij/openapi/project/Project;)V", "ideService", "Lorg/jetbrains/kotlin/resolve/LanguageVersionSettingsProvider;", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmDefaultsInHierarchy", "", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "checkPossibleClashMember", "inheritedFun", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkSpecializationInCompatibilityMode", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "actualImplementation", "performSpecializationCheck", "findPossibleClashMember", "isCompiledToJvmDefaultWithProperMode", "compilationDefaultMode", "frontend.java"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;
    @Nullable
    private final LanguageVersionSettingsProvider ideService;

    public JvmDefaultChecker(@NotNull JvmTarget jvmTarget, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.jvmTarget = jvmTarget;
        this.ideService = LanguageVersionSettingsProvider.Companion.getInstance(project);
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void $this$forEach$iv;
        Map.Entry $dstr$_u24__u24$actualImplementation232;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        boolean performSpecializationCheck;
        Object list$iv$iv;
        Object $this$flatMap$iv;
        Collection<? extends CallableMemberDescriptor> $this$any$iv;
        boolean $i$f$any;
        Object $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JvmDefaultMode jvmDefaultMode = context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.INSTANCE.getJvmDefaultMode());
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME());
        if (annotationDescriptor != null) {
            KtElement reportOn;
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            AnnotationDescriptor annotationDescriptor3 = annotationDescriptor2;
            boolean bl3 = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor3);
            KtElement ktElement = reportOn = ktAnnotationEntry == null ? (KtElement)declaration2 : (KtElement)ktAnnotationEntry;
            if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_NOT_IN_INTERFACE.on(reportOn));
            } else if (this.getJvmTarget() == JvmTarget.JVM_1_6) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefault"));
            } else if (!jvmDefaultMode.isEnabled()) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)declaration2), "JvmDefault"));
            }
            return;
        }
        annotationDescriptor = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor != null) {
            KtElement reportOn;
            AnnotationDescriptor annotationDescriptor4 = annotationDescriptor;
            boolean bl = false;
            boolean bl4 = false;
            AnnotationDescriptor annotationDescriptor5 = annotationDescriptor4;
            boolean bl5 = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor5);
            KtElement ktElement = reportOn = ktAnnotationEntry == null ? (KtElement)declaration2 : (KtElement)ktAnnotationEntry;
            if (this.getJvmTarget() == JvmTarget.JVM_1_6) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefaultWithoutCompatibility"));
            } else if (!jvmDefaultMode.isEnabled()) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)reportOn), "JvmDefaultWithoutCompatibility"));
            }
            return;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            boolean hasDeclaredJvmDefaults;
            block33: {
                boolean bl;
                MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope();
                Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"descriptor.unsubstitutedMemberScope");
                Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection collection = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                    collection.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)collection;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && $this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : $this$any$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)t;
                        boolean bl6 = false;
                        if (!(it.getKind().isReal() && JvmAnnotationUtilKt.isCompiledToJvmDefault(it, jvmDefaultMode))) continue;
                        bl = true;
                        break block33;
                    }
                    bl = hasDeclaredJvmDefaults = false;
                }
            }
            if (!hasDeclaredJvmDefaults && !this.checkJvmDefaultsInHierarchy(descriptor2, jvmDefaultMode)) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_THROUGH_INHERITANCE.on((KtDeclaration)((PsiElement)declaration2)));
            }
        }
        if (!jvmDefaultMode.getForAllMethodsWithBody() && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
            boolean bl;
            block34: {
                Collection<? extends CallableMemberDescriptor> collection = $this$any$iv = descriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)descriptor2 : null;
                if ($this$any$iv == null) {
                    return;
                }
                CallableMemberDescriptor memberDescriptor = $this$any$iv;
                if (descriptor2 instanceof PropertyAccessorDescriptor) {
                    return;
                }
                $this$any$iv = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"memberDescriptor.overriddenDescriptors");
                $this$any$iv = $this$any$iv;
                $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : $this$any$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)t;
                        boolean bl7 = false;
                        if (!it.getAnnotations().hasAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME())) continue;
                        bl = true;
                        break block34;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context2.getTrace().report(ErrorsJvm.JVM_DEFAULT_REQUIRED_FOR_OVERRIDE.on((KtDeclaration)((PsiElement)declaration2)));
            } else if (jvmDefaultMode.isEnabled()) {
                void $this$flatMapTo$iv$iv22;
                $this$any$iv = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue($this$any$iv, (String)"descriptor.overriddenDescriptors");
                $this$flatMap$iv = $this$any$iv;
                boolean $i$f$flatMap = false;
                $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
                Collection collection = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv22) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                    boolean bl8 = false;
                    Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations(it);
                    Intrinsics.checkNotNullExpressionValue(set, (String)"getOverriddenDeclarations(it)");
                    list$iv$iv = set;
                    CollectionsKt.addAll((Collection)collection, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = CollectionsKt.toSet((Iterable)((List)collection));
                $i$f$flatMap = false;
                boolean $this$flatMapTo$iv$iv22 = false;
                Object object = $this$flatMap$iv;
                boolean bl9 = false;
                for (CallableMemberDescriptor realDescriptor : OverridingUtil.filterOutOverridden(object)) {
                    if (!(realDescriptor instanceof JavaMethodDescriptor) || ((JavaMethodDescriptor)realDescriptor).getModality() == Modality.ABSTRACT) continue;
                    context2.getTrace().report(ErrorsJvm.NON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT.on((KtDeclaration)((PsiElement)declaration2)));
                    return;
                }
            }
        }
        if (!jvmDefaultMode.isEnabled() || !(descriptor2 instanceof ClassDescriptor) || DescriptorUtils.isInterface(descriptor2) || DescriptorUtils.isAnnotationClass(descriptor2)) {
            return;
        }
        boolean bl = performSpecializationCheck = jvmDefaultMode.isCompatibility() && !JvmAnnotationUtilKt.hasJvmDefaultNoCompatibilityAnnotation(descriptor2) && (((ClassDescriptor)descriptor2).getModality() == Modality.OPEN || ((ClassDescriptor)descriptor2).getModality() == Modality.ABSTRACT) && !DescriptorUtilsKt.isEffectivelyPrivateApi((DeclarationDescriptorWithVisibility)descriptor2);
        if (DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2) == null && !performSpecializationCheck) {
            return;
        }
        $this$flatMap$iv = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation((ClassDescriptor)descriptor2, true);
        boolean $i$f$filter = false;
        void $this$flatMapTo$iv$iv22 = $this$filter$iv;
        Map map = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void bl7 = $this$filterTo$iv$iv;
        boolean realDescriptor = false;
        list$iv$iv = bl7.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Map.Entry element$iv$iv;
            $dstr$_u24__u24$actualImplementation232 = element$iv$iv = list$iv$iv.next();
            boolean bl10 = false;
            Map.Entry entry = $dstr$_u24__u24$actualImplementation232;
            boolean bl2 = false;
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)entry.getValue();
            if (!this.isCompiledToJvmDefaultWithProperMode(actualImplementation, jvmDefaultMode)) continue;
            map.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = map;
        boolean $i$f$forEach = false;
        void var8_20 = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator3 = var8_20.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$inheritedMember$actualImplementation = element$iv = iterator3.next();
            boolean bl13 = false;
            Map.Entry element$iv$iv = $dstr$inheritedMember$actualImplementation;
            boolean $dstr$_u24__u24$actualImplementation232 = false;
            CallableMemberDescriptor inheritedMember = (CallableMemberDescriptor)element$iv$iv.getKey();
            $dstr$_u24__u24$actualImplementation232 = $dstr$inheritedMember$actualImplementation;
            boolean bl4 = false;
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)$dstr$_u24__u24$actualImplementation232.getValue();
            if (actualImplementation instanceof FunctionDescriptor && inheritedMember instanceof FunctionDescriptor) {
                if (!this.checkSpecializationInCompatibilityMode((FunctionDescriptor)inheritedMember, (FunctionDescriptor)actualImplementation, context2, declaration2, performSpecializationCheck)) continue;
                this.checkPossibleClashMember(inheritedMember, jvmDefaultMode, context2, declaration2);
                continue;
            }
            if (!(actualImplementation instanceof PropertyDescriptor) || !(inheritedMember instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getterImpl = ((PropertyDescriptor)actualImplementation).getGetter();
            PropertyGetterDescriptor getterInherited = ((PropertyDescriptor)inheritedMember).getGetter();
            if (getterImpl != null && getterInherited != null && jvmDefaultMode.isCompatibility() && !this.checkSpecializationInCompatibilityMode(getterInherited, getterImpl, context2, declaration2, performSpecializationCheck)) continue;
            if (((PropertyDescriptor)actualImplementation).isVar() && ((PropertyDescriptor)inheritedMember).isVar()) {
                PropertySetterDescriptor setterImpl = ((PropertyDescriptor)actualImplementation).getSetter();
                PropertySetterDescriptor setterInherited = ((PropertyDescriptor)inheritedMember).getSetter();
                if (setterImpl != null && setterInherited != null && !this.checkSpecializationInCompatibilityMode(setterInherited, setterImpl, context2, declaration2, performSpecializationCheck)) continue;
            }
            this.checkPossibleClashMember(inheritedMember, jvmDefaultMode, context2, declaration2);
        }
    }

    private final boolean checkSpecializationInCompatibilityMode(FunctionDescriptor inheritedFun, FunctionDescriptor actualImplementation, DeclarationCheckerContext context2, KtDeclaration declaration2, boolean performSpecializationCheck) {
        if (!performSpecializationCheck || actualImplementation instanceof JavaMethodDescriptor) {
            return true;
        }
        String inheritedSignature = MethodSignatureMappingKt.computeJvmDescriptor(inheritedFun, true, false);
        FunctionDescriptor functionDescriptor = actualImplementation.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"actualImplementation.original");
        FunctionDescriptor originalImplementation = functionDescriptor;
        String actualSignature = MethodSignatureMappingKt.computeJvmDescriptor(originalImplementation, true, false);
        if (!Intrinsics.areEqual((Object)inheritedSignature, (Object)actualSignature)) {
            context2.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_COMPATIBILITY_MODE.on((KtDeclaration)((PsiElement)declaration2), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(originalImplementation)));
            return false;
        }
        return true;
    }

    private final void checkPossibleClashMember(CallableMemberDescriptor inheritedFun, JvmDefaultMode jvmDefaultMode, DeclarationCheckerContext context2, KtDeclaration declaration2) {
        CallableMemberDescriptor clashMember = this.findPossibleClashMember(inheritedFun, jvmDefaultMode);
        if (clashMember != null) {
            context2.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_MIXED_MODE.on((KtDeclaration)((PsiElement)declaration2), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(clashMember), jvmDefaultMode.getDescription()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final CallableMemberDescriptor findPossibleClashMember(CallableMemberDescriptor inheritedFun, JvmDefaultMode jvmDefaultMode) {
        block8: {
            block7: {
                var4_3 = inheritedFun.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)var4_3, (String)"inheritedFun.containingDeclaration");
                classDescriptor = var4_3;
                if (!(classDescriptor instanceof ClassDescriptor) || DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)classDescriptor) == null) {
                    return null;
                }
                var5_5 = inheritedFun.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(var5_5, (String)"inheritedFun.overriddenDescriptors");
                $this$filter$iv = var5_5;
                $i$f$filter = false;
                var7_8 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CallableMemberDescriptor)element$iv$iv;
                    $i$a$-filter-JvmDefaultChecker$findPossibleClashMember$classMembers$1 = false;
                    if (!(DescriptorUtils.isInterface(it.getContainingDeclaration()) == false && DescriptorUtils.isAnnotationClass(it.getContainingDeclaration()) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                classMembers = (List)destination$iv$iv;
                $this$firstOrNull$iv = classMembers;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (CallableMemberDescriptor)element$iv;
                    $i$a$-firstOrNull-JvmDefaultChecker$findPossibleClashMember$implicitDefaultImplsDelegate$1 = false;
                    if (it instanceof JavaCallableMemberDescriptor) ** GOTO lbl-1000
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    var12_18 = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation(it, true);
                    if (Intrinsics.areEqual(var12_18 == null ? null : Boolean.valueOf(this.isCompiledToJvmDefaultWithProperMode(var12_18, jvmDefaultMode)), (Object)false)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            implicitDefaultImplsDelegate = v1;
            if (implicitDefaultImplsDelegate != null) {
                return implicitDefaultImplsDelegate;
            }
            $this$firstNotNullResult$iv = classMembers;
            $i$f$firstNotNullResult = false;
            for (T element$iv : $this$firstNotNullResult$iv) {
                it = (CallableMemberDescriptor)element$iv;
                $i$a$-firstNotNullResult-JvmDefaultChecker$findPossibleClashMember$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                result$iv = this.findPossibleClashMember(it, jvmDefaultMode);
                if (result$iv == null) continue;
                v2 = result$iv;
                break block8;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkJvmDefaultsInHierarchy(DeclarationDescriptor descriptor2, JvmDefaultMode jvmDefaultMode) {
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        if (jvmDefaultMode.isEnabled()) {
            return true;
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return true;
        }
        MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope();
        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"descriptor.unsubstitutedMemberScope");
        Iterable $this$filterIsInstance$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null);
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$all$iv = (List)destination$iv$iv;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        object = $this$all$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)element$iv;
            boolean bl2 = false;
            if (!memberDescriptor.getKind().isReal()) {
                boolean bl3;
                Collection<? extends CallableMemberDescriptor> element$iv$iv = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(element$iv$iv, (String)"memberDescriptor.overriddenDescriptors");
                Set set = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)element$iv$iv));
                Intrinsics.checkNotNullExpressionValue(set, (String)"filterOutOverridden(memberDescriptor.overriddenDescriptors.toSet())");
                Iterable $this$all$iv2 = set;
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv2;
                        boolean bl4 = false;
                        if (DescriptorUtils.isInterface(it.getContainingDeclaration())) {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (this.isCompiledToJvmDefaultWithProperMode(it, jvmDefaultMode)) {
                                if (it.getModality() != Modality.ABSTRACT) return false;
                            }
                        }
                        boolean bl5 = true;
                        if (bl5) continue;
                        return false;
                    }
                    bl3 = true;
                }
                if (!bl3) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final boolean isCompiledToJvmDefaultWithProperMode(CallableMemberDescriptor $this$isCompiledToJvmDefaultWithProperMode, JvmDefaultMode compilationDefaultMode) {
        Object object;
        if ($this$isCompiledToJvmDefaultWithProperMode instanceof DeserializedDescriptor) {
            object = compilationDefaultMode;
        } else {
            LanguageVersionSettings languageVersionSettings;
            Object object2 = this.ideService;
            LanguageVersionSettings languageVersionSettings2 = languageVersionSettings = object2 == null ? null : object2.getModuleLanguageVersionSettings(DescriptorUtilsKt.getModule($this$isCompiledToJvmDefaultWithProperMode));
            object = languageVersionSettings == null ? compilationDefaultMode : ((object2 = languageVersionSettings.getFlag(JvmAnalysisFlags.INSTANCE.getJvmDefaultMode())) == null ? compilationDefaultMode : object2);
        }
        JvmDefaultMode jvmDefault = object;
        return JvmAnnotationUtilKt.isCompiledToJvmDefault($this$isCompiledToJvmDefaultWithProperMode, jvmDefault);
    }
}

