/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.multiplatform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaPropertyInitializerEvaluatorImpl;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationAsAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClassObjectAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaEnumValueAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor;", "Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "()V", "convertTypeToKClassValue", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "javaType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "extractDefaultValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "convert", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationArgument;", "frontend.java"})
public final class JavaActualAnnotationArgumentExtractor
implements ExpectedActualDeclarationChecker.ActualAnnotationArgumentExtractor {
    @Override
    @Nullable
    public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor parameter, @NotNull KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
        Object object = parameter.getSource();
        Object object2 = object instanceof JavaSourceElement ? (JavaSourceElement)object : null;
        JavaElement element = object2 == null ? null : object2.getJavaElement();
        Object object3 = object2 = element instanceof JavaMethod ? (JavaMethod)element : null;
        return object2 == null ? null : ((object = object2.getAnnotationParameterDefaultValue()) == null ? null : this.convert((JavaAnnotationArgument)object, expectedType2));
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> convert(JavaAnnotationArgument $this$convert, KotlinType expectedType2) {
        ConstantValue constantValue;
        JavaAnnotationArgument javaAnnotationArgument = $this$convert;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            Object object = ((JavaLiteralAnnotationArgument)$this$convert).getValue();
            if (object == null) {
                constantValue = null;
            } else {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                constantValue = JavaPropertyInitializerEvaluatorImpl.INSTANCE.convertLiteralValue$frontend_java(it, expectedType2);
            }
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            EnumValue enumValue;
            ClassId classId = ((JavaEnumValueAnnotationArgument)$this$convert).getEnumClassId();
            if (classId == null) {
                enumValue = null;
            } else {
                ClassId classId2 = classId;
                boolean bl = false;
                boolean bl4 = false;
                ClassId enumClassId = classId2;
                boolean bl5 = false;
                Name name = ((JavaEnumValueAnnotationArgument)$this$convert).getEntryName();
                if (name == null) {
                    enumValue = null;
                } else {
                    Name name2 = name;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Name entryName = name2;
                    boolean bl8 = false;
                    enumValue = new EnumValue(enumClassId, entryName);
                }
            }
            constantValue = enumValue;
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = TypeUtilsKt.getBuiltIns(expectedType2).getArrayElementType(expectedType2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expectedType.builtIns.getArrayElementType(expectedType)");
            KotlinType elementType = object;
            object = ((JavaArrayAnnotationArgument)$this$convert).getElements();
            ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
            boolean $i$f$mapNotNull = false;
            void var7_15 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConstantValue<?> constantValue2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                JavaAnnotationArgument it = (JavaAnnotationArgument)element$iv$iv;
                boolean bl9 = false;
                if (this.convert(it, elementType) == null) continue;
                boolean bl10 = false;
                boolean bl11 = false;
                ConstantValue<?> it$iv$iv = constantValue2;
                boolean bl12 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            constantValue = constantValueFactory.createArrayValue(list2, expectedType2);
        } else {
            constantValue = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? (ConstantValue)null : (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument ? (ConstantValue)this.convertTypeToKClassValue(((JavaClassObjectAnnotationArgument)$this$convert).getReferencedType()) : null);
        }
        return constantValue;
    }

    private final KClassValue convertTypeToKClassValue(JavaType javaType) {
        KClassValue kClassValue;
        JavaType type2 = javaType;
        int arrayDimensions = 0;
        while (type2 instanceof JavaArrayType) {
            type2 = ((JavaArrayType)type2).getComponentType();
            int n = arrayDimensions;
            arrayDimensions = n + 1;
        }
        JavaType javaType2 = type2;
        if (javaType2 instanceof JavaPrimitiveType) {
            Object object = ((JavaPrimitiveType)type2).getType();
            if (object == null) {
                ClassId classId = ClassId.topLevel(StandardNames.FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(StandardNames.FqNames.unit.toSafe())");
                return new KClassValue(classId, 0);
            }
            PrimitiveType primitiveType = object;
            if (arrayDimensions > 0) {
                object = ClassId.topLevel(primitiveType.getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(primitiveType.arrayTypeFqName)");
                KClassValue kClassValue2 = new KClassValue((ClassId)object, arrayDimensions - 1);
                kClassValue = kClassValue2;
            } else {
                object = ClassId.topLevel(primitiveType.getTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(primitiveType.typeFqName)");
                KClassValue kClassValue3 = new KClassValue((ClassId)object, arrayDimensions);
                kClassValue = kClassValue3;
            }
        } else if (javaType2 instanceof JavaClassifierType) {
            ClassId classId;
            FqName fqName2 = new FqName(((JavaClassifierType)type2).getClassifierQualifiedName());
            ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
            if (classId2 == null) {
                ClassId classId3 = ClassId.topLevel(fqName2);
                Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"topLevel(fqName)");
                classId = classId3;
            } else {
                classId = classId2;
            }
            ClassId classId4 = classId;
            kClassValue = new KClassValue(classId4, arrayDimensions);
        } else {
            kClassValue = null;
        }
        return kClassValue;
    }
}

