/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassQualifier;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "classValueReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "getClassValueReceiver", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getReferenceExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "staticScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getStaticScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "toString", "", "frontend"})
public final class ClassQualifier
implements ClassifierQualifier {
    @NotNull
    private final KtSimpleNameExpression referenceExpression;
    @NotNull
    private final ClassDescriptor descriptor;
    @Nullable
    private final ClassValueReceiver classValueReceiver;

    /*
     * WARNING - void declaration
     */
    public ClassQualifier(@NotNull KtSimpleNameExpression referenceExpression, @NotNull ClassDescriptor descriptor2) {
        ClassValueReceiver classValueReceiver;
        Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.referenceExpression = referenceExpression;
        this.descriptor = descriptor2;
        ClassQualifier classQualifier = this;
        KotlinType kotlinType = DescriptorUtilsKt.getClassValueType(this.getDescriptor());
        if (kotlinType == null) {
            classValueReceiver = null;
        } else {
            void it;
            KotlinType kotlinType2 = kotlinType;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType kotlinType3 = kotlinType2;
            ClassQualifier classQualifier2 = classQualifier;
            boolean bl3 = false;
            ClassValueReceiver classValueReceiver2 = new ClassValueReceiver(this, (KotlinType)it, null, 4, null);
            classQualifier = classQualifier2;
            classValueReceiver = classValueReceiver2;
        }
        classQualifier.classValueReceiver = classValueReceiver;
    }

    @Override
    @NotNull
    public KtSimpleNameExpression getReferenceExpression() {
        return this.referenceExpression;
    }

    @Override
    @NotNull
    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @Nullable
    public ClassValueReceiver getClassValueReceiver() {
        return this.classValueReceiver;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2;
        if (this.getDescriptor().getKind() == ClassKind.ENUM_ENTRY) {
            MemberScope memberScope3 = this.getDescriptor().getStaticScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope3, (String)"descriptor.staticScope");
            memberScope2 = memberScope3;
        } else {
            String string2 = "Static scope for " + this.getDescriptor().getName() + " as class or object";
            MemberScope[] memberScopeArray = new MemberScope[2];
            MemberScope memberScope4 = this.getDescriptor().getStaticScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope4, (String)"descriptor.staticScope");
            memberScopeArray[0] = memberScope4;
            memberScope4 = this.getDescriptor().getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope4, (String)"descriptor.unsubstitutedInnerClassesScope");
            memberScopeArray[1] = memberScope4;
            memberScope2 = ChainedMemberScope.Companion.create(string2, memberScopeArray);
        }
        return memberScope2;
    }

    @NotNull
    public String toString() {
        return "Class{" + this.getDescriptor() + '}';
    }

    @Override
    @Nullable
    public ReceiverValueWithSmartCastInfo getClassValueReceiverWithSmartCastInfo() {
        return ClassifierQualifier.DefaultImpls.getClassValueReceiverWithSmartCastInfo(this);
    }
}

