/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000f\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkInnerDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "checkLocalDeclaration", "checkTopLevelDeclaration", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reportInLocal", "checkers"})
public final class FirSealedSupertypeChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirSealedSupertypeChecker INSTANCE = new FirSealedSupertypeChecker();

    private FirSealedSupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2 instanceof FirClass) {
            if (context2.getContainingDeclarations().size() == 1) {
                this.checkTopLevelDeclaration((FirClass)((Object)declaration2), context2, reporter);
            } else if (FirDeclarationUtilKt.getClassId((FirClass)((Object)declaration2)).isLocal()) {
                this.checkLocalDeclaration((FirClass)((Object)declaration2), context2, reporter);
            } else {
                this.checkInnerDeclaration((FirClass)((Object)declaration2), context2, reporter);
            }
        } else if (declaration2 instanceof FirProperty) {
            FirClass firClass;
            FirExpression $this$safeAs$iv = ((FirProperty)declaration2).getInitializer();
            boolean $i$f$safeAs = false;
            FirExpression firExpression2 = $this$safeAs$iv;
            if (!(firExpression2 instanceof FirClass)) {
                firExpression2 = null;
            }
            if ((firClass = (FirClass)((Object)firExpression2)) == null) {
                return;
            }
            FirClass initializer2 = firClass;
            this.checkLocalDeclaration(initializer2, context2, reporter);
        }
    }

    private final void checkTopLevelDeclaration(FirClass<?> declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterator<FirTypeRef> iterator2 = declaration2.getSuperTypeRefs().iterator();
        while (iterator2.hasNext()) {
            Object fir;
            ClassId classId;
            Object object;
            ClassId classId2;
            FirResolvedTypeRef firResolvedTypeRef;
            FirTypeRef it;
            FirTypeRef $this$safeAs$iv = it = iterator2.next();
            boolean $i$f$safeAs = false;
            FirTypeRef firTypeRef = $this$safeAs$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirClassLikeSymbol<?> $this$safeAs$iv2 = (firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef) == null ? null : firResolvedTypeRef.getType();
            boolean $i$f$safeAs2 = false;
            Object object2 = $this$safeAs$iv2;
            if (!(object2 instanceof ConeClassLikeType)) {
                object2 = null;
            }
            if ((classId2 = (object = (ConeClassLikeType)object2) == null ? null : (($this$safeAs$iv2 = ((ConeClassLikeType)object).getLookupTag()) == null ? null : ((ConeClassLikeLookupTag)((Object)$this$safeAs$iv2)).getClassId())) == null || (classId = classId2).isLocal()) continue;
            $this$safeAs$iv2 = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(classId);
            $this$safeAs$iv2 = $this$safeAs$iv2 == null ? null : (FirClassLikeDeclaration)$this$safeAs$iv2.getFir();
            $i$f$safeAs2 = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv2;
            if (!(firClassLikeSymbol instanceof FirRegularClass)) {
                firClassLikeSymbol = null;
            }
            if ((object = (FirRegularClass)((Object)firClassLikeSymbol)) == null || ((FirRegularClass)(fir = object)).getStatus().getModality() != Modality.SEALED || classId.getOuterClassId() == null) continue;
            this.report(reporter, it.getSource());
            return;
        }
    }

    private final void checkLocalDeclaration(FirClass<?> declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterator<FirTypeRef> iterator2 = declaration2.getSuperTypeRefs().iterator();
        while (iterator2.hasNext()) {
            Object fir;
            ClassId classId;
            Object object;
            ClassId classId2;
            FirResolvedTypeRef firResolvedTypeRef;
            FirTypeRef it;
            FirTypeRef $this$safeAs$iv = it = iterator2.next();
            boolean $i$f$safeAs = false;
            FirTypeRef firTypeRef = $this$safeAs$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirClassLikeSymbol<?> $this$safeAs$iv2 = (firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef) == null ? null : firResolvedTypeRef.getType();
            boolean $i$f$safeAs2 = false;
            Object object2 = $this$safeAs$iv2;
            if (!(object2 instanceof ConeClassLikeType)) {
                object2 = null;
            }
            if ((classId2 = (object = (ConeClassLikeType)object2) == null ? null : (($this$safeAs$iv2 = ((ConeClassLikeType)object).getLookupTag()) == null ? null : ((ConeClassLikeLookupTag)((Object)$this$safeAs$iv2)).getClassId())) == null || (classId = classId2).isLocal()) continue;
            $this$safeAs$iv2 = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(classId);
            $this$safeAs$iv2 = $this$safeAs$iv2 == null ? null : (FirClassLikeDeclaration)$this$safeAs$iv2.getFir();
            $i$f$safeAs2 = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv2;
            if (!(firClassLikeSymbol instanceof FirRegularClass)) {
                firClassLikeSymbol = null;
            }
            if ((object = (FirRegularClass)((Object)firClassLikeSymbol)) == null || ((FirRegularClass)(fir = object)).getStatus().getModality() != Modality.SEALED) continue;
            this.reportInLocal(reporter, it.getSource());
            return;
        }
    }

    private final void checkInnerDeclaration(FirClass<?> declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterator<FirTypeRef> iterator2 = declaration2.getSuperTypeRefs().iterator();
        while (iterator2.hasNext()) {
            Object fir;
            ClassId classId;
            Object object;
            ClassId classId2;
            FirResolvedTypeRef firResolvedTypeRef;
            FirTypeRef it;
            FirTypeRef $this$safeAs$iv = it = iterator2.next();
            boolean $i$f$safeAs = false;
            FirTypeRef firTypeRef = $this$safeAs$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirClassLikeSymbol<?> $this$safeAs$iv2 = (firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef) == null ? null : firResolvedTypeRef.getType();
            boolean $i$f$safeAs2 = false;
            Object object2 = $this$safeAs$iv2;
            if (!(object2 instanceof ConeClassLikeType)) {
                object2 = null;
            }
            if ((classId2 = (object = (ConeClassLikeType)object2) == null ? null : (($this$safeAs$iv2 = ((ConeClassLikeType)object).getLookupTag()) == null ? null : ((ConeClassLikeLookupTag)((Object)$this$safeAs$iv2)).getClassId())) == null || (classId = classId2).isLocal()) continue;
            $this$safeAs$iv2 = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(classId);
            $this$safeAs$iv2 = $this$safeAs$iv2 == null ? null : (FirClassLikeDeclaration)$this$safeAs$iv2.getFir();
            $i$f$safeAs2 = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv2;
            if (!(firClassLikeSymbol instanceof FirRegularClass)) {
                firClassLikeSymbol = null;
            }
            if ((object = (FirRegularClass)((Object)firClassLikeSymbol)) == null || ((FirRegularClass)(fir = object)).getStatus().getModality() != Modality.SEALED || context2.getContainingDeclarations().contains(fir)) continue;
            this.report(reporter, it.getSource());
            return;
        }
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getSEALED_SUPERTYPE().on(it));
        }
    }

    private final void reportInLocal(DiagnosticReporter $this$reportInLocal, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportInLocal.report((FirDiagnostic)FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS().on(it));
        }
    }
}

