/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 -2\u00020\u0001:\u0002-.B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u001d\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\nB%\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u000fB+\b\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\u001e\u001a\u00020\u0006J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006J\b\u0010 \u001a\u00020\u0006H\u0002J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eJ\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0014\u0010*\u001a\u00020'2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010,\u001a\u00020'2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "common", "Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "stackTrace", "", "", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Common;Ljava/util/List;)V", "wrapper", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;Ljava/util/List;)V", "exception", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Ljava/lang/Throwable;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;Ljava/util/List;)V", "causeProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exceptionFqName", "exceptionHierarchy", "getFields", "()Ljava/util/List;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "messageProperty", "getCause", "getFullDescription", "getMessage", "getMessageWithName", "getThisAsCauseForException", "Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$ExceptionData;", "isSubtypeOf", "", "ancestor", "setCause", "", "causeValue", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "setMessage", "messageValue", "setUpCauseIfNeeded", "Companion", "ExceptionData", "ir.interpreter"})
public final class ExceptionState
extends Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final List<Variable> fields;
    private String exceptionFqName;
    @NotNull
    private final List<String> exceptionHierarchy;
    @NotNull
    private final IrProperty messageProperty;
    @NotNull
    private final IrProperty causeProperty;
    @NotNull
    private final List<String> stackTrace;

    private ExceptionState(IrClass irClass2, List<Variable> fields2, List<String> stackTrace) {
        boolean bl;
        block5: {
            super(irClass2, fields2);
            this.irClass = irClass2;
            this.fields = fields2;
            boolean bl2 = false;
            this.exceptionHierarchy = new ArrayList();
            this.messageProperty = ExceptionState.Companion.getPropertyByName(this.getIrClass(), "message");
            this.causeProperty = ExceptionState.Companion.getPropertyByName(this.getIrClass(), "cause");
            this.stackTrace = CollectionsKt.reversed((Iterable)stackTrace);
            if (this.exceptionFqName == null) {
                this.exceptionFqName = this.irClassFqName();
            }
            Iterable $this$none$iv = this.getFields();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Variable it = (Variable)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getSymbol(), (Object)this.messageProperty.getSymbol())) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            ExceptionState.setMessage$default(this, null, 1, null);
        }
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    public ExceptionState(@NotNull Common common, @NotNull List<String> stackTrace) {
        Complex complex;
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        this(common.getIrClass(), common.getFields(), stackTrace);
        Complex wrapperSuperType = common;
        while (wrapperSuperType != null && !(wrapperSuperType instanceof Wrapper)) {
            complex = wrapperSuperType;
            wrapperSuperType = ((Common)complex).getSuperClass();
        }
        complex = wrapperSuperType;
        this.setUpCauseIfNeeded(complex instanceof Wrapper ? (Wrapper)complex : null);
    }

    public ExceptionState(@NotNull Wrapper wrapper, @NotNull List<String> stackTrace) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        this((Throwable)wrapper.getValue(), wrapper.getIrClass(), stackTrace);
        this.setUpCauseIfNeeded(wrapper);
    }

    public ExceptionState(@NotNull Throwable exception, @NotNull IrClass irClass2, @NotNull List<String> stackTrace) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        this(irClass2, ExceptionState.Companion.evaluateFields(exception, irClass2, stackTrace), (List<String>)CollectionsKt.plus((Collection)stackTrace, (Iterable)ExceptionState.Companion.evaluateAdditionalStackTrace(exception)));
        if (!Intrinsics.areEqual((Object)irClass2.getName().asString(), (Object)exception.getClass().getSimpleName())) {
            Object object = exception.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"exception::class.java.name");
            this.exceptionFqName = object;
            object = this;
            Collection collection = ((ExceptionState)object).exceptionHierarchy;
            String string2 = this.exceptionFqName;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                throw null;
            }
            boolean bl = false;
            collection.add(string2);
            Sequence $this$forEach$iv = SequencesKt.generateSequence(exception.getClass().getSuperclass(), (Function1)3.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                ExceptionState exceptionState = this;
                Collection collection2 = exceptionState.exceptionHierarchy;
                String string3 = it.getName();
                boolean bl3 = false;
                collection2.add(string3);
            }
            this.exceptionHierarchy.remove(CollectionsKt.getLastIndex(this.exceptionHierarchy));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpCauseIfNeeded(Wrapper wrapper) {
        Object object = wrapper;
        Object object2 = object == null ? null : ((Wrapper)object).getValue();
        Object object3 = object2 instanceof Throwable ? (Throwable)object2 : null;
        Throwable throwable = object3 == null ? null : ((Throwable)object3).getCause();
        ExceptionData cause = throwable instanceof ExceptionData ? (ExceptionData)throwable : null;
        throwable = cause;
        this.setCause(throwable == null ? null : ((ExceptionData)throwable).getState());
        if (this.getMessage() == null && cause != null) {
            Object object4;
            object3 = cause.getState().exceptionFqName;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                throw null;
            }
            Object object5 = object3;
            object3 = cause.getState().getMessage();
            if (object3 == null) {
                object4 = "";
            } else {
                void it;
                object = object3;
                boolean bl = false;
                boolean bl2 = false;
                Object object6 = object;
                Object object7 = object5;
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus((String)": ", (Object)it);
                object5 = object7;
                object2 = string2;
                object4 = object2 == null ? "" : object2;
            }
            String causeMessage = Intrinsics.stringPlus((String)object5, (Object)object4);
            this.setMessage(causeMessage);
        }
    }

    public final boolean isSubtypeOf(@NotNull IrClass ancestor) {
        Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
        Collection collection = this.exceptionHierarchy;
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean bl2;
            block4: {
                Iterable $this$any$iv = this.exceptionHierarchy;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        CharSequence charSequence = it;
                        String string2 = ancestor.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ancestor.name.asString()");
                        if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        return IrUtilsKt.isSubclassOf(this.getIrClass(), ancestor);
    }

    private final void setMessage(String messageValue) {
        IrSymbol irSymbol = this.messageProperty.getSymbol();
        IrSimpleFunction irSimpleFunction = this.messageProperty.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        this.setField(new Variable(irSymbol, new Primitive<String>(messageValue, irSimpleFunction.getReturnType())));
    }

    static /* synthetic */ void setMessage$default(ExceptionState exceptionState, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        exceptionState.setMessage(string2);
    }

    private final void setCause(State causeValue) {
        State state;
        IrSymbol irSymbol = this.causeProperty.getSymbol();
        State state2 = causeValue;
        if (state2 == null) {
            IrSimpleFunction irSimpleFunction = this.causeProperty.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            state = new Primitive<Object>(null, irSimpleFunction.getReturnType());
        } else {
            state = state2;
        }
        this.setField(new Variable(irSymbol, state));
    }

    @Nullable
    public final String getMessage() {
        State state = this.getState(this.messageProperty.getSymbol());
        if (state == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
        }
        return (String)((Primitive)state).getValue();
    }

    private final String getMessageWithName() {
        String string2;
        String string3;
        String string4 = this.getMessage();
        if (string4 == null) {
            string3 = null;
        } else {
            String string5 = string4;
            boolean bl = false;
            boolean bl2 = false;
            String it = string5;
            boolean bl3 = false;
            String string6 = this.exceptionFqName;
            if (string6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                throw null;
            }
            string3 = string6 + ": " + it;
        }
        String string7 = string3;
        if (string7 == null) {
            string4 = this.exceptionFqName;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                throw null;
            }
            string2 = string4;
        } else {
            string2 = string7;
        }
        return string2;
    }

    @Nullable
    public final ExceptionState getCause() {
        ExceptionState exceptionState;
        State state = this.getState(this.causeProperty.getSymbol());
        if (state == null) {
            exceptionState = null;
        } else {
            State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            State it = state2;
            boolean bl3 = false;
            exceptionState = it instanceof ExceptionState ? (ExceptionState)it : null;
        }
        return exceptionState;
    }

    @NotNull
    public final String getFullDescription() {
        String string2;
        Boolean bl;
        String string3 = this.getMessage();
        boolean bl2 = false;
        boolean bl3 = false;
        String it = string3;
        boolean bl4 = false;
        String string4 = it;
        if (string4 == null) {
            bl = null;
        } else {
            CharSequence charSequence = string4;
            boolean bl5 = false;
            bl = charSequence.length() > 0;
        }
        String message2 = Intrinsics.areEqual(bl, (Object)true) ? Intrinsics.stringPlus((String)": ", (Object)it) : "";
        Collection collection = this.stackTrace;
        bl3 = false;
        String prefix = !collection.isEmpty() ? "\n\t" : "";
        String postfix = this.stackTrace.size() > 10 ? "\n\t..." : "";
        Object object = this.getCause();
        String string5 = string2 = object == null ? null : ((ExceptionState)object).getFullDescription();
        String causeMessage = string2 == null ? "" : ((object = StringsKt.replaceFirst$default((String)string2, (String)"Exception ", (String)"\nCaused by: ", (boolean)false, (int)4, null)) == null ? "" : object);
        string2 = this.exceptionFqName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
            throw null;
        }
        int n = this.stackTrace.size();
        int n2 = 10;
        boolean bl6 = false;
        return "Exception " + string2 + message2 + CollectionsKt.joinToString$default((Iterable)this.stackTrace.subList(0, Math.min(n, n2)), (CharSequence)"\n\t", (CharSequence)prefix, (CharSequence)postfix, (int)0, null, null, (int)56, null) + causeMessage;
    }

    @NotNull
    public final ExceptionData getThisAsCauseForException() {
        return new ExceptionData(this);
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$ExceptionData;", "", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "(Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;)V", "message", "", "getMessage", "()Ljava/lang/String;", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "component1", "copy", "equals", "", "other", "", "fillInStackTrace", "hashCode", "", "toString", "ir.interpreter"})
    public static final class ExceptionData
    extends Throwable {
        @NotNull
        private final ExceptionState state;
        @Nullable
        private final String message;

        public ExceptionData(@NotNull ExceptionState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.state = state;
            this.message = this.state.getMessage();
        }

        @NotNull
        public final ExceptionState getState() {
            return this.state;
        }

        @Override
        @Nullable
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public ExceptionData fillInStackTrace() {
            return this;
        }

        @Override
        @NotNull
        public String toString() {
            return this.state.getMessageWithName();
        }

        @NotNull
        public final ExceptionState component1() {
            return this.state;
        }

        @NotNull
        public final ExceptionData copy(@NotNull ExceptionState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new ExceptionData(state);
        }

        public static /* synthetic */ ExceptionData copy$default(ExceptionData exceptionData, ExceptionState exceptionState, int n, Object object) {
            if ((n & 1) != 0) {
                exceptionState = exceptionData.state;
            }
            return exceptionData.copy(exceptionState);
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExceptionData)) {
                return false;
            }
            ExceptionData exceptionData = (ExceptionData)other;
            return Intrinsics.areEqual((Object)this.state, (Object)exceptionData.state);
        }
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion;", "", "()V", "evaluateAdditionalStackTrace", "", "", "e", "", "evaluateFields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "exception", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stackTrace", "getPropertyByName", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "name", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        private final IrProperty getPropertyByName(IrClass $this$getPropertyByName, String name) {
            Iterable $this$single$iv = $this$getPropertyByName.getDeclarations();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), (Object)name)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty property2 = single$iv;
            IrSimpleFunction irSimpleFunction = property2.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)UtilsKt.getLastOverridden(irSimpleFunction)).getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull((Object)irPropertySymbol);
            return (IrProperty)irPropertySymbol.getOwner();
        }

        /*
         * WARNING - void declaration
         */
        private final List<Variable> evaluateFields(Throwable exception, IrClass irClass2, List<String> stackTrace) {
            Variable variable2;
            IrProperty messageProperty = this.getPropertyByName(irClass2, "message");
            IrProperty causeProperty = this.getPropertyByName(irClass2, "cause");
            IrSymbol irSymbol = messageProperty.getSymbol();
            String string2 = exception.getMessage();
            IrSimpleFunction irSimpleFunction = messageProperty.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            Variable messageVar = new Variable(irSymbol, UtilsKt.toState(string2, irSimpleFunction.getReturnType()));
            Object[] objectArray = exception.getCause();
            if (objectArray == null) {
                variable2 = null;
            } else {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                boolean bl2 = false;
                Object[] it = objectArray2;
                boolean bl3 = false;
                IrSymbol irSymbol2 = causeProperty.getSymbol();
                Collection collection2 = stackTrace;
                Object object = it.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.stackTrace");
                object = ArraysKt.reversed((Object[])object);
                Collection collection3 = collection2;
                IrClass irClass3 = irClass2;
                Object[] objectArray3 = it;
                IrSymbol irSymbol3 = irSymbol2;
                boolean $i$f$map = false;
                void var24_20 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string3 = Intrinsics.stringPlus((String)"at ", (Object)it2);
                    collection.add(string3);
                }
                collection = (List)destination$iv$iv;
                List list2 = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
                IrClass irClass4 = irClass3;
                Object[] objectArray4 = objectArray3;
                State state = new ExceptionState((Throwable)objectArray4, irClass4, (List<String>)list2);
                IrSymbol irSymbol4 = irSymbol3;
                variable2 = new Variable(irSymbol4, state);
            }
            Variable causeVar = variable2;
            objectArray = new Variable[]{messageVar, causeVar};
            return CollectionsKt.toMutableList((Collection)CollectionsKt.listOfNotNull((Object[])objectArray));
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> evaluateAdditionalStackTrace(Throwable e) {
            boolean bl;
            Object[] $this$any$iv;
            List additionalStack;
            block6: {
                boolean bl2 = false;
                additionalStack = new ArrayList();
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
                $this$any$iv = stackTraceElementArray;
                boolean $i$f$any22 = false;
                for (Object object : $this$any$iv) {
                    StackTraceElement it = (StackTraceElement)object;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"java.lang.invoke.MethodHandle")) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                StackTraceElement[] $i$f$any22 = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$any22, (String)"e.stackTrace");
                $this$any$iv = $i$f$any22;
                int n = $this$any$iv.length;
                for (int $i$f$any22 = 0; $i$f$any22 < n; ++$i$f$any22) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    int index2 = $i$f$any22;
                    Object stackTraceElement = $this$any$iv[$i$f$any22];
                    if (!Intrinsics.areEqual((Object)((StackTraceElement)stackTraceElement).getMethodName(), (Object)"invokeWithArguments")) continue;
                    StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
                    Iterable iterable = CollectionsKt.reversed((Iterable)ArraysKt.slice((Object[])stackTraceElementArray, (IntRange)RangesKt.until((int)0, (int)index2)));
                    List list2 = additionalStack;
                    boolean $i$f$map = false;
                    Iterable bl3 = iterable;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StackTraceElement stackTraceElement2 = (StackTraceElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        String string2 = Intrinsics.stringPlus((String)"at ", (Object)it);
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    list2.addAll((Collection)collection);
                    break;
                }
                Object object = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.stackTrace");
                object = ArraysKt.first((Object[])object);
                int n2 = 0;
                int n3 = 0;
                StackTraceElement stackTraceElement = (StackTraceElement)object;
                boolean bl5 = false;
                String lastNeededValue = stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName();
                block3: for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"cause.stackTrace");
                    object = stackTraceElementArray;
                    n3 = ((StackTraceElement[])object).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        int n4 = n2;
                        StackTraceElement[] causeStackTraceElement = object[n2];
                        StackTraceElement[] stackTraceElementArray2 = causeStackTraceElement;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        StackTraceElement[] it2 = stackTraceElementArray2;
                        boolean bl8 = false;
                        String currentStackTraceValue = it2.getClassName() + '.' + it2.getMethodName();
                        if (!Intrinsics.areEqual((Object)currentStackTraceValue, (Object)lastNeededValue)) continue;
                        stackTraceElementArray2 = cause.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray2, (String)"cause.stackTrace");
                        cause.setStackTrace((StackTraceElement[])ArraysKt.reversedArray((Object[])ArraysKt.sliceArray((Object[])stackTraceElementArray2, (IntRange)RangesKt.until((int)0, (int)n4))));
                        continue block3;
                    }
                }
            }
            return additionalStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

