/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.TargetedAnnotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

public class AnnotationResolverImpl
extends AnnotationResolver {
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public AnnotationResolverImpl(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull StorageManager storageManager) {
        if (callResolver == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(0);
        }
        if (constantExpressionEvaluator == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(1);
        }
        if (storageManager == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(2);
        }
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.storageManager = storageManager;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(3);
        }
        this.typeResolver = typeResolver;
    }

    @Override
    @NotNull
    public Annotations resolveAnnotationEntries(@NotNull LexicalScope scope2, @NotNull List<KtAnnotationEntry> annotationEntryElements, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope2 == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(4);
        }
        if (annotationEntryElements == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(5);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(6);
        }
        if (annotationEntryElements.isEmpty()) {
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            if (annotations2 == null) {
                AnnotationResolverImpl.$$$reportNull$$$0(7);
            }
            return annotations2;
        }
        ArrayList<AnnotationDescriptor> standard = new ArrayList<AnnotationDescriptor>();
        ArrayList<AnnotationWithTarget> targeted = new ArrayList<AnnotationWithTarget>();
        for (KtAnnotationEntry entryElement : annotationEntryElements) {
            KtAnnotationUseSiteTarget target;
            AnnotationDescriptor descriptor2 = trace.get(BindingContext.ANNOTATION, entryElement);
            if (descriptor2 == null) {
                descriptor2 = new LazyAnnotationDescriptor(new LazyAnnotationsContextImpl(this, this.storageManager, trace, scope2), entryElement);
            }
            if (shouldResolveArguments) {
                ForceResolveUtil.forceResolveAllContents(descriptor2);
            }
            if ((target = entryElement.getUseSiteTarget()) != null) {
                targeted.add(new AnnotationWithTarget(descriptor2, target.getAnnotationUseSiteTarget()));
                continue;
            }
            standard.add(descriptor2);
        }
        return new TargetedAnnotations(CollectionsKt.toList(standard), CollectionsKt.toList(targeted));
    }

    @Override
    @NotNull
    public KotlinType resolveAnnotationType(@NotNull LexicalScope scope2, @NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace) {
        KtTypeReference typeReference;
        if (scope2 == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(8);
        }
        if (entryElement == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(9);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(10);
        }
        if ((typeReference = entryElement.getTypeReference()) == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("No type reference: " + entryElement.getText());
            if (simpleType2 == null) {
                AnnotationResolverImpl.$$$reportNull$$$0(11);
            }
            return simpleType2;
        }
        KotlinType type2 = this.typeResolver.resolveType(scope2, typeReference, trace, true);
        if (!(type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            SimpleType simpleType3 = ErrorUtils.createErrorType("Not an annotation: " + type2);
            if (simpleType3 == null) {
                AnnotationResolverImpl.$$$reportNull$$$0(12);
            }
            return simpleType3;
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(13);
        }
        return kotlinType;
    }

    public static void checkAnnotationType(@NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace, @NotNull OverloadResolutionResults<FunctionDescriptor> results) {
        if (entryElement == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(14);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(15);
        }
        if (results == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(16);
        }
        if (!results.isSingleResult()) {
            return;
        }
        FunctionDescriptor descriptor2 = results.getResultingDescriptor();
        if (!ErrorUtils.isError(descriptor2)) {
            if (descriptor2 instanceof ConstructorDescriptor) {
                ConstructorDescriptor constructor2 = (ConstructorDescriptor)descriptor2;
                ClassDescriptor classDescriptor2 = constructor2.getConstructedClass();
                if (classDescriptor2.getKind() != ClassKind.ANNOTATION_CLASS) {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor2));
                }
            } else {
                trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor2));
            }
        }
    }

    @Override
    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(@NotNull KtAnnotationEntry annotationEntry, @NotNull LexicalScope scope2, @NotNull BindingTrace trace) {
        if (annotationEntry == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(17);
        }
        if (scope2 == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(18);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(19);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)annotationEntry, KtAnnotationEntry.class) != null) {
            trace.report(Errors.ANNOTATION_USED_AS_ANNOTATION_ARGUMENT.on(annotationEntry));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(trace, scope2, CallMaker.makeCall(null, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfoFactory.EMPTY, true);
        if (overloadResolutionResults == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(20);
        }
        return overloadResolutionResults;
    }

    public static void reportUnsupportedAnnotationForTypeParameter(@NotNull KtTypeParameter jetTypeParameter, @NotNull BindingTrace trace) {
        KtModifierList modifierList2;
        if (jetTypeParameter == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(21);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(22);
        }
        if ((modifierList2 = jetTypeParameter.getModifierList()) == null) {
            return;
        }
        for (KtAnnotationEntry annotationEntry : modifierList2.getAnnotationEntries()) {
            trace.report(Errors.UNSUPPORTED.on(annotationEntry, "Annotations for type parameters are not supported yet"));
        }
    }

    @Override
    @Nullable
    public ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter2, @NotNull ResolvedValueArgument resolvedArgument) {
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(23);
        }
        if (valueParameter2 == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(24);
        }
        if (resolvedArgument == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(25);
        }
        return this.constantExpressionEvaluator.getAnnotationArgumentValue(trace, valueParameter2, resolvedArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantExpressionEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationEntryElements";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/AnnotationResolverImpl";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationEntry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetTypeParameter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/AnnotationResolverImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnnotationEntries";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnnotationType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnnotationCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTypeResolver";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationEntries";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationType";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationCall";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportUnsupportedAnnotationForTypeParameter";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationArgumentValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

