/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "PROPERTY_SET_OPERATIONS", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "shouldCheckPropertyGetter", "", "expression", "shouldCheckPropertyGetter$frontend", "frontend"})
public final class DeprecatedCallChecker
implements CallChecker {
    @NotNull
    public static final DeprecatedCallChecker INSTANCE = new DeprecatedCallChecker();
    @NotNull
    private static final TokenSet PROPERTY_SET_OPERATIONS;

    private DeprecatedCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"resolvedCall.resultingDescriptor");
        this.check((CallableDescriptor)obj, context2.getTrace(), reportOn, context2.getLanguageVersionSettings(), context2.getDeprecationResolver());
    }

    private final void check(CallableDescriptor targetDescriptor, BindingTrace trace, PsiElement element, LanguageVersionSettings languageVersionSettings, DeprecationResolver deprecationResolver) {
        boolean bl;
        Object object;
        if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
            return;
        }
        List deprecations2 = CollectionsKt.toMutableList((Collection)deprecationResolver.getDeprecations(targetDescriptor));
        if (targetDescriptor instanceof PropertySetterDescriptor) {
            object = deprecations2;
            Object object2 = ((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"targetDescriptor.correspondingProperty");
            object2 = deprecationResolver.getDeprecations((DeclarationDescriptor)object2);
            bl = false;
            CollectionsKt.removeAll((Collection)object, (Iterable)object2);
        }
        object = deprecations2;
        boolean bl2 = false;
        if (!object.isEmpty()) {
            for (Deprecation deprecation : deprecations2) {
                trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element, deprecation, languageVersionSettings));
            }
        } else if (targetDescriptor instanceof PropertyDescriptor && this.shouldCheckPropertyGetter$frontend(element) && (object = ((PropertyDescriptor)targetDescriptor).getGetter()) != null) {
            Object object3 = object;
            bl = false;
            boolean bl3 = false;
            Object it = object3;
            boolean bl4 = false;
            INSTANCE.check((CallableDescriptor)it, trace, element, languageVersionSettings, deprecationResolver);
        }
    }

    public final boolean shouldCheckPropertyGetter$frontend(@NotNull PsiElement expression2) {
        KtReferenceExpression[] unaryExpression;
        KtReferenceExpression[] ktReferenceExpressionArray;
        KtReferenceExpression[] referenceExpressions;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression2, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual((Object)left, (Object)expression2) && PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            referenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
            if (referenceExpressions != null) {
                ktReferenceExpressionArray = referenceExpressions;
                int n = ktReferenceExpressionArray.length;
                for (int i = 0; i < n; ++i) {
                    KtReferenceExpression expr = ktReferenceExpressionArray[i];
                    if (!Intrinsics.areEqual((Object)expr, (Object)expression2) || !PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) continue;
                    return false;
                }
            }
        }
        if (PROPERTY_SET_OPERATIONS.contains((referenceExpressions = (unaryExpression = PsiTreeUtil.getParentOfType(expression2, KtUnaryExpression.class))) == null ? null : ((ktReferenceExpressionArray = referenceExpressions.getOperationReference()) == null ? null : ktReferenceExpressionArray.getReferencedNameElementType()))) {
            return false;
        }
        KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression2, KtCallableReferenceExpression.class);
        return callableExpression == null || !Intrinsics.areEqual((Object)callableExpression.getCallableReference(), (Object)expression2);
    }

    static {
        SpreadBuilder spreadBuilder2 = new SpreadBuilder(3);
        spreadBuilder2.addSpread((Object)KtTokens.ALL_ASSIGNMENTS.getTypes());
        spreadBuilder2.add((Object)KtTokens.PLUSPLUS);
        spreadBuilder2.add((Object)KtTokens.MINUSMINUS);
        TokenSet tokenSet = TokenSet.create((IElementType[])spreadBuilder2.toArray((Object[])new IElementType[spreadBuilder2.size()]));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(*KtTokens.ALL_ASSIGNMENTS.types, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS)");
        PROPERTY_SET_OPERATIONS = tokenSet;
    }
}

