/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.js.JsProtoBuf;
import org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.serialization.ApproximatingStringTable;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinDeserializedFileMetadata;
import org.jetbrains.kotlin.serialization.js.KotlinFileRegistry;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtilKt;
import org.jetbrains.kotlin.serialization.js.KotlinPsiFileMetadata;
import org.jetbrains.kotlin.types.FlexibleType;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J*\u0010%\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020'2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J*\u0010(\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020*2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "fileRegistry", "Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "(Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "stringTable", "Lorg/jetbrains/kotlin/serialization/ApproximatingStringTable;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/ApproximatingStringTable;", "getFileId", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/Integer;", "releaseCoroutines", "", "serializeClass", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "versionRequirementTable", "Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "childSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeFlexibleType", "flexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "lowerProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "upperProto", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "js.serializer"})
public final class KotlinJavascriptSerializerExtension
extends KotlinSerializerExtensionBase {
    @NotNull
    private final KotlinFileRegistry fileRegistry;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final ApproximatingStringTable stringTable;

    public KotlinJavascriptSerializerExtension(@NotNull KotlinFileRegistry fileRegistry, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BinaryVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)fileRegistry, (String)"fileRegistry");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        super(JsSerializerProtocol.INSTANCE);
        this.fileRegistry = fileRegistry;
        this.languageVersionSettings = languageVersionSettings;
        this.metadataVersion = metadataVersion;
        this.stringTable = new ApproximatingStringTable();
    }

    @Override
    @NotNull
    public BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    @NotNull
    public ApproximatingStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        Intrinsics.checkNotNullParameter((Object)lowerProto, (String)"lowerProto");
        Intrinsics.checkNotNullParameter((Object)upperProto, (String)"upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex("kotlin.DynamicType"));
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"versionRequirementTable");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.classContainingFileId, id);
        }
        super.serializeClass(descriptor2, proto, versionRequirementTable, childSerializer);
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.propertyContainingFileId, id);
        }
        super.serializeProperty(descriptor2, proto, versionRequirementTable, childSerializer);
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)childSerializer, (String)"childSerializer");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.functionContainingFileId, id);
        }
        super.serializeFunction(descriptor2, proto, versionRequirementTable, childSerializer);
    }

    private final Integer getFileId(DeclarationDescriptor descriptor2) {
        Integer n;
        Object object;
        Object object2;
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2) || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        Integer fileId = KotlinJavascriptSerializationUtilKt.extractFileId(descriptor2);
        if (fileId != null) {
            KotlinJavascriptPackageFragment kotlinJavascriptPackageFragment;
            object2 = ((DeclarationDescriptorWithSource)descriptor2).getContainingDeclaration();
            KotlinJavascriptPackageFragment kotlinJavascriptPackageFragment2 = kotlinJavascriptPackageFragment = object2 instanceof KotlinJavascriptPackageFragment ? (KotlinJavascriptPackageFragment)object2 : null;
            if (kotlinJavascriptPackageFragment != null) {
                object2 = kotlinJavascriptPackageFragment;
                boolean bl = false;
                boolean bl2 = false;
                Object packageFragment = object2;
                boolean bl3 = false;
                return this.fileRegistry.lookup(new KotlinDeserializedFileMetadata((KotlinJavascriptPackageFragment)packageFragment, fileId));
            }
        }
        Object object3 = object2 = (object = ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile()) instanceof PsiSourceFile ? (PsiSourceFile)object : null;
        if (object2 == null) {
            return null;
        }
        Object file2 = object2;
        PsiFile psiFile = ((PsiSourceFile)file2).getPsiFile();
        Object object4 = object = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (object == null) {
            n = null;
        } else {
            Object object5 = object;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object5;
            boolean bl5 = false;
            n = this.fileRegistry.lookup(new KotlinPsiFileMetadata((KtFile)it));
        }
        return n;
    }

    @Override
    public boolean releaseCoroutines() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }
}

