/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictingProjectionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "reportConflictingProjections", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "desiredProjection", "", "reportVarianceNotAllowed", "checkers"})
public final class FirConflictingProjectionChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictingProjectionChecker INSTANCE = new FirConflictingProjectionChecker();

    private FirConflictingProjectionChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2 instanceof FirPropertyAccessor) {
            return;
        }
        if (declaration2 instanceof FirTypedDeclaration) {
            this.checkTypeRef(((FirTypedDeclaration)declaration2).getReturnTypeRef(), context2, reporter);
        }
        if ((firDeclaration = declaration2) instanceof FirClass) {
            for (FirTypeRef it : ((FirClass)declaration2).getSuperTypeRefs()) {
                this.checkTypeRef(it, context2, reporter);
            }
        } else if (firDeclaration instanceof FirTypeAlias) {
            for (FirTypeParameter it : ((FirTypeAlias)declaration2).getTypeParameters()) {
                if (it.getVariance() == Variance.INVARIANT) continue;
                this.reportVarianceNotAllowed(reporter, it.getSource());
            }
            this.checkTypeRef(((FirTypeAlias)declaration2).getExpandedTypeRef(), context2, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeRef(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter) {
        FirRegularClass firRegularClass;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        Object object;
        boolean $i$f$coneTypeSafe22;
        ConeClassLikeLookupTag coneClassLikeLookupTag2;
        Object object2;
        Object $this$safeAs$iv = typeRef;
        boolean $i$f$safeAs2 = false;
        Object object3 = $this$safeAs$iv;
        if (!(object3 instanceof FirResolvedTypeRef)) {
            object3 = null;
        }
        if ((object2 = (FirResolvedTypeRef)object3) == null) {
            coneClassLikeLookupTag2 = null;
        } else {
            void $this$coneTypeSafe$iv;
            FirTypeRef $i$f$safeAs2 = (FirTypeRef)object2;
            $i$f$coneTypeSafe22 = false;
            boolean bl = false;
            object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            coneClassLikeLookupTag2 = coneClassLikeLookupTag = ($this$safeAs$iv = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : ((ConeClassLikeType)$this$safeAs$iv).getLookupTag();
        }
        FirClassLikeDeclaration $this$safeAs$iv2 = coneClassLikeLookupTag == null ? null : ((object2 = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession())) == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object2).getFir());
        boolean $i$f$safeAs3 = false;
        FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv2;
        if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
            firClassLikeDeclaration = null;
        }
        if ((firRegularClass = (FirRegularClass)firClassLikeDeclaration) == null) {
            return;
        }
        FirRegularClass declaration2 = firRegularClass;
        Comparable comparable = Integer.valueOf(declaration2.getTypeParameters().size());
        FirTypeRef $this$coneType$iv = typeRef;
        boolean $i$f$getConeType = false;
        Object $this$coneTypeSafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeSafe = false;
        $i$f$coneTypeSafe22 = false;
        FirResolvedTypeRef $i$f$coneTypeSafe22 = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType = $i$f$coneTypeSafe22 == null ? null : $i$f$coneTypeSafe22.getType();
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if ((object = coneKotlinType) == null) {
            $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
            $i$f$coneTypeSafe = false;
            throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
        }
        int n = 0;
        int size = ((Number)((Object)AddToStdlibKt.min(comparable, ((ConeKotlinType)object).getTypeArguments().length))).intValue();
        if (n < size) {
            do {
                ConeKotlinType coneKotlinType2;
                Variance protoVariance;
                ConeKotlinType coneKotlinType3;
                int it = n++;
                FirTypeParameterRef proto = declaration2.getTypeParameters().get(it);
                FirTypeRef $this$coneType$iv2 = typeRef;
                boolean $i$f$getConeType2 = false;
                Object $this$coneTypeSafe$iv$iv2 = $this$coneType$iv2;
                boolean $i$f$coneTypeSafe3 = false;
                boolean bl = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv2 instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv2 : null;
                ConeKotlinType coneKotlinType4 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType4 instanceof ConeKotlinType)) {
                    coneKotlinType4 = null;
                }
                if ((coneKotlinType3 = coneKotlinType4) == null) {
                    $this$coneTypeSafe$iv$iv2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv2.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv2, null, 1, null);
                    $i$f$coneTypeSafe3 = false;
                    throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv2.toString());
                }
                ConeTypeProjection actual = coneKotlinType3.getTypeArguments()[it];
                FirTypeParameterRef $this$safeAs$iv3 = proto;
                boolean $i$f$safeAs4 = false;
                FirTypeParameterRef firTypeParameterRef = $this$safeAs$iv3;
                if (!(firTypeParameterRef instanceof FirTypeParameterRef)) {
                    firTypeParameterRef = null;
                }
                Object object4 = $this$coneTypeSafe$iv$iv2 = ($i$f$coneTypeSafe3 = firTypeParameterRef) == null ? null : $i$f$coneTypeSafe3.getSymbol();
                Variance variance = $this$coneTypeSafe$iv$iv2 == null ? null : ($i$f$getConeType2 = ($i$f$coneTypeSafe3 = (FirTypeParameter)((AbstractFirBasedSymbol)$this$coneTypeSafe$iv$iv2).getFir()) == null ? null : ((FirTypeParameter)$i$f$coneTypeSafe3).getVariance());
                if ($i$f$getConeType2 == null || (protoVariance = $i$f$getConeType2) == Variance.INVARIANT || (!(actual instanceof ConeKotlinTypeProjectionIn) || protoVariance != Variance.OUT_VARIANCE) && (!(actual instanceof ConeKotlinTypeProjectionOut) || protoVariance != Variance.IN_VARIANCE)) continue;
                FirSourceElement firSourceElement = typeRef.getSource();
                FirTypeRef $this$coneType$iv3 = typeRef;
                boolean $i$f$getConeType3 = false;
                FirTypeRef $this$coneTypeSafe$iv$iv3 = $this$coneType$iv3;
                boolean $i$f$coneTypeSafe4 = false;
                boolean bl2 = false;
                FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv$iv3 instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv3 : null;
                ConeKotlinType coneKotlinType5 = firResolvedTypeRef2 == null ? null : firResolvedTypeRef2.getType();
                if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                    coneKotlinType5 = null;
                }
                if ((coneKotlinType2 = coneKotlinType5) == null) {
                    String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv3.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv3, null, 1, null);
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                this.reportConflictingProjections(reporter, firSourceElement, coneKotlinType2.toString());
                return;
            } while (n < size);
        }
    }

    private final void reportConflictingProjections(DiagnosticReporter $this$reportConflictingProjections, FirSourceElement source, String desiredProjection) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportConflictingProjections.report((FirDiagnostic)FirErrors.INSTANCE.getCONFLICTING_PROJECTION().on(it, desiredProjection));
        }
    }

    private final void reportVarianceNotAllowed(DiagnosticReporter $this$reportVarianceNotAllowed, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportVarianceNotAllowed.report((FirDiagnostic)FirErrors.INSTANCE.getVARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED().on(it));
        }
    }
}

