/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J!\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\bH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "analysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "specificFeatures", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/util/Map;Ljava/util/Map;)V", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "getFeatureSupport", "feature", "getFlag", "T", "flag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;)Ljava/lang/Object;", "isPreRelease", "", "toString", "", "Companion", "util"})
public final class LanguageVersionSettingsImpl
implements LanguageVersionSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private final Map<AnalysisFlag<?>, ?> analysisFlags;
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures;
    @JvmField
    @NotNull
    public static final LanguageVersionSettingsImpl DEFAULT = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, null, null, 12, null);

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags, @NotNull Map<LanguageFeature, ? extends LanguageFeature.State> specificFeatures) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        Intrinsics.checkNotNullParameter(specificFeatures, (String)"specificFeatures");
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion;
        Map<Object, Object> map = Collections.unmodifiableMap(analysisFlags);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(analysisFlags)");
        this.analysisFlags = map;
        map = Collections.unmodifiableMap(specificFeatures);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(specificFeatures)");
        this.specificFeatures = map;
    }

    public /* synthetic */ LanguageVersionSettingsImpl(LanguageVersion languageVersion, ApiVersion apiVersion, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(languageVersion, apiVersion, map, map2);
    }

    @Override
    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public <T> T getFlag(@NotNull AnalysisFlag<? extends T> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        Object obj = this.analysisFlags.get(flag);
        return (T)(obj == null ? flag.getDefaultValue() : obj);
    }

    @Override
    @NotNull
    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        LanguageFeature.State state = this.specificFeatures.get((Object)feature);
        if (state != null) {
            LanguageFeature.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            LanguageFeature.State it = state2;
            boolean bl3 = false;
            return it;
        }
        LanguageVersion since = feature.getSinceVersion();
        if (since != null && this.getLanguageVersion().compareTo((Enum)since) >= 0 && this.getApiVersion().compareTo(feature.getSinceApiVersion()) >= 0) {
            return feature.getDefaultState();
        }
        return LanguageFeature.State.DISABLED;
    }

    @NotNull
    public String toString() {
        Object state;
        Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d3 = stringBuilder2;
        boolean bl5 = false;
        $this$toString_u24lambda_u2d3.append("Language = " + this.getLanguageVersion() + ", API = " + this.getApiVersion());
        Map<Object, LanguageFeature.State> $this$forEach$iv = this.specificFeatures;
        boolean $i$f$forEach = false;
        Map<LanguageFeature, LanguageFeature.State> map = $this$forEach$iv;
        boolean bl6 = false;
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            char c;
            Map.Entry<LanguageFeature, LanguageFeature.State> $dstr$feature$state = element$iv = iterator2.next();
            boolean bl7 = false;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = $dstr$feature$state;
            boolean bl8 = false;
            LanguageFeature feature = entry.getKey();
            Map.Entry<LanguageFeature, LanguageFeature.State> entry2 = $dstr$feature$state;
            boolean bl9 = false;
            state = entry2.getValue();
            LanguageFeature.State state2 = state;
            int n = WhenMappings.$EnumSwitchMapping$0[state2.ordinal()];
            switch (n) {
                case 1: {
                    c = '+';
                    break;
                }
                case 2: {
                    c = '~';
                    break;
                }
                case 3: 
                case 4: {
                    c = '-';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            char c2 = c;
            $this$toString_u24lambda_u2d3.append("" + ' ' + c2 + (Object)((Object)feature));
        }
        $this$forEach$iv = this.analysisFlags;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl6 = false;
        iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<LanguageFeature, LanguageFeature.State> $dstr$flag$value = element$iv = iterator2.next();
            boolean bl10 = false;
            state = $dstr$flag$value;
            boolean bl11 = false;
            AnalysisFlag flag = (AnalysisFlag)state.getKey();
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = $dstr$flag$value;
            boolean bl12 = false;
            LanguageFeature.State value2 = entry.getValue();
            $this$toString_u24lambda_u2d3.append("" + ' ' + flag + ':' + value2);
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPreRelease() {
        boolean bl;
        if (LanguageVersionSettingsKt.isPreRelease(this.getLanguageVersion())) return true;
        Map<LanguageFeature, LanguageFeature.State> $this$any$iv = this.specificFeatures;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Map<LanguageFeature, LanguageFeature.State> map = $this$any$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = map.entrySet().iterator();
        do {
            Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<LanguageFeature, LanguageFeature.State> $dstr$feature$state = element$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = $dstr$feature$state;
            boolean bl4 = false;
            LanguageFeature feature = entry.getKey();
            Map.Entry<LanguageFeature, LanguageFeature.State> entry2 = $dstr$feature$state;
            boolean bl5 = false;
            LanguageFeature.State state = entry2.getValue();
            if (state == LanguageFeature.State.ENABLED && LanguageVersionSettingsKt.forcesPreReleaseBinariesIfEnabled(feature)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Override
    public boolean supportsFeature(@NotNull LanguageFeature feature) {
        return LanguageVersionSettings.DefaultImpls.supportsFeature(this, feature);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        this(languageVersion, apiVersion, analysisFlags, null, 8, null);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        this(languageVersion, apiVersion, null, null, 12, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageFeature.State.values().length];
            nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
            nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 2;
            nArray[LanguageFeature.State.ENABLED_WITH_ERROR.ordinal()] = 3;
            nArray[LanguageFeature.State.DISABLED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

