/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017H\u0002R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "declarationDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;)V", "annotations", "", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructorCall;", "getDeclarationDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "reversedSignatureIndex", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "", "kotlin.jvm.PlatformType", "getReversedSignatureIndex", "()Ljava/util/Map;", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "deserializeDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "idSig", "deserializeDeclaration$ir_serialization_common", "deserializeFileImplicitDataIfFirstUse", "", "loadTopLevelDeclarationProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclaration;", "readDeclaration", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "index", "ir.serialization.common"})
public final class IrFileDeserializer {
    @NotNull
    private final org.jetbrains.kotlin.ir.declarations.IrFile file;
    @NotNull
    private final IrLibraryFile fileReader;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final IrDeclarationDeserializer declarationDeserializer;
    @NotNull
    private final Map<IdSignature, Integer> reversedSignatureIndex;
    @Nullable
    private List<IrConstructorCall> annotations;

    /*
     * WARNING - void declaration
     */
    public IrFileDeserializer(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IrLibraryFile fileReader, @NotNull IrFile fileProto, @NotNull IrSymbolDeserializer symbolDeserializer2, @NotNull IrDeclarationDeserializer declarationDeserializer) {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileReader, (String)"fileReader");
        Intrinsics.checkNotNullParameter((Object)fileProto, (String)"fileProto");
        Intrinsics.checkNotNullParameter((Object)symbolDeserializer2, (String)"symbolDeserializer");
        Intrinsics.checkNotNullParameter((Object)declarationDeserializer, (String)"declarationDeserializer");
        this.file = file2;
        this.fileReader = fileReader;
        this.symbolDeserializer = symbolDeserializer2;
        this.declarationDeserializer = declarationDeserializer;
        Iterable<Integer> iterable = fileProto.getDeclarationIdList();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"fileProto.declarationIdList");
        iterable = iterable;
        IrFileDeserializer irFileDeserializer = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var9_10 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Integer n = (Integer)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            IrSymbolDeserializer irSymbolDeserializer = this.getSymbolDeserializer();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            IdSignature idSignature = irSymbolDeserializer.deserializeIdSignature(it.intValue());
            map.put(idSignature, element$iv$iv);
        }
        irFileDeserializer.reversedSignatureIndex = map = destination$iv$iv;
        this.annotations = fileProto.getAnnotationList();
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrFile getFile() {
        return this.file;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    @NotNull
    public final IrDeclarationDeserializer getDeclarationDeserializer() {
        return this.declarationDeserializer;
    }

    @NotNull
    public final Map<IdSignature, Integer> getReversedSignatureIndex() {
        return this.reversedSignatureIndex;
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrDeclaration deserializeDeclaration$ir_serialization_common(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration2 = this.declarationDeserializer.deserializeDeclaration(this.loadTopLevelDeclarationProto(idSig));
        boolean bl = false;
        boolean bl2 = false;
        org.jetbrains.kotlin.ir.declarations.IrDeclaration it = irDeclaration2;
        boolean bl3 = false;
        org.jetbrains.kotlin.ir.declarations.IrFile irFile = this.getFile();
        Collection collection = irFile.getDeclarations();
        boolean bl4 = false;
        collection.add(it);
        return irDeclaration2;
    }

    private final CodedInputStream readDeclaration(int index2) {
        return BasicIrModuleDeserializerKt.getCodedInputStream(this.fileReader.irDeclaration(index2));
    }

    private final IrDeclaration loadTopLevelDeclarationProto(IdSignature idSig) {
        Serializable serializable = this.reversedSignatureIndex.get(idSig);
        if (serializable == null) {
            String string2 = Intrinsics.stringPlus((String)"Not found Idx for ", (Object)idSig);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        int idSigIndex = serializable;
        serializable = IrDeclaration.parseFrom(this.readDeclaration(idSigIndex), ExtensionRegistryLite.newInstance());
        Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"parseFrom(readDeclaration(idSigIndex), ExtensionRegistryLite.newInstance())");
        return serializable;
    }

    public final void deserializeFileImplicitDataIfFirstUse() {
        List<IrConstructorCall> list2 = this.annotations;
        if (list2 != null) {
            List<IrConstructorCall> list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List<IrConstructorCall> it = list3;
            boolean bl3 = false;
            org.jetbrains.kotlin.ir.declarations.IrFile irFile = this.getFile();
            irFile.setAnnotations(CollectionsKt.plus((Collection)irFile.getAnnotations(), (Iterable)this.getDeclarationDeserializer().deserializeAnnotations$ir_serialization_common(it)));
            this.annotations = null;
        }
    }
}

