/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.cfg.ConstructorConsistencyChecker;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProviderImpl;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.ReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.cfg.TailInstructionDetector;
import org.jetbrains.kotlin.cfg.TailRecursionKind;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.cfg.UnreachableCodeImpl;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.JumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraverseInstructionResult;
import org.jetbrains.kotlin.cfg.variable.BlockScopeVariableInfo;
import org.jetbrains.kotlin.cfg.variable.PseudocodeVariablesData;
import org.jetbrains.kotlin.cfg.variable.VariableControlFlowState;
import org.jetbrains.kotlin.cfg.variable.VariableInitReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.cfg.variable.VariableUseState;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CapturingInClosureCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 h2\u00020\u0001:\u0006hijklmB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB/\b\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001cH\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010%\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010(\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010)\u001a\u00020\u001c2\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\b\u0010.\u001a\u00020\u001cH\u0002J2\u0010/\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\b\u00103\u001a\u00020\u001cH\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\"H\u0002J\u0018\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00109\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020\u001cH\u0002J\b\u0010>\u001a\u00020\u001cH\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010E\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010F\u001a\u00020\u001cH\u0002J\b\u0010G\u001a\u00020\u001cH\u0002J\b\u0010H\u001a\u00020\u001cH\u0002J\b\u0010I\u001a\u00020\u001cH\u0002J.\u0010J\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020K2\u0006\u00108\u001a\u00020-2\n\u0010\u0017\u001a\u00060LR\u00020\u00002\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J$\u0010O\u001a\u00020\u001c2\n\u0010\u0017\u001a\u00060LR\u00020\u00002\u0006\u0010*\u001a\u00020P2\u0006\u00108\u001a\u00020-H\u0002J\b\u0010Q\u001a\u00020\u001cH\u0002J*\u0010Q\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010R\u001a\u0014\u0012\u0004\u0012\u00020C\u0012\n\u0012\b\u0012\u0004\u0012\u00020U0T0SH\u0002J\u001c\u0010V\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020X2\n\u0010\u0017\u001a\u00060YR\u00020\u0000H\u0002J\u0010\u0010Z\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J$\u0010[\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00108\u001a\u00020-2\n\u0010\u0017\u001a\u00060\u0018R\u00020\u0000H\u0002JG\u0010\\\u001a\u00020\u001c2<\b\u0004\u0010]\u001a6\u0012\u0013\u0012\u00110_\u00a2\u0006\f\b`\u0012\b\ba\u0012\u0004\b\b(B\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030b\u00a2\u0006\f\b`\u0012\b\ba\u0012\u0004\b\b(c\u0012\u0004\u0012\u00020\u001c0^H\u0082\bJ\f\u0010d\u001a\u00020\u0016*\u00020eH\u0002J\u0010\u0010f\u001a\u00020\u0016*\u00060\u0018R\u00020\u0000H\u0002J\u0016\u0010g\u001a\u00020\u0016*\u00020_2\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider;", "declaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;)V", "subroutine", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;)V", "pseudocodeVariablesData", "Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "getPseudocodeVariablesData", "()Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "pseudocodeVariablesData$delegate", "Lkotlin/Lazy;", "checkAssignmentBeforeDeclaration", "", "ctxt", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableInitContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkConstructorConsistency", "", "checkDeclaration", "checkDefiniteReturn", "expectedReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "unreachableCode", "Lorg/jetbrains/kotlin/cfg/UnreachableCode;", "checkForLocalClassOrObjectMode", "checkForSuspendLambdaAndMarkParameters", "checkFunction", "checkIfExpressions", "checkImplicitCastOnConditionalExpression", "checkInitializationForCustomSetter", "checkIsInitialized", "element", "varWithUninitializedErrorGenerated", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkLocalFunctions", "checkValReassignment", "writeValueInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/WriteValueInstruction;", "varWithValReassignErrorGenerated", "checkWhenExpressions", "collectReturnExpressions", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$ReturnedExpressionsInfo;", "collectUnreachableCode", "isCapturedWrite", "variableDescriptor", "isInsideTry", "markAndCheckRecursiveTailCalls", "subroutineDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "markAndCheckTailCalls", "markAnnotationArguments", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "markImplicitReceiverOfSuspendLambda", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "markReadOfSuspendLambdaParameter", "markReadOfSuspendLambdaParameters", "markStatements", "markUninitializedVariables", "markUnusedExpressions", "markUnusedVariables", "processUnusedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableUseContext;", "variableUseState", "Lorg/jetbrains/kotlin/cfg/variable/VariableUseState;", "processUnusedParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "recordInitializedVariables", "initializersMap", "", "Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/Edges;", "Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;", "report", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "reportUnreachableCode", "reportValReassigned", "traverseCalls", "onCall", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/CallInstruction;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "isDefinitelyInitialized", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isInitializationBeforeDeclaration", "isTailCall", "Companion", "Factory", "ReturnedExpressionsInfo", "VariableContext", "VariableInitContext", "VariableUseContext", "cfg"})
public final class ControlFlowInformationProviderImpl
implements ControlFlowInformationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtElement subroutine;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Pseudocode pseudocode;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    @NotNull
    private final Lazy pseudocodeVariablesData$delegate;

    private ControlFlowInformationProviderImpl(KtElement subroutine, BindingTrace trace, Pseudocode pseudocode, LanguageVersionSettings languageVersionSettings, PlatformDiagnosticSuppressor diagnosticSuppressor) {
        this.subroutine = subroutine;
        this.trace = trace;
        this.pseudocode = pseudocode;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.pseudocodeVariablesData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PseudocodeVariablesData>(this){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PseudocodeVariablesData invoke() {
                Pseudocode pseudocode = ControlFlowInformationProviderImpl.access$getPseudocode$p(this.this$0);
                BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                return new PseudocodeVariablesData(pseudocode, bindingContext);
            }
        }));
    }

    private final PseudocodeVariablesData getPseudocodeVariablesData() {
        Lazy lazy = this.pseudocodeVariablesData$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (PseudocodeVariablesData)lazy.getValue();
    }

    public ControlFlowInformationProviderImpl(@NotNull KtElement declaration2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
        this(declaration2, trace, new ControlFlowProcessor(trace, languageVersionSettings).generatePseudocode(declaration2), languageVersionSettings, diagnosticSuppressor);
    }

    @Override
    public void checkForLocalClassOrObjectMode() {
        this.recordInitializedVariables();
    }

    @Override
    public void checkDeclaration() {
        this.recordInitializedVariables();
        this.checkLocalFunctions();
        this.markUninitializedVariables();
        if (this.trace.wantsDiagnostics()) {
            this.markUnusedVariables();
        }
        this.checkForSuspendLambdaAndMarkParameters(this.pseudocode);
        this.markStatements();
        this.markAnnotationArguments();
        this.markUnusedExpressions();
        if (this.trace.wantsDiagnostics()) {
            this.checkIfExpressions();
        }
        this.checkWhenExpressions();
        this.checkConstructorConsistency();
    }

    @Override
    public void checkFunction(@Nullable KotlinType expectedReturnType) {
        KotlinType kotlinType;
        UnreachableCode unreachableCode = this.collectUnreachableCode();
        this.reportUnreachableCode(unreachableCode);
        if (this.subroutine instanceof KtFunctionLiteral) {
            return;
        }
        KotlinType kotlinType2 = expectedReturnType;
        if (kotlinType2 == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        } else {
            kotlinType = kotlinType2;
        }
        this.checkDefiniteReturn(kotlinType, unreachableCode);
        this.markAndCheckTailCalls();
    }

    private final ReturnedExpressionsInfo collectReturnExpressions() {
        HashSet instructions = CollectionsKt.toHashSet((Iterable)this.pseudocode.getInstructions());
        SubroutineExitInstruction exitInstruction = this.pseudocode.getExitInstruction();
        boolean bl = false;
        ArrayList<KtElement> returnedExpressions = new ArrayList<KtElement>();
        Ref.BooleanRef hasReturnsInInlinedLambda = new Ref.BooleanRef();
        for (Instruction previousInstruction : exitInstruction.getPreviousInstructions()) {
            previousInstruction.accept(new InstructionVisitor(instructions, returnedExpressions, hasReturnsInInlinedLambda){
                final /* synthetic */ HashSet<Instruction> $instructions;
                final /* synthetic */ ArrayList<KtElement> $returnedExpressions;
                final /* synthetic */ Ref.BooleanRef $hasReturnsInInlinedLambda;
                {
                    this.$instructions = $instructions;
                    this.$returnedExpressions = $returnedExpressions;
                    this.$hasReturnsInInlinedLambda = $hasReturnsInInlinedLambda;
                }

                public void visitReturnValue(@NotNull ReturnValueInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    if (this.$instructions.contains(instruction)) {
                        this.$returnedExpressions.add(instruction.getElement());
                    }
                    if (instruction.getOwner().isInlined()) {
                        this.$hasReturnsInInlinedLambda.element = true;
                    }
                }

                public void visitReturnNoValue(@NotNull ReturnNoValueInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    if (this.$instructions.contains(instruction)) {
                        this.$returnedExpressions.add(instruction.getElement());
                    }
                    if (instruction.getOwner().isInlined()) {
                        this.$hasReturnsInInlinedLambda.element = true;
                    }
                }

                public void visitUnconditionalJump(@NotNull UnconditionalJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                private final void redirectToPrevInstructions(Instruction instruction) {
                    for (Instruction redirectInstruction : instruction.getPreviousInstructions()) {
                        redirectInstruction.accept(this);
                    }
                }

                public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitMarkInstruction(@NotNull MarkInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitInstruction(@NotNull Instruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    if (!(instruction instanceof KtElementInstruction)) {
                        throw new IllegalStateException(instruction + " precedes the exit point");
                    }
                    this.$returnedExpressions.add(((KtElementInstruction)instruction).getElement());
                }
            });
        }
        return new ReturnedExpressionsInfo((Collection<? extends KtElement>)returnedExpressions, hasReturnsInInlinedLambda.element);
    }

    private final void checkLocalFunctions() {
        for (LocalFunctionDeclarationInstruction localDeclarationInstruction : this.pseudocode.getLocalDeclarations()) {
            CallableDescriptor functionDescriptor;
            KtElement element = localDeclarationInstruction.getElement();
            if (!(element instanceof KtDeclarationWithBody)) continue;
            DeclarationDescriptor declarationDescriptor = this.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            CallableDescriptor callableDescriptor = functionDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            KotlinType expectedType2 = callableDescriptor == null ? null : callableDescriptor.getReturnType();
            ControlFlowInformationProviderImpl providerForLocalDeclaration = new ControlFlowInformationProviderImpl(element, this.trace, localDeclarationInstruction.getBody(), this.languageVersionSettings, this.diagnosticSuppressor);
            providerForLocalDeclaration.checkFunction(expectedType2);
        }
    }

    private final void checkDefiniteReturn(KotlinType expectedReturnType, UnreachableCode unreachableCode) {
        Object object;
        KtElement ktElement = this.subroutine;
        Object object2 = object = ktElement instanceof KtDeclarationWithBody ? (KtDeclarationWithBody)ktElement : null;
        if (object == null) {
            throw new AssertionError((Object)("checkDefiniteReturn is called for " + this.subroutine.getText() + " which is not KtDeclarationWithBody"));
        }
        Object function2 = object;
        if (!function2.hasBody()) {
            return;
        }
        object = this.collectReturnExpressions();
        Collection<KtElement> returnedExpressions = ((ReturnedExpressionsInfo)object).component1();
        boolean hasReturnsInInlinedLambdas = ((ReturnedExpressionsInfo)object).component2();
        boolean blockBody = function2.hasBlockBody();
        Ref.BooleanRef noReturnError = new Ref.BooleanRef();
        for (KtElement returnedExpression : returnedExpressions) {
            returnedExpression.accept(new KtVisitorVoid(blockBody, this, expectedReturnType, unreachableCode, noReturnError){
                final /* synthetic */ boolean $blockBody;
                final /* synthetic */ ControlFlowInformationProviderImpl this$0;
                final /* synthetic */ KotlinType $expectedReturnType;
                final /* synthetic */ UnreachableCode $unreachableCode;
                final /* synthetic */ Ref.BooleanRef $noReturnError;
                {
                    this.$blockBody = $blockBody;
                    this.this$0 = $receiver;
                    this.$expectedReturnType = $expectedReturnType;
                    this.$unreachableCode = $unreachableCode;
                    this.$noReturnError = $noReturnError;
                }

                public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (!this.$blockBody) {
                        ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY.on((KtReturnExpression)((PsiElement)expression2)));
                    }
                }

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!(element instanceof KtExpression) && !(element instanceof KtWhenCondition)) {
                        return;
                    }
                    if (this.$blockBody && !TypeUtils.noExpectedType(this.$expectedReturnType) && !KotlinBuiltIns.isUnit(this.$expectedReturnType) && !this.$unreachableCode.getElements().contains(element)) {
                        this.$noReturnError.element = true;
                    }
                }
            });
        }
        if (noReturnError.element) {
            if (hasReturnsInInlinedLambdas) {
                this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY_MIGRATION.on((KtDeclarationWithBody)((PsiElement)function2)));
            } else {
                this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY.on((KtDeclarationWithBody)((PsiElement)function2)));
            }
        }
    }

    private final void reportUnreachableCode(UnreachableCode unreachableCode) {
        for (KtElement element : unreachableCode.getElements()) {
            this.trace.report(Errors.UNREACHABLE_CODE.on((KtElement)((PsiElement)element), unreachableCode.getReachableElements(), unreachableCode.getUnreachableElements()));
        }
    }

    private final UnreachableCode collectUnreachableCode() {
        boolean bl = false;
        HashSet<KtElement> reachableElements = new HashSet<KtElement>();
        boolean bl2 = false;
        HashSet<KtElement> unreachableElements = new HashSet<KtElement>();
        for (Instruction instruction : this.pseudocode.getInstructionsIncludingDeadCode()) {
            boolean isJumpElement;
            if (!(instruction instanceof KtElementInstruction) || instruction instanceof LoadUnitValueInstruction || instruction instanceof MergeInstruction || instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getSynthetic()) continue;
            KtElement element = ((KtElementInstruction)instruction).getElement();
            if (instruction instanceof JumpInstruction && !(isJumpElement = element instanceof KtBreakExpression || element instanceof KtContinueExpression || element instanceof KtReturnExpression || element instanceof KtThrowExpression)) continue;
            if (instruction.getDead()) {
                unreachableElements.add(element);
                continue;
            }
            reachableElements.add(element);
        }
        return new UnreachableCodeImpl((Set<? extends KtElement>)reachableElements, (Set<? extends KtElement>)unreachableElements);
    }

    private final void markUninitializedVariables() {
        boolean bl = false;
        HashSet<VariableDescriptor> varWithUninitializedErrorGenerated = new HashSet<VariableDescriptor>();
        boolean bl2 = false;
        HashSet<VariableDescriptor> varWithValReassignErrorGenerated = new HashSet<VariableDescriptor>();
        boolean processClassOrObject = this.subroutine instanceof KtClassOrObject;
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(this.pseudocode, true);
        BlockScopeVariableInfo blockScopeVariableInfo = this.getPseudocodeVariablesData().getBlockScopeVariableInfo();
        boolean bl3 = false;
        HashMap reportedDiagnosticMap = new HashMap();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, initializers, (Function3)new Function3<Instruction, VariableInitReadOnlyControlFlowInfo, VariableInitReadOnlyControlFlowInfo, Unit>(this, reportedDiagnosticMap, blockScopeVariableInfo, declaredVariables, varWithUninitializedErrorGenerated, varWithValReassignErrorGenerated, processClassOrObject){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap<Instruction, DiagnosticFactory<?>> $reportedDiagnosticMap;
            final /* synthetic */ BlockScopeVariableInfo $blockScopeVariableInfo;
            final /* synthetic */ Set<VariableDescriptor> $declaredVariables;
            final /* synthetic */ HashSet<VariableDescriptor> $varWithUninitializedErrorGenerated;
            final /* synthetic */ HashSet<VariableDescriptor> $varWithValReassignErrorGenerated;
            final /* synthetic */ boolean $processClassOrObject;
            {
                this.this$0 = $receiver;
                this.$reportedDiagnosticMap = $reportedDiagnosticMap;
                this.$blockScopeVariableInfo = $blockScopeVariableInfo;
                this.$declaredVariables = $declaredVariables;
                this.$varWithUninitializedErrorGenerated = $varWithUninitializedErrorGenerated;
                this.$varWithValReassignErrorGenerated = $varWithValReassignErrorGenerated;
                this.$processClassOrObject = $processClassOrObject;
                super(3);
            }

            public final void invoke(@NotNull Instruction instruction, @NotNull VariableInitReadOnlyControlFlowInfo enterData, @NotNull VariableInitReadOnlyControlFlowInfo exitData) {
                KtExpression ktExpression;
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Intrinsics.checkNotNullParameter((Object)enterData, (String)"enterData");
                Intrinsics.checkNotNullParameter((Object)exitData, (String)"exitData");
                VariableInitContext ctxt = this.this$0.new VariableInitContext(instruction, (Map)this.$reportedDiagnosticMap, enterData, exitData, this.$blockScopeVariableInfo);
                if (ctxt.getVariableDescriptor$cfg() == null) {
                    return;
                }
                if (instruction instanceof ReadValueInstruction) {
                    KtElement element = ((ReadValueInstruction)instruction).getElement();
                    if (PseudocodeUtil.isThisOrNoDispatchReceiver((AccessValueInstruction)instruction, ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext()) && this.$declaredVariables.contains(ctxt.getVariableDescriptor$cfg())) {
                        ControlFlowInformationProviderImpl.access$checkIsInitialized(this.this$0, ctxt, element, this.$varWithUninitializedErrorGenerated);
                    }
                    return;
                }
                if (!(instruction instanceof WriteValueInstruction)) {
                    return;
                }
                KtElement ktElement = ((WriteValueInstruction)instruction).getLValue();
                KtExpression ktExpression2 = ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
                if (ktExpression == null) {
                    return;
                }
                KtExpression element = ktExpression;
                boolean error = ControlFlowInformationProviderImpl.access$checkValReassignment(this.this$0, ctxt, element, (WriteValueInstruction)instruction, this.$varWithValReassignErrorGenerated);
                if (!error && this.$processClassOrObject) {
                    error = ControlFlowInformationProviderImpl.access$checkAssignmentBeforeDeclaration(this.this$0, ctxt, element);
                }
                if (!error && this.$processClassOrObject) {
                    ControlFlowInformationProviderImpl.access$checkInitializationForCustomSetter(this.this$0, ctxt, element);
                }
            }
        });
    }

    private final void recordInitializedVariables() {
        Pseudocode pseudocode = this.getPseudocodeVariablesData().getPseudocode();
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        this.recordInitializedVariables(pseudocode, initializers);
        for (LocalFunctionDeclarationInstruction instruction : pseudocode.getLocalDeclarations()) {
            this.recordInitializedVariables(instruction.getBody(), initializers);
        }
    }

    private final boolean isDefinitelyInitialized(PropertyDescriptor $this$isDefinitelyInitialized) {
        if (Intrinsics.areEqual(this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, $this$isDefinitelyInitialized), (Object)true)) {
            return false;
        }
        PsiElement property2 = DescriptorToSourceUtils.descriptorToDeclaration($this$isDefinitelyInitialized);
        return !(property2 instanceof KtProperty) || !((KtProperty)property2).hasDelegate();
    }

    private final void checkIsInitialized(VariableInitContext ctxt, KtElement element, Collection<VariableDescriptor> varWithUninitializedErrorGenerated) {
        block14: {
            VariableDescriptor variableDescriptor;
            ParametrizedDiagnostic<KtSimpleNameExpression> parametrizedDiagnostic;
            VariableDescriptor variableDescriptor2;
            block16: {
                Object it;
                int n;
                block15: {
                    boolean bl;
                    if (!(element instanceof KtSimpleNameExpression)) {
                        return;
                    }
                    VariableControlFlowState variableControlFlowState = ctxt.getExitInitState$cfg();
                    boolean isDefinitelyInitialized = variableControlFlowState == null ? false : (bl = variableControlFlowState.definitelyInitialized());
                    variableDescriptor2 = ctxt.getVariableDescriptor$cfg();
                    if (!isDefinitelyInitialized && variableDescriptor2 instanceof PropertyDescriptor) {
                        isDefinitelyInitialized = this.isDefinitelyInitialized((PropertyDescriptor)variableDescriptor2);
                    }
                    if (isDefinitelyInitialized || CollectionsKt.contains((Iterable)varWithUninitializedErrorGenerated, (Object)variableDescriptor2)) break block14;
                    if (!(variableDescriptor2 instanceof PropertyDescriptor)) {
                        VariableDescriptor variableDescriptor3 = variableDescriptor2;
                        if (variableDescriptor3 != null) {
                            parametrizedDiagnostic = variableDescriptor3;
                            boolean bl2 = false;
                            n = 0;
                            it = parametrizedDiagnostic;
                            boolean bl3 = false;
                            varWithUninitializedErrorGenerated.add((VariableDescriptor)it);
                        }
                    } else if (((PropertyDescriptor)variableDescriptor2).isLateInit()) {
                        this.trace.record(BindingContext.MUST_BE_LATEINIT, variableDescriptor2);
                        return;
                    }
                    variableDescriptor = variableDescriptor2;
                    if (!(variableDescriptor instanceof ValueParameterDescriptor)) break block15;
                    parametrizedDiagnostic = Errors.UNINITIALIZED_PARAMETER.on((KtSimpleNameExpression)element, (ValueParameterDescriptor)variableDescriptor2);
                    Intrinsics.checkNotNullExpressionValue((Object)parametrizedDiagnostic, (String)"UNINITIALIZED_PARAMETER.\u2026ment, variableDescriptor)");
                    this.report(parametrizedDiagnostic, ctxt);
                    break block14;
                }
                if (!(variableDescriptor instanceof FakeCallableDescriptorForObject)) break block16;
                ClassDescriptor classDescriptor = ((FakeCallableDescriptorForObject)variableDescriptor2).getClassDescriptor();
                ClassKind classKind = classDescriptor.getKind();
                n = WhenMappings.$EnumSwitchMapping$0[classKind.ordinal()];
                switch (n) {
                    case 1: {
                        it = Errors.UNINITIALIZED_ENUM_ENTRY.on((KtSimpleNameExpression)element, classDescriptor);
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"UNINITIALIZED_ENUM_ENTRY\u2026element, classDescriptor)");
                        this.report((Diagnostic)it, ctxt);
                        break;
                    }
                    case 2: {
                        if (!classDescriptor.isCompanionObject()) break block14;
                        Object object = classDescriptor.getContainingDeclaration();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classDescriptor.containingDeclaration");
                        DeclarationDescriptor container2 = object;
                        if (!(container2 instanceof ClassDescriptor) || ((ClassDescriptor)container2).getKind() != ClassKind.ENUM_CLASS) break block14;
                        object = Errors.UNINITIALIZED_ENUM_COMPANION.on((KtSimpleNameExpression)element, (ClassDescriptor)container2);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UNINITIALIZED_ENUM_COMPA\u2026ON.on(element, container)");
                        this.report((Diagnostic)object, ctxt);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block14;
            }
            if (!(variableDescriptor == null || variableDescriptor2.isLateInit() || variableDescriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)variableDescriptor2)))) {
                parametrizedDiagnostic = Errors.UNINITIALIZED_VARIABLE.on((KtSimpleNameExpression)element, variableDescriptor2);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"UNINITIALIZED_VARIABLE.o\u2026ment, variableDescriptor)");
                this.report(parametrizedDiagnostic, ctxt);
            }
        }
    }

    private final boolean isCapturedWrite(VariableDescriptor variableDescriptor, WriteValueInstruction writeValueInstruction) {
        block5: {
            BindingContext context2;
            DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"variableDescriptor.containingDeclaration");
            DeclarationDescriptor containingDeclarationDescriptor = declarationDescriptor;
            if (containingDeclarationDescriptor instanceof PackageFragmentDescriptor) {
                return false;
            }
            KtDeclaration parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(writeValueInstruction.getElement());
            while (true) {
                BindingContext bindingContext = this.trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                context2 = bindingContext;
                DeclarationDescriptor parentDescriptor = CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(parentDeclaration, context2);
                if (Intrinsics.areEqual((Object)parentDescriptor, (Object)containingDeclarationDescriptor)) {
                    return false;
                }
                KtDeclaration ktDeclaration = parentDeclaration;
                if (ktDeclaration instanceof KtObjectDeclaration ? true : ktDeclaration instanceof KtClassInitializer) {
                    parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration);
                    continue;
                }
                if (!(ktDeclaration instanceof KtDeclarationWithBody)) break block5;
                PsiElement maybeEnclosingLambdaExpr = ((KtDeclarationWithBody)parentDeclaration).getParent();
                if (!(maybeEnclosingLambdaExpr instanceof KtLambdaExpression) || this.trace.get(BindingContext.LAMBDA_INVOCATIONS, maybeEnclosingLambdaExpr) == null) break;
                parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration);
            }
            if (parentDeclaration instanceof KtFunction && ((KtFunction)parentDeclaration).isLocal()) {
                return true;
            }
            return !Intrinsics.areEqual((Object)CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration), context2), (Object)containingDeclarationDescriptor);
        }
        return true;
    }

    private final boolean checkValReassignment(VariableInitContext ctxt, KtExpression expression2, WriteValueInstruction writeValueInstruction, Collection<VariableDescriptor> varWithValReassignErrorGenerated) {
        boolean captured2;
        boolean bl;
        Object receiverValue;
        boolean bl2;
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
        Boolean bl3;
        Object object;
        boolean bl4;
        VariableDescriptor variableDescriptor = ctxt.getVariableDescriptor$cfg();
        VariableControlFlowState variableControlFlowState = ctxt.getEnterInitState$cfg();
        boolean mayBeInitializedNotHere = variableControlFlowState == null ? false : (bl4 = variableControlFlowState.mayBeInitialized());
        Object object2 = object = variableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)variableDescriptor : null;
        if (object == null) {
            bl3 = true;
        } else {
            parametrizedDiagnostic = object;
            boolean bl5 = false;
            bl2 = false;
            PropertyDescriptor it = parametrizedDiagnostic;
            boolean bl6 = false;
            Boolean bl7 = (Boolean)this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, it);
            bl3 = bl7 == null ? Boolean.valueOf(true) : bl7;
        }
        Boolean bl8 = bl3;
        boolean hasBackingField = bl8;
        if (variableDescriptor instanceof PropertyDescriptor && ((PropertyDescriptor)variableDescriptor).isVar()) {
            object = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
            DeclarationDescriptor descriptor2 = BindingContextUtilsKt.getEnclosingDescriptor((BindingContext)object, expression2);
            PropertySetterDescriptor setterDescriptor = ((PropertyDescriptor)variableDescriptor).getSetter();
            KtElement ktElement = expression2;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            parametrizedDiagnostic = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            Object object3 = receiverValue = parametrizedDiagnostic == null ? null : ResolvedCallUtilKt.getDispatchReceiverWithSmartCast(parametrizedDiagnostic);
            if (DescriptorVisibilities.isVisible((ReceiverValue)receiverValue, variableDescriptor, descriptor2) && setterDescriptor != null && !DescriptorVisibilities.isVisible((ReceiverValue)receiverValue, setterDescriptor, descriptor2)) {
                parametrizedDiagnostic = Errors.INVISIBLE_SETTER.on(expression2, variableDescriptor, setterDescriptor.getVisibility(), setterDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"INVISIBLE_SETTER.on(\n   \u2026tor\n                    )");
                this.report(parametrizedDiagnostic, ctxt);
                return true;
            }
        }
        boolean isThisOrNoDispatchReceiver = PseudocodeUtil.isThisOrNoDispatchReceiver(writeValueInstruction, this.trace.getBindingContext());
        receiverValue = variableDescriptor;
        if (receiverValue == null) {
            bl = false;
        } else {
            boolean bl9;
            VariableDescriptor variableDescriptor2 = receiverValue;
            bl2 = false;
            boolean bl10 = false;
            VariableDescriptor it = variableDescriptor2;
            boolean bl11 = false;
            bl = captured2 = (bl9 = this.isCapturedWrite(it, writeValueInstruction));
        }
        if (!(!mayBeInitializedNotHere && hasBackingField && isThisOrNoDispatchReceiver && !captured2 || variableDescriptor == null || variableDescriptor.isVar())) {
            KtSimpleNameExpression operationReference;
            boolean hasReassignMethodReturningUnit = false;
            PsiElement parent2 = expression2.getParent();
            KtSimpleNameExpression ktSimpleNameExpression = parent2 instanceof KtBinaryExpression ? (KtSimpleNameExpression)((KtBinaryExpression)parent2).getOperationReference() : (operationReference = parent2 instanceof KtUnaryExpression ? ((KtUnaryExpression)parent2).getOperationReference() : null);
            if (operationReference != null) {
                Object object4;
                DeclarationDescriptor descriptor3 = (DeclarationDescriptor)this.trace.get(BindingContext.REFERENCE_TARGET, operationReference);
                if (descriptor3 instanceof FunctionDescriptor) {
                    boolean bl12;
                    KotlinType kotlinType = ((FunctionDescriptor)descriptor3).getReturnType();
                    if (kotlinType == null) {
                        bl12 = false;
                    } else {
                        object4 = kotlinType;
                        boolean it = false;
                        boolean bl13 = false;
                        Iterator it2 = object4;
                        boolean bl14 = false;
                        bl12 = KotlinBuiltIns.isUnit(it2);
                    }
                    if (bl12) {
                        hasReassignMethodReturningUnit = true;
                    }
                }
                if (descriptor3 == null) {
                    object4 = (Collection)this.trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationReference);
                    Iterator descriptors = object4 == null ? (Collection)CollectionsKt.emptyList() : object4;
                    object4 = descriptors.iterator();
                    while (object4.hasNext()) {
                        boolean bl15;
                        FunctionDescriptor functionDescriptor;
                        DeclarationDescriptor referenceDescriptor = (DeclarationDescriptor)object4.next();
                        FunctionDescriptor functionDescriptor2 = functionDescriptor = referenceDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)referenceDescriptor : null;
                        if (functionDescriptor == null) {
                            bl15 = false;
                        } else {
                            KotlinType kotlinType = functionDescriptor.getReturnType();
                            if (kotlinType == null) {
                                bl15 = false;
                            } else {
                                KotlinType kotlinType2 = kotlinType;
                                boolean bl16 = false;
                                boolean bl17 = false;
                                KotlinType it = kotlinType2;
                                boolean bl18 = false;
                                bl15 = KotlinBuiltIns.isUnit(it);
                            }
                        }
                        if (!bl15) continue;
                        hasReassignMethodReturningUnit = true;
                    }
                }
            }
            if (!hasReassignMethodReturningUnit) {
                if (!isThisOrNoDispatchReceiver || !varWithValReassignErrorGenerated.contains(variableDescriptor)) {
                    ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic2;
                    if (captured2 && !mayBeInitializedNotHere && hasBackingField && isThisOrNoDispatchReceiver) {
                        if (variableDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                            parametrizedDiagnostic2 = Errors.CAPTURED_MEMBER_VAL_INITIALIZATION.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, (String)"CAPTURED_MEMBER_VAL_INIT\u2026sion, variableDescriptor)");
                            this.report(parametrizedDiagnostic2, ctxt);
                        } else {
                            parametrizedDiagnostic2 = Errors.CAPTURED_VAL_INITIALIZATION.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, (String)"CAPTURED_VAL_INITIALIZAT\u2026sion, variableDescriptor)");
                            this.report(parametrizedDiagnostic2, ctxt);
                        }
                    } else if (DescriptorPsiUtilsKt.isBackingFieldReference(variableDescriptor)) {
                        this.reportValReassigned(expression2, variableDescriptor, ctxt);
                    } else {
                        parametrizedDiagnostic2 = Errors.VAL_REASSIGNMENT.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, (String)"VAL_REASSIGNMENT.on(expr\u2026sion, variableDescriptor)");
                        this.report(parametrizedDiagnostic2, ctxt);
                    }
                }
                if (isThisOrNoDispatchReceiver) {
                    varWithValReassignErrorGenerated.add(variableDescriptor);
                }
                return true;
            }
        }
        return false;
    }

    private final void reportValReassigned(KtExpression expression2, VariableDescriptor variableDescriptor, VariableInitContext ctxt) {
        DiagnosticFactory1<KtExpression, DeclarationDescriptor> diagnosticFactory = this.languageVersionSettings.supportsFeature(LanguageFeature.RestrictionOfValReassignmentViaBackingField) ? Errors.VAL_REASSIGNMENT_VIA_BACKING_FIELD_ERROR : Errors.VAL_REASSIGNMENT_VIA_BACKING_FIELD;
        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = diagnosticFactory.on((KtExpression)((PsiElement)expression2), variableDescriptor);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"diagnosticFactory.on(exp\u2026sion, variableDescriptor)");
        this.report(parametrizedDiagnostic, ctxt);
    }

    private final boolean checkAssignmentBeforeDeclaration(VariableInitContext ctxt, KtExpression expression2) {
        boolean bl;
        if (this.isInitializationBeforeDeclaration(ctxt)) {
            if (ctxt.getVariableDescriptor$cfg() != null) {
                ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.INITIALIZATION_BEFORE_DECLARATION.on((KtExpression)((PsiElement)expression2), ctxt.getVariableDescriptor$cfg());
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"INITIALIZATION_BEFORE_DE\u2026 ctxt.variableDescriptor)");
                this.report(parametrizedDiagnostic, ctxt);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isInitializationBeforeDeclaration(VariableInitContext $this$isInitializationBeforeDeclaration) {
        VariableControlFlowState variableControlFlowState = $this$isInitializationBeforeDeclaration.getEnterInitState$cfg();
        return !(variableControlFlowState == null ? false : variableControlFlowState.isDeclared()) && !((variableControlFlowState = $this$isInitializationBeforeDeclaration.getExitInitState$cfg()) == null ? false : variableControlFlowState.isDeclared()) && !((variableControlFlowState = $this$isInitializationBeforeDeclaration.getEnterInitState$cfg()) == null ? false : variableControlFlowState.mayBeInitialized());
    }

    private final boolean checkInitializationForCustomSetter(VariableInitContext ctxt, KtExpression expression2) {
        KtExpression variable2;
        KtProperty ktProperty;
        VariableControlFlowState variableControlFlowState;
        VariableDescriptor variableDescriptor = ctxt.getVariableDescriptor$cfg();
        if (!(variableDescriptor instanceof PropertyDescriptor && !((variableControlFlowState = ctxt.getEnterInitState$cfg()) == null ? false : variableControlFlowState.mayBeInitialized()) && ((variableControlFlowState = ctxt.getExitInitState$cfg()) == null ? false : variableControlFlowState.mayBeInitialized()) && ((PropertyDescriptor)variableDescriptor).isVar() && Intrinsics.areEqual(this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, variableDescriptor), (Object)true))) {
            return false;
        }
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor);
        KtProperty ktProperty2 = ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            throw new AssertionError((Object)(variableDescriptor + " is not related to KtProperty"));
        }
        KtProperty property2 = ktProperty;
        KtPropertyAccessor setter2 = property2.getSetter();
        if (!(((PropertyDescriptor)variableDescriptor).getModality() != Modality.FINAL || setter2 != null && setter2.hasBody())) {
            return false;
        }
        KtExpression ktExpression = variable2 = expression2 instanceof KtDotQualifiedExpression && ((KtDotQualifiedExpression)expression2).getReceiverExpression() instanceof KtThisExpression ? ((KtDotQualifiedExpression)expression2).getSelectorExpression() : expression2;
        if (variable2 instanceof KtSimpleNameExpression) {
            this.trace.record(BindingContext.IS_UNINITIALIZED, variableDescriptor);
            return true;
        }
        return false;
    }

    private final void recordInitializedVariables(Pseudocode pseudocode, Map<Instruction, ? extends Edges<? extends VariableInitReadOnlyControlFlowInfo>> initializersMap) {
        Edges<? extends VariableInitReadOnlyControlFlowInfo> edges = initializersMap.get(pseudocode.getExitInstruction());
        if (edges == null) {
            return;
        }
        Edges<? extends VariableInitReadOnlyControlFlowInfo> initializers = edges;
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(pseudocode, false);
        for (VariableDescriptor variable2 : declaredVariables) {
            VariableControlFlowState variableControlFlowState;
            if (!(variable2 instanceof PropertyDescriptor) || ((variableControlFlowState = (VariableControlFlowState)initializers.getIncoming().getOrNull(variable2)) == null ? false : variableControlFlowState.definitelyInitialized())) continue;
            this.trace.record(BindingContext.IS_UNINITIALIZED, variable2);
        }
    }

    private final void markUnusedVariables() {
        Map<Instruction, Edges<ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState>>> variableStatusData = this.getPseudocodeVariablesData().getVariableUseStatusData();
        boolean bl = false;
        HashMap reportedDiagnosticMap = new HashMap();
        boolean bl2 = false;
        HashMap<KtExpression, Pair<VariableDescriptor, VariableUseContext>> unusedValueExpressions = new HashMap<KtExpression, Pair<VariableDescriptor, VariableUseContext>>();
        boolean bl3 = false;
        HashSet<KtExpression> usedValueExpressions = new HashSet<KtExpression>();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.BACKWARD, variableStatusData, (Function3)new Function3<Instruction, ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState>, ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState>, Unit>(this, reportedDiagnosticMap, unusedValueExpressions, usedValueExpressions){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap<Instruction, DiagnosticFactory<?>> $reportedDiagnosticMap;
            final /* synthetic */ HashMap<KtExpression, Pair<VariableDescriptor, VariableUseContext>> $unusedValueExpressions;
            final /* synthetic */ HashSet<KtExpression> $usedValueExpressions;
            {
                this.this$0 = $receiver;
                this.$reportedDiagnosticMap = $reportedDiagnosticMap;
                this.$unusedValueExpressions = $unusedValueExpressions;
                this.$usedValueExpressions = $usedValueExpressions;
                super(3);
            }

            public final void invoke(@NotNull Instruction instruction, @NotNull ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState> enterData, @NotNull ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState> $noName_2) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Intrinsics.checkNotNullParameter(enterData, (String)"enterData");
                Intrinsics.checkNotNullParameter($noName_2, (String)"$noName_2");
                VariableUseContext ctxt = this.this$0.new VariableUseContext(instruction, (Map)this.$reportedDiagnosticMap);
                Set<VariableDescriptor> declaredVariables = ControlFlowInformationProviderImpl.access$getPseudocodeVariablesData(this.this$0).getDeclaredVariables(instruction.getOwner(), false);
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext());
                if (variableDescriptor == null || !declaredVariables.contains(variableDescriptor) || !ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), variableDescriptor)) {
                    return;
                }
                VariableUseState variableUseState = enterData.getOrNull(variableDescriptor);
                Instruction instruction2 = instruction;
                if (instruction2 instanceof WriteValueInstruction) {
                    Object object;
                    if (ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null) {
                        return;
                    }
                    KtElement ktElement = ((WriteValueInstruction)instruction).getElement();
                    Object object2 = object = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
                    if (object == null) {
                        return;
                    }
                    KtExpression expressionInQuestion = object;
                    if (variableUseState != VariableUseState.READ) {
                        object = this.$unusedValueExpressions;
                        ktElement = TuplesKt.to((Object)variableDescriptor, (Object)ctxt);
                        boolean bl = false;
                        object.put(expressionInQuestion, ktElement);
                    } else {
                        this.$usedValueExpressions.add(expressionInQuestion);
                    }
                } else if (instruction2 instanceof VariableDeclarationInstruction) {
                    KtNamedDeclaration ktNamedDeclaration;
                    KtDeclaration ktDeclaration = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
                    KtNamedDeclaration ktNamedDeclaration2 = ktNamedDeclaration = ktDeclaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktDeclaration : null;
                    if (ktNamedDeclaration == null) {
                        return;
                    }
                    KtNamedDeclaration element = ktNamedDeclaration;
                    ControlFlowInformationProviderImpl.access$processUnusedDeclaration(this.this$0, element, variableDescriptor, ctxt, variableUseState);
                }
            }
        });
        unusedValueExpressions.keySet().removeAll((Collection)usedValueExpressions);
        Object object = unusedValueExpressions;
        boolean bl4 = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            IElementType operationToken;
            Object object2;
            Object object3 = object = iterator2.next();
            boolean bl5 = false;
            KtExpression expressionInQuestion = (KtExpression)object3.getKey();
            Object object4 = object;
            boolean bl6 = false;
            Pair variableInContext = (Pair)object4.getValue();
            object4 = variableInContext;
            VariableDescriptor variableDescriptor = (VariableDescriptor)object4.component1();
            VariableUseContext ctxt = (VariableUseContext)object4.component2();
            KtExpression ktExpression = expressionInQuestion;
            if (ktExpression instanceof KtBinaryExpression) {
                KtExpression ktExpression2;
                if (((KtBinaryExpression)expressionInQuestion).getOperationToken() != KtTokens.EQ || (ktExpression2 = ((KtBinaryExpression)expressionInQuestion).getRight()) == null) continue;
                object2 = ktExpression2;
                boolean bl7 = false;
                boolean bl8 = false;
                KtExpression it = object2;
                boolean bl9 = false;
                ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.UNUSED_VALUE.on((KtBinaryExpression)expressionInQuestion, it, variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"UNUSED_VALUE.on(expressi\u2026, it, variableDescriptor)");
                this.report(parametrizedDiagnostic, ctxt);
                continue;
            }
            if (!(ktExpression instanceof KtPostfixExpression) || (operationToken = ((KtPostfixExpression)expressionInQuestion).getOperationReference().getReferencedNameElementType()) != KtTokens.PLUSPLUS && operationToken != KtTokens.MINUSMINUS) continue;
            object2 = Errors.UNUSED_CHANGED_VALUE.on((KtElement)((PsiElement)expressionInQuestion), expressionInQuestion);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"UNUSED_CHANGED_VALUE.on(\u2026on, expressionInQuestion)");
            this.report((Diagnostic)object2, ctxt);
        }
    }

    private final void processUnusedDeclaration(KtNamedDeclaration element, VariableDescriptor variableDescriptor, VariableUseContext ctxt, VariableUseState variableUseState) {
        Object object = element.getNameIdentifier();
        if (object == null) {
            return;
        }
        if (!VariableUseState.Companion.isUsed(variableUseState)) {
            if (UnderscoreUtilKt.isSingleUnderscore(element)) {
                return;
            }
            if (element instanceof KtDestructuringDeclarationEntry && ((object = ((KtDestructuringDeclarationEntry)element).getParent().getParent()) == null ? null : object.getParent()) instanceof KtParameterList) {
                object = Errors.UNUSED_DESTRUCTURED_PARAMETER_ENTRY.on((KtDestructuringDeclarationEntry)element, variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(object, (String)"UNUSED_DESTRUCTURED_PARA\u2026ment, variableDescriptor)");
                this.report((Diagnostic)object, ctxt);
            } else if (KtPsiUtil.isRemovableVariableDeclaration(element)) {
                object = Errors.UNUSED_VARIABLE.on((KtNamedDeclaration)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(object, (String)"UNUSED_VARIABLE.on(element, variableDescriptor)");
                this.report((Diagnostic)object, ctxt);
            } else if (element instanceof KtParameter) {
                this.processUnusedParameter(ctxt, (KtParameter)element, variableDescriptor);
            }
        } else if (variableUseState == VariableUseState.ONLY_WRITTEN_NEVER_READ && KtPsiUtil.isRemovableVariableDeclaration(element)) {
            object = Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE.on((KtNamedDeclaration)((PsiElement)element), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ASSIGNED_BUT_NEVER_ACCES\u2026ment, variableDescriptor)");
            this.report((Diagnostic)object, ctxt);
        } else if (variableUseState == VariableUseState.WRITTEN_AFTER_READ && element instanceof KtVariableDeclaration) {
            object = element;
            if (object instanceof KtProperty) {
                KtExpression ktExpression = ((KtProperty)element).getInitializer();
                if (ktExpression != null) {
                    KtExpression ktExpression2 = ktExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtExpression it = ktExpression2;
                    boolean bl3 = false;
                    ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on((KtExpression)((PsiElement)it), variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"VARIABLE_WITH_REDUNDANT_\u2026n(it, variableDescriptor)");
                    this.report(parametrizedDiagnostic, ctxt);
                }
            } else if (object instanceof KtDestructuringDeclarationEntry) {
                ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on((KtExpression)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"VARIABLE_WITH_REDUNDANT_\u2026ment, variableDescriptor)");
                this.report(parametrizedDiagnostic, ctxt);
            }
        }
    }

    private final void processUnusedParameter(VariableUseContext ctxt, KtParameter element, VariableDescriptor variableDescriptor) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)variableDescriptor.getContainingDeclaration();
        if (functionDescriptor.isExpect() || functionDescriptor.isActual() || DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor) || !this.diagnosticSuppressor.shouldReportUnusedParameter(variableDescriptor)) {
            return;
        }
        PsiElement owner = element.getParent().getParent();
        if (owner instanceof KtPrimaryConstructor) {
            if (!element.hasValOrVar()) {
                Object object = ((ConstructorDescriptor)functionDescriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functionDescriptor as Co\u2026or).containingDeclaration");
                ClassifierDescriptorWithTypeParameters containingClass = object;
                if (!DescriptorUtils.isAnnotationClass(containingClass)) {
                    object = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UNUSED_PARAMETER.on(element, variableDescriptor)");
                    this.report((Diagnostic)object, ctxt);
                }
            }
        } else if (owner instanceof KtFunction) {
            boolean anonymous;
            boolean bl = anonymous = owner instanceof KtFunctionLiteral || owner instanceof KtNamedFunction && ((KtNamedFunction)owner).getName() == null;
            if (anonymous && !this.languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) {
                return;
            }
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(bindingContext, this.languageVersionSettings);
            boolean isMain = owner instanceof KtNamedFunction && MainFunctionDetector.isMain$default(mainFunctionDetector, (KtNamedFunction)owner, false, false, 6, null);
            ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = functionDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)parametrizedDiagnostic, (String)"functionDescriptor.name");
            Name functionName = parametrizedDiagnostic;
            if (isMain) {
                if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    return;
                }
                if (!this.languageVersionSettings.supportsFeature(LanguageFeature.WarningOnMainUnusedParameter)) {
                    if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)owner) == null) {
                        this.trace.record(BindingContext.UNUSED_MAIN_PARAMETER, element);
                    }
                    return;
                }
                if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)owner) != null) {
                    return;
                }
            }
            if (functionDescriptor.isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(functionName)) {
                this.trace.record(BindingContext.UNUSED_DELEGATED_PROPERTY_OPERATOR_PARAMETER, variableDescriptor, true);
                return;
            }
            if (ModalityUtilsKt.isOverridableOrOverrides(functionDescriptor) || ((KtFunction)owner).hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                return;
            }
            if (anonymous) {
                parametrizedDiagnostic = Errors.UNUSED_ANONYMOUS_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"UNUSED_ANONYMOUS_PARAMET\u2026ment, variableDescriptor)");
                this.report(parametrizedDiagnostic, ctxt);
            } else {
                parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"UNUSED_PARAMETER.on(element, variableDescriptor)");
                this.report(parametrizedDiagnostic, ctxt);
            }
        } else if (owner instanceof KtPropertyAccessor) {
            ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"UNUSED_PARAMETER.on(element, variableDescriptor)");
            this.report(parametrizedDiagnostic, ctxt);
        }
    }

    private final void markUnusedExpressions() {
        boolean bl = false;
        HashMap reportedDiagnosticMap = new HashMap();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(this, reportedDiagnosticMap){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap<Instruction, DiagnosticFactory<?>> $reportedDiagnosticMap;
            {
                this.this$0 = $receiver;
                this.$reportedDiagnosticMap = $reportedDiagnosticMap;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (!(instruction instanceof KtElementInstruction)) {
                    return;
                }
                KtElement ktElement = ((KtElementInstruction)instruction).getElement();
                Object object2 = object = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
                if (object == null) {
                    return;
                }
                KtExpression element = object;
                object = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
                if (BindingContextUtilsKt.isUsedAsStatement(element, (BindingContext)object) && PseudocodeUtilsKt.getSideEffectFree(instruction)) {
                    SimpleDiagnostic<KtElement> simpleDiagnostic;
                    VariableContext context2 = this.this$0.new VariableContext(instruction, (Map)this.$reportedDiagnosticMap);
                    ktElement = element;
                    if (ktElement instanceof KtLambdaExpression) {
                        SimpleDiagnostic<KtLambdaExpression> simpleDiagnostic2 = Errors.UNUSED_LAMBDA_EXPRESSION.on((KtLambdaExpression)element);
                        Intrinsics.checkNotNullExpressionValue(simpleDiagnostic2, (String)"UNUSED_LAMBDA_EXPRESSION.on(element)");
                        simpleDiagnostic = simpleDiagnostic2;
                    } else {
                        SimpleDiagnostic<KtElement> simpleDiagnostic3 = Errors.UNUSED_EXPRESSION.on((KtElement)((PsiElement)element));
                        Intrinsics.checkNotNullExpressionValue(simpleDiagnostic3, (String)"UNUSED_EXPRESSION.on(element)");
                        simpleDiagnostic = simpleDiagnostic3;
                    }
                    ControlFlowInformationProviderImpl.access$report(this.this$0, simpleDiagnostic, context2);
                }
            }
        }));
    }

    private final void markStatements() {
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(this){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
                PseudoValue value2 = instructionWithValue == null ? null : instructionWithValue.getOutputValue();
                Pseudocode pseudocode = instruction.getOwner();
                List<Instruction> usages = pseudocode.getUsages(value2);
                Collection collection = usages;
                boolean bl = false;
                boolean isUsedAsExpression = !collection.isEmpty();
                boolean isUsedAsResultOfLambda = org.jetbrains.kotlin.cfg.ControlFlowInformationProviderImpl$Companion.access$isUsedAsResultOfLambda(ControlFlowInformationProviderImpl.Companion, usages);
                for (KtElement element : pseudocode.getValueElements(value2)) {
                    ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).record(BindingContext.USED_AS_EXPRESSION, element, isUsedAsExpression);
                    ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).record(BindingContext.USED_AS_RESULT_OF_LAMBDA, element, isUsedAsResultOfLambda);
                }
            }
        }));
    }

    private final void checkForSuspendLambdaAndMarkParameters(Pseudocode pseudocode) {
        for (Instruction instruction : pseudocode.getInstructionsIncludingDeadCode()) {
            DeclarationDescriptor descriptor2;
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            KtElement psi = ((LocalFunctionDeclarationInstruction)instruction).getBody().getCorrespondingElement();
            if (psi instanceof KtFunctionLiteral && (descriptor2 = this.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, psi)) instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)descriptor2).isSuspend()) {
                this.markReadOfSuspendLambdaParameters(((LocalFunctionDeclarationInstruction)instruction).getBody());
                continue;
            }
            this.checkForSuspendLambdaAndMarkParameters(((LocalFunctionDeclarationInstruction)instruction).getBody());
        }
    }

    private final void markReadOfSuspendLambdaParameters(Pseudocode pseudocode) {
        List<Instruction> instructions = pseudocode.getInstructionsIncludingDeadCode();
        for (Instruction instruction : instructions) {
            if (instruction instanceof LocalFunctionDeclarationInstruction) {
                this.markReadOfSuspendLambdaParameters(((LocalFunctionDeclarationInstruction)instruction).getBody());
                continue;
            }
            this.markReadOfSuspendLambdaParameter(instruction);
            this.markImplicitReceiverOfSuspendLambda(instruction);
        }
    }

    private final void markReadOfSuspendLambdaParameter(Instruction instruction) {
        DeclarationDescriptor containing;
        AccessTarget.Call call2;
        if (!(instruction instanceof ReadValueInstruction)) {
            return;
        }
        AccessTarget accessTarget = ((ReadValueInstruction)instruction).getTarget();
        AccessTarget.Call call3 = call2 = accessTarget instanceof AccessTarget.Call ? (AccessTarget.Call)accessTarget : null;
        if (call2 == null) {
            return;
        }
        AccessTarget.Call target = call2;
        Object descriptor2 = target.getResolvedCall().getResultingDescriptor();
        if (descriptor2 instanceof ParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            containing = declarationDescriptor;
            if (containing instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)containing).isSuspend()) {
                this.trace.record(BindingContext.SUSPEND_LAMBDA_PARAMETER_USED, TuplesKt.to((Object)containing, (Object)KtDescriptorUtilKt.indexOrMinusOne((ParameterDescriptor)descriptor2)));
            }
        } else if (descriptor2 instanceof LocalVariableDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((LocalVariableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            containing = declarationDescriptor;
            if (containing instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)containing).isSuspend() && (declarationDescriptor = CapturingInClosureCheckerKt.findDestructuredVariable((VariableDescriptor)descriptor2, containing)) != null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                boolean bl = false;
                boolean bl2 = false;
                DeclarationDescriptor it = declarationDescriptor2;
                boolean bl3 = false;
                this.trace.record(BindingContext.SUSPEND_LAMBDA_PARAMETER_USED, TuplesKt.to((Object)containing, (Object)it.getIndex()));
            }
        }
    }

    private final void markImplicitReceiverOfSuspendLambda(Instruction instruction) {
        if (!(instruction instanceof MagicInstruction) || ((MagicInstruction)instruction).getKind() != MagicKind.IMPLICIT_RECEIVER && ((MagicInstruction)instruction).getKind() != MagicKind.UNBOUND_CALLABLE_REFERENCE) {
            return;
        }
        KtElement element = ((MagicInstruction)instruction).getElement();
        if (element instanceof KtDestructuringDeclarationEntry ? true : element instanceof KtCallExpression) {
            boolean bl = false;
            Set visited2 = new LinkedHashSet();
            Instruction instruction2 = ((MagicInstruction)instruction).getNext();
            if (instruction2 != null) {
                Instruction instruction3 = instruction2;
                boolean bl2 = false;
                boolean bl3 = false;
                Instruction it = instruction3;
                boolean bl4 = false;
                ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$dfs(visited2, element, this, it);
            }
        } else if ((element instanceof KtNameReferenceExpression ? true : element instanceof KtBinaryExpression) ? true : element instanceof KtUnaryExpression) {
            boolean bl;
            boolean bl5;
            Object object;
            Object object2;
            Object object3 = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(element, (BindingContext)object3);
            if (call2 instanceof VariableAsFunctionResolvedCall) {
                object2 = ((VariableAsFunctionResolvedCall)((Object)call2)).getVariableCall().getDispatchReceiver();
                Object object4 = object3 = object2 instanceof ExtensionReceiver ? (ExtensionReceiver)object2 : null;
                if (object3 != null && (object2 = ((ExtensionReceiver)object3).getDeclarationDescriptor()) != null) {
                    object = object2;
                    bl5 = false;
                    bl = false;
                    Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d10 = object;
                    boolean bl6 = false;
                    ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d10, this);
                }
                Object object5 = object3 = (object2 = ((VariableAsFunctionResolvedCall)((Object)call2)).getVariableCall().getExtensionReceiver()) instanceof ExtensionReceiver ? (ExtensionReceiver)object2 : null;
                if (object3 != null && (object2 = ((ExtensionReceiver)object3).getDeclarationDescriptor()) != null) {
                    object = object2;
                    bl5 = false;
                    bl = false;
                    Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d11 = object;
                    boolean bl7 = false;
                    ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d11, this);
                }
            }
            object2 = (object = call2) == null ? null : object.getDispatchReceiver();
            Object object6 = object3 = object2 instanceof ExtensionReceiver ? (ExtensionReceiver)object2 : null;
            if (object3 != null && (object2 = ((ExtensionReceiver)object3).getDeclarationDescriptor()) != null) {
                object = object2;
                bl5 = false;
                bl = false;
                Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d12 = object;
                boolean bl8 = false;
                ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d12, this);
            }
            object2 = (object = call2) == null ? null : object.getExtensionReceiver();
            Object object7 = object3 = object2 instanceof ExtensionReceiver ? (ExtensionReceiver)object2 : null;
            if (object3 != null && (object2 = ((ExtensionReceiver)object3).getDeclarationDescriptor()) != null) {
                object = object2;
                bl5 = false;
                bl = false;
                Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d13 = object;
                boolean bl9 = false;
                ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d13, this);
            }
        } else if (element instanceof KtCallableReferenceExpression) {
            KtElement ktElement = ((KtCallableReferenceExpression)element).getCallableReference();
            Object object = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, (BindingContext)object);
            Object object8 = resolvedCall2;
            Object object9 = object8 == null ? null : object8.getDispatchReceiver();
            Object object10 = object = object9 instanceof ExtensionReceiver ? (ExtensionReceiver)object9 : null;
            if (object != null && (object9 = ((ExtensionReceiver)object).getDeclarationDescriptor()) != null) {
                object8 = object9;
                boolean bl = false;
                boolean bl10 = false;
                Object $this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d14 = object8;
                boolean bl11 = false;
                ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded((CallableDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24lambda_u2d14, this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markAnnotationArguments() {
        if (this.subroutine instanceof KtAnnotationEntry) {
            this.markAnnotationArguments((KtAnnotationEntry)this.subroutine);
        } else {
            PsiElement[] psiElementArray = this.subroutine.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"subroutine.children");
            Object[] $this$forEach$iv = psiElementArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEachDescendantOfType$iv;
                PsiElement child = (PsiElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                PsiElement psiElement = child;
                Function1 action$iv = (Function1)new Function1<KtAnnotationEntry, Unit>(this){
                    final /* synthetic */ ControlFlowInformationProviderImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull KtAnnotationEntry it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ControlFlowInformationProviderImpl.access$markAnnotationArguments(this.this$0, it);
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                $this$forEachDescendantOfType$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiElement it = element;
                        boolean bl = false;
                        if (!(it instanceof KtDeclaration) || it instanceof KtParameter) {
                            super.visitElement(element);
                        }
                        if (element instanceof KtAnnotationEntry) {
                            this.$action.invoke((Object)element);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markAnnotationArguments(KtAnnotationEntry entry) {
        for (ValueArgument valueArgument : entry.getValueArguments()) {
            void $this$forEachDescendantOfType$iv;
            KtExpression ktExpression = valueArgument.getArgumentExpression();
            if (ktExpression == null) continue;
            PsiElement psiElement = ktExpression;
            Function1 action$iv = (Function1)new Function1<KtExpression, Unit>(this){
                final /* synthetic */ ControlFlowInformationProviderImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull KtExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).record(BindingContext.USED_AS_EXPRESSION, it, true);
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
        }
    }

    private final void checkIfExpressions() {
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(this){
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
                PseudoValue value2 = instructionWithValue == null ? null : instructionWithValue.getOutputValue();
                for (KtElement element : instruction.getOwner().getValueElements(value2)) {
                    if (!(element instanceof KtIfExpression)) continue;
                    KtExpression ktExpression = (KtExpression)element;
                    BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    if (!BindingContextUtilsKt.isUsedAsExpression(ktExpression, bindingContext)) continue;
                    KtExpression thenExpression = ((KtIfExpression)element).getThen();
                    KtExpression elseExpression = ((KtIfExpression)element).getElse();
                    if (thenExpression == null || elseExpression == null) {
                        ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.INVALID_IF_AS_EXPRESSION.on(((KtIfExpression)element).getIfKeyword()));
                        continue;
                    }
                    ControlFlowInformationProviderImpl.access$checkImplicitCastOnConditionalExpression(this.this$0, (KtExpression)element);
                }
            }
        }));
    }

    private final void checkImplicitCastOnConditionalExpression(KtExpression expression2) {
        List branchExpressions = ControlFlowInformationProviderImpl.Companion.collectResultingExpressionsOfConditionalExpression(expression2);
        KotlinType expectedExpressionType = (KotlinType)this.trace.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2);
        if (expectedExpressionType != null && expectedExpressionType != TypeUtils.DONT_CARE) {
            return;
        }
        Object object = this.trace.getType(expression2);
        if (object == null) {
            return;
        }
        Object object2 = object;
        KotlinType expressionType = object2;
        if (KotlinBuiltIns.isAnyOrNullableAny(expressionType)) {
            KotlinType branchType;
            KotlinType kotlinType;
            KotlinType kotlinType2;
            object = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
            boolean isUsedAsResultOfLambda = BindingContextUtilsKt.isUsedAsResultOfLambda(expression2, (BindingContext)object);
            for (KtExpression branchExpression : branchExpressions) {
                kotlinType2 = this.trace.getType(branchExpression);
                if (kotlinType2 == null) {
                    return;
                }
                kotlinType = kotlinType2;
                branchType = kotlinType;
                if (!KotlinBuiltIns.isAnyOrNullableAny(branchType) && (!isUsedAsResultOfLambda || !KotlinBuiltIns.isUnitOrNullableUnit(branchType))) continue;
                return;
            }
            for (KtExpression branchExpression : branchExpressions) {
                kotlinType2 = this.trace.getType(branchExpression);
                if (kotlinType2 == null || KotlinBuiltIns.isNothing(branchType = (kotlinType = kotlinType2))) continue;
                this.trace.report(Errors.IMPLICIT_CAST_TO_ANY.on((KtExpression)((PsiElement)ControlFlowInformationProviderImpl.Companion.getResultingExpression(branchExpression)), branchType, expressionType));
            }
        }
    }

    private final void checkWhenExpressions() {
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(initializers, this){
            final /* synthetic */ Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> $initializers;
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            {
                this.$initializers = $initializers;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Instruction instruction) {
                Instruction next;
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getKind() == MagicKind.EXHAUSTIVE_WHEN_ELSE && (next = ((MagicInstruction)instruction).getNext()) instanceof MergeInstruction) {
                    VariableInitReadOnlyControlFlowInfo magicInfo;
                    Edges<VariableInitReadOnlyControlFlowInfo> edges = this.$initializers.get(next);
                    VariableInitReadOnlyControlFlowInfo mergeInfo = edges == null ? null : edges.getIncoming();
                    Edges<VariableInitReadOnlyControlFlowInfo> edges2 = this.$initializers.get(instruction);
                    VariableInitReadOnlyControlFlowInfo variableInitReadOnlyControlFlowInfo = magicInfo = edges2 == null ? null : edges2.getOutgoing();
                    if (mergeInfo != null && magicInfo != null && ((MergeInstruction)next).getElement() instanceof KtWhenExpression && magicInfo.checkDefiniteInitializationInWhen(mergeInfo)) {
                        ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).record(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, ((MergeInstruction)next).getElement());
                    }
                }
                InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
                PseudoValue value2 = instructionWithValue == null ? null : instructionWithValue.getOutputValue();
                for (KtElement element : instruction.getOwner().getValueElements(value2)) {
                    ClassDescriptor sealedClassDescriptor;
                    Object pseudocodeDescriptor;
                    KtWhenEntry ktWhenEntry;
                    Object it;
                    Object object;
                    Iterator<KtWhenEntry> iterator2;
                    List<WhenMissingCase> missingCases;
                    BindingContext context2;
                    boolean usedAsExpression;
                    block12: {
                        if (!(element instanceof KtWhenExpression)) continue;
                        KtExpression ktExpression = (KtExpression)element;
                        BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                        usedAsExpression = BindingContextUtilsKt.isUsedAsExpression(ktExpression, bindingContext);
                        if (usedAsExpression) {
                            ControlFlowInformationProviderImpl.access$checkImplicitCastOnConditionalExpression(this.this$0, (KtExpression)element);
                        }
                        BindingContext bindingContext2 = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
                        context2 = bindingContext2;
                        missingCases = WhenChecker.INSTANCE.getMissingCases((KtWhenExpression)element, context2);
                        Iterable<KtWhenEntry> iterable = ((KtWhenExpression)element).getEntries();
                        Intrinsics.checkNotNullExpressionValue(iterable, (String)"element.entries");
                        iterable = iterable;
                        boolean bl = false;
                        Iterable<KtWhenEntry> iterable2 = iterable;
                        boolean bl2 = false;
                        iterator2 = iterable2.iterator();
                        while (iterator2.hasNext()) {
                            it = object = iterator2.next();
                            boolean bl3 = false;
                            if (!((KtWhenEntry)it).isElse()) continue;
                            ktWhenEntry = object;
                            break block12;
                        }
                        ktWhenEntry = null;
                    }
                    KtWhenEntry elseEntry = ktWhenEntry;
                    KtExpression subjectExpression = ((KtWhenExpression)element).getSubjectExpression();
                    if (usedAsExpression) {
                        Object object2 = missingCases;
                        boolean bl = false;
                        if (!object2.isEmpty()) {
                            KtWhenEntry ktWhenEntry2;
                            Object $this$firstOrNull$iv;
                            block13: {
                                if (elseEntry != null) continue;
                                ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.NO_ELSE_IN_WHEN.on((KtWhenExpression)element, missingCases));
                                $this$firstOrNull$iv = missingCases;
                                boolean $i$f$firstOrNull = false;
                                iterator2 = $this$firstOrNull$iv.iterator();
                                while (iterator2.hasNext()) {
                                    KtWhenEntry element$iv = iterator2.next();
                                    it = (WhenMissingCase)((Object)element$iv);
                                    boolean bl4 = false;
                                    if (!(it instanceof WhenMissingCase.ConditionTypeIsExpect)) continue;
                                    ktWhenEntry2 = element$iv;
                                    break block13;
                                }
                                ktWhenEntry2 = null;
                            }
                            object2 = (WhenMissingCase)((Object)ktWhenEntry2);
                            if (object2 == null) continue;
                            $this$firstOrNull$iv = object2;
                            ControlFlowInformationProviderImpl $i$f$firstOrNull = this.this$0;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            it = $this$firstOrNull$iv;
                            boolean bl7 = false;
                            boolean bl8 = it instanceof WhenMissingCase.ConditionTypeIsExpect;
                            boolean bl9 = false;
                            boolean bl10 = false;
                            bl10 = false;
                            boolean bl11 = false;
                            if (!bl8) {
                                boolean bl12 = false;
                                String string2 = "Failed requirement.";
                                throw (Throwable)new IllegalArgumentException(string2.toString());
                            }
                            ControlFlowInformationProviderImpl.access$getTrace$p($i$f$firstOrNull).report(Errors.EXPECT_TYPE_IN_WHEN_WITHOUT_ELSE.on((KtWhenExpression)element, ((WhenMissingCase.ConditionTypeIsExpect)it).getTypeOfDeclaration()));
                            continue;
                        }
                    }
                    if (subjectExpression == null) continue;
                    KotlinType subjectType = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getType(subjectExpression);
                    if (elseEntry != null) {
                        if (!missingCases.isEmpty() || subjectType == null || FlexibleTypesKt.isFlexible(subjectType)) continue;
                        ClassifierDescriptor $i$f$firstOrNull = subjectType.getConstructor().getDeclarationDescriptor();
                        ClassDescriptor subjectClass = $i$f$firstOrNull instanceof ClassDescriptor ? (ClassDescriptor)$i$f$firstOrNull : null;
                        KtElement pseudocodeElement = instruction.getOwner().getCorrespondingElement();
                        pseudocodeDescriptor = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, pseudocodeElement);
                        if (subjectClass != null && !KotlinBuiltIns.isBooleanOrNullableBoolean(subjectType) && !Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(subjectClass), (Object)((object = pseudocodeDescriptor) == null ? null : DescriptorUtilsKt.getModule((DeclarationDescriptor)object)))) continue;
                        ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.REDUNDANT_ELSE_IN_WHEN.on((KtWhenEntry)((PsiElement)elseEntry)));
                        continue;
                    }
                    if (usedAsExpression) continue;
                    ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType);
                    if (enumClassDescriptor != null) {
                        List<WhenMissingCase> enumMissingCases = WhenChecker.getEnumMissingCases((KtWhenExpression)element, context2, enumClassDescriptor);
                        pseudocodeDescriptor = enumMissingCases;
                        boolean bl = false;
                        if (!pseudocodeDescriptor.isEmpty()) {
                            ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.NON_EXHAUSTIVE_WHEN.on((KtWhenExpression)element, enumMissingCases));
                        }
                    }
                    if ((sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed(subjectType)) == null) continue;
                    List<WhenMissingCase> sealedMissingCases = WhenChecker.getSealedMissingCases((KtWhenExpression)element, context2, sealedClassDescriptor);
                    object = sealedMissingCases;
                    boolean bl = false;
                    if (!(!object.isEmpty())) continue;
                    ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.NON_EXHAUSTIVE_WHEN_ON_SEALED_CLASS.on((KtWhenExpression)element, sealedMissingCases));
                }
            }
        }));
    }

    private final void checkConstructorConsistency() {
        KtElement ktElement = this.subroutine;
        if (ktElement instanceof KtClassOrObject) {
            ConstructorConsistencyChecker.Companion.check((KtClassOrObject)this.subroutine, this.trace, this.pseudocode, this.getPseudocodeVariablesData());
        } else if (ktElement instanceof KtSecondaryConstructor) {
            ConstructorConsistencyChecker.Companion.check((KtSecondaryConstructor)this.subroutine, this.trace, this.pseudocode, this.getPseudocodeVariablesData());
        }
    }

    private final void markAndCheckTailCalls() {
        FunctionDescriptor functionDescriptor;
        DeclarationDescriptor declarationDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.subroutine);
        FunctionDescriptor functionDescriptor2 = functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor subroutineDescriptor = functionDescriptor;
        this.markAndCheckRecursiveTailCalls(subroutineDescriptor);
    }

    private final void markAndCheckRecursiveTailCalls(FunctionDescriptor subroutineDescriptor) {
        if (!subroutineDescriptor.isTailrec()) {
            return;
        }
        if (this.subroutine instanceof KtNamedFunction && !((KtNamedFunction)this.subroutine).hasBody()) {
            return;
        }
        HashMap calls = new HashMap();
        ControlFlowInformationProviderImpl this_$iv = this;
        boolean $i$f$traverseCalls = false;
        PseudocodeTraverserKt.traverse(this_$iv.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)((Function1)new Function1<Instruction, Unit>(subroutineDescriptor, this, calls){
            final /* synthetic */ FunctionDescriptor $subroutineDescriptor$inlined;
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap $calls$inlined;
            {
                this.$subroutineDescriptor$inlined = functionDescriptor;
                this.this$0 = controlFlowInformationProviderImpl;
                this.$calls$inlined = hashMap;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Instruction instruction) {
                void resolvedCall2;
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (!(instruction instanceof CallInstruction)) {
                    return;
                }
                ResolvedCall<?> resolvedCall3 = ((CallInstruction)instruction).getResolvedCall();
                CallInstruction instruction2 = (CallInstruction)instruction;
                boolean bl = false;
                D functionDescriptor = resolvedCall2.getResultingDescriptor();
                if (Intrinsics.areEqual((Object)functionDescriptor.getOriginal(), (Object)this.$subroutineDescriptor$inlined) && (resolvedCall2.getCall().getValueArguments().size() == functionDescriptor.getValueParameters().size() || functionDescriptor.getOverriddenDescriptors().isEmpty())) {
                    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"org/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$markAndCheckRecursiveTailCalls$KindAndCall", "", "kind", "Lorg/jetbrains/kotlin/cfg/TailRecursionKind;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "(Lorg/jetbrains/kotlin/cfg/TailRecursionKind;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)V", "getCall", "()Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getKind", "()Lorg/jetbrains/kotlin/cfg/TailRecursionKind;", "setKind", "(Lorg/jetbrains/kotlin/cfg/TailRecursionKind;)V", "cfg"})
                    public final class KindAndCall {
                        @NotNull
                        private TailRecursionKind kind;
                        @NotNull
                        private final ResolvedCall<?> call;

                        public KindAndCall(@NotNull TailRecursionKind kind, @NotNull ResolvedCall<?> call2) {
                            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                            Intrinsics.checkNotNullParameter(call2, (String)"call");
                            this.kind = kind;
                            this.call = call2;
                        }

                        @NotNull
                        public final TailRecursionKind getKind() {
                            return this.kind;
                        }

                        public final void setKind(@NotNull TailRecursionKind tailRecursionKind) {
                            Intrinsics.checkNotNullParameter((Object)((Object)tailRecursionKind), (String)"<set-?>");
                            this.kind = tailRecursionKind;
                        }

                        @NotNull
                        public final ResolvedCall<?> getCall() {
                            return this.call;
                        }
                    }
                    KtElement element = instruction2.getElement();
                    if (ControlFlowInformationProviderImpl.access$isInsideTry(this.this$0, element)) {
                        Map map = this.$calls$inlined;
                        KindAndCall kindAndCall = new KindAndCall(TailRecursionKind.IN_TRY, (ResolvedCall<?>)resolvedCall2);
                        boolean bl2 = false;
                        map.put(element, kindAndCall);
                    } else {
                        BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                        boolean sameDispatchReceiver = ResolvedCallUtilKt.hasThisOrNoDispatchReceiver(resolvedCall2, bindingContext);
                        TailRecursionKind kind = sameDispatchReceiver && ControlFlowInformationProviderImpl.isTailCall$default(this.this$0, instruction2, null, 1, null) ? TailRecursionKind.TAIL_CALL : TailRecursionKind.NON_TAIL;
                        KindAndCall kindAndCall = (KindAndCall)this.$calls$inlined.get(element);
                        Map map = this.$calls$inlined;
                        KindAndCall kindAndCall2 = kindAndCall;
                        kindAndCall2 = new KindAndCall(org.jetbrains.kotlin.cfg.ControlFlowInformationProviderImpl$Companion.access$combineKinds(ControlFlowInformationProviderImpl.Companion, kind, kindAndCall2 == null ? null : kindAndCall2.getKind()), (ResolvedCall<?>)resolvedCall2);
                        boolean bl3 = false;
                        map.put(element, kindAndCall2);
                    }
                }
            }
        }));
        boolean hasTailCalls = false;
        Object object = calls;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2 = object = iterator2.next();
            boolean bl2 = false;
            KtElement element = (KtElement)object2.getKey();
            Object object3 = object;
            int n = 0;
            KindAndCall kindAndCall = (KindAndCall)object3.getValue();
            object3 = kindAndCall.getKind();
            n = WhenMappings.$EnumSwitchMapping$1[((Enum)object3).ordinal()];
            switch (n) {
                case 1: {
                    this.trace.record(BindingContext.TAIL_RECURSION_CALL, kindAndCall.getCall().getCall(), TailRecursionKind.TAIL_CALL);
                    hasTailCalls = true;
                    break;
                }
                case 2: {
                    this.trace.report(Errors.TAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED.on(element));
                    break;
                }
                case 3: {
                    this.trace.report(Errors.NON_TAIL_RECURSIVE_CALL.on(element));
                }
            }
        }
        if (!hasTailCalls && this.subroutine instanceof KtNamedFunction) {
            this.trace.report(Errors.NO_TAIL_CALLS_FOUND.on((KtNamedFunction)this.subroutine));
        }
    }

    private final boolean isInsideTry(KtElement element) {
        Class[] classArray = new Class[]{KtTryExpression.class, KtFunction.class, KtAnonymousInitializer.class};
        return PsiTreeUtil.getParentOfType((PsiElement)element, classArray) instanceof KtTryExpression;
    }

    private final boolean isTailCall(CallInstruction $this$isTailCall, KtElement subroutine) {
        TailInstructionDetector tailInstructionDetector = new TailInstructionDetector(subroutine);
        boolean bl = false;
        return PseudocodeTraverserKt.traverseFollowingInstructions($this$isTailCall, new HashSet(), TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)((Function1)new Function1<Instruction, TraverseInstructionResult>($this$isTailCall, tailInstructionDetector){
            final /* synthetic */ CallInstruction $this_isTailCall;
            final /* synthetic */ TailInstructionDetector $tailInstructionDetector;
            {
                this.$this_isTailCall = $receiver;
                this.$tailInstructionDetector = $tailInstructionDetector;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final TraverseInstructionResult invoke(@NotNull Instruction it) {
                TraverseInstructionResult traverseInstructionResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)it, (Object)this.$this_isTailCall)) {
                    R r = it.accept(this.$tailInstructionDetector);
                    Intrinsics.checkNotNullExpressionValue(r, (String)"it.accept(tailInstructionDetector)");
                    if (!((Boolean)r).booleanValue()) {
                        traverseInstructionResult = TraverseInstructionResult.HALT;
                        return traverseInstructionResult;
                    }
                }
                traverseInstructionResult = TraverseInstructionResult.CONTINUE;
                return traverseInstructionResult;
            }
        }));
    }

    static /* synthetic */ boolean isTailCall$default(ControlFlowInformationProviderImpl controlFlowInformationProviderImpl, CallInstruction callInstruction, KtElement ktElement, int n, Object object) {
        if ((n & 1) != 0) {
            ktElement = controlFlowInformationProviderImpl.subroutine;
        }
        return controlFlowInformationProviderImpl.isTailCall(callInstruction, ktElement);
    }

    private final void report(Diagnostic diagnostic, VariableContext ctxt) {
        Map<Instruction, DiagnosticFactory<?>> previouslyReported;
        Instruction instruction = ctxt.getInstruction$cfg();
        if (instruction.getCopies().isEmpty()) {
            this.trace.report(diagnostic);
            return;
        }
        Map<Instruction, DiagnosticFactory<?>> map = previouslyReported = ctxt.getReportedDiagnosticMap$cfg();
        DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
        boolean bl = false;
        map.put(instruction, diagnosticFactory);
        boolean alreadyReported = false;
        boolean sameErrorForAllCopies = true;
        for (Instruction copy2 : instruction.getCopies()) {
            DiagnosticFactory<?> previouslyReportedErrorFactory = previouslyReported.get(copy2);
            if (previouslyReportedErrorFactory != null) {
                alreadyReported = true;
            }
            if (previouslyReportedErrorFactory == diagnostic.getFactory()) continue;
            sameErrorForAllCopies = false;
        }
        if (ControlFlowInformationProviderImpl.Companion.mustBeReportedOnAllCopies(diagnostic.getFactory())) {
            if (sameErrorForAllCopies) {
                this.trace.report(diagnostic);
            }
        } else if (!alreadyReported) {
            this.trace.report(diagnostic);
        }
    }

    private static final void markImplicitReceiverOfSuspendLambda$markIfNeeded(CallableDescriptor $this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded, ControlFlowInformationProviderImpl this$0) {
        if ($this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)$this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded).isSuspend()) {
            this$0.trace.record(BindingContext.SUSPEND_LAMBDA_PARAMETER_USED, TuplesKt.to((Object)$this$markImplicitReceiverOfSuspendLambda_u24markIfNeeded, (Object)-1));
        }
    }

    private static final void markImplicitReceiverOfSuspendLambda$dfs(Set<Instruction> visited2, KtElement element, ControlFlowInformationProviderImpl this$0, Instruction insn) {
        if (!visited2.add(insn)) {
            return;
        }
        if (insn instanceof CallInstruction && Intrinsics.areEqual((Object)((CallInstruction)insn).getElement(), (Object)element)) {
            Object object = ((CallInstruction)insn).getReceiverValues();
            boolean bl = false;
            Iterator<Object> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                CallableDescriptor callableDescriptor;
                Object object2 = object = (Map.Entry)iterator2.next();
                boolean bl2 = false;
                ReceiverValue receiver = (ReceiverValue)object2.getValue();
                if ((object2 = receiver instanceof ExtensionReceiver ? (ExtensionReceiver)receiver : null) == null || (callableDescriptor = ((ExtensionReceiver)object2).getDeclarationDescriptor()) == null) continue;
                CallableDescriptor callableDescriptor2 = callableDescriptor;
                boolean bl3 = false;
                boolean bl4 = false;
                CallableDescriptor $this$markImplicitReceiverOfSuspendLambda_u24dfs_u24lambda_u2d8 = callableDescriptor2;
                boolean bl5 = false;
                ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$markIfNeeded($this$markImplicitReceiverOfSuspendLambda_u24dfs_u24lambda_u2d8, this$0);
            }
        }
        for (Instruction next : insn.getNextInstructions()) {
            ControlFlowInformationProviderImpl.markImplicitReceiverOfSuspendLambda$dfs(visited2, element, this$0, next);
        }
    }

    public static final /* synthetic */ void access$checkIsInitialized(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtElement element, Collection varWithUninitializedErrorGenerated) {
        $this.checkIsInitialized(ctxt, element, varWithUninitializedErrorGenerated);
    }

    public static final /* synthetic */ boolean access$checkValReassignment(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtExpression expression2, WriteValueInstruction writeValueInstruction, Collection varWithValReassignErrorGenerated) {
        return $this.checkValReassignment(ctxt, expression2, writeValueInstruction, varWithValReassignErrorGenerated);
    }

    public static final /* synthetic */ boolean access$checkAssignmentBeforeDeclaration(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtExpression expression2) {
        return $this.checkAssignmentBeforeDeclaration(ctxt, expression2);
    }

    public static final /* synthetic */ boolean access$checkInitializationForCustomSetter(ControlFlowInformationProviderImpl $this, VariableInitContext ctxt, KtExpression expression2) {
        return $this.checkInitializationForCustomSetter(ctxt, expression2);
    }

    public static final /* synthetic */ PseudocodeVariablesData access$getPseudocodeVariablesData(ControlFlowInformationProviderImpl $this) {
        return $this.getPseudocodeVariablesData();
    }

    public static final /* synthetic */ void access$processUnusedDeclaration(ControlFlowInformationProviderImpl $this, KtNamedDeclaration element, VariableDescriptor variableDescriptor, VariableUseContext ctxt, VariableUseState variableUseState) {
        $this.processUnusedDeclaration(element, variableDescriptor, ctxt, variableUseState);
    }

    public static final /* synthetic */ void access$report(ControlFlowInformationProviderImpl $this, Diagnostic diagnostic, VariableContext ctxt) {
        $this.report(diagnostic, ctxt);
    }

    public static final /* synthetic */ void access$checkImplicitCastOnConditionalExpression(ControlFlowInformationProviderImpl $this, KtExpression expression2) {
        $this.checkImplicitCastOnConditionalExpression(expression2);
    }

    public static final /* synthetic */ void access$markAnnotationArguments(ControlFlowInformationProviderImpl $this, KtAnnotationEntry entry) {
        $this.markAnnotationArguments(entry);
    }

    public static final /* synthetic */ boolean access$isInsideTry(ControlFlowInformationProviderImpl $this, KtElement element) {
        return $this.isInsideTry(element);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$ReturnedExpressionsInfo;", "", "returnedExpressions", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "hasReturnsInInlinedLambda", "", "(Ljava/util/Collection;Z)V", "getHasReturnsInInlinedLambda", "()Z", "getReturnedExpressions", "()Ljava/util/Collection;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "cfg"})
    private static final class ReturnedExpressionsInfo {
        @NotNull
        private final Collection<KtElement> returnedExpressions;
        private final boolean hasReturnsInInlinedLambda;

        public ReturnedExpressionsInfo(@NotNull Collection<? extends KtElement> returnedExpressions, boolean hasReturnsInInlinedLambda) {
            Intrinsics.checkNotNullParameter(returnedExpressions, (String)"returnedExpressions");
            this.returnedExpressions = returnedExpressions;
            this.hasReturnsInInlinedLambda = hasReturnsInInlinedLambda;
        }

        @NotNull
        public final Collection<KtElement> getReturnedExpressions() {
            return this.returnedExpressions;
        }

        public final boolean getHasReturnsInInlinedLambda() {
            return this.hasReturnsInInlinedLambda;
        }

        @NotNull
        public final Collection<KtElement> component1() {
            return this.returnedExpressions;
        }

        public final boolean component2() {
            return this.hasReturnsInInlinedLambda;
        }

        @NotNull
        public final ReturnedExpressionsInfo copy(@NotNull Collection<? extends KtElement> returnedExpressions, boolean hasReturnsInInlinedLambda) {
            Intrinsics.checkNotNullParameter(returnedExpressions, (String)"returnedExpressions");
            return new ReturnedExpressionsInfo(returnedExpressions, hasReturnsInInlinedLambda);
        }

        public static /* synthetic */ ReturnedExpressionsInfo copy$default(ReturnedExpressionsInfo returnedExpressionsInfo, Collection collection, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                collection = returnedExpressionsInfo.returnedExpressions;
            }
            if ((n & 2) != 0) {
                bl = returnedExpressionsInfo.hasReturnsInInlinedLambda;
            }
            return returnedExpressionsInfo.copy(collection, bl);
        }

        @NotNull
        public String toString() {
            return "ReturnedExpressionsInfo(returnedExpressions=" + this.returnedExpressions + ", hasReturnsInInlinedLambda=" + this.hasReturnsInInlinedLambda + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.returnedExpressions).hashCode();
            int n = this.hasReturnsInInlinedLambda ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReturnedExpressionsInfo)) {
                return false;
            }
            ReturnedExpressionsInfo returnedExpressionsInfo = (ReturnedExpressionsInfo)other;
            if (!Intrinsics.areEqual(this.returnedExpressions, returnedExpressionsInfo.returnedExpressions)) {
                return false;
            }
            return this.hasReturnsInInlinedLambda == returnedExpressionsInfo.hasReturnsInInlinedLambda;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "reportedDiagnosticMap", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;)V", "getInstruction$cfg", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getReportedDiagnosticMap$cfg", "()Ljava/util/Map;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getVariableDescriptor$cfg", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "cfg"})
    private class VariableContext {
        @NotNull
        private final Instruction instruction;
        @NotNull
        private final Map<Instruction, DiagnosticFactory<?>> reportedDiagnosticMap;
        @Nullable
        private final VariableDescriptor variableDescriptor;

        public VariableContext(@NotNull Instruction instruction, Map<Instruction, DiagnosticFactory<?>> reportedDiagnosticMap) {
            Intrinsics.checkNotNullParameter((Object)ControlFlowInformationProviderImpl.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter(reportedDiagnosticMap, (String)"reportedDiagnosticMap");
            this.instruction = instruction;
            this.reportedDiagnosticMap = reportedDiagnosticMap;
            this.variableDescriptor = PseudocodeUtil.extractVariableDescriptorFromReference(this.instruction, ControlFlowInformationProviderImpl.this.trace.getBindingContext());
        }

        @NotNull
        public final Instruction getInstruction$cfg() {
            return this.instruction;
        }

        @NotNull
        public final Map<Instruction, DiagnosticFactory<?>> getReportedDiagnosticMap$cfg() {
            return this.reportedDiagnosticMap;
        }

        @Nullable
        public final VariableDescriptor getVariableDescriptor$cfg() {
            return this.variableDescriptor;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ$\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\tH\u0002R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableInitContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "map", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "in", "Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;", "out", "blockScopeVariableInfo", "Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;)V", "enterInitState", "Lorg/jetbrains/kotlin/cfg/variable/VariableControlFlowState;", "getEnterInitState$cfg", "()Lorg/jetbrains/kotlin/cfg/variable/VariableControlFlowState;", "exitInitState", "getExitInitState$cfg", "initialize", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "cfg"})
    private final class VariableInitContext
    extends VariableContext {
        @Nullable
        private final VariableControlFlowState enterInitState;
        @Nullable
        private final VariableControlFlowState exitInitState;

        public VariableInitContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory<?>> map, @NotNull VariableInitReadOnlyControlFlowInfo in, @NotNull VariableInitReadOnlyControlFlowInfo out, BlockScopeVariableInfo blockScopeVariableInfo) {
            Intrinsics.checkNotNullParameter((Object)ControlFlowInformationProviderImpl.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)blockScopeVariableInfo, (String)"blockScopeVariableInfo");
            super(instruction, map);
            this.enterInitState = this.initialize(this.getVariableDescriptor$cfg(), blockScopeVariableInfo, in);
            this.exitInitState = this.initialize(this.getVariableDescriptor$cfg(), blockScopeVariableInfo, out);
        }

        @Nullable
        public final VariableControlFlowState getEnterInitState$cfg() {
            return this.enterInitState;
        }

        @Nullable
        public final VariableControlFlowState getExitInitState$cfg() {
            return this.exitInitState;
        }

        private final VariableControlFlowState initialize(VariableDescriptor variableDescriptor, BlockScopeVariableInfo blockScopeVariableInfo, VariableInitReadOnlyControlFlowInfo map) {
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            if (variableDescriptor2 == null) {
                return null;
            }
            VariableControlFlowState state = (VariableControlFlowState)map.getOrNull(variableDescriptor2);
            if (state != null) {
                return state;
            }
            return PseudocodeVariablesData.Companion.getDefaultValueForInitializers(variableDescriptor, this.getInstruction$cfg(), blockScopeVariableInfo);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableUseContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "map", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;)V", "cfg"})
    private final class VariableUseContext
    extends VariableContext {
        public VariableUseContext(@NotNull Instruction instruction, Map<Instruction, DiagnosticFactory<?>> map) {
            Intrinsics.checkNotNullParameter((Object)ControlFlowInformationProviderImpl.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(instruction, map);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$Factory;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider$Factory;", "()V", "createControlFlowInformationProvider", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider;", "declaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "cfg"})
    public static final class Factory
    implements ControlFlowInformationProvider.Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @NotNull
        public ControlFlowInformationProvider createControlFlowInformationProvider(@NotNull KtElement declaration2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
            return new ControlFlowInformationProviderImpl(declaration2, trace, languageVersionSettings, diagnosticSuppressor);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J\u0014\u0010\u0019\u001a\u00020\u00042\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$Companion;", "", "()V", "check", "", "a", "b", "x", "y", "collectResultingExpressionsOfConditionalExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "collectResultingExpressionsOfConditionalExpressionRec", "", "resultingExpressions", "", "combineKinds", "Lorg/jetbrains/kotlin/cfg/TailRecursionKind;", "kind", "existingKind", "getResultingExpression", "isUsedAsResultOfLambda", "usages", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "mustBeReportedOnAllCopies", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "cfg"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUsedAsResultOfLambda(List<? extends Instruction> usages) {
            for (Instruction instruction : usages) {
                if (!(instruction instanceof ReturnValueInstruction)) continue;
                KtElement returnElement = ((ReturnValueInstruction)instruction).getElement();
                PsiElement parentElement = returnElement.getParent();
                if (returnElement instanceof KtReturnExpression || parentElement instanceof KtDeclaration && !(parentElement instanceof KtFunctionLiteral)) continue;
                return true;
            }
            return false;
        }

        private final List<KtExpression> collectResultingExpressionsOfConditionalExpression(KtExpression expression2) {
            ArrayList leafBranches = new ArrayList();
            this.collectResultingExpressionsOfConditionalExpressionRec(expression2, leafBranches);
            return leafBranches;
        }

        private final void collectResultingExpressionsOfConditionalExpressionRec(KtExpression expression2, List<KtExpression> resultingExpressions) {
            KtExpression ktExpression = expression2;
            if (ktExpression instanceof KtIfExpression) {
                this.collectResultingExpressionsOfConditionalExpressionRec(((KtIfExpression)expression2).getThen(), resultingExpressions);
                this.collectResultingExpressionsOfConditionalExpressionRec(((KtIfExpression)expression2).getElse(), resultingExpressions);
            } else if (ktExpression instanceof KtWhenExpression) {
                for (KtWhenEntry whenEntry : ((KtWhenExpression)expression2).getEntries()) {
                    this.collectResultingExpressionsOfConditionalExpressionRec(whenEntry.getExpression(), resultingExpressions);
                }
            } else if (ktExpression instanceof Object) {
                KtExpression resultingExpression = this.getResultingExpression(expression2);
                if (resultingExpression instanceof KtIfExpression || resultingExpression instanceof KtWhenExpression) {
                    this.collectResultingExpressionsOfConditionalExpressionRec(resultingExpression, resultingExpressions);
                } else {
                    resultingExpressions.add(resultingExpression);
                }
            }
        }

        private final KtExpression getResultingExpression(KtExpression expression2) {
            KtExpression finger = expression2;
            while (true) {
                KtExpression deparenthesized = KtPsiUtil.deparenthesize(finger);
                if ((deparenthesized = KtPsiUtil.getExpressionOrLastStatementInBlock(deparenthesized)) == null || deparenthesized == finger) break;
                finger = deparenthesized;
            }
            return finger;
        }

        private final TailRecursionKind combineKinds(TailRecursionKind kind, TailRecursionKind existingKind) {
            return existingKind == null || existingKind == kind ? kind : (this.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.TAIL_CALL) ? TailRecursionKind.IN_TRY : (this.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.NON_TAIL) ? TailRecursionKind.IN_TRY : TailRecursionKind.NON_TAIL));
        }

        private final boolean check(Object a, Object b, Object x, Object y) {
            return a == x && b == y || a == y && b == x;
        }

        private final boolean mustBeReportedOnAllCopies(DiagnosticFactory<?> diagnosticFactory) {
            return diagnosticFactory == Errors.UNUSED_VARIABLE || diagnosticFactory == Errors.UNUSED_PARAMETER || diagnosticFactory == Errors.UNUSED_ANONYMOUS_PARAMETER || diagnosticFactory == Errors.UNUSED_CHANGED_VALUE;
        }

        public static final /* synthetic */ boolean access$isUsedAsResultOfLambda(Companion $this, List usages) {
            return $this.isUsedAsResultOfLambda(usages);
        }

        public static final /* synthetic */ TailRecursionKind access$combineKinds(Companion $this, TailRecursionKind kind, TailRecursionKind existingKind) {
            return $this.combineKinds(kind, existingKind);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ClassKind.values().length];
            nArray[ClassKind.ENUM_ENTRY.ordinal()] = 1;
            nArray[ClassKind.OBJECT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TailRecursionKind.values().length];
            nArray[TailRecursionKind.TAIL_CALL.ordinal()] = 1;
            nArray[TailRecursionKind.IN_TRY.ordinal()] = 2;
            nArray[TailRecursionKind.NON_TAIL.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

