/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.FirCallCompleterKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J0\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUselessTypeOperationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isExactTypeCast", "", "candidateType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "targetType", "isRefinementUseless", "shouldCheckForExactType", "arg", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isUpcast", "checkers"})
public final class FirUselessTypeOperationCallChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirUselessTypeOperationCallChecker INSTANCE = new FirUselessTypeOperationCallChecker();

    private FirUselessTypeOperationCallChecker() {
    }

    @Override
    public void check(@NotNull FirTypeOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType refinedTargetType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirOperation.Companion.getTYPES().contains((Object)expression2.getOperation())) {
            return;
        }
        FirCall $this$argument$iv = expression2;
        boolean $i$f$getArgument = false;
        FirExpression arg = (FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments());
        ConeKotlinType candidateType = TypeExpansionUtilsKt.fullyExpandedType(ConeTypesKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(arg.getTypeRef())), context2.getSession());
        if (candidateType instanceof ConeClassErrorType) {
            return;
        }
        ConeKotlinType targetType = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(expression2.getConversionTypeRef()), context2.getSession());
        if (targetType instanceof ConeClassErrorType) {
            return;
        }
        ConeKotlinType coneKotlinType = refinedTargetType = expression2.getOperation() == FirOperation.SAFE_AS ? TypeUtilsKt.withNullability$default(targetType, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(context2.getSession()), null, 4, null) : targetType;
        if (this.isRefinementUseless(context2, candidateType, refinedTargetType, this.shouldCheckForExactType(expression2, context2), arg)) {
            FirOperation firOperation = expression2.getOperation();
            int n = WhenMappings.$EnumSwitchMapping$0[firOperation.ordinal()];
            switch (n) {
                case 1: {
                    DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), true, context2, null, 16, null);
                    break;
                }
                case 2: {
                    DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), false, context2, null, 16, null);
                    break;
                }
                case 3: 
                case 4: {
                    DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CAST(), context2, null, 8, null);
                    break;
                }
                default: {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Should not be here: ", (Object)((Object)expression2.getOperation())));
                }
            }
        }
    }

    private final boolean shouldCheckForExactType(FirTypeOperatorCall expression2, CheckerContext context2) {
        boolean bl;
        FirOperation firOperation = expression2.getOperation();
        int n = WhenMappings.$EnumSwitchMapping$0[firOperation.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            default: {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Should not be here: ", (Object)((Object)expression2.getOperation())));
            }
        }
        return bl;
    }

    private final boolean isRefinementUseless(CheckerContext context2, ConeKotlinType candidateType, ConeKotlinType targetType, boolean shouldCheckForExactType, FirExpression arg) {
        boolean bl;
        if (shouldCheckForExactType) {
            if (arg instanceof FirFunctionCall) {
                FirFunction function2;
                FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(arg);
                FirCallableDeclaration firCallableDeclaration = firCallableSymbol == null ? null : (FirCallableDeclaration)firCallableSymbol.getFir();
                FirFunction firFunction = function2 = firCallableDeclaration instanceof FirFunction ? (FirFunction)firCallableDeclaration : null;
                if (function2 != null && FirCallCompleterKt.isFunctionForExpectTypeFromCastFeature(function2)) {
                    return false;
                }
            }
            bl = this.isExactTypeCast(context2, candidateType, targetType);
        } else {
            bl = this.isUpcast(context2, candidateType, targetType);
        }
        return bl;
    }

    private final boolean isExactTypeCast(CheckerContext context2, ConeKotlinType candidateType, ConeKotlinType targetType) {
        if (!AbstractTypeChecker.INSTANCE.equalTypes(SessionUtilsKt.getTypeContext(context2.getSession()), candidateType, targetType, false)) {
            return false;
        }
        return CompilerConeAttributesKt.isExtensionFunctionType(candidateType) == CompilerConeAttributesKt.isExtensionFunctionType(targetType);
    }

    private final boolean isUpcast(CheckerContext context2, ConeKotlinType candidateType, ConeKotlinType targetType) {
        if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(SessionUtilsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)candidateType, (KotlinTypeMarker)targetType, false)) {
            return false;
        }
        return CompilerConeAttributesKt.isExtensionFunctionType(candidateType) == CompilerConeAttributesKt.isExtensionFunctionType(targetType);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            nArray[FirOperation.IS.ordinal()] = 1;
            nArray[FirOperation.NOT_IS.ordinal()] = 2;
            nArray[FirOperation.AS.ordinal()] = 3;
            nArray[FirOperation.SAFE_AS.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

