/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirAbstractAnnotationResolveTransformer;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002$\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0001B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J(\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0016\u0010\u001f\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002H\u0016J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0016\u0010\u001f\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002H\u0016J(\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00052\u0016\u0010\u001f\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00050\u0002H\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirAnnotationResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirAbstractAnnotationResolveTransformer;", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "metaAnnotations", "", "getMetaAnnotations", "()Ljava/util/Set;", "setMetaAnnotations", "(Ljava/util/Set;)V", "owners", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "afterChildren", "", "state", "beforeChildren", "declaration", "transformAnnotatedDeclaration", "annotatedDeclaration", "data", "transformAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "transformRegularClass", "regularClass", "resolve"})
final class FirAnnotationResolveTransformer
extends FirAbstractAnnotationResolveTransformer<Multimap<FqName, FirRegularClass>, PersistentList<? extends FirAnnotatedDeclaration>> {
    @NotNull
    private Set<FqName> metaAnnotations;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @NotNull
    private PersistentList<? extends FirAnnotatedDeclaration> owners;
    @NotNull
    private final ArrayDeque<FirRegularClass> classDeclarationsStack;

    public FirAnnotationResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session2, scopeSession);
        this.metaAnnotations = SetsKt.emptySet();
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(session2, false);
        this.owners = ExtensionsKt.persistentListOf();
        this.classDeclarationsStack = new ArrayDeque();
    }

    @NotNull
    public final Set<FqName> getMetaAnnotations() {
        return this.metaAnnotations;
    }

    public final void setMetaAnnotations(@NotNull Set<FqName> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.metaAnnotations = set;
    }

    @Override
    @NotNull
    protected PersistentList<FirAnnotatedDeclaration> beforeChildren(@NotNull FirAnnotatedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        PersistentList<FirAnnotatedDeclaration> current = this.owners;
        this.owners = this.owners.add(declaration2);
        return current;
    }

    @Override
    protected void afterChildren(@Nullable PersistentList<? extends FirAnnotatedDeclaration> state) {
        if (state == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.owners = state;
    }

    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull Multimap<FqName, FirRegularClass> data) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return annotationCall.transformAnnotationTypeRef(this.typeResolverTransformer, new ScopeClassDeclaration(this.getScope(), (FirRegularClass)this.classDeclarationsStack.lastOrNull()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @NotNull Multimap<FqName, FirRegularClass> data) {
        void classDeclarations$iv;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        ArrayDeque<FirRegularClass> arrayDeque = this.classDeclarationsStack;
        FirRegularClass topClassDeclaration$iv = (FirRegularClass)this.classDeclarationsStack.last();
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast((Object)topClassDeclaration$iv);
        try {
            FirStatement firStatement;
            boolean bl = false;
            FirStatement it = firStatement = super.transformRegularClass(regularClass, data);
            boolean bl2 = false;
            if (regularClass.getClassKind() == ClassKind.ANNOTATION_CLASS && !((Collection)this.getMetaAnnotations()).isEmpty()) {
                void $this$filterTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = regularClass.getAnnotations();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Iterable<FqName> destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FqName fqName2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    FirAnnotationCall it2 = (FirAnnotationCall)element$iv$iv;
                    boolean bl4 = false;
                    FqName fqName3 = ResolveUtilsKt.fqName(it2, this.getSession());
                    if (fqName3 == null) continue;
                    FqName it$iv$iv = fqName2 = fqName3;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List annotations2 = (List)destination$iv$iv;
                Iterable $this$filter$iv = annotations2;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FqName it3 = (FqName)element$iv$iv;
                    boolean bl6 = false;
                    if (!this.getMetaAnnotations().contains(it3)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (FqName annotation2 : (List)destination$iv$iv2) {
                    data.put(annotation2, regularClass);
                }
            }
            FirStatement firStatement2 = firStatement;
            return firStatement2;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    @Override
    @NotNull
    public FirAnnotatedDeclaration transformAnnotatedDeclaration(@NotNull FirAnnotatedDeclaration annotatedDeclaration, @NotNull Multimap<FqName, FirRegularClass> data) {
        FirAnnotatedDeclaration firAnnotatedDeclaration;
        Intrinsics.checkNotNullParameter((Object)annotatedDeclaration, (String)"annotatedDeclaration");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        FirAnnotatedDeclaration it = firAnnotatedDeclaration = super.transformAnnotatedDeclaration(annotatedDeclaration, data);
        boolean bl = false;
        FirPredicateBasedProviderKt.getPredicateBasedProvider(this.getSession()).registerAnnotatedDeclaration(annotatedDeclaration, this.owners);
        return firAnnotatedDeclaration;
    }
}

