/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u000eJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0012H\u0002J \u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0012H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020-H\u0002R\u001e\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0012*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/InstructionLivenessAnalyzer;", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "handlers", "", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "isLive", "", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nInsns", "", "queue", "", "queued", "top", "indexOf", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getIndexOf", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)I", "analyze", "checkAssertions", "", "computeExceptionHandlersForEachInsn", "m", "initControlFlowAnalysis", "localVariableAndTryCatchBlockLabelsAreAlwaysLive", "traverseCfg", "visitControlFlowEdge", "insn", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitOpInsn", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "backend"})
public final class InstructionLivenessAnalyzer {
    @NotNull
    private final MethodNode method;
    private final InsnList instructions;
    private final int nInsns;
    @NotNull
    private final boolean[] isLive;
    @NotNull
    private final List<TryCatchBlockNode>[] handlers;
    @NotNull
    private final boolean[] queued;
    @NotNull
    private final int[] queue;
    private int top;

    public InstructionLivenessAnalyzer(@NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.method = method;
        this.instructions = this.method.instructions;
        this.nInsns = this.instructions.size();
        this.isLive = new boolean[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    private final int getIndexOf(AbstractInsnNode $this$indexOf) {
        return this.instructions.indexOf($this$indexOf);
    }

    @NotNull
    public final boolean[] analyze() {
        if (this.nInsns == 0) {
            return this.isLive;
        }
        this.checkAssertions();
        this.computeExceptionHandlersForEachInsn(this.method);
        this.initControlFlowAnalysis();
        this.traverseCfg();
        this.localVariableAndTryCatchBlockLabelsAreAlwaysLive();
        if (this.instructions.getLast() instanceof LabelNode) {
            AbstractInsnNode abstractInsnNode = this.instructions.getLast();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"instructions.last");
            this.isLive[this.getIndexOf((AbstractInsnNode)abstractInsnNode)] = true;
        }
        return this.isLive;
    }

    private final void traverseCfg() {
        while (this.top > 0) {
            InstructionLivenessAnalyzer instructionLivenessAnalyzer = this;
            instructionLivenessAnalyzer.top += -1;
            int insn = this.queue[instructionLivenessAnalyzer.top];
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            int insnOpcode = insnNode.getOpcode();
            int n = insnNode.getType();
            switch (n) {
                case 8: 
                case 14: 
                case 15: {
                    this.visitOpInsn(insn);
                    break;
                }
                case 7: {
                    if (insnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                    }
                    this.visitJumpInsnNode((JumpInsnNode)insnNode, insn, insnOpcode);
                    break;
                }
                case 12: {
                    if (insnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                    }
                    this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode);
                    break;
                }
                case 11: {
                    if (insnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                    }
                    this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode);
                    break;
                }
                default: {
                    if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                    this.visitOpInsn(insn);
                }
            }
            List<TryCatchBlockNode> list2 = this.handlers[insn];
            if (list2 == null) continue;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                boolean bl = false;
                LabelNode labelNode = tcb.handler;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.handler");
                this.visitControlFlowEdge(this.getIndexOf(labelNode));
            }
        }
    }

    private final void localVariableAndTryCatchBlockLabelsAreAlwaysLive() {
        LabelNode labelNode;
        for (LocalVariableNode localVariable : this.method.localVariables) {
            labelNode = localVariable.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"localVariable.start");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
            labelNode = localVariable.end;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"localVariable.end");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
        }
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
            labelNode = tcb.end;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.end");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
            labelNode = tcb.handler;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.handler");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
        }
    }

    private final void checkAssertions() {
        boolean bl;
        block4: {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            Iterable $this$any$iv = insnList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
        }
    }

    private final void visitOpInsn(int insn) {
        this.visitControlFlowEdge(insn + 1);
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.dflt");
        int jump = this.getIndexOf(labelNode);
        this.visitControlFlowEdge(jump);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
            jump = this.getIndexOf(label);
            this.visitControlFlowEdge(jump);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.dflt");
        int jump = this.getIndexOf(labelNode);
        this.visitControlFlowEdge(jump);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
            jump = this.getIndexOf(label);
            this.visitControlFlowEdge(jump);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, int insn, int insnOpcode) {
        if (insnOpcode != 167 && insnOpcode != 168) {
            this.visitControlFlowEdge(insn + 1);
        }
        LabelNode labelNode = insnNode.label;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.label");
        int jump = this.getIndexOf(labelNode);
        this.visitControlFlowEdge(jump);
    }

    private final void initControlFlowAnalysis() {
        this.visitControlFlowEdge(0);
    }

    private final void computeExceptionHandlersForEachInsn(MethodNode m) {
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
            int begin = this.getIndexOf(labelNode);
            LabelNode labelNode2 = tcb.end;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"tcb.end");
            int end = this.getIndexOf(labelNode2);
            int n = begin;
            while (n < end) {
                int j = n++;
                AbstractInsnNode abstractInsnNode = this.instructions.get(j);
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"instructions[j]");
                if (!UtilKt.isMeaningful(abstractInsnNode)) continue;
                List insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = (List)new ArrayList();
                }
                Intrinsics.checkNotNullExpressionValue((Object)tcb, (String)"tcb");
                insnHandlers.add(tcb);
            }
        }
    }

    private final void visitControlFlowEdge(int insn) {
        boolean changes = !this.isLive[insn];
        this.isLive[insn] = true;
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            InstructionLivenessAnalyzer instructionLivenessAnalyzer = this;
            int n = instructionLivenessAnalyzer.top;
            instructionLivenessAnalyzer.top = n + 1;
            this.queue[n] = insn;
        }
    }
}

