/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J>\u0010\u0013\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAnnotationOnSuperclass", "superTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkClassCannotBeExtendedDirectly", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "checkDelegationNotToInterface", "checkExpandedTypeCannotBeInherited", "fullyExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneType", "checkProjectionInImmediateArgumentToSupertype", "checkers"})
public final class FirSupertypesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSupertypesChecker INSTANCE = new FirSupertypesChecker();

    private FirSupertypesChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        boolean nullableSupertypeReported = false;
        boolean extensionFunctionSupertypeReported = false;
        boolean interfaceWithSuperclassReported = false;
        interfaceWithSuperclassReported = !isInterface;
        boolean finalSupertypeReported = false;
        boolean singletonInSupertypeReported = false;
        boolean classAppeared = false;
        HashSet superClassSymbols = new HashSet();
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            ConeKotlinType fullyExpandedType2;
            boolean $i$f$getModality;
            FirClassLikeSymbol<?> superTypeSymbol;
            ConeClassLikeLookupTag lookupTag;
            boolean $i$f$safeAs;
            ConeKotlinType $this$safeAs$iv;
            ConeKotlinType coneType;
            boolean bl;
            CheckerContext it;
            List<String> list2;
            FirAnnotationContainer firAnnotationContainer;
            boolean $i$f$withSuppressedDiagnostics = false;
            FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)superTypeRef instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)superTypeRef) : null;
            if (firAnnotationContainer == null) {
                list2 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer3;
                FirAnnotationContainer it$iv = firAnnotationContainer3 = firAnnotationContainer;
                boolean bl2 = false;
                list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv = list2;
            if (arguments$iv != null) {
                ConeClassLikeType coneClassLikeType;
                it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                bl = false;
                coneType = FirTypeUtilsKt.getConeType(superTypeRef);
                if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), context2, null, 8, null);
                    nullableSupertypeReported = true;
                }
                if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType)) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), context2, null, 8, null);
                    extensionFunctionSupertypeReported = true;
                }
                $this$safeAs$iv = coneType;
                $i$f$safeAs = false;
                ConeKotlinType coneKotlinType = $this$safeAs$iv;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                if ((coneClassLikeType = (ConeClassLikeType)coneKotlinType) == null) continue;
                lookupTag = coneClassLikeType.getLookupTag();
                superTypeSymbol = LookupTagUtilsKt.toSymbol(lookupTag, context2.getSession());
                if (superTypeSymbol instanceof FirRegularClassSymbol) {
                    boolean isObject;
                    if (!superClassSymbols.add(superTypeSymbol)) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), context2, null, 8, null);
                    }
                    if (((FirRegularClassSymbol)superTypeSymbol).getClassKind() != ClassKind.INTERFACE) {
                        if (classAppeared) {
                            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), context2, null, 8, null);
                        } else {
                            classAppeared = true;
                        }
                        if (!interfaceWithSuperclassReported) {
                            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), context2, null, 8, null);
                            interfaceWithSuperclassReported = true;
                        }
                    }
                    boolean bl3 = isObject = ((FirRegularClassSymbol)superTypeSymbol).getClassKind() == ClassKind.OBJECT;
                    if (!finalSupertypeReported && !isObject) {
                        FirRegularClassSymbol $this$modality$iv = (FirRegularClassSymbol)superTypeSymbol;
                        $i$f$getModality = false;
                        if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), context2, null, 8, null);
                            finalSupertypeReported = true;
                        }
                    }
                    if (!singletonInSupertypeReported && isObject) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), context2, null, 8, null);
                        singletonInSupertypeReported = true;
                    }
                }
                INSTANCE.checkAnnotationOnSuperclass(superTypeRef, context2, reporter);
                fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(coneType, context2.getSession());
                FirBasedSymbol<?> symbol2 = TypeUtilsKt.toSymbol(fullyExpandedType2, context2.getSession());
                INSTANCE.checkClassCannotBeExtendedDirectly(symbol2, reporter, superTypeRef, context2);
                if (!(coneType.getTypeArguments().length == 0)) {
                    INSTANCE.checkProjectionInImmediateArgumentToSupertype(coneType, superTypeRef, reporter, context2);
                    continue;
                }
                INSTANCE.checkExpandedTypeCannotBeInherited(symbol2, fullyExpandedType2, reporter, superTypeRef, coneType, context2);
                continue;
            }
            it = context2;
            bl = false;
            coneType = FirTypeUtilsKt.getConeType(superTypeRef);
            if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), context2, null, 8, null);
                nullableSupertypeReported = true;
            }
            if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType)) {
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), context2, null, 8, null);
                extensionFunctionSupertypeReported = true;
            }
            $this$safeAs$iv = coneType;
            $i$f$safeAs = false;
            ConeKotlinType coneKotlinType = $this$safeAs$iv;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((superTypeSymbol = (ConeClassLikeType)coneKotlinType) == null) continue;
            lookupTag = ((ConeClassLikeType)((Object)superTypeSymbol)).getLookupTag();
            if ((superTypeSymbol = LookupTagUtilsKt.toSymbol(lookupTag, context2.getSession())) instanceof FirRegularClassSymbol) {
                boolean isObject;
                if (!superClassSymbols.add(superTypeSymbol)) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), context2, null, 8, null);
                }
                if (((FirRegularClassSymbol)superTypeSymbol).getClassKind() != ClassKind.INTERFACE) {
                    if (classAppeared) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), context2, null, 8, null);
                    } else {
                        classAppeared = true;
                    }
                    if (!interfaceWithSuperclassReported) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), context2, null, 8, null);
                        interfaceWithSuperclassReported = true;
                    }
                }
                boolean bl4 = isObject = ((FirRegularClassSymbol)superTypeSymbol).getClassKind() == ClassKind.OBJECT;
                if (!finalSupertypeReported && !isObject) {
                    FirRegularClassSymbol $this$modality$iv = (FirRegularClassSymbol)superTypeSymbol;
                    $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), context2, null, 8, null);
                        finalSupertypeReported = true;
                    }
                }
                if (!singletonInSupertypeReported && isObject) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), context2, null, 8, null);
                    singletonInSupertypeReported = true;
                }
            }
            INSTANCE.checkAnnotationOnSuperclass(superTypeRef, context2, reporter);
            fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(coneType, context2.getSession());
            FirBasedSymbol<?> symbol3 = TypeUtilsKt.toSymbol(fullyExpandedType2, context2.getSession());
            INSTANCE.checkClassCannotBeExtendedDirectly(symbol3, reporter, superTypeRef, context2);
            if (!(coneType.getTypeArguments().length == 0)) {
                INSTANCE.checkProjectionInImmediateArgumentToSupertype(coneType, superTypeRef, reporter, context2);
                continue;
            }
            INSTANCE.checkExpandedTypeCannotBeInherited(symbol3, fullyExpandedType2, reporter, superTypeRef, coneType, context2);
        }
        this.checkDelegationNotToInterface(declaration2, context2, reporter);
        if (declaration2 instanceof FirRegularClass && declaration2.getSuperTypeRefs().size() > 1) {
            FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(CollectionsKt.listOf((Object)new Pair(null, (Object)((FirRegularClass)declaration2).getSymbol())), context2, reporter, declaration2.getSource(), true);
        }
    }

    private final void checkAnnotationOnSuperclass(FirTypeRef superTypeRef, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirAnnotationCall annotation2 : superTypeRef.getAnnotations()) {
            boolean bl;
            CheckerContext it;
            List<String> list2;
            FirAnnotationContainer firAnnotationContainer;
            boolean $i$f$withSuppressedDiagnostics = false;
            FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)annotation2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)annotation2) : null;
            if (firAnnotationContainer == null) {
                list2 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer3;
                FirAnnotationContainer it$iv = firAnnotationContainer3 = firAnnotationContainer;
                boolean bl2 = false;
                list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv = list2;
            if (arguments$iv != null) {
                it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                bl = false;
                if (annotation2.getUseSiteTarget() == null) continue;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), context2, null, 8, null);
                continue;
            }
            it = context2;
            bl = false;
            if (annotation2.getUseSiteTarget() == null) continue;
            DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), context2, null, 8, null);
        }
    }

    private final void checkClassCannotBeExtendedDirectly(FirBasedSymbol<?> symbol2, DiagnosticReporter reporter, FirTypeRef superTypeRef, CheckerContext context2) {
        if (symbol2 instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)symbol2).getClassId(), (Object)StandardClassIds.INSTANCE.getEnum())) {
            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_CANNOT_BE_EXTENDED_DIRECTLY(), symbol2, context2, null, 16, null);
        }
    }

    private final void checkProjectionInImmediateArgumentToSupertype(ConeKotlinType coneType, FirTypeRef superTypeRef, DiagnosticReporter reporter, CheckerContext context2) {
        ConeTypeProjection[] coneTypeProjectionArray = coneType.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int i = 0; i < n; ++i) {
            FirTypeRefSource firTypeRefSource;
            int index2 = i;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
            if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument) || (firTypeRefSource = FirHelpersKt.extractArgumentTypeRefAndSource(superTypeRef, index2)) == null) continue;
            FirTypeRefSource firTypeRefSource2 = firTypeRefSource;
            FirSourceElement argSource = firTypeRefSource2.component2();
            FirSourceElement firSourceElement = argSource;
            DiagnosticReporterKt.reportOn$default(reporter, firSourceElement == null ? superTypeRef.getSource() : firSourceElement, FirErrors.INSTANCE.getPROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE(), context2, null, 8, null);
        }
    }

    private final void checkExpandedTypeCannotBeInherited(FirBasedSymbol<?> symbol2, ConeKotlinType fullyExpandedType2, DiagnosticReporter reporter, FirTypeRef superTypeRef, ConeKotlinType coneType, CheckerContext context2) {
        if (symbol2 instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)symbol2).getClassKind() == ClassKind.INTERFACE) {
            for (ConeTypeProjection typeArgument : fullyExpandedType2.getTypeArguments()) {
                if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getEXPANDED_TYPE_CANNOT_BE_INHERITED(), (Object)coneType, context2, null, 16, null);
                break;
            }
        }
    }

    private final void checkDelegationNotToInterface(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirDeclaration subDeclaration : declaration2.getDeclarations()) {
            FirRegularClassSymbol delegatedClassSymbol;
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)((Object)subDeclaration);
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE) || !((FirField)subDeclaration).getName().isSpecial() || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName()) || (delegatedClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirField)subDeclaration).getReturnTypeRef(), context2.getSession())) == null || delegatedClassSymbol.getClassKind() == ClassKind.INTERFACE) continue;
            DiagnosticReporterKt.reportOn$default(reporter, ((FirField)subDeclaration).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getDELEGATION_NOT_TO_INTERFACE(), context2, null, 8, null);
        }
    }
}

