/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u000e\u0010)\u001a\u00020**\u0004\u0018\u00010+H\u0002\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;)V", "reportFirDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "qualifiedAccessSource", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "data", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorImport", "errorImport", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorImport;", "visitErrorLoop", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "cannotBeResolved", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    public ErrorNodeDiagnosticCollectorComponent(@NotNull FirSession session2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        super(session2, reporter);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorLoop, (String)"errorLoop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorLoop.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorTypeRef.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean bl2 = bl = !(resolvedTypeRef.getType() instanceof ConeClassErrorType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus((String)"Instead use FirErrorTypeRef for ", (Object)TypeRendererKt.render(resolvedTypeRef.getType()));
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data) {
        FirStatement qualifiedAccessOrAnnotationCall;
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)errorNamedReference, (String)"errorNamedReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorNamedReference.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        FirStatement firStatement2 = (FirStatement)CollectionsKt.lastOrNull(data.getQualifiedAccessOrAnnotationCalls());
        if (firStatement2 == null) {
            firStatement = null;
        } else {
            FirStatement firStatement3;
            FirStatement it = firStatement3 = firStatement2;
            boolean bl = false;
            FirStatement firStatement4 = it;
            firStatement = qualifiedAccessOrAnnotationCall = (firStatement4 instanceof FirQualifiedAccess ? Intrinsics.areEqual((Object)((FirQualifiedAccess)it).getCalleeReference(), (Object)errorNamedReference) : (firStatement4 instanceof FirAnnotationCall ? Intrinsics.areEqual((Object)((FirAnnotationCall)it).getCalleeReference(), (Object)errorNamedReference) : false)) ? firStatement3 : null;
        }
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.ANNOTATION_ENTRY) && errorNamedReference.getDiagnostic() instanceof ConeUnresolvedNameError) {
            return;
        }
        if (Intrinsics.areEqual((Object)source.getKind(), (Object)FirFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && errorNamedReference.getDiagnostic() instanceof ConeUnresolvedNameError) {
            return;
        }
        if (qualifiedAccessOrAnnotationCall instanceof FirQualifiedAccess && (this.cannotBeResolved(((FirQualifiedAccess)qualifiedAccessOrAnnotationCall).getDispatchReceiver()) || this.cannotBeResolved(((FirQualifiedAccess)qualifiedAccessOrAnnotationCall).getExtensionReceiver()) || this.cannotBeResolved(((FirQualifiedAccess)qualifiedAccessOrAnnotationCall).getExplicitReceiver()))) {
            return;
        }
        this.reportFirDiagnostic(errorNamedReference.getDiagnostic(), source, this.getReporter(), data, (firStatement2 = qualifiedAccessOrAnnotationCall) == null ? null : firStatement2.getSource());
    }

    private final boolean cannotBeResolved(FirExpression $this$cannotBeResolved) {
        FirExpression firExpression2 = $this$cannotBeResolved;
        FirTypeRef firTypeRef = firExpression2 == null ? null : firExpression2.getTypeRef();
        FirErrorTypeRef firErrorTypeRef = firTypeRef instanceof FirErrorTypeRef ? (FirErrorTypeRef)firTypeRef : null;
        ConeDiagnostic diagnostic = firErrorTypeRef == null ? null : firErrorTypeRef.getDiagnostic();
        return (diagnostic instanceof ConeUnresolvedNameError ? true : diagnostic instanceof ConeInstanceAccessBeforeSuperCall) ? true : (diagnostic instanceof ConeSimpleDiagnostic ? ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.NotASupertype || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SuperNotAvailable || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.UnresolvedLabel || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.AmbiguousSuper : false);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorExpression, (String)"errorExpression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorExpression.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorExpression.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorFunction, (String)"errorFunction");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorFunction.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorResolvedQualifier.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorImport(@NotNull FirErrorImport errorImport, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorImport, (String)"errorImport");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirSourceElement firSourceElement = errorImport.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorImport.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, FirSourceElement source, DiagnosticReporter reporter, CheckerContext context2, FirSourceElement qualifiedAccessSource) {
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        if (Intrinsics.areEqual((Object)source.getKind(), (Object)FirFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableCandidateError)) {
            return;
        }
        if (Intrinsics.areEqual((Object)source.getKind(), (Object)FirFakeSourceElementKind.ImplicitConstructor.INSTANCE) || Intrinsics.areEqual((Object)source.getKind(), (Object)FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        for (FirDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, source, qualifiedAccessSource)) {
            reporter.report(coneDiagnostic, context2);
        }
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, FirSourceElement firSourceElement, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, FirSourceElement firSourceElement2, int n, Object object) {
        if ((n & 0x10) != 0) {
            firSourceElement2 = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, firSourceElement, diagnosticReporter, checkerContext, firSourceElement2);
    }
}

