/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirDeprecatedJavaAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "javaToKotlinNameMap", "", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirDeprecatedJavaAnnotationsChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirDeprecatedJavaAnnotationsChecker INSTANCE = new FirDeprecatedJavaAnnotationsChecker();
    @NotNull
    private static final Map<FqName, FqName> javaToKotlinNameMap;

    private FirDeprecatedJavaAnnotationsChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (!Intrinsics.areEqual(firDeclaration == null ? null : ((object = firDeclaration.getSource()) == null ? null : ((FirSourceElement)object).getKind()), (Object)FirRealSourceElementKind.INSTANCE)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null) {
            return;
        }
        ConeClassLikeLookupTag lookupTag = ((ConeClassLikeType)object).getLookupTag();
        if ((object = javaToKotlinNameMap.get(lookupTag.getClassId().asSingleFqName())) != null) {
            Object object2;
            Object betterName = object2 = object;
            boolean bl = false;
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirJvmErrors.INSTANCE.getDEPRECATED_JAVA_ANNOTATION(), betterName, context2, null, 16, null);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JvmAnnotationNames.TARGET_ANNOTATION, (Object)StandardNames.FqNames.target), TuplesKt.to((Object)JvmAnnotationNames.RETENTION_ANNOTATION, (Object)StandardNames.FqNames.retention), TuplesKt.to((Object)JvmAnnotationNames.DEPRECATED_ANNOTATION, (Object)StandardNames.FqNames.deprecated), TuplesKt.to((Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION, (Object)StandardNames.FqNames.mustBeDocumented)};
        javaToKotlinNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

