/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.CounterWithExclude;
import org.jetbrains.kotlin.util.ReenterableCounter;
import org.jetbrains.kotlin.util.SimpleCounter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H$\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0004J\u001a\u0010\u0019\u001a\u00020\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u001bJ&\u0010\u0019\u001a\u00020\u00162\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u001cJ\u0006\u0010\u001d\u001a\u00020\u0016J\u001f\u0010\u001e\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter;", "", "name", "", "(Ljava/lang/String;)V", "count", "", "excludedFrom", "", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "getExcludedFrom$frontend", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "totalTimeNanos", "", "countTime", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "increment", "", "incrementTime", "delta", "report", "consumer", "Lkotlin/Function1;", "Lkotlin/Function3;", "reset", "time", "Companion", "frontend"})
public abstract class PerformanceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<CounterWithExclude> excludedFrom;
    private int count;
    private long totalTimeNanos;
    @NotNull
    private static final ArrayList<PerformanceCounter> allCounters = new ArrayList();
    private static boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PerformanceCounter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.excludedFrom = new ArrayList();
        ArrayList<PerformanceCounter> arrayList = allCounters;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = allCounters.add(this);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<CounterWithExclude> getExcludedFrom$frontend() {
        return this.excludedFrom;
    }

    public final void increment() {
        PerformanceCounter performanceCounter = this;
        int n = performanceCounter.count;
        performanceCounter.count = n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T time(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        PerformanceCounter performanceCounter = this;
        int n = performanceCounter.count;
        performanceCounter.count = n + 1;
        if (!enabled) {
            return (T)block.invoke();
        }
        Iterable $this$forEach$iv = this.excludedFrom;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CounterWithExclude it = (CounterWithExclude)element$iv;
            boolean bl = false;
            it.enterExcludedMethod();
        }
        try {
            performanceCounter = this.countTime(block);
            return (T)performanceCounter;
        }
        finally {
            Iterable $this$forEach$iv2 = this.excludedFrom;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                CounterWithExclude it = (CounterWithExclude)element$iv;
                boolean bl = false;
                it.exitExcludedMethod();
            }
        }
    }

    public final void reset() {
        this.count = 0;
        this.totalTimeNanos = 0L;
    }

    protected final void incrementTime(long delta) {
        PerformanceCounter performanceCounter = this;
        performanceCounter.totalTimeNanos += delta;
    }

    protected abstract <T> T countTime(@NotNull Function0<? extends T> var1);

    public final void report(@NotNull Function1<? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.totalTimeNanos == 0L) {
            consumer.invoke((Object)(this.name + " performed " + this.count + " times"));
        } else {
            long millis = TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
            consumer.invoke((Object)(this.name + " performed " + this.count + " times, total time " + millis + " ms"));
        }
    }

    public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.invoke((Object)this.name, (Object)this.count, (Object)this.totalTimeNanos);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0011\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\bH\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J5\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0!J&\u0010\u001e\u001a\u00020\u001f2\u001e\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001f0\"J\u0006\u0010#\u001a\u00020\u001fJ\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter$Companion;", "", "()V", "allCounters", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "Lkotlin/collections/ArrayList;", "enabled", "", "numberOfCounters", "", "getNumberOfCounters", "()I", "create", "name", "", "excluded", "", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)Lorg/jetbrains/kotlin/util/PerformanceCounter;", "reenterable", "currentTime", "", "getOrPut", "T", "threadLocal", "Ljava/lang/ThreadLocal;", "default", "Lkotlin/Function0;", "getOrPut$frontend", "(Ljava/lang/ThreadLocal;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "report", "", "consumer", "Lkotlin/Function1;", "Lkotlin/Function3;", "resetAllCounters", "setTimeCounterEnabled", "enable", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final long currentTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function1<? super String, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$22;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$22 = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PerformanceCounter[] performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
                if (performanceCounterArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$22 = performanceCounterArray;
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$22;
            boolean $i$f$forEach = false;
            for (PerformanceCounter element$iv : $this$forEach$iv) {
                PerformanceCounter it = element$iv;
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$32;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$32 = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PerformanceCounter[] performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
                if (performanceCounterArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$32 = performanceCounterArray;
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = $i$a$-synchronized-PerformanceCounter$Companion$report$countersCopy$32;
            boolean $i$f$forEach = false;
            for (PerformanceCounter element$iv : $this$forEach$iv) {
                PerformanceCounter it = element$iv;
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getNumberOfCounters() {
            int n;
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                n = allCounters.size();
            }
            return n;
        }

        public final void setTimeCounterEnabled(boolean enable) {
            enabled = enable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetAllCounters() {
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Iterable $this$forEach$iv = allCounters;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PerformanceCounter p0 = (PerformanceCounter)element$iv;
                    boolean bl2 = false;
                    p0.reset();
                }
                Unit unit2 = Unit.INSTANCE;
            }
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name, boolean reenterable) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return reenterable ? (PerformanceCounter)new ReenterableCounter(name) : (PerformanceCounter)new SimpleCounter(name);
        }

        public static /* synthetic */ PerformanceCounter create$default(Companion companion, String string2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(string2, bl);
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name, PerformanceCounter ... excluded) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)excluded, (String)"excluded");
            return new CounterWithExclude(name, Arrays.copyOf(excluded, excluded.length));
        }

        public final <T> T getOrPut$frontend(@NotNull ThreadLocal<T> threadLocal, @NotNull Function0<? extends T> function0) {
            Intrinsics.checkNotNullParameter(threadLocal, (String)"threadLocal");
            Intrinsics.checkNotNullParameter(function0, (String)"default");
            boolean $i$f$getOrPut$frontend = false;
            Object value2 = threadLocal.get();
            if (value2 == null) {
                value2 = function0.invoke();
                threadLocal.set(value2);
            }
            return value2;
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return org.jetbrains.kotlin.util.PerformanceCounter$Companion.create$default(this, name, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

