/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrDeclarationToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrClassModel;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eH\u0002J\u001e\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010$0#2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u001fH\u0002J\b\u0010(\u001a\u00020\u001fH\u0002J\b\u0010)\u001a\u00020\u001aH\u0002J\b\u0010*\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020\u001a*\u00020\bH\u0002J\f\u0010-\u001a\u00020\u001a*\u00020&H\u0002J\f\u0010.\u001a\u00020\u001a*\u00020\u0003H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsClassGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "baseClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "baseClassRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "getBaseClassRef", "()Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "baseClassRef$delegate", "Lkotlin/Lazy;", "classBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "classModel", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrClassModel;", "className", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "classNameRef", "classPrototypeRef", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "es6mode", "", "generate", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateAssociatedKeyProperties", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "generateClassMetadata", "generateInheritanceCode", "generateMemberFunction", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateSuperClasses", "generateSuspendArity", "isCoroutineClass", "maybeGeneratePrimaryConstructor", "", "isFunctionType", "overridesExternal", "shouldCopyFrom", "backend.js"})
public final class JsClassGenerator {
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final JsGenerationContext context;
    @NotNull
    private final JsName className;
    @NotNull
    private final JsNameRef classNameRef;
    @Nullable
    private final IrType baseClass;
    @NotNull
    private final Lazy baseClassRef$delegate;
    @NotNull
    private final JsNameRef classPrototypeRef;
    @NotNull
    private final JsGlobalBlock classBlock;
    @NotNull
    private final JsIrClassModel classModel;
    private final boolean es6mode;

    /*
     * WARNING - void declaration
     */
    public JsClassGenerator(@NotNull IrClass irClass2, @NotNull JsGenerationContext context2) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.irClass = irClass2;
            this.context = context2;
            this.className = this.context.getNameForClass(this.irClass);
            Object object = this.className.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"className.makeRef()");
            this.classNameRef = object;
            object = this.irClass.getSuperTypes();
            JsClassGenerator jsClassGenerator = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrType it = (IrType)element$iv;
                boolean bl = false;
                if (!(!JsClassGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail(it)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var10_10 = v0;
        jsClassGenerator.baseClass = var10_10;
        this.baseClassRef$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JsNameRef>(this){
            final /* synthetic */ JsClassGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final JsNameRef invoke() {
                IrType irType = JsClassGenerator.access$getBaseClass$p(this.this$0);
                return irType == null ? null : IrTypeUtilsKt.getClassRef(irType, this.this$0.getContext());
            }
        }));
        this.classPrototypeRef = JsAstUtilsKt.prototypeOf(this.classNameRef);
        this.classBlock = new JsGlobalBlock();
        this.classModel = new JsIrClassModel(this.irClass);
        this.es6mode = this.context.getStaticContext().getBackendContext().getEs6mode();
    }

    @NotNull
    public final JsGenerationContext getContext() {
        return this.context;
    }

    private final JsNameRef getBaseClassRef() {
        Lazy lazy = this.baseClassRef$delegate;
        Object var2_2 = null;
        return (JsNameRef)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsStatement generate() {
        Object object;
        Object object2;
        Object object3;
        IrDeclaration irDeclaration2;
        Iterator iterator2;
        boolean bl;
        boolean bl2 = bl = !this.irClass.isExpect();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!this.es6mode) {
            this.maybeGeneratePrimaryConstructor();
        }
        IrDeclarationToJsTransformer transformer2 = new IrDeclarationToJsTransformer();
        Set properties2 = new LinkedHashSet();
        JsClass jsClass = new JsClass(this.className, null, null, null, 14, null);
        if (this.baseClass != null && !IrTypePredicatesKt.isAny(this.baseClass)) {
            jsClass.setBaseClass(this.getBaseClassRef());
        }
        if (this.es6mode) {
            iterator2 = this.classModel.getPreDeclarationBlock();
            List<JsStatement> list2 = ((JsBlock)((Object)iterator2)).getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"classModel.preDeclarationBlock.statements");
            ((Collection)list2).add(jsClass.makeStmt());
        }
        for (IrDeclaration irDeclaration3 : this.irClass.getDeclarations()) {
            Object object4;
            irDeclaration2 = irDeclaration3;
            if (irDeclaration2 instanceof IrConstructor) {
                List<JsStatement> it;
                if (this.es6mode) {
                    boolean bl3;
                    block16: {
                        object3 = irDeclaration3.accept(new IrFunctionToJsTransformer(), this.context);
                        it = (JsFunction)object3;
                        boolean bl4 = false;
                        object2 = this.baseClass;
                        IrSymbolOwner irSymbolOwner = object2 == null ? null : ((object4 = IrTypesKt.getClassifierOrNull((IrType)object2)) == null ? null : object4.getOwner());
                        Object object5 = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
                        if ((object5 == null ? null : ((IrClass)object5).getSymbol()) == this.getContext().getStaticContext().getBackendContext().getThrowableClass()) {
                            ((JsFunction)((Object)it)).getBody().getStatements().add(0, new JsInvocation((JsExpression)new JsNameRef("super"), new JsExpression[0]).makeStmt());
                        }
                        object5 = ((JsFunction)((Object)it)).getBody().getStatements();
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"it.body.statements");
                        Iterable $this$any$iv = (Iterable)object5;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                JsStatement it2 = (JsStatement)element$iv;
                                boolean bl5 = false;
                                if (!(!(it2 instanceof JsEmpty))) continue;
                                bl3 = true;
                                break block16;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    jsClass.setConstructor((JsFunction)((Object)it));
                    continue;
                }
                object3 = this.classBlock;
                it = ((JsBlock)object3).getStatements();
                Intrinsics.checkNotNullExpressionValue(it, (String)"classBlock.statements");
                ((Collection)it).add(irDeclaration3.accept(transformer2, this.context));
                object3 = this.classModel.getPreDeclarationBlock();
                it = ((JsBlock)object3).getStatements();
                Intrinsics.checkNotNullExpressionValue(it, (String)"classModel.preDeclarationBlock.statements");
                kotlin.collections.CollectionsKt.addAll((Collection)it, (Iterable)this.generateInheritanceCode());
                continue;
            }
            if (irDeclaration2 instanceof IrSimpleFunction) {
                void $this$generate_u24lambda_u2d5_u24lambda_u2d4;
                Object object6;
                Object object7;
                object3 = ((IrSimpleFunction)irDeclaration3).getCorrespondingPropertySymbol();
                CollectionsKt.addIfNotNull(properties2, object3 == null ? null : (IrProperty)object3.getOwner());
                if (this.es6mode) {
                    object3 = this.generateMemberFunction((IrSimpleFunction)irDeclaration3);
                    JsFunction function2 = (JsFunction)object3.component2();
                    JsFunction bl4 = function2;
                    if (bl4 == null) continue;
                    object2 = bl4;
                    Iterator it = object2;
                    boolean bl6 = false;
                    JsClass $this$any$iv = jsClass;
                    object7 = $this$any$iv.getMembers();
                    object7.add(it);
                    continue;
                }
                object3 = this.generateMemberFunction((IrSimpleFunction)irDeclaration3);
                JsNameRef memberRef = (JsNameRef)object3.component1();
                JsFunction function3 = (JsFunction)object3.component2();
                object2 = function3;
                if (object2 == null) continue;
                Object it = object4 = object2;
                boolean bl7 = false;
                object7 = this.classBlock;
                List<JsStatement> list2 = ((JsBlock)object7).getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"classBlock.statements");
                Object object8 = object6 = it;
                JsExpression jsExpression = memberRef;
                Collection collection = list2;
                boolean bl8 = false;
                $this$generate_u24lambda_u2d5_u24lambda_u2d4.setName(null);
                Unit unit2 = Unit.INSTANCE;
                collection.add(JsAstUtilsKt.jsAssignment(jsExpression, (JsExpression)object6).makeStmt());
                continue;
            }
            if (irDeclaration2 instanceof IrClass) {
                object3 = this.classBlock;
                object = ((JsBlock)object3).getStatements();
                Intrinsics.checkNotNullExpressionValue(object, (String)"classBlock.statements");
                ((Collection)object).add(new JsClassGenerator((IrClass)irDeclaration3, this.context).generate());
                continue;
            }
            if (irDeclaration2 instanceof IrField) continue;
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected declaration in class: ", (Object)RenderIrElementKt.render(irDeclaration3)).toString());
        }
        iterator2 = this.classBlock;
        List<JsStatement> list3 = ((JsBlock)((Object)iterator2)).getStatements();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"classBlock.statements");
        ((Collection)list3).add(this.generateClassMetadata());
        if (!(IrUtilsKt.isInterface(this.irClass) || IrUtilsKt.isEnumClass(this.irClass) || IrUtilsKt.isEnumEntry(this.irClass))) {
            for (IrProperty irProperty2 : properties2) {
                irDeclaration2 = irProperty2.getGetter();
                if ((irDeclaration2 == null ? null : ((IrFunction)irDeclaration2).getExtensionReceiverParameter()) != null || ((irDeclaration2 = irProperty2.getSetter()) == null ? null : ((IrFunction)irDeclaration2).getExtensionReceiverParameter()) != null || !Intrinsics.areEqual((Object)irProperty2.getVisibility(), (Object)DescriptorVisibilities.PUBLIC) || irProperty2.isFakeOverride() || !ExportModelGeneratorKt.isExported(this.irClass, this.context.getStaticContext().getBackendContext()) && !((irDeclaration2 = irProperty2.getGetter()) == null ? false : this.overridesExternal((IrSimpleFunction)irDeclaration2)) && AnnotationUtilsKt.getJsName(irProperty2) == null) continue;
                object3 = irProperty2.getGetter();
                JsNameRef getterRef = object3 == null ? null : JsClassGenerator.generate$accessorRef((IrSimpleFunction)object3, this);
                object = irProperty2.getSetter();
                JsNameRef setterRef = object == null ? null : JsClassGenerator.generate$accessorRef((IrSimpleFunction)object, this);
                object = this.classBlock;
                List<JsStatement> list4 = ((JsBlock)object).getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"classBlock.statements");
                Collection collection = list4;
                JsExpression jsExpression = this.classPrototypeRef;
                object2 = this.context.getNameForProperty(irProperty2).getIdent();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.getNameForProperty(property).ident");
                collection.add(new JsExpressionStatement(JsAstUtilsKt.defineProperty(jsExpression, (String)object2, getterRef, setterRef)));
            }
        }
        this.context.getStaticContext().getClassModels().put(this.irClass.getSymbol(), this.classModel);
        return this.classBlock;
    }

    private final boolean overridesExternal(IrSimpleFunction $this$overridesExternal) {
        boolean bl;
        block4: {
            if (IrUtilsKt.isEffectivelyExternal($this$overridesExternal)) {
                return true;
            }
            Iterable $this$any$iv = $this$overridesExternal.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl2 = false;
                    if (!this.overridesExternal((IrSimpleFunction)it.getOwner())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldCopyFrom(IrClass $this$shouldCopyFrom) {
        return IrUtilsKt.isInterface($this$shouldCopyFrom) && !IrUtilsKt.isEffectivelyExternal($this$shouldCopyFrom);
    }

    private final Pair<JsNameRef, JsFunction> generateMemberFunction(IrSimpleFunction declaration2) {
        JsName memberName = this.context.getNameForMemberFunction(IrResolveUtilsKt.getRealOverrideTarget(declaration2));
        JsNameRef memberRef = new JsNameRef(memberName, (JsExpression)this.classPrototypeRef);
        if (AdditionalIrUtilsKt.isReal(declaration2) && declaration2.getBody() != null) {
            boolean bl;
            JsFunction translatedFunction = (JsFunction)declaration2.accept(new IrFunctionToJsTransformer(), this.context);
            boolean bl2 = bl = !IrFunctionKt.isStaticMethodOfClass(declaration2);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return new Pair((Object)memberRef, (Object)translatedFunction);
        }
        if (!IrUtilsKt.isInterface(this.irClass)) {
            Object v1;
            Object object;
            block6: {
                object = IrFakeOverrideUtilsKt.collectRealOverrides$default(declaration2, null, null, 3, null);
                Iterable iterable = object;
                for (Object t : iterable) {
                    IrSimpleFunction it = (IrSimpleFunction)t;
                    boolean bl = false;
                    if (!(it.getModality() != Modality.ABSTRACT)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            IrSimpleFunction irSimpleFunction = v1;
            if (irSimpleFunction != null) {
                Object it = object = irSimpleFunction;
                boolean bl = false;
                IrClass implClassDeclaration = (IrClass)it.getParent();
                if (this.shouldCopyFrom(implClassDeclaration)) {
                    JsName implMethodName = this.getContext().getNameForMemberFunction((IrSimpleFunction)it);
                    JsName implClassName = this.getContext().getNameForClass(implClassDeclaration);
                    JsNameRef jsNameRef = implClassName.makeRef();
                    Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"implClassName.makeRef()");
                    JsNameRef implClassPrototype = JsAstUtilsKt.prototypeOf(jsNameRef);
                    JsNameRef implMemberRef = new JsNameRef(implMethodName, (JsExpression)implClassPrototype);
                    JsGlobalBlock jsGlobalBlock = this.classModel.getPostDeclarationBlock();
                    List<JsStatement> list2 = jsGlobalBlock.getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"classModel.postDeclarationBlock.statements");
                    ((Collection)list2).add(JsAstUtilsKt.jsAssignment(memberRef, implMemberRef).makeStmt());
                }
            }
        }
        return new Pair((Object)memberRef, null);
    }

    private final void maybeGeneratePrimaryConstructor() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.irClass.getDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrConstructor)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            JsFunction func = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(), Intrinsics.stringPlus((String)"Ctor for ", (Object)this.irClass.getName()));
            func.setName(this.className);
            JsGlobalBlock jsGlobalBlock = this.classBlock;
            List<JsStatement> list2 = jsGlobalBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classBlock.statements");
            ((Collection)list2).add(func.makeStmt());
            jsGlobalBlock = this.classModel.getPreDeclarationBlock();
            list2 = jsGlobalBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"classModel.preDeclarationBlock.statements");
            kotlin.collections.CollectionsKt.addAll((Collection)list2, (Iterable)this.generateInheritanceCode());
        }
    }

    private final List<JsStatement> generateInheritanceCode() {
        if (this.baseClass == null || IrTypePredicatesKt.isAny(this.baseClass)) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        JsExpression jsExpression = this.classPrototypeRef;
        JsExpression jsExpression2 = Namer.INSTANCE.getJS_OBJECT_CREATE_FUNCTION();
        Object[] objectArray = new JsExpression[1];
        JsNameRef jsNameRef = this.getBaseClassRef();
        Intrinsics.checkNotNull((Object)jsNameRef);
        objectArray[0] = JsAstUtilsKt.prototypeOf(jsNameRef);
        JsStatement jsStatement = JsAstUtilsKt.jsAssignment(jsExpression, new JsInvocation(jsExpression2, (JsExpression[])objectArray)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"jsAssignment(\n          \u2026!!))\n        ).makeStmt()");
        JsStatement createCall = jsStatement;
        objectArray = JsAstUtilsKt.jsAssignment(new JsNameRef(Namer.INSTANCE.getCONSTRUCTOR_NAME(), (JsExpression)this.classPrototypeRef), this.classNameRef).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"jsAssignment(JsNameRef(N\u2026 classNameRef).makeStmt()");
        Object ctorAssign = objectArray;
        objectArray = new JsStatement[]{createCall, ctorAssign};
        return kotlin.collections.CollectionsKt.listOf((Object[])objectArray);
    }

    private final JsStatement generateClassMetadata() {
        Collection<JsPropertyInitializer> collection;
        JsNode jsNode;
        JsObjectLiteral metadataLiteral = new JsObjectLiteral(true);
        Name simpleName = this.irClass.getName();
        if (!simpleName.isSpecial()) {
            JsPropertyInitializer simpleNameProp = new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_SIMPLE_NAME()), new JsStringLiteral(simpleName.getIdentifier()));
            jsNode = metadataLiteral;
            collection = jsNode.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"metadataLiteral.propertyInitializers");
            collection = collection;
            collection.add(simpleNameProp);
        }
        JsStringLiteral classKind = new JsStringLiteral(IrUtilsKt.isInterface(this.irClass) ? "interface" : (IrUtilsKt.isObject(this.irClass) ? "object" : "class"));
        jsNode = metadataLiteral;
        collection = jsNode.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"metadataLiteral.propertyInitializers");
        collection = collection;
        Object object = new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_CLASS_KIND()), classKind);
        collection.add((JsPropertyInitializer)object);
        jsNode = metadataLiteral;
        collection = jsNode.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"metadataLiteral.propertyInitializers");
        object = this.generateSuperClasses();
        collection.add((JsPropertyInitializer)object);
        jsNode = metadataLiteral;
        collection = jsNode.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"metadataLiteral.propertyInitializers");
        object = this.generateAssociatedKeyProperties();
        kotlin.collections.CollectionsKt.addAll(collection, (Iterable)object);
        if (this.isCoroutineClass()) {
            jsNode = metadataLiteral;
            collection = jsNode.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"metadataLiteral.propertyInitializers");
            object = this.generateSuspendArity();
            collection.add((JsPropertyInitializer)object);
        }
        jsNode = JsAstUtilsKt.jsAssignment(new JsNameRef(Namer.INSTANCE.getMETADATA(), (JsExpression)this.classNameRef), metadataLiteral).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"jsAssignment(JsNameRef(N\u2026tadataLiteral).makeStmt()");
        return jsNode;
    }

    private final boolean isCoroutineClass() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.irClass.getSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isSuspendFunctionTypeOrSubtype(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final JsPropertyInitializer generateSuspendArity() {
        Object object;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Collection<IrSimpleFunction> collection2 = this.context.getStaticContext().getBackendContext().getMapping().getSuspendArityStore().get((IrClass)((IrDeclaration)this.irClass));
        Intrinsics.checkNotNull(collection2);
        Iterable $this$map$iv = collection2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getValueParameters().size();
            collection.add(object);
        }
        $this$map$iv = kotlin.collections.CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            object = new JsIntLiteral(it);
            collection.add(object);
        }
        List arity = (List)destination$iv$iv;
        return new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_SUSPEND_ARITY()), new JsArrayLiteral(arity));
    }

    /*
     * WARNING - void declaration
     */
    private final JsPropertyInitializer generateSuperClasses() {
        List list2;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = this.irClass.getSuperTypes();
        JsExpression jsExpression = new JsNameRef(Namer.INSTANCE.getMETADATA_INTERFACES());
        boolean $i$f$mapNotNull = false;
        void var3_4 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JsNameRef jsNameRef;
            boolean requireInMetadata;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            IrClassSymbol symbol2 = (IrClassSymbol)IrTypesKt.getClassifierOrFail(it);
            boolean isFunctionType = this.isFunctionType(it);
            boolean bl3 = this.getContext().getStaticContext().getBackendContext().getBaseClassIntoMetadata() ? !IrTypePredicatesKt.isAny(it) : (requireInMetadata = JsClassGeneratorKt.access$isInterface(symbol2));
            JsNameRef jsNameRef2 = requireInMetadata && !isFunctionType && !JsClassGeneratorKt.access$isEffectivelyExternal(symbol2) ? new JsNameRef(this.getContext().getNameForClass((IrClass)symbol2.getOwner())) : null;
            if (jsNameRef2 == null) continue;
            JsNameRef it$iv$iv = jsNameRef = jsNameRef2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list2 = (List)destination$iv$iv;
        JsExpression jsExpression2 = new JsArrayLiteral(list3);
        JsExpression jsExpression3 = jsExpression;
        return new JsPropertyInitializer(jsExpression3, jsExpression2);
    }

    private final boolean isFunctionType(IrType $this$isFunctionType) {
        return org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isFunctionOrKFunction($this$isFunctionType) || org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isSuspendFunctionOrKFunction($this$isFunctionType);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsPropertyInitializer> generateAssociatedKeyProperties() {
        void $this$mapNotNullTo$iv$iv;
        List result2 = null;
        result2 = kotlin.collections.CollectionsKt.emptyList();
        Integer n = this.context.getAssociatedObjectKey(this.irClass);
        if (n != null) {
            Integer n2 = n;
            int key = ((Number)n2).intValue();
            boolean bl = false;
            result2 = kotlin.collections.CollectionsKt.plus((Collection)result2, (Object)new JsPropertyInitializer(new JsStringLiteral("associatedObjectKey"), new JsIntLiteral(key)));
        }
        Iterable $this$mapNotNull$iv = this.irClass.getAnnotations();
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JsPropertyInitializer jsPropertyInitializer;
            JsPropertyInitializer jsPropertyInitializer2;
            JsPropertyInitializer jsPropertyInitializer3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            IrConstructorCall annotation2 = (IrConstructorCall)element$iv$iv;
            boolean bl3 = false;
            IrClass annotationClass = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)annotation2.getSymbol().getOwner());
            Integer n3 = this.getContext().getAssociatedObjectKey(annotationClass);
            if (n3 == null) {
                jsPropertyInitializer3 = null;
            } else {
                Integer n4 = n3;
                int key = ((Number)n4).intValue();
                boolean bl4 = false;
                IrClass irClass2 = AnnotationUtilsKt.associatedObject(annotation2);
                if (irClass2 == null) {
                    jsPropertyInitializer3 = null;
                } else {
                    IrClass irClass3;
                    IrClass obj = irClass3 = irClass2;
                    boolean bl5 = false;
                    IrSimpleFunction irSimpleFunction = this.getContext().getStaticContext().getBackendContext().getMapping().getObjectToGetInstanceFunction().get((IrClass)((IrDeclaration)obj));
                    if (irSimpleFunction == null) {
                        jsPropertyInitializer3 = null;
                    } else {
                        IrSimpleFunction irSimpleFunction2;
                        IrSimpleFunction factory2 = irSimpleFunction2 = irSimpleFunction;
                        boolean bl6 = false;
                        jsPropertyInitializer3 = new JsPropertyInitializer(new JsIntLiteral(key), this.getContext().getStaticContext().getNameForStaticFunction(factory2).makeRef());
                    }
                }
            }
            if ((jsPropertyInitializer2 = jsPropertyInitializer3) == null) continue;
            JsPropertyInitializer it$iv$iv = jsPropertyInitializer = jsPropertyInitializer2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List associatedObjects = (List)destination$iv$iv;
        if (!((Collection)associatedObjects).isEmpty()) {
            result2 = kotlin.collections.CollectionsKt.plus((Collection)result2, (Object)new JsPropertyInitializer(new JsStringLiteral("associatedObjects"), new JsObjectLiteral(associatedObjects)));
        }
        return result2;
    }

    private static final JsNameRef generate$accessorRef(IrSimpleFunction $this$generate_u24accessorRef, JsClassGenerator this$0) {
        DescriptorVisibility descriptorVisibility = $this$generate_u24accessorRef.getVisibility();
        return Intrinsics.areEqual((Object)descriptorVisibility, (Object)DescriptorVisibilities.PRIVATE) ? null : new JsNameRef(this$0.context.getNameForMemberFunction($this$generate_u24accessorRef), (JsExpression)this$0.classPrototypeRef);
    }

    public static final /* synthetic */ IrType access$getBaseClass$p(JsClassGenerator $this) {
        return $this.baseClass;
    }
}

