/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KFunctionProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KMutableProperty1Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KMutableProperty2Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KProperty1Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KProperty2Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeParameterProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeParameterState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0018\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KClassState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;)V", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "_constructors", "", "Lkotlin/reflect/KFunction;", "_members", "Lkotlin/reflect/KCallable;", "_supertypes", "", "Lkotlin/reflect/KType;", "_typeParameters", "Lkotlin/reflect/KTypeParameter;", "getClassReference", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrClass", "equals", "", "other", "", "getConstructors", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "getMembers", "getSupertypes", "getTypeParameters", "hashCode", "", "toString", "", "ir.interpreter"})
public final class KClassState
extends ReflectionState {
    @NotNull
    private final IrClass classReference;
    @NotNull
    private final IrClass irClass;
    @Nullable
    private Collection<? extends KCallable<?>> _members;
    @Nullable
    private Collection<? extends KFunction<?>> _constructors;
    @Nullable
    private List<? extends KTypeParameter> _typeParameters;
    @Nullable
    private List<? extends KType> _supertypes;

    public KClassState(@NotNull IrClass classReference, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)classReference, (String)"classReference");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.classReference = classReference;
        this.irClass = irClass2;
    }

    @NotNull
    public final IrClass getClassReference() {
        return this.classReference;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    public KClassState(@NotNull IrClassReference classReference) {
        Intrinsics.checkNotNullParameter((Object)classReference, (String)"classReference");
        IrClass irClass2 = (IrClass)classReference.getSymbol().getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(classReference.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this(irClass2, (IrClass)irClassSymbol.getOwner());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Collection<KCallable<?>> getMembers(@NotNull CallInterceptor callInterceptor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrDeclaration it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._members != null) {
            Collection<? extends KCallable<?>> collection = this._members;
            Intrinsics.checkNotNull(collection);
            return collection;
        }
        Iterable iterable = this.classReference.getDeclarations();
        KClassState kClassState = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof IrClass) && !(it instanceof IrConstructor))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<KCallable> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ReflectionProxy reflectionProxy;
            it = (IrDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrDeclaration irDeclaration2 = it;
            if (irDeclaration2 instanceof IrProperty) {
                IrSimpleFunction irSimpleFunction = ((IrProperty)it).getGetter();
                boolean withExtension = (irSimpleFunction == null ? null : irSimpleFunction.getExtensionReceiverParameter()) != null;
                if (!withExtension && !((IrProperty)it).isVar()) {
                    reflectionProxy = new KProperty1Proxy(new KPropertyState((IrProperty)it, (IrClass)callInterceptor.getIrBuiltIns().getKPropertyClass(false, 1).getOwner(), null, 4, null), callInterceptor);
                } else if (!withExtension && ((IrProperty)it).isVar()) {
                    reflectionProxy = new KMutableProperty1Proxy(new KPropertyState((IrProperty)it, (IrClass)callInterceptor.getIrBuiltIns().getKPropertyClass(true, 1).getOwner(), null, 4, null), callInterceptor);
                } else if (withExtension && !((IrProperty)it).isVar()) {
                    reflectionProxy = new KProperty2Proxy(new KPropertyState((IrProperty)it, (IrClass)callInterceptor.getIrBuiltIns().getKPropertyClass(false, 2).getOwner(), null, 4, null), callInterceptor);
                } else {
                    if (withExtension || !((IrProperty)it).isVar()) throw new NotImplementedError(null, 1, null);
                    reflectionProxy = new KMutableProperty2Proxy(new KPropertyState((IrProperty)it, (IrClass)callInterceptor.getIrBuiltIns().getKPropertyClass(true, 2).getOwner(), null, 4, null), callInterceptor);
                }
            } else {
                if (!(irDeclaration2 instanceof IrFunction)) throw new NotImplementedError(null, 1, null);
                IrClass irClass2 = callInterceptor.getIrBuiltIns().kFunctionN(((IrFunction)it).getValueParameters().size());
                reflectionProxy = new KFunctionProxy(new KFunctionState((IrFunction)it, irClass2, callInterceptor.getEnvironment(), null, 8, null), callInterceptor);
            }
            KCallable kCallable = reflectionProxy;
            collection.add(kCallable);
        }
        collection = (List)destination$iv$iv;
        kClassState._members = collection;
        Collection<? extends KCallable<?>> collection2 = this._members;
        Intrinsics.checkNotNull(collection2);
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<KFunction<?>> getConstructors(@NotNull CallInterceptor callInterceptor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._constructors != null) {
            Collection<? extends KFunction<?>> collection = this._constructors;
            Intrinsics.checkNotNull(collection);
            return collection;
        }
        Iterable iterable = this.classReference.getDeclarations();
        KClassState kClassState = this;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<KFunctionProxy> collection = (List)destination$iv$iv;
        $this$filterIsInstance$iv = collection;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrConstructor irConstructor2 = (IrConstructor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrClass irClass2 = callInterceptor.getIrBuiltIns().kFunctionN(it.getValueParameters().size());
            KFunctionProxy kFunctionProxy = new KFunctionProxy(new KFunctionState((IrFunction)it, irClass2, callInterceptor.getEnvironment(), null, 8, null), callInterceptor);
            collection.add(kFunctionProxy);
        }
        collection = (List)destination$iv$iv;
        kClassState._constructors = collection;
        Collection<? extends KFunction<?>> collection2 = this._constructors;
        Intrinsics.checkNotNull(collection2);
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KTypeParameter> getTypeParameters(@NotNull CallInterceptor callInterceptor) {
        Collection<KTypeParameterProxy> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._typeParameters != null) {
            List<KTypeParameter> list2 = this._typeParameters;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        IrClass kTypeParameterIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeParameterClass$ir_interpreter().getOwner();
        Iterable iterable = this.classReference.getTypeParameters();
        KClassState kClassState = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KTypeParameterProxy kTypeParameterProxy = new KTypeParameterProxy(new KTypeParameterState((IrTypeParameter)it, kTypeParameterIrClass), callInterceptor);
            collection.add(kTypeParameterProxy);
        }
        collection = (List)destination$iv$iv;
        kClassState._typeParameters = collection;
        List<KTypeParameter> list3 = this._typeParameters;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    @NotNull
    public final List<KType> getSupertypes(@NotNull CallInterceptor callInterceptor) {
        KTypeProxy kTypeProxy;
        IrType it;
        Collection<KTypeProxy> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._supertypes != null) {
            List<KType> list2 = this._supertypes;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        IrClass kTypeIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeClass$ir_interpreter().getOwner();
        Iterable iterable = this.classReference.getSuperTypes();
        KClassState kClassState = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType irType = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            kTypeProxy = it;
            collection.add(kTypeProxy);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection, (Object)callInterceptor.getIrBuiltIns().getAnyType()));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            kTypeProxy = new KTypeProxy(new KTypeState(it, kTypeIrClass), callInterceptor);
            collection.add(kTypeProxy);
        }
        collection = (List)destination$iv$iv;
        kClassState._supertypes = collection;
        List<KType> list3 = this._supertypes;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState");
        }
        KClassState cfr_ignored_0 = (KClassState)other;
        return Intrinsics.areEqual((Object)this.classReference, (Object)((KClassState)other).classReference);
    }

    public int hashCode() {
        return this.classReference.hashCode();
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus((String)"class ", (Object)UtilsKt.internalName(this.classReference));
    }
}

