/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.ir.declarations.persistent.carriers

import org.jetbrains.kotlin.ir.declarations.IrClass
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol
import org.jetbrains.kotlin.ir.symbols.IrSymbol

// Auto-generated by compiler/ir/ir.tree.persistent/generator/src/org/jetbrains/kotlin/ir/persistentIrGenerator/Main.kt. DO NOT EDIT!

internal interface EnumEntryCarrier : DeclarationCarrier{
    val correspondingClassField: IrClass?
    val correspondingClassSymbolField: IrClassSymbol?
    val initializerExpressionField: IrExpressionBody?

    override fun clone(): EnumEntryCarrier {
        return EnumEntryCarrierImpl(
            lastModified,
            parentSymbolField,
            originField,
            annotationsField,
            correspondingClassSymbolField,
            initializerExpressionField
        )
    }
}

internal class EnumEntryCarrierImpl(
    override val lastModified: Int,
    override val parentSymbolField: IrSymbol?,
    override val originField: IrDeclarationOrigin,
    override val annotationsField: List<IrConstructorCall>,
    override val correspondingClassSymbolField: IrClassSymbol?,
    override val initializerExpressionField: IrExpressionBody?
) : EnumEntryCarrier {

    override val correspondingClassField: IrClass?
        get() = correspondingClassSymbolField?.owner
}
