/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u0004\u0018\u00010\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"isExportedClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isExportedInterface", "isExportedInterfaceMember", "isExportedMember", "isTheLastReturnStatementIn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnableBlockSymbol;", "backend.js"})
public final class IrJsUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedMember(@NotNull IrDeclaration $this$isExportedMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isExportedMember, (String)"<this>");
        if (!($this$isExportedMember instanceof IrDeclarationWithVisibility)) return false;
        if (!((IrDeclarationWithVisibility)$this$isExportedMember).getVisibility().isPublicAPI()) return false;
        IrClass it = IrUtilsKt.getParentClassOrNull($this$isExportedMember);
        boolean bl = false;
        if (it == null) return false;
        if (!AnnotationUtilsKt.isJsExport(it)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedClass(@Nullable IrDeclaration $this$isExportedClass) {
        if (!($this$isExportedClass instanceof IrClass)) return false;
        ClassKind $this$isClass$iv = ((IrClass)$this$isExportedClass).getKind();
        boolean $i$f$isClass = false;
        if ($this$isClass$iv != ClassKind.CLASS) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!AnnotationUtilsKt.isJsExport($this$isExportedClass)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedInterface(@Nullable IrDeclaration $this$isExportedInterface) {
        if (!($this$isExportedInterface instanceof IrClass)) return false;
        ClassKind $this$isInterface$iv = ((IrClass)$this$isExportedInterface).getKind();
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!AnnotationUtilsKt.isJsExport($this$isExportedInterface)) return false;
        return true;
    }

    public static final boolean isExportedInterfaceMember(@NotNull IrDeclaration $this$isExportedInterfaceMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isExportedInterfaceMember, (String)"<this>");
        return IrJsUtilsKt.isExportedInterface(IrUtilsKt.getParentClassOrNull($this$isExportedInterfaceMember));
    }

    public static final boolean isTheLastReturnStatementIn(@NotNull IrReturn $this$isTheLastReturnStatementIn, @NotNull IrReturnableBlockSymbol target) {
        Intrinsics.checkNotNullParameter((Object)$this$isTheLastReturnStatementIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return CollectionsKt.lastOrNull(((IrReturnableBlock)target.getOwner()).getStatements()) == $this$isTheLastReturnStatementIn;
    }
}

