/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinderKt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "packageDirectory", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "findKotlinClassOrContent", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findMetadata", "hasMetadataPackage", "", "fqName", "decompiler-to-file-stubs"})
public final class DirectoryBasedClassFinder
implements KotlinClassFinder {
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    public DirectoryBasedClassFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkNotNullParameter((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        ClassId classId = JavaElementsKt.getClassId(javaClass);
        Intrinsics.checkNotNull((Object)classId);
        return this.findKotlinClassOrContent(classId);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (!Intrinsics.areEqual((Object)classId.getPackageFqName(), (Object)this.directoryPackageFqName)) {
            return null;
        }
        List<Name> list2 = classId.getRelativeClassName().pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classId.relativeClassName.pathSegments()");
        String targetName = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"$", null, (CharSequence)".class", (int)0, null, null, (int)58, null);
        VirtualFile virtualFile2 = this.packageDirectory.findChild(targetName);
        if (virtualFile2 != null && DirectoryBasedClassFinderKt.access$isKotlinWithCompatibleAbiVersion(virtualFile2)) {
            KotlinClassFinder.Result.KotlinClass kotlinClass;
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = ClsKotlinBinaryClassCache.getKotlinBinaryClass$default(ClsKotlinBinaryClassCache.Companion.getInstance(), virtualFile2, null, 2, null);
            if (kotlinJvmBinaryClass2 != null) {
                KotlinJvmBinaryClass p0 = kotlinJvmBinaryClass2;
                boolean bl = false;
                kotlinClass = new KotlinClassFinder.Result.KotlinClass(p0, null, 2, null);
            } else {
                kotlinClass = null;
            }
            return kotlinClass;
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return null;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return false;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }
}

