/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedArrayValue;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J>\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JN\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010(\"\u0004\b\u0001\u0010'*\u0002H(2\u0006\u0010)\u001a\u00020\u00122\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H'0+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H'0+H\u0082\b\u00a2\u0006\u0002\u0010-R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/AnnotationDeserializer;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "notFoundClasses", "Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializeAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "doesValueConformToExpectedType", "", "result", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value;", "resolveArgument", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument;", "parameterByName", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveValue", "resolveValueAndCheckExpectedType", "letIf", "R", "T", "predicate", "f", "Lkotlin/Function1;", "g", "(Ljava/lang/Object;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "deserialization"})
public final class AnnotationDeserializer {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final NotFoundClasses notFoundClasses;

    public AnnotationDeserializer(@NotNull ModuleDescriptor module2, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"notFoundClasses");
        this.module = module2;
        this.notFoundClasses = notFoundClasses;
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        ClassDescriptor annotationClass = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver2, proto.getId()));
        Map arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"annotationClass.constructors");
            ClassConstructorDescriptor constructor2 = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor2 != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$associateByTo$iv$iv;
                List<ValueParameterDescriptor> list2 = constructor2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"constructor.valueParameters");
                Iterable $this$associateBy$iv = list2;
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getName(), element$iv$iv);
                }
                Map parameterByName2 = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list3 = proto.getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.argumentList");
                Iterable $this$mapNotNull$iv = list3;
                boolean $i$f$mapNotNull = false;
                Iterable capacity$iv22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ProtoBuf.Annotation.Argument it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (this.resolveArgument(it, parameterByName2, nameResolver2) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments2 = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            }
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName2, NameResolver nameResolver2) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName2.get(NameResolverUtilKt.getName(nameResolver2, proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver2, proto.getNameId());
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.type");
        ProtoBuf.Annotation.Argument.Value value2 = proto.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"proto.value");
        return new Pair((Object)name, this.resolveValueAndCheckExpectedType(kotlinType, value2, nameResolver2));
    }

    private final ConstantValue<?> resolveValueAndCheckExpectedType(KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value2, NameResolver nameResolver2) {
        ConstantValue constantValue;
        ConstantValue it = constantValue = this.resolveValue(expectedType, value2, nameResolver2);
        boolean bl = false;
        ConstantValue constantValue2 = this.doesValueConformToExpectedType(it, expectedType, value2) ? constantValue : null;
        if (constantValue2 == null) {
            constantValue2 = ErrorValue.Companion.create("Unexpected argument value: actual type " + value2.getType() + " != expected type " + expectedType);
        }
        return constantValue2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value2, @NotNull NameResolver nameResolver2) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Boolean bl = Flags.IS_UNSIGNED.get(value2.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"IS_UNSIGNED.get(value.flags)");
        boolean isUnsigned = bl;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value2.getType();
        switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                ConstantValue constantValue2;
                AnnotationDeserializer annotationDeserializer = this;
                byte $this$letIf$iv = (byte)value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    byte p0 = $this$letIf$iv;
                    boolean bl2 = false;
                    constantValue2 = new UByteValue(p0);
                } else {
                    byte p0 = $this$letIf$iv;
                    boolean bl3 = false;
                    constantValue2 = new ByteValue(p0);
                }
                constantValue = constantValue2;
                break;
            }
            case 2: {
                constantValue = new CharValue((char)value2.getIntValue());
                break;
            }
            case 3: {
                ConstantValue constantValue3;
                AnnotationDeserializer this_$iv = this;
                short $this$letIf$iv = (short)value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    short p0 = $this$letIf$iv;
                    boolean bl4 = false;
                    constantValue3 = new UShortValue(p0);
                } else {
                    short p0 = $this$letIf$iv;
                    boolean bl5 = false;
                    constantValue3 = new ShortValue(p0);
                }
                constantValue = constantValue3;
                break;
            }
            case 4: {
                ConstantValue constantValue4;
                AnnotationDeserializer this_$iv = this;
                int $this$letIf$iv = (int)value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    int p0 = $this$letIf$iv;
                    boolean bl6 = false;
                    constantValue4 = new UIntValue(p0);
                } else {
                    int p0 = $this$letIf$iv;
                    boolean bl7 = false;
                    constantValue4 = new IntValue(p0);
                }
                constantValue = constantValue4;
                break;
            }
            case 5: {
                ConstantValue constantValue5;
                AnnotationDeserializer this_$iv = this;
                long $this$letIf$iv = value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    long p0 = $this$letIf$iv;
                    boolean bl8 = false;
                    constantValue5 = new ULongValue(p0);
                } else {
                    long p0 = $this$letIf$iv;
                    boolean bl9 = false;
                    constantValue5 = new LongValue(p0);
                }
                constantValue = constantValue5;
                break;
            }
            case 6: {
                constantValue = new FloatValue(value2.getFloatValue());
                break;
            }
            case 7: {
                constantValue = new DoubleValue(value2.getDoubleValue());
                break;
            }
            case 8: {
                constantValue = new BooleanValue(value2.getIntValue() != 0L);
                break;
            }
            case 9: {
                constantValue = new StringValue(nameResolver2.getString(value2.getStringValue()));
                break;
            }
            case 10: {
                constantValue = new KClassValue(NameResolverUtilKt.getClassId(nameResolver2, value2.getClassId()), value2.getArrayDimensionCount());
                break;
            }
            case 11: {
                constantValue = new EnumValue(NameResolverUtilKt.getClassId(nameResolver2, value2.getClassId()), NameResolverUtilKt.getName(nameResolver2, value2.getEnumValueId()));
                break;
            }
            case 12: {
                ProtoBuf.Annotation annotation2 = value2.getAnnotation();
                Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"value.annotation");
                constantValue = new AnnotationValue(this.deserializeAnnotation(annotation2, nameResolver2));
                break;
            }
            case 13: {
                void $this$mapTo$iv$iv;
                List<ProtoBuf.Annotation.Argument.Value> list2 = value2.getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"value.arrayElementList");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable $i$f$letIf = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProtoBuf.Annotation.Argument.Value value3 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl10 = false;
                    SimpleType simpleType2 = this.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"builtIns.anyType");
                    KotlinType kotlinType = simpleType2;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(this.resolveValue(kotlinType, (ProtoBuf.Annotation.Argument.Value)it, nameResolver2));
                }
                KotlinType kotlinType = expectedType;
                List list3 = (List)destination$iv$iv;
                constantValue = new DeserializedArrayValue(list3, kotlinType);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported annotation argument type: " + value2.getType() + " (expected " + expectedType + ')').toString());
            }
        }
        return constantValue;
    }

    private final boolean doesValueConformToExpectedType(ConstantValue<?> result2, KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value2) {
        boolean bl;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value2.getType();
        block0 : switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 10: {
                ClassDescriptor expectedClass;
                ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor = expectedClass = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (expectedClass == null || KotlinBuiltIns.isKClass(expectedClass)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 13: {
                if (!(result2 instanceof ArrayValue && ((List)((ArrayValue)result2).getValue()).size() == value2.getArrayElementList().size())) {
                    boolean $i$a$-check-AnnotationDeserializer$doesValueConformToExpectedType$22 = false;
                    String $i$a$-check-AnnotationDeserializer$doesValueConformToExpectedType$22 = "Deserialized ArrayValue should have the same number of elements as the original array value: " + result2;
                    throw new IllegalStateException($i$a$-check-AnnotationDeserializer$doesValueConformToExpectedType$22.toString());
                }
                KotlinType kotlinType = this.getBuiltIns().getArrayElementType(expectedType);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"builtIns.getArrayElementType(expectedType)");
                KotlinType expectedElementType = kotlinType;
                Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)((Collection)((ArrayValue)result2).getValue()));
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                    break;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    ConstantValue constantValue = (ConstantValue)((List)((ArrayValue)result2).getValue()).get(i);
                    ProtoBuf.Annotation.Argument.Value value3 = value2.getArrayElement(i);
                    Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"value.getArrayElement(i)");
                    if (this.doesValueConformToExpectedType(constantValue, expectedElementType, value3)) continue;
                    bl = false;
                    break block0;
                }
                bl = true;
                break;
            }
            default: {
                bl = Intrinsics.areEqual((Object)result2.getType(this.module), (Object)expectedType);
            }
        }
        return bl;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.Annotation.Argument.Value.Type.values().length];
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CLASS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ENUM.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ARRAY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

