/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.wasm.CompilerKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleFragmentGenerator;
import org.jetbrains.kotlin.backend.wasm.lower.MarkAdditionalExportedDeclarationsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aH\u0010\u0000\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a:\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\u000f\u001a\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018\u001a \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0018\u001a\n\u0010!\u001a\u00020\u0018*\u00020\"\u00a8\u0006#"}, d2={"compileToLoweredIr", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "depsDescriptors", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "propertyLazyInitialization", "", "compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "allModules", "backendContext", "emitNameSection", "allowIncompleteImplementations", "generateWat", "generateJsWasmLoader", "", "wasmFilePath", "externalJs", "writeCompilationResult", "", "result", "dir", "Ljava/io/File;", "fileNameBase", "generateJs", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "backend.wasm"})
public final class CompilerKt {
    @NotNull
    public static final Pair<List<IrModuleFragment>, WasmBackendContext> compileToLoweredIr(@NotNull ModulesStructure depsDescriptors, @NotNull PhaseConfig phaseConfig, @NotNull IrFactory irFactory, @NotNull Set<FqName> exportedDeclarations, boolean propertyLazyInitialization) {
        IrModuleFragment it;
        List list2;
        Intrinsics.checkNotNullParameter((Object)depsDescriptors, (String)"depsDescriptors");
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter(exportedDeclarations, (String)"exportedDeclarations");
        MainModule mainModule = depsDescriptors.getMainModule();
        CompilerConfiguration configuration2 = depsDescriptors.getCompilerConfiguration();
        IrModuleInfo irModuleInfo = KlibKt.loadIr$default(depsDescriptors, irFactory, false, null, true, 8, null);
        IrModuleFragment moduleFragment2 = irModuleInfo.component1();
        List dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker deserializer2 = irModuleInfo.component5();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf((Object)moduleFragment2));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List allModules2 = list2;
        ModuleDescriptor moduleDescriptor = moduleFragment2.getDescriptor();
        WasmBackendContext context = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment2, propertyLazyInitialization, configuration2);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)deserializer2)).generateUnboundSymbolsAsDependencies();
        }
        new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)deserializer2)).generateUnboundSymbolsAsDependencies();
        $this$forEach$iv = allModules2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            PatchDeclarationParentsKt.patchDeclarationParents$default(it, null, 1, null);
        }
        deserializer2.postProcess();
        SymbolTableKt.noUnboundLeft(symbolTable, "Unbound symbols at the end of linker");
        for (IrModuleFragment module2 : allModules2) {
            for (IrFile file2 : module2.getFiles()) {
                MarkAdditionalExportedDeclarationsKt.markExportedDeclarations(context, file2, exportedDeclarations);
            }
        }
        CompilerPhaseKt.invokeToplevel((CompilerPhase)WasmLoweringPhasesKt.getWasmPhases(), phaseConfig, (CommonBackendContext)context, allModules2);
        return new Pair((Object)allModules2, (Object)context);
    }

    public static /* synthetic */ Pair compileToLoweredIr$default(ModulesStructure modulesStructure, PhaseConfig phaseConfig, IrFactory irFactory, Set set, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return CompilerKt.compileToLoweredIr(modulesStructure, phaseConfig, irFactory, set, bl);
    }

    @NotNull
    public static final WasmCompilerResult compileWasm(@NotNull List<? extends IrModuleFragment> allModules2, @NotNull WasmBackendContext backendContext, boolean emitNameSection, boolean allowIncompleteImplementations, boolean generateWat) {
        String string2;
        IrModuleFragment it;
        Intrinsics.checkNotNullParameter(allModules2, (String)"allModules");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        WasmCompiledModuleFragment compiledWasmModule = new WasmCompiledModuleFragment(backendContext.getIrBuiltIns());
        WasmModuleFragmentGenerator codeGenerator = new WasmModuleFragmentGenerator(backendContext, compiledWasmModule, allowIncompleteImplementations);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            codeGenerator.collectInterfaceTables(it);
        }
        $this$forEach$iv = allModules2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            codeGenerator.generateModule(it);
        }
        WasmModule linkedModule = compiledWasmModule.linkWasmCompiledFragments();
        if (generateWat) {
            WasmIrToText watGenerator = new WasmIrToText();
            watGenerator.appendWasmModule(linkedModule);
            string2 = watGenerator.toString();
        } else {
            string2 = null;
        }
        String wat = string2;
        String js = CompilerKt.generateJs(compiledWasmModule);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStream outputStream2 = os;
        String string3 = ((IrModuleFragment)CollectionsKt.last(allModules2)).getDescriptor().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"allModules.last().descriptor.name.asString()");
        new WasmIrToBinary(outputStream2, linkedModule, string3, emitNameSection).appendWasmModule();
        byte[] byteArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byteArray, (String)"byteArray");
        return new WasmCompilerResult(wat, js, byteArray);
    }

    public static /* synthetic */ WasmCompilerResult compileWasm$default(List list2, WasmBackendContext wasmBackendContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return CompilerKt.compileWasm(list2, wasmBackendContext, bl, bl2, bl3);
    }

    @NotNull
    public static final String generateJs(@NotNull WasmCompiledModuleFragment $this$generateJs) {
        Intrinsics.checkNotNullParameter((Object)$this$generateJs, (String)"<this>");
        String runtime = "\nconst externrefBoxes = new WeakMap();";
        String jsCodeBody2 = CollectionsKt.joinToString$default((Iterable)$this$generateJs.getJsFuns(), (CharSequence)",\n", null, null, (int)0, null, (Function1)generateJs.jsCodeBody.1.INSTANCE, (int)30, null);
        String jsCodeBodyIndented = StringsKt.prependIndent((String)jsCodeBody2, (String)"    ");
        String jsCode = "\nconst js_code = {\n" + jsCodeBodyIndented + "\n};\n";
        return runtime + jsCode;
    }

    @NotNull
    public static final String generateJsWasmLoader(@NotNull String wasmFilePath, @NotNull String externalJs) {
        Intrinsics.checkNotNullParameter((Object)wasmFilePath, (String)"wasmFilePath");
        Intrinsics.checkNotNullParameter((Object)externalJs, (String)"externalJs");
        return externalJs + StringsKt.trimIndent((String)("\n    \n    const isNodeJs = (typeof process !== 'undefined') && (process.release.name === 'node');\n    const isD8 = !isNodeJs && (typeof d8 !== 'undefined');\n    const isBrowser = !isNodeJs && !isD8 && (typeof window !== 'undefined');\n    \n    if (!isNodeJs && !isD8 && !isBrowser) {\n      throw \"Supported JS engine not detected\";\n    }\n    \n    let wasmInstance;\n    let require; // Placed here to give access to it from externals (js_code)\n    if (isNodeJs) {\n      const module = await import('node:module');\n      require = module.createRequire(import.meta.url);\n      const fs = require('fs');\n      const path = require('path');\n      const url = require('url');\n      const __dirname = url.fileURLToPath(new URL('.', import.meta.url));\n      const wasmBuffer = fs.readFileSync(path.resolve(__dirname, './" + wasmFilePath + "'));\n      const wasmModule = new WebAssembly.Module(wasmBuffer);\n      wasmInstance = new WebAssembly.Instance(wasmModule, { js_code });\n    }\n    \n    if (isD8) {\n      const wasmBuffer = read('" + wasmFilePath + "', 'binary');\n      const wasmModule = new WebAssembly.Module(wasmBuffer);\n      wasmInstance = new WebAssembly.Instance(wasmModule, { js_code });\n    }\n    \n    if (isBrowser) {\n      wasmInstance = (await WebAssembly.instantiateStreaming(fetch('" + wasmFilePath + "'), { js_code })).instance;\n    }\n    \n    const wasmExports = wasmInstance.exports;\n    wasmExports.__init();\n    export default wasmExports;\n    "));
    }

    public static final void writeCompilationResult(@NotNull WasmCompilerResult result2, @NotNull File dir, @NotNull String fileNameBase) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameBase, (String)"fileNameBase");
        dir.mkdirs();
        if (result2.getWat() != null) {
            FilesKt.writeText$default((File)new File(dir, fileNameBase + ".wat"), (String)result2.getWat(), null, (int)2, null);
        }
        FilesKt.writeBytes((File)new File(dir, fileNameBase + ".wasm"), (byte[])result2.getWasm());
        String jsWithLoader = CompilerKt.generateJsWasmLoader("./" + fileNameBase + ".wasm", result2.getJs());
        FilesKt.writeText$default((File)new File(dir, fileNameBase + ".mjs"), (String)jsWithLoader, null, (int)2, null);
    }

    public static /* synthetic */ void writeCompilationResult$default(WasmCompilerResult wasmCompilerResult, File file2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "index";
        }
        CompilerKt.writeCompilationResult(wasmCompilerResult, file2, string2);
    }
}

