/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "irBuiltins", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "findEqualsMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.wasm"})
public final class BuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrBuiltIns irBuiltins;
    @NotNull
    private final WasmSymbols symbols;

    public BuiltInsLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.irBuiltins = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction findEqualsMethod(IrType $this$findEqualsMethod) {
        IrClass irClass2 = IrTypesKt.getClass($this$findEqualsMethod);
        if (irClass2 == null) {
            irClass2 = (IrClass)this.irBuiltins.getAnyClass().getOwner();
        }
        IrClass klass = irClass2;
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(klass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!MiscKt.isEqualsInheritedFromAny(it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return single$iv;
    }

    @NotNull
    public final IrExpression transformCall(@NotNull IrCall call2, @NotNull DeclarationIrBuilder builder2) {
        IrSimpleFunctionSymbol symbol2;
        block32: {
            block34: {
                block33: {
                    block29: {
                        block31: {
                            block30: {
                                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                                Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                                symbol2 = call2.getSymbol();
                                if (!Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getFloatClass()))) break block29;
                                IrExpression irExpression = call2.getValueArgument(0);
                                Intrinsics.checkNotNull((Object)irExpression);
                                if (org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(irExpression.getType())) break block30;
                                IrExpression irExpression2 = call2.getValueArgument(1);
                                Intrinsics.checkNotNull((Object)irExpression2);
                                if (!org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(irExpression2.getType())) break block31;
                            }
                            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.symbols.getNullableFloatIeee754Equals(), false, false, null, null, 60, null);
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, (IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getFloatType()), false, false, null, null, 60, null);
                    }
                    if (!Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getDoubleClass()))) break block32;
                    IrExpression irExpression = call2.getValueArgument(0);
                    Intrinsics.checkNotNull((Object)irExpression);
                    if (org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(irExpression.getType())) break block33;
                    IrExpression irExpression3 = call2.getValueArgument(1);
                    Intrinsics.checkNotNull((Object)irExpression3);
                    if (!org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(irExpression3.getType())) break block34;
                }
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.symbols.getNullableDoubleIeee754Equals(), false, false, null, null, 60, null);
            }
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, (IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getDoubleType()), false, false, null, null, 60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getEqeqSymbol())) {
            Object newSymbol;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression lhs = irExpression;
            IrExpression irExpression4 = call2.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression4);
            IrExpression rhs = irExpression4;
            IrType lhsType = lhs.getType();
            IrType rhsType = rhs.getType();
            if (Intrinsics.areEqual((Object)lhsType, (Object)rhsType) && (newSymbol = this.symbols.getEqualityFunctions().get(lhsType)) != null) {
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, (IrSimpleFunctionSymbol)newSymbol, false, false, null, null, 60, null);
            }
            if (IrUtilsKt.isNullConst(lhs)) {
                Object $this$transformCall_u24lambda_u241 = newSymbol = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder2, this.symbols.getRefIsNull());
                boolean bl = false;
                ((IrMemberAccessExpression)$this$transformCall_u24lambda_u241).putValueArgument(0, rhs);
                return (IrExpression)newSymbol;
            }
            if (IrUtilsKt.isNullConst(rhs)) {
                Object $this$transformCall_u24lambda_u242 = newSymbol = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder2, this.symbols.getRefIsNull());
                boolean bl = false;
                ((IrMemberAccessExpression)$this$transformCall_u24lambda_u242).putValueArgument(0, lhs);
                return (IrExpression)newSymbol;
            }
            if (!org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(lhsType)) {
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.findEqualsMethod(lhsType).getSymbol(), false, true, null, null, 52, null);
            }
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.symbols.getNullableEquals(), false, false, null, null, 60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getEqeqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrType type2 = irExpression.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getEqualityFunctions().get(type2);
            if (irSimpleFunctionSymbol == null && (irSimpleFunctionSymbol = this.symbols.getFloatEqualityFunctions().get(type2)) == null) {
                irSimpleFunctionSymbol = this.symbols.getRefEq();
            }
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, false, null, null, 60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getCheckNotNullSymbol())) {
            IrCall type2;
            BuiltInsLowering $this$transformCall_u24lambda_u243 = this;
            boolean bl = false;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression arg = irExpression;
            if (IrUtilsKt.isNullConst(arg)) {
                return ExpressionHelpersKt.irCall$default(builder2, $this$transformCall_u24lambda_u243.symbols.getWasmUnreachable(), $this$transformCall_u24lambda_u243.irBuiltins.getNothingType(), 0, 0, null, 28, null);
            }
            IrCall it = type2 = IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.symbols.getEnsureNotNull(), false, false, null, null, 60, null);
            boolean bl2 = false;
            it.putTypeArgument(0, call2.getType());
            return type2;
        }
        if (this.symbols.getComparisonBuiltInsToWasmIntrinsics().keySet().contains(symbol2)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getComparisonBuiltInsToWasmIntrinsics().get(symbol2);
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, false, null, null, 60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getNoWhenBranchMatchedExceptionSymbol())) {
            return ExpressionHelpersKt.irCall$default(builder2, this.symbols.getThrowNoBranchMatchedException(), this.irBuiltins.getNothingType(), 0, 0, null, 28, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getIllegalArgumentExceptionSymbol())) {
            IrCall newSymbol;
            IrCall $this$transformCall_u24lambda_u245 = newSymbol = ExpressionHelpersKt.irCall$default(builder2, this.symbols.getThrowIAE(), this.irBuiltins.getNothingType(), 1, 0, null, 24, null);
            boolean bl = false;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            $this$transformCall_u24lambda_u245.putValueArgument(0, irExpression);
            return newSymbol;
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol()) ? true : Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getDataClassArrayMemberToStringSymbol())) {
            IrCall newSymbol;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression argument2 = irExpression;
            IrType argumentType = argument2.getType();
            IrSimpleFunctionSymbol overloadSymbol = null;
            IrType returnType2 = null;
            if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol())) {
                overloadSymbol = this.symbols.findContentHashCodeOverload(argumentType);
                returnType2 = this.irBuiltins.getIntType();
            } else {
                overloadSymbol = this.symbols.findContentToStringOverload(argumentType);
                returnType2 = this.irBuiltins.getStringType();
            }
            IrCall $this$transformCall_u24lambda_u246 = newSymbol = ExpressionHelpersKt.irCall$default(builder2, overloadSymbol, returnType2, 0, 0, null, 28, null);
            boolean bl = false;
            $this$transformCall_u24lambda_u246.setExtensionReceiver(argument2);
            if (Intrinsics.areEqual((Object)IrTypesKt.getClassOrNull(argumentType), (Object)this.irBuiltins.getArrayClass())) {
                $this$transformCall_u24lambda_u246.putTypeArgument(0, org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.getArrayElementType(argumentType, this.irBuiltins));
            }
            return newSymbol;
        }
        if (this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().contains(symbol2)) {
            int arity = this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().indexOf(symbol2);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.irBuiltins.suspendFunctionN(arity), "invoke");
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, true, null, null, 52, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.symbols.getReflectionSymbols$backend_wasm().getGetClassData())) {
            IrFunctionAccessExpression irFunctionAccessExpression;
            Object object;
            IrConstructorSymbol infoDataCtor = (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(this.symbols.getReflectionSymbols$backend_wasm().getWasmTypeInfoData()));
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType type3 = irType;
            boolean isInterface = IrTypeUtilsKt.isInterface(type3);
            FqName fqName2 = IrTypesKt.getClassFqName(type3);
            Intrinsics.checkNotNull((Object)fqName2);
            FqName fqName3 = fqName2;
            boolean fqnShouldBeEmitted = CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
            if (fqnShouldBeEmitted) {
                object = FqNamesUtilKt.parentOrNull(fqName3);
                if (object == null || (object = ((FqName)object).asString()) == null) {
                    object = "";
                }
            } else {
                object = "";
            }
            String packageName = object;
            String string2 = fqName3.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.shortName().asString()");
            String typeName = string2;
            DeclarationIrBuilder $this$transformCall_u24lambda_u249 = builder2;
            boolean bl = false;
            IrSimpleFunctionSymbol wasmIdGetter = IrTypeUtilsKt.isInterface(type3) ? this.symbols.getWasmInterfaceId() : this.symbols.getWasmClassId();
            IrCall it = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$transformCall_u24lambda_u249, wasmIdGetter);
            boolean bl3 = false;
            it.putTypeArgument(0, type3);
            IrCall typeId = irFunctionAccessExpression;
            it = irFunctionAccessExpression = ExpressionHelpersKt.irCallConstructor($this$transformCall_u24lambda_u249, infoDataCtor, CollectionsKt.emptyList());
            boolean bl4 = false;
            it.putValueArgument(0, typeId);
            it.putValueArgument(1, IrTreeBuildUtilsKt.toIrConst$default(isInterface, $this$transformCall_u24lambda_u249.getContext().getIrBuiltIns().getBooleanType(), 0, 0, 6, null));
            it.putValueArgument(2, IrTreeBuildUtilsKt.toIrConst$default(packageName, $this$transformCall_u24lambda_u249.getContext().getIrBuiltIns().getStringType(), 0, 0, 6, null));
            it.putValueArgument(3, IrTreeBuildUtilsKt.toIrConst$default(typeName, $this$transformCall_u24lambda_u249.getContext().getIrBuiltIns().getStringType(), 0, 0, 6, null));
            return irFunctionAccessExpression;
        }
        return call2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)irFile.getSymbol(), 0, 0, 6, null);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoidWithContext(this, builder2){
            final /* synthetic */ BuiltInsLowering this$0;
            final /* synthetic */ DeclarationIrBuilder $builder;
            {
                this.this$0 = $receiver;
                this.$builder = $builder;
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression newExpression = this.this$0.transformCall(expression2, this.$builder);
                IrElementTransformerVoidKt.transformChildrenVoid(newExpression, this);
                return newExpression;
            }
        });
    }
}

