/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContextBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DataClassMembersGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XJ\u0016\u0010Y\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XJ\u001c\u0010Z\u001a\b\u0012\u0004\u0012\u00020[032\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_J\u001c\u0010`\u001a\b\u0012\u0004\u0012\u00020[032\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_J\u001c\u0010a\u001a\b\u0012\u0004\u0012\u00020[032\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0012\u0010&\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0012\u0010*\u001a\u00020+X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0012\u0010.\u001a\u00020/X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0018\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0012\u00107\u001a\u000208X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0012\u0010;\u001a\u00020<X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0012\u0010?\u001a\u00020@X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0012\u0010C\u001a\u00020DX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0012\u0010G\u001a\u00020HX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0012\u0010K\u001a\u00020LX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0012\u0010O\u001a\u00020PX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bQ\u0010R\u00a8\u0006c"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "converter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "getDelegatedMemberGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "generateDataClassComponentBody", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "generateDataClassCopyBody", "generateDataClassMembers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateMultiFieldValueClassMembers", "generateSingleFieldValueClassMembers", "MyDataClassMethodsGenerator", "fir2ir"})
public final class DataClassMembersGenerator
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents components;

    public DataClassMembersGenerator(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.components.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.components.getExtensions();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.components.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    @NotNull
    public final List<FirDeclaration> generateSingleFieldValueClassMembers(@NotNull FirClass klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_SINGLE_FIELD_VALUE_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    @NotNull
    public final List<FirDeclaration> generateMultiFieldValueClassMembers(@NotNull FirClass klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_MULTI_FIELD_VALUE_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    @NotNull
    public final List<FirDeclaration> generateDataClassMembers(@NotNull FirClass klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    public final void generateDataClassComponentBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)lookupTag2, (String)"lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag2, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateComponentBody(irFunction2);
    }

    public final void generateDataClassCopyBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)lookupTag2, (String)"lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag2, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateCopyBody(irFunction2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0013H\u0002J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020)H\u0002J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00101\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0018\u0010\u0019\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0018\u0010\u001b\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irDataClassMembersGenerator", "org/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1", "Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1;", "getLookupTag", "()Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "matchesDataClassSyntheticMemberSignatures", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "createSyntheticIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "otherParameterNeeded", "createSyntheticIrParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irFunction", "type", "index", "", "generate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "generateComponentBody", "", "generateCopyBody", "generateDispatchReceiverParameter", "fir2ir"})
    private final class MyDataClassMethodsGenerator {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final ConeClassLikeLookupTag lookupTag;
        @NotNull
        private final IrDeclarationOrigin origin;
        @NotNull
        private final irDataClassMembersGenerator.1 irDataClassMembersGenerator;

        public MyDataClassMethodsGenerator(@NotNull IrClass irClass2, @NotNull ConeClassLikeLookupTag lookupTag2, IrDeclarationOrigin origin) {
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)lookupTag2, (String)"lookupTag");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            this.irClass = irClass2;
            this.lookupTag = lookupTag2;
            this.origin = origin;
            IrGeneratorContextBase irGeneratorContextBase = new IrGeneratorContextBase(DataClassMembersGenerator.this.getComponents().getIrBuiltIns());
            SymbolTable symbolTable = DataClassMembersGenerator.this.getComponents().getSymbolTable();
            IrClass irClass3 = this.irClass;
            FqName fqName2 = AdditionalIrUtilsKt.getKotlinFqName(this.irClass);
            IrDeclarationOrigin irDeclarationOrigin = this.origin;
            this.irDataClassMembersGenerator = new org.jetbrains.kotlin.ir.util.DataClassMembersGenerator(DataClassMembersGenerator.this, irGeneratorContextBase, symbolTable, irClass3, fqName2, irDeclarationOrigin){
                final /* synthetic */ DataClassMembersGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, false, false, 96, null);
                }

                @NotNull
                public IrFunction declareSimpleFunction(int startOffset, int endOffset, @NotNull FunctionDescriptor functionDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
                    throw new IllegalStateException("Not expect to see function declaration.");
                }

                public void generateSyntheticFunctionParameterDeclarations(@NotNull IrFunction irFunction2) {
                    Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public IrProperty getProperty(@Nullable ValueParameterDescriptor parameter, @Nullable IrValueParameter irValueParameter) {
                    block6: {
                        block5: {
                            v0 = irValueParameter;
                            if (v0 == null) break block5;
                            it = v0;
                            $i$a$-let-DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1$getProperty$1 = false;
                            $this$single$iv = IrUtilsKt.getProperties(this.getIrClass());
                            $i$f$single = false;
                            single$iv = null;
                            found$iv = false;
                            for (E element$iv : $this$single$iv) {
                                irProperty = (IrProperty)element$iv;
                                $i$a$-single-DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1$getProperty$1$1 = false;
                                if (!Intrinsics.areEqual((Object)irProperty.getName(), (Object)irValueParameter.getName())) ** GOTO lbl-1000
                                v1 = irProperty.getBackingField();
                                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getType() : null), (Object)irValueParameter.getType())) {
                                    v2 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v2 = false;
                                }
                                if (!v2) continue;
                                if (found$iv) {
                                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                                }
                                single$iv = element$iv;
                                found$iv = true;
                            }
                            if (!found$iv) {
                                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                            }
                            v3 = single$iv;
                            break block6;
                        }
                        v3 = null;
                    }
                    return v3;
                }

                @NotNull
                public IrType transform(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                    return this.this$0.getComponents().getIrBuiltIns().getAnyType();
                }

                private final IrSimpleFunctionSymbol getHashCodeFunction(IrClass klass) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
                    Object v0;
                    block7: {
                        Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(klass);
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (E element$iv : $this$singleOrNull$iv) {
                            IrSimpleFunction it = (IrSimpleFunction)element$iv;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)"hashCode") && it.getValueParameters().isEmpty() && it.getExtensionReceiverParameter() == null)) continue;
                            if (found$iv) {
                                v0 = null;
                                break block7;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v0 = !found$iv ? null : single$iv;
                    }
                    IrSimpleFunction irSimpleFunction = v0;
                    if (irSimpleFunction != null && (irSimpleFunctionSymbol2 = irSimpleFunction.getSymbol()) != null) {
                        irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
                    } else {
                        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(this.getContext().getIrBuiltIns().getAnyClass());
                        boolean $i$f$single = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (E element$iv : $this$single$iv) {
                            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"hashCode")) continue;
                            if (found$iv) {
                                throw new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        irSimpleFunctionSymbol = single$iv;
                    }
                    return irSimpleFunctionSymbol;
                }

                @NotNull
                public final IrClass getErasedUpperBound(@NotNull IrTypeParameter $this$erasedUpperBound) {
                    IrClass irClass2;
                    IrSymbolOwner firstSuper;
                    Intrinsics.checkNotNullParameter((Object)$this$erasedUpperBound, (String)"<this>");
                    for (IrType type2 : $this$erasedUpperBound.getSuperTypes()) {
                        Object irClass3;
                        Object object = IrTypesKt.getClassOrNull(type2);
                        if (object == null) continue;
                        if ((object = (IrClass)object.getOwner()) == null || IrUtilsKt.isInterface((IrClass)(irClass3 = object)) || IrUtilsKt.isAnnotationClass((IrClass)irClass3)) continue;
                        return irClass3;
                    }
                    IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)CollectionsKt.first($this$erasedUpperBound.getSuperTypes()));
                    IrSymbolOwner irSymbolOwner = firstSuper = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
                    if (firstSuper instanceof IrClass) {
                        irClass2 = (IrClass)firstSuper;
                    } else if (firstSuper instanceof IrTypeParameter) {
                        irClass2 = this.getErasedUpperBound((IrTypeParameter)firstSuper);
                    } else {
                        throw new IllegalStateException(("unknown supertype kind " + firstSuper).toString());
                    }
                    return irClass2;
                }

                @NotNull
                public DataClassMembersGenerator.HashCodeFunctionInfo getHashCodeFunctionInfo(@NotNull IrType type2) {
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    IrClassifierSymbol classifier2 = IrTypesKt.getClassifierOrNull(type2);
                    if (this.isArrayOrPrimitiveArray(classifier2)) {
                        irSimpleFunctionSymbol = this.getContext().getIrBuiltIns().getDataClassArrayMemberHashCodeSymbol();
                    } else if (classifier2 instanceof IrClassSymbol) {
                        irSimpleFunctionSymbol = this.getHashCodeFunction((IrClass)((IrClassSymbol)classifier2).getOwner());
                    } else if (classifier2 instanceof IrTypeParameterSymbol) {
                        irSimpleFunctionSymbol = this.getHashCodeFunction(this.getErasedUpperBound((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()));
                    } else {
                        throw new IllegalStateException(("Unknown classifier kind " + classifier2).toString());
                    }
                    IrSimpleFunctionSymbol symbol2 = irSimpleFunctionSymbol;
                    return new irDataClassMembersGenerator.Fir2IrHashCodeFunctionInfo(this, symbol2);
                }
            };
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final ConeClassLikeLookupTag getLookupTag() {
            return this.lookupTag;
        }

        @NotNull
        public final IrDeclarationOrigin getOrigin() {
            return this.origin;
        }

        @NotNull
        public final IrValueParameter generateDispatchReceiverParameter(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            return ConversionUtilsKt.declareThisReceiverParameter$default(DataClassMembersGenerator.this, irFunction2, IrUtilsKt.getDefaultType(this.irClass), this.origin, -1, -1, null, 32, null);
        }

        private final boolean getMatchesEqualsSignature(FirSimpleFunction $this$matchesEqualsSignature) {
            return $this$matchesEqualsSignature.getValueParameters().size() == 1 && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getValueParameters().get(0).getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyNType()) && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType());
        }

        private final boolean getMatchesHashCodeSignature(FirSimpleFunction $this$matchesHashCodeSignature) {
            return $this$matchesHashCodeSignature.getValueParameters().isEmpty() && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesHashCodeSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType());
        }

        private final boolean getMatchesToStringSignature(FirSimpleFunction $this$matchesToStringSignature) {
            return $this$matchesToStringSignature.getValueParameters().isEmpty() && Intrinsics.areEqual((Object)Fir2IrTypeConverterKt.toIrType$default($this$matchesToStringSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), (Object)DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType());
        }

        private final boolean getMatchesDataClassSyntheticMemberSignatures(FirSimpleFunction $this$matchesDataClassSyntheticMemberSignatures) {
            return Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)OperatorNameConventions.EQUALS) && this.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)StandardNames.HASHCODE_NAME) && this.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)$this$matchesDataClassSyntheticMemberSignatures.getName(), (Object)OperatorNameConventions.TO_STRING) && this.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
        }

        @NotNull
        public final List<FirDeclaration> generate(@NotNull FirClass klass) {
            FirSimpleFunction toStringContributedFunction;
            FirSimpleFunction hashcodeNameContributedFunction;
            Map $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Object object = IrUtilsKt.getPrimaryConstructor(this.irClass);
            int propertyParametersCount = object != null && (object = IrUtilsKt.getExplicitParameters((IrFunction)object)) != null ? object.size() : 0;
            List properties2 = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.filter(IrUtilsKt.getProperties(this.irClass), (Function1)generate.properties.1.INSTANCE), (int)propertyParametersCount));
            List result2 = new ArrayList();
            Iterable $this$mapNotNull$iv = klass.getDeclarations();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Object[] $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirDeclaration it = (FirDeclaration)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof FirSimpleFunction && this.getMatchesDataClassSyntheticMemberSignatures((FirSimpleFunction)it) ? ((FirSimpleFunction)it).getName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List contributedFunctionsInThisType = (List)destination$iv$iv;
            FirTypeScope scope2 = FirKotlinScopeProviderKt.unsubstitutedScope(klass, DataClassMembersGenerator.this.getComponents().getSession(), DataClassMembersGenerator.this.getComponents().getScopeSession(), true);
            Map $this$generate_u24lambda_u241 = $this$mapNotNullTo$iv$iv = MapsKt.createMapBuilder();
            boolean bl = false;
            $this$forEach$iv$iv$iv = new Name[]{OperatorNameConventions.EQUALS, StandardNames.HASHCODE_NAME, OperatorNameConventions.TO_STRING};
            for (Name name : CollectionsKt.listOf((Object[])$this$forEach$iv$iv$iv)) {
                if (contributedFunctionsInThisType.contains(name)) continue;
                scope2.processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(this, (Map<Name, FirSimpleFunction>)$this$generate_u24lambda_u241){
                    final /* synthetic */ MyDataClassMethodsGenerator this$0;
                    final /* synthetic */ Map<Name, FirSimpleFunction> $this_buildMap;
                    {
                        this.this$0 = $receiver;
                        this.$this_buildMap = $receiver2;
                        super(1);
                    }

                    public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FirSimpleFunction declaration = (FirSimpleFunction)it.getFir();
                        if (MyDataClassMethodsGenerator.access$getMatchesDataClassSyntheticMemberSignatures(this.this$0, declaration)) {
                            FirMemberDeclaration $this$modality$iv = declaration;
                            boolean $i$f$getModality = false;
                            if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
                                this.$this_buildMap.putIfAbsent(declaration.getName(), declaration);
                            }
                        }
                    }
                }));
            }
            Map contributedFunctionsInSupertypes2 = MapsKt.build((Map)$this$mapNotNullTo$iv$iv);
            FirSimpleFunction equalsContributedFunction = (FirSimpleFunction)contributedFunctionsInSupertypes2.get(OperatorNameConventions.EQUALS);
            if (equalsContributedFunction != null) {
                result2.add(equalsContributedFunction);
                IrFunction equalsFunction = this.createSyntheticIrFunction(OperatorNameConventions.EQUALS, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType(), true);
                this.irDataClassMembersGenerator.generateEqualsMethod(equalsFunction, properties2);
                this.irClass.getDeclarations().add(equalsFunction);
            }
            if ((hashcodeNameContributedFunction = (FirSimpleFunction)contributedFunctionsInSupertypes2.get(StandardNames.HASHCODE_NAME)) != null) {
                result2.add(hashcodeNameContributedFunction);
                IrFunction hashCodeFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, StandardNames.HASHCODE_NAME, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType(), false, 4, null);
                this.irDataClassMembersGenerator.generateHashCodeMethod(hashCodeFunction, properties2);
                this.irClass.getDeclarations().add(hashCodeFunction);
            }
            if ((toStringContributedFunction = (FirSimpleFunction)contributedFunctionsInSupertypes2.get(OperatorNameConventions.TO_STRING)) != null) {
                result2.add(toStringContributedFunction);
                IrFunction toStringFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, OperatorNameConventions.TO_STRING, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType(), false, 4, null);
                this.irDataClassMembersGenerator.generateToStringMethod(toStringFunction, properties2);
                this.irClass.getDeclarations().add(toStringFunction);
            }
            return result2;
        }

        public final void generateComponentBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            String string2 = irFunction2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irFunction.name.asString()");
            int index2 = DataClassResolver.INSTANCE.getComponentIndex(string2);
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull((Object)irConstructor2);
            IrValueParameter valueParameter2 = irConstructor2.getValueParameters().get(index2 - 1);
            IrProperty irProperty2 = this.irDataClassMembersGenerator.getProperty(null, valueParameter2);
            Intrinsics.checkNotNull((Object)irProperty2);
            IrProperty irProperty3 = irProperty2;
            this.irDataClassMembersGenerator.generateComponentFunction(irFunction2, irProperty3);
        }

        public final void generateCopyBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull((Object)irConstructor2);
            this.irDataClassMembersGenerator.generateCopyFunction(irFunction2, irConstructor2.getSymbol());
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction createSyntheticIrFunction(Name name, IrType returnType2, boolean otherParameterNeeded) {
            IrSimpleFunction irSimpleFunction;
            block8: {
                void $this$toTypedArray$iv;
                Collection<ConeStarProjection> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                void $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242;
                Object object;
                FirTypeRef firTypeRef;
                DataClassMembersGenerator dataClassMembersGenerator = DataClassMembersGenerator.this;
                boolean $i$f$buildSimpleFunction = false;
                Object object2 = new FirSimpleFunctionBuilder();
                FirSimpleFunctionBuilder $this$createSyntheticIrFunction_u24lambda_u244 = object2;
                boolean bl = false;
                $this$createSyntheticIrFunction_u24lambda_u244.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                $this$createSyntheticIrFunction_u24lambda_u244.setName(name);
                $this$createSyntheticIrFunction_u24lambda_u244.setSymbol(new FirNamedFunctionSymbol(new CallableId(this.lookupTag.getClassId(), name)));
                $this$createSyntheticIrFunction_u24lambda_u244.setStatus(new FirDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL));
                $this$createSyntheticIrFunction_u24lambda_u244.setModuleData(FirModuleDataKt.getModuleData(dataClassMembersGenerator.getComponents().getSession()));
                IrType irType = returnType2;
                if (Intrinsics.areEqual((Object)irType, (Object)dataClassMembersGenerator.getComponents().getIrBuiltIns().getBooleanType())) {
                    firTypeRef = new FirImplicitBooleanTypeRef(null);
                } else if (Intrinsics.areEqual((Object)irType, (Object)dataClassMembersGenerator.getComponents().getIrBuiltIns().getIntType())) {
                    firTypeRef = new FirImplicitIntTypeRef(null);
                } else if (Intrinsics.areEqual((Object)irType, (Object)dataClassMembersGenerator.getComponents().getIrBuiltIns().getStringType())) {
                    firTypeRef = new FirImplicitStringTypeRef(null);
                } else {
                    throw new IllegalStateException(("Unexpected synthetic data class function return type: " + returnType2).toString());
                }
                $this$createSyntheticIrFunction_u24lambda_u244.setReturnTypeRef(firTypeRef);
                if (otherParameterNeeded) {
                    FirValueParameterBuilder firValueParameterBuilder;
                    boolean $i$f$buildValueParameter = false;
                    FirValueParameterBuilder firValueParameterBuilder2 = firValueParameterBuilder = new FirValueParameterBuilder();
                    object = $this$createSyntheticIrFunction_u24lambda_u244.getValueParameters();
                    boolean bl2 = false;
                    Name name2 = Name.identifier("other");
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"other\")");
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setName(name2);
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setModuleData(FirModuleDataKt.getModuleData(dataClassMembersGenerator.getComponents().getSession()));
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setReturnTypeRef(new FirImplicitNullableAnyTypeRef(null));
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setSymbol(new FirValueParameterSymbol($this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.getName()));
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setCrossinline(false);
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setNoinline(false);
                    $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242.setVararg(false);
                    object.add(firValueParameterBuilder.build());
                }
                Iterable $i$f$buildValueParameter = (Iterable)new IntRange(1, this.irClass.getTypeParameters().size());
                ConeClassifierLookupTag coneClassifierLookupTag = this.lookupTag;
                object = $this$createSyntheticIrFunction_u24lambda_u244;
                boolean $i$f$map = false;
                $this$createSyntheticIrFunction_u24lambda_u244_u24lambda_u242 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(ConeStarProjection.INSTANCE);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ConeStarProjection[] coneStarProjectionArray = thisCollection$iv.toArray(new ConeStarProjection[0]);
                Intrinsics.checkNotNull((Object)coneStarProjectionArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                ((FirSimpleFunctionBuilder)object).setDispatchReceiverType(TypeConstructionUtilsKt.constructType$default(coneClassifierLookupTag, coneStarProjectionArray, false, null, 4, null));
                FirSimpleFunction firFunction = ((FirSimpleFunctionBuilder)object2).build();
                IdSignature signature2 = this.lookupTag.getClassId().isLocal() ? null : Fir2IrSignatureComposer.DefaultImpls.composeSignature$default(DataClassMembersGenerator.this.getComponents().getSignatureComposer(), firFunction, null, false, 6, null);
                irSimpleFunction = DataClassMembersGenerator.this.getComponents().getDeclarationStorage().declareIrSimpleFunction$fir2ir(signature2, null, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(DataClassMembersGenerator.this, this, name, returnType2, otherParameterNeeded, firFunction){
                    final /* synthetic */ DataClassMembersGenerator this$0;
                    final /* synthetic */ MyDataClassMethodsGenerator this$1;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ IrType $returnType;
                    final /* synthetic */ boolean $otherParameterNeeded;
                    final /* synthetic */ FirSimpleFunction $firFunction;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$name = $name;
                        this.$returnType = $returnType;
                        this.$otherParameterNeeded = $otherParameterNeeded;
                        this.$firFunction = $firFunction;
                        super(1);
                    }

                    @NotNull
                    public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol symbol2) {
                        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                        IrFactory irFactory = this.this$0.getComponents().getIrFactory();
                        IrDeclarationOrigin irDeclarationOrigin = this.this$1.getOrigin();
                        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
                        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
                        IrSimpleFunction irSimpleFunction = IrFactory.DefaultImpls.createFunction$default(irFactory, -1, -1, irDeclarationOrigin, symbol2, this.$name, descriptorVisibility, Modality.OPEN, this.$returnType, false, false, false, false, false, false, false, false, null, 65536, null);
                        boolean bl = this.$otherParameterNeeded;
                        MyDataClassMethodsGenerator myDataClassMethodsGenerator = this.this$1;
                        FirSimpleFunction firSimpleFunction = this.$firFunction;
                        DataClassMembersGenerator dataClassMembersGenerator = this.this$0;
                        IrSimpleFunction $this$invoke_u24lambda_u240 = irSimpleFunction;
                        boolean bl2 = false;
                        if (bl) {
                            IrValueParameter irValueParameter = MyDataClassMethodsGenerator.createSyntheticIrParameter$default(myDataClassMethodsGenerator, $this$invoke_u24lambda_u240, ((FirValueParameter)CollectionsKt.first(firSimpleFunction.getValueParameters())).getName(), dataClassMembersGenerator.getComponents().getIrBuiltIns().getAnyNType(), 0, 8, null);
                            $this$invoke_u24lambda_u240.setValueParameters(CollectionsKt.listOf((Object)irValueParameter));
                        }
                        $this$invoke_u24lambda_u240.setMetadata(new FirMetadataSource.Function(firSimpleFunction));
                        return irSimpleFunction;
                    }
                }));
                object2 = DataClassMembersGenerator.this;
                IrSimpleFunction $this$createSyntheticIrFunction_u24lambda_u246 = irSimpleFunction;
                boolean bl4 = false;
                $this$createSyntheticIrFunction_u24lambda_u246.setParent(this.irClass);
                $this$createSyntheticIrFunction_u24lambda_u246.setDispatchReceiverParameter(this.generateDispatchReceiverParameter($this$createSyntheticIrFunction_u24lambda_u246));
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)CollectionsKt.singleOrNull(((DataClassMembersGenerator)object2).getComponents().getIrBuiltIns().findBuiltInClassMemberFunctions(((DataClassMembersGenerator)object2).getComponents().getIrBuiltIns().getAnyClass(), $this$createSyntheticIrFunction_u24lambda_u246.getName()));
                if (irSimpleFunctionSymbol == null) break block8;
                IrSimpleFunctionSymbol it = irSimpleFunctionSymbol;
                boolean bl5 = false;
                $this$createSyntheticIrFunction_u24lambda_u246.setOverriddenSymbols(CollectionsKt.listOf((Object)it));
            }
            return irSimpleFunction;
        }

        static /* synthetic */ IrFunction createSyntheticIrFunction$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, Name name, IrType irType, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return myDataClassMethodsGenerator.createSyntheticIrFunction(name, irType, bl);
        }

        private final IrValueParameter createSyntheticIrParameter(IrFunction irFunction2, Name name, IrType type2, int index2) {
            IrValueParameter irValueParameter;
            IrValueParameter $this$createSyntheticIrParameter_u24lambda_u247 = irValueParameter = DataClassMembersGenerator.this.getComponents().getIrFactory().createValueParameter(-1, -1, this.origin, new IrValueParameterSymbolImpl(null, 1, null), name, index2, type2, null, false, false, false, false);
            boolean bl = false;
            $this$createSyntheticIrParameter_u24lambda_u247.setParent(irFunction2);
            return irValueParameter;
        }

        static /* synthetic */ IrValueParameter createSyntheticIrParameter$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, IrFunction irFunction2, Name name, IrType irType, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            return myDataClassMethodsGenerator.createSyntheticIrParameter(irFunction2, name, irType, n);
        }

        public static final /* synthetic */ boolean access$getMatchesDataClassSyntheticMemberSignatures(MyDataClassMethodsGenerator $this, FirSimpleFunction $receiver) {
            return $this.getMatchesDataClassSyntheticMemberSignatures($receiver);
        }
    }
}

