/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\f*\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/EnumEntryVsCompanionPriorityCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "containsEntryWithName", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "isQualifierFor", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "classDescriptor", "frontend"})
public final class EnumEntryVsCompanionPriorityCallChecker
implements CallChecker {
    @NotNull
    public static final EnumEntryVsCompanionPriorityCallChecker INSTANCE = new EnumEntryVsCompanionPriorityCallChecker();

    private EnumEntryVsCompanionPriorityCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        Name name = ((PropertyDescriptor)descriptor2).getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"descriptor.name");
        Name propertyName = name;
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        if (!(containingDescriptor instanceof ClassDescriptor) || !((ClassDescriptor)containingDescriptor).isCompanionObject()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)containingDescriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"containingDescriptor.containingDeclaration");
        DeclarationDescriptor grandParent = declarationDescriptor2;
        if (grandParent instanceof ClassDescriptor && ((ClassDescriptor)grandParent).getKind() == ClassKind.ENUM_CLASS && this.containsEntryWithName((ClassDescriptor)grandParent, propertyName) && this.isQualifierFor(resolvedCall2.getDispatchReceiver(), (ClassDescriptor)grandParent)) {
            context.getResolutionContext().trace.report(Errors.DEPRECATED_ACCESS_TO_ENUM_COMPANION_PROPERTY.on(reportOn, (PropertyDescriptor)descriptor2));
        }
    }

    private final boolean containsEntryWithName(ClassDescriptor $this$containsEntryWithName, Name name) {
        ClassifierDescriptor foundDescriptor = $this$containsEntryWithName.getUnsubstitutedMemberScope().getContributedClassifier(name, NoLookupLocation.FOR_ALREADY_TRACKED);
        return foundDescriptor instanceof ClassDescriptor && ((ClassDescriptor)foundDescriptor).getKind() == ClassKind.ENUM_ENTRY;
    }

    private final boolean isQualifierFor(ReceiverValue $this$isQualifierFor, ClassDescriptor classDescriptor) {
        if (!($this$isQualifierFor instanceof ClassValueReceiver)) {
            return false;
        }
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ClassValueReceiver)$this$isQualifierFor).getClassQualifier().getDescriptor();
        ClassDescriptor classDescriptor2 = classifierDescriptorWithTypeParameters instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptorWithTypeParameters : null;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor thisClass = classDescriptor2;
        return Intrinsics.areEqual((Object)thisClass.getTypeConstructor(), (Object)classDescriptor.getTypeConstructor());
    }
}

