/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.CompilationException;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.dce.DceKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalNextRoundChecker;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.LoweredIr;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.WholeWorldStageController;
import org.jetbrains.kotlin.ir.backend.js.codegen.JsGenerationGranularity;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheUpdater;
import org.jetbrains.kotlin.ir.backend.js.ic.DirtyFileState;
import org.jetbrains.kotlin.ir.backend.js.ic.JsExecutableProducer;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinLibraryFile;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFile;
import org.jetbrains.kotlin.ir.backend.js.ic.ModuleArtifact;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformerTmp;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SourceMapsInfo;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslationMode;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.AbstractIrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImplForJsIC;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0014\u0010\u001e\u001a\u00020\u0019*\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "addPlatformOptions", "", "write", "Ljava/io/File;", "outputs", "Lorg/jetbrains/kotlin/ir/backend/js/CompilationOutputs;", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonCompilerPerformanceManager defaultPerformanceManager = new CommonCompilerPerformanceManager(){};
    @NotNull
    private static final Map<String, ModuleKind> moduleKindMap;
    @NotNull
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;

    @Override
    @NotNull
    public CommonCompilerPerformanceManager getDefaultPerformanceManager() {
        return this.defaultPerformanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration2, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        List<ModuleArtifact> list2;
        Object msg2;
        Object srcFiles;
        CharSequence charSequence2;
        Unit unit2;
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (configuration2.getBoolean(CommonConfigurationKeys.USE_FIR)) {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "K2 does not support JS target right now", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration2);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (arguments2.getScript()) {
            Object v2;
            KotlinCoreEnvironment.ProjectEnvironment projectEnv;
            block56: {
                if (!arguments2.getEnableJsScripting()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                configuration2.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration2);
                projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment, configuration2);
                projectEnv.registerExtensionsFromPlugins(configuration2);
                MockProject mockProject = projectEnv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnv.project");
                List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances(mockProject);
                Iterable iterable = scriptingEvaluators;
                for (Object t : iterable) {
                    ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                    boolean bl = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v2 = t;
                    break block56;
                }
                v2 = null;
            }
            ScriptEvaluationExtension scriptingEvaluator = v2;
            if (scriptingEvaluator == null) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return scriptingEvaluator.eval(arguments2, configuration2, projectEnv);
        }
        if (arguments2.getFreeArgs().isEmpty() && !UtilsKt.incrementalCompilationIsEnabledForJs(arguments2)) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            CharSequence environment = arguments2.getIncludes();
            if (environment == null || environment.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        List libraries = CollectionsKt.plus((Collection)K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries()), (Iterable)CollectionsKt.listOfNotNull((Object)arguments2.getIncludes()));
        List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
        List repositories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getRepositries());
        configuration2.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration2.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        configuration2.put(JSConfigurationKeys.REPOSITORIES, repositories);
        configuration2.put(JSConfigurationKeys.PARTIAL_LINKAGE, arguments2.getPartialLinkage());
        configuration2.put(JSConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS, arguments2.getWasmEnableArrayRangeChecks());
        configuration2.put(JSConfigurationKeys.WASM_ENABLE_ASSERTS, arguments2.getWasmEnableAsserts());
        Object[] commonSourcesArray = arguments2.getCommonSources();
        Object object = commonSourcesArray;
        if (commonSourcesArray == null || (object = ArraysKt.toSet((Object[])object)) == null) {
            object = SetsKt.emptySet();
        }
        Object commonSources = object;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration2, arg, commonSources.contains(arg));
        }
        Object[] objectArray = arguments2.getRelativePathBases();
        if (objectArray != null) {
            Object[] it = objectArray;
            boolean bl = false;
            configuration2.put(CommonConfigurationKeys.KLIB_RELATIVE_PATH_BASES, ArraysKt.toList((Object[])it));
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        configuration2.put(CommonConfigurationKeys.KLIB_NORMALIZE_ABSOLUTE_PATH, arguments2.getNormalizeAbsolutePath());
        configuration2.put(CommonConfigurationKeys.PRODUCE_KLIB_SIGNATURES_CLASH_CHECKS, arguments2.getEnableSignatureClashChecks());
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project projectJs = environmentForJS.getProject();
        CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        configurationJs.put(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME, arguments2.getRenderInternalDiagnosticNames());
        configurationJs.put(JSConfigurationKeys.PROPERTY_LAZY_INITIALIZATION, arguments2.getIrPropertyLazyInitialization());
        configurationJs.put(JSConfigurationKeys.GENERATE_INLINE_ANONYMOUS_FUNCTIONS, arguments2.getIrGenerateInlineAnonymousFunctions());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS.getConfiguration(), (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !UtilsKt.incrementalCompilationIsEnabledForJs(arguments2) && ((charSequence2 = (CharSequence)arguments2.getIncludes()) == null || charSequence2.length() == 0)) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        String string2 = arguments2.getIrModuleName();
        if (string2 == null) {
            String string3 = FileUtil.getNameWithoutExtension(outputFile);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(outputFile)");
        }
        String moduleName = string2;
        configurationJs.put(CommonConfigurationKeys.MODULE_NAME, moduleName);
        JsConfig config = new JsConfig(projectJs, configurationJs, CompilerEnvironment.INSTANCE);
        File file2 = outputFile.getParentFile();
        if (file2 == null) {
            File file3 = outputFile.getAbsoluteFile().getParentFile();
            file2 = file3;
            Intrinsics.checkNotNull((Object)file3);
        }
        File outputDir2 = file2;
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual((Object)"noCall", (Object)arguments2.getMain()) ? null : CollectionsKt.emptyList();
        List cacheDirectories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getCacheDirectories());
        if (!((Collection)cacheDirectories).isEmpty()) {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "", null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Building cache:", null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "to: " + outputFilePath, null, 4, null);
            String string4 = arguments2.getCacheDirectories();
            if (string4 == null) {
                string4 = "";
            }
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, string4, null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, libraries.toString(), null, 4, null);
            long start = System.currentTimeMillis();
            String string5 = arguments2.getIncludes();
            Intrinsics.checkNotNull((Object)string5);
            CacheUpdater cacheUpdater2 = new CacheUpdater(string5, libraries, cacheDirectories, configurationJs, (Function0<? extends IrFactory>)((Function0)doExecute.icCaches.cacheUpdater.1.INSTANCE), mainCallArguments, doExecute.icCaches.cacheUpdater.2.INSTANCE);
            Ref.LongRef tp = new Ref.LongRef();
            tp.element = System.currentTimeMillis();
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC cache updater initialization: " + (tp.element - start) + "ms", null, 4, null);
            List<ModuleArtifact> artifacts2 = cacheUpdater2.actualizeCaches((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(messageCollector2, tp){
                final /* synthetic */ MessageCollector $messageCollector;
                final /* synthetic */ Ref.LongRef $tp;
                {
                    this.$messageCollector = $messageCollector;
                    this.$tp = $tp;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    long now = System.currentTimeMillis();
                    MessageCollector.DefaultImpls.report$default(this.$messageCollector, CompilerMessageSeverity.INFO, "IC " + it + ": " + (now - this.$tp.element) + "ms", null, 4, null);
                    this.$tp.element = now;
                }
            }));
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC rebuilt overall time: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            for (Map.Entry entry : ((Map)cacheUpdater2.getDirtyFileStats()).entrySet()) {
                boolean bl;
                String libFile;
                block57: {
                    libFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                    srcFiles = (Map)entry.getValue();
                    Iterable $this$all$iv = srcFiles.values();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            EnumSet it = (EnumSet)element$iv;
                            boolean bl2 = false;
                            if (it.contains((Object)DirtyFileState.ADDED_FILE)) continue;
                            bl = false;
                            break block57;
                        }
                        bl = true;
                    }
                }
                boolean bl2 = bl;
                msg2 = bl2 ? "fully rebuilt" : "partially rebuilt";
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "module [" + new File(libFile).getName() + "] was " + msg2, null, 4, null);
                if (bl2) continue;
                for (Map.Entry entry2 : srcFiles.entrySet()) {
                    String srcFile = ((KotlinSourceFile)entry2.getKey()).unbox-impl();
                    EnumSet stat = (EnumSet)entry2.getValue();
                    String statStr2 = CollectionsKt.joinToString$default((Iterable)stat, null, null, null, (int)0, null, (Function1)doExecute.icCaches.statStr.1.INSTANCE, (int)31, null);
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "  file [" + new File(srcFile).getName() + "]: (" + statStr2 + ')', null, 4, null);
                }
            }
            list2 = artifacts2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List<ModuleArtifact> icCaches2 = list2;
        ModulesStructure sourceModule = null;
        String includes = arguments2.getIncludes();
        if (includes == null) {
            AnalysisResult result2;
            do {
                List<KtFile> list3 = environmentForJS.getSourceFiles();
                CompilerConfiguration compilerConfiguration = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"config.configuration");
                sourceModule = KlibKt.prepareAnalyzedSourceModule$default(projectJs, list3, configurationJs, libraries, friendLibraries, new AnalyzerWithCompilerReport(compilerConfiguration), null, 64, null);
                ModulesStructure modulesStructure = sourceModule;
                if (modulesStructure == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sourceModule");
                    modulesStructure = null;
                }
                if (!((result2 = modulesStructure.getJsFrontEndResult().getJsAnalysisResult()) instanceof JsAnalysisResult.RetryWithAdditionalRoots)) continue;
                environmentForJS.addKotlinSourceRoots(((JsAnalysisResult.RetryWithAdditionalRoots)result2).getAdditionalKotlinRoots());
            } while (result2 instanceof JsAnalysisResult.RetryWithAdditionalRoots);
            if (!sourceModule.getJsFrontEndResult().getJsAnalysisResult().getShouldGenerateCode()) {
                return ExitCode.OK;
            }
        }
        if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
            if (arguments2.getIrProduceKlibFile() && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)outputFile), (Object)"klib")) {
                boolean $i$a$-require-K2JsIrCompiler$doExecute$332 = false;
                String $i$a$-require-K2JsIrCompiler$doExecute$332 = "Please set up .klib file as output";
                throw new IllegalArgumentException($i$a$-require-K2JsIrCompiler$doExecute$332.toString());
            }
            ModulesStructure modulesStructure = sourceModule;
            if (modulesStructure == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sourceModule");
                modulesStructure = null;
            }
            IrFactory irFactory = IrFactoryImpl.INSTANCE;
            String string6 = outputFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"outputFile.path");
            KlibKt.generateKLib$default(modulesStructure, irFactory, string6, arguments2.getIrProduceKlibDir(), false, null, arguments2.getIrPerModuleOutputName(), 48, null);
        }
        if (arguments2.getIrProduceJs()) {
            ModulesStructure module2;
            ModulesStructure modulesStructure;
            Pair<List<IrModuleFragment>, WasmBackendContext> includesPath;
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Produce executable: " + outputFilePath, null, 4, null);
            String string7 = arguments2.getCacheDirectories();
            if (string7 == null) {
                string7 = "";
            }
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, string7, null, 4, null);
            if (!((Collection)icCaches2).isEmpty()) {
                long beforeIc2Js = System.currentTimeMillis();
                ModuleKind moduleKind = configurationJs.get(JSConfigurationKeys.MODULE_KIND);
                Intrinsics.checkNotNull((Object)((Object)moduleKind));
                JsExecutableProducer jsExecutableProducer = new JsExecutableProducer(moduleName, moduleKind, SourceMapsInfo.Companion.from(configurationJs), icCaches2, true);
                CompilationOutputs outputs2 = jsExecutableProducer.buildExecutable(arguments2.getIrPerModule(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(messageCollector2){
                    final /* synthetic */ MessageCollector $messageCollector;
                    {
                        this.$messageCollector = $messageCollector;
                        super(1);
                    }

                    public final void invoke(@NotNull String rebuiltModule) {
                        Intrinsics.checkNotNullParameter((Object)rebuiltModule, (String)"rebuiltModule");
                        MessageCollector.DefaultImpls.report$default(this.$messageCollector, CompilerMessageSeverity.INFO, "IC module builder rebuilt module [" + new File(rebuiltModule).getName() + ']', null, 4, null);
                    }
                }));
                this.write(outputFile, outputs2);
                Iterable<Pair<String, CompilationOutputs>> $this$forEach$iv = outputs2.getDependencies();
                boolean $i$f$forEach = false;
                for (Object e : $this$forEach$iv) {
                    msg2 = (Pair)e;
                    boolean bl = false;
                    String string8 = (String)msg2.component1();
                    CompilationOutputs content2 = (CompilationOutputs)msg2.component2();
                    this.write(FilesKt.resolveSibling((File)outputFile, (String)(string8 + ".js")), content2);
                }
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Executable production duration (IC): " + (System.currentTimeMillis() - beforeIc2Js) + "ms", null, 4, null);
                return ExitCode.OK;
            }
            PhaseConfig phaseConfig = CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector2);
            if (includes != null) {
                Object v22;
                block58: {
                    if (!((Collection)sourcesFiles).isEmpty()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                    }
                    includesPath = new File(includes).getCanonicalPath();
                    srcFiles = libraries;
                    Iterator iterator2 = srcFiles.iterator();
                    while (iterator2.hasNext()) {
                        msg2 = iterator2.next();
                        String it = (String)msg2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)new File(it).getCanonicalPath(), (Object)includesPath)) continue;
                        v22 = msg2;
                        break block58;
                    }
                    v22 = null;
                }
                String string9 = v22;
                if (string9 == null) {
                    throw new IllegalStateException(("No library with name " + includes + " (" + (String)includesPath + ") found").toString());
                }
                String mainLibPath = string9;
                MainModule.Klib kLib = new MainModule.Klib(mainLibPath);
                modulesStructure = new ModulesStructure(projectJs, kLib, configurationJs, libraries, friendLibraries);
            } else {
                modulesStructure = sourceModule;
                if (modulesStructure == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sourceModule");
                    modulesStructure = module2 = null;
                }
            }
            if (arguments2.getWasm()) {
                includesPath = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileToLoweredIr(module2, new PhaseConfig(WasmLoweringPhasesKt.getWasmPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), IrFactoryImpl.INSTANCE, SetsKt.setOf((Object)new FqName("main")), arguments2.getIrPropertyLazyInitialization());
                List allModules2 = (List)includesPath.component1();
                WasmBackendContext backendContext = (WasmBackendContext)includesPath.component2();
                if (arguments2.getIrDce()) {
                    DceKt.eliminateDeadDeclarations(allModules2, backendContext);
                }
                WasmCompilerResult res2 = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileWasm(allModules2, backendContext, arguments2.getWasmDebug(), arguments2.getIrDce(), true);
                File file4 = outputFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"outputFile.parentFile");
                org.jetbrains.kotlin.backend.wasm.CompilerKt.writeCompilationResult(res2, file4, FilesKt.getNameWithoutExtension((File)outputFile));
                return ExitCode.OK;
            }
            long start = System.currentTimeMillis();
            JsGenerationGranularity granularity = arguments2.getIrPerModule() ? JsGenerationGranularity.PER_MODULE : (arguments2.getIrPerFile() ? JsGenerationGranularity.PER_FILE : JsGenerationGranularity.WHOLE_PROGRAM);
            try {
                CompilerResult compilerResult;
                AbstractIrFactoryImpl irFactory = arguments2.getIrNewIr2Js() ? (AbstractIrFactoryImpl)new IrFactoryImplForJsIC(new WholeWorldStageController()) : (AbstractIrFactoryImpl)IrFactoryImpl.INSTANCE;
                LoweredIr ir2 = CompilerKt.compile$default(module2, phaseConfig, irFactory, null, K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrDceRuntimeDiagnostic(), messageCollector2), false, false, arguments2.getIrBaseClassInMetadata(), arguments2.getIrSafeExternalBoolean(), K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrSafeExternalBooleanDiagnostic(), messageCollector2), null, granularity, arguments2.getIrNewIr2Js(), 1128, null);
                if (arguments2.getIrNewIr2Js()) {
                    IrModuleToJsTransformerTmp transformer2 = new IrModuleToJsTransformerTmp(ir2.getContext(), mainCallArguments, false, true, ir2.getModuleFragmentToUniqueName(), false, 36, null);
                    compilerResult = transformer2.generateModule((Iterable<? extends IrModuleFragment>)ir2.getAllModules(), SetsKt.setOf((Object)((Object)TranslationMode.Companion.fromFlags(arguments2.getIrDce(), arguments2.getIrPerModule(), arguments2.getIrMinimizedMemberNames()))));
                } else {
                    IrModuleToJsTransformer transformer2 = new IrModuleToJsTransformer(ir2.getContext(), mainCallArguments, false, null, !arguments2.getIrDce(), arguments2.getIrDce(), arguments2.getIrPerModule(), true, ir2.getModuleFragmentToUniqueName(), false, 524, null);
                    compilerResult = transformer2.generateModule((Iterable<? extends IrModuleFragment>)ir2.getAllModules());
                }
                CompilerResult compilerResult2 = compilerResult;
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Executable production duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
                CompilationOutputs outputs3 = (CompilationOutputs)CollectionsKt.single((Iterable)compilerResult2.getOutputs().values());
                this.write(outputFile, outputs3);
                Iterable<Pair<String, CompilationOutputs>> $this$forEach$iv = outputs3.getDependencies();
                boolean bl = false;
                Iterator<Pair<String, CompilationOutputs>> iterator3 = $this$forEach$iv.iterator();
                while (iterator3.hasNext()) {
                    Pair<String, CompilationOutputs> element$iv;
                    Pair<String, CompilationOutputs> pair = element$iv = iterator3.next();
                    boolean bl3 = false;
                    String name = (String)pair.component1();
                    CompilationOutputs content3 = (CompilationOutputs)pair.component2();
                    this.write(FilesKt.resolveSibling((File)outputFile, (String)(name + ".js")), content3);
                }
                if (arguments2.getGenerateDts()) {
                    File file5 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "d.ts");
                    Intrinsics.checkNotNull((Object)file5);
                    File dtsFile = file5;
                    String string10 = compilerResult2.getTsDefinitions();
                    if (string10 == null) {
                        throw new IllegalStateException("No ts definitions".toString());
                    }
                    FilesKt.writeText$default((File)dtsFile, (String)string10, null, (int)2, null);
                }
            }
            catch (CompilationException e) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, ExceptionsKt.stackTraceToString((Throwable)e), CompilerMessageLocation.Companion.create(e.getPath(), e.getLine(), e.getColumn(), e.getContent()));
                return ExitCode.INTERNAL_ERROR;
            }
        }
        return ExitCode.OK;
    }

    private final void write(File $this$write, CompilationOutputs outputs2) {
        FilesKt.writeText$default((File)$this$write, (String)outputs2.getJsCode(), null, (int)2, null);
        CompilerKt.writeSourceMapIfPresent(outputs2, $this$write);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration2, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ErrorTolerancePolicy errorTolerancePolicy;
        ModuleKind moduleKind;
        String moduleKindName;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual((Object)"v5", (Object)arguments2.getTarget());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("Unsupported ECMA version: ");
                String string2 = arguments2.getTarget();
                Intrinsics.checkNotNull((Object)string2);
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = stringBuilder2.append(string2).toString();
                throw new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22);
            }
        }
        configuration2.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration2.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                String string3 = arguments2.getSourceMapPrefix();
                Intrinsics.checkNotNull((Object)string3);
                configuration2.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, string3);
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty(arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                List<String> list2 = StringUtil.split(sourceMapSourceRoots, File.pathSeparator);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"split(sourceMapSourceRoots, File.pathSeparator)");
                List<String> sourceMapSourceRootList = list2;
                configuration2.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration2.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration2.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration2.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            List list3;
            Iterable $this$dropLastWhile$iv;
            Object object = friendModules;
            String string4 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
            String string5 = string4;
            string5 = new Regex(string5);
            int n = 0;
            object = string5.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            boolean $i$f$filterNot = false;
            void iterator$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration2.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        String string6 = moduleKindName = arguments2.getModuleKind();
        ModuleKind moduleKind2 = moduleKind = string6 != null ? moduleKindMap.get(string6) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration2.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, services.get(IncrementalDataProvider.class));
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, services.get(IncrementalResultsConsumer.class));
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_NEXT_ROUND_CHECKER, services.get(IncrementalNextRoundChecker.class));
        configuration2.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
        configuration2.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
        String string7 = arguments2.getErrorTolerancePolicy();
        if (string7 != null) {
            String it = string7;
            boolean bl = false;
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.resolvePolicy(it);
        } else {
            errorTolerancePolicy = null;
        }
        ErrorTolerancePolicy errorTolerancePolicy2 = errorTolerancePolicy;
        configuration2.putIfNotNull(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, errorTolerancePolicy2);
        ErrorTolerancePolicy errorTolerancePolicy3 = errorTolerancePolicy2;
        boolean bl = errorTolerancePolicy3 != null ? errorTolerancePolicy3.getAllowErrors() : false;
        if (bl) {
            configuration2.put(JSConfigurationKeys.DEVELOPER_MODE, true);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection<String>)sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
        configuration2.put(JSConfigurationKeys.PRINT_REACHABILITY_INFO, arguments2.getIrDcePrintReachabilityInfo());
        configuration2.put(JSConfigurationKeys.FAKE_OVERRIDE_VALIDATOR, arguments2.getFakeOverrideValidator());
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        String string2 = "Provide a proper way to run the compiler with IR BE";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new KlibMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"plain", (Object)((Object)ModuleKind.PLAIN)), TuplesKt.to((Object)"commonjs", (Object)((Object)ModuleKind.COMMON_JS)), TuplesKt.to((Object)"amd", (Object)((Object)ModuleKind.AMD)), TuplesKt.to((Object)"umd", (Object)((Object)ModuleKind.UMD)), TuplesKt.to((Object)"es", (Object)((Object)ModuleKind.ES))};
        moduleKindMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"always", (Object)((Object)SourceMapSourceEmbedding.ALWAYS)), TuplesKt.to((Object)"never", (Object)((Object)SourceMapSourceEmbedding.NEVER)), TuplesKt.to((Object)"inlining", (Object)((Object)SourceMapSourceEmbedding.INLINING))};
        sourceMapContentEmbeddingMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                collection.add(virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : file2.getName() + " (no virtual file)");
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            Object object = libraryString;
            if (object == null || (object = this.splitByPathSeparator((String)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence2 = $this$splitByPathSeparator;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            String string3 = string2;
            string3 = new Regex(string3);
            int n = 0;
            List $this$dropLastWhile$iv = string3.split(charSequence2, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] $this$filterNot$iv = thisCollection$iv.toArray(new String[0]);
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (void element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

