/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.NewCommonSuperTypeCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPositionAndErrorsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorageKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u00014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001e\u001a\u00020\u0015*\u00020\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J\u001a\u0010 \u001a\u00020\u0015*\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\"\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010#\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010$\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010%\u001a\u00020&H\u0002J$\u0010'\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010(\u001a\u00020\n*\u00020\u00172\u0006\u0010)\u001a\u00020\u0015H\u0002J\u001c\u0010*\u001a\u00020\n*\u00020\u00172\u0006\u0010+\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010,\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012*\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010.\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J*\u0010+\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\b\u0010/\u001a\u0004\u0018\u00010\u00152\b\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u00101\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012*\u00020\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J\u001e\u00102\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\u0006\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u0015H\u0002J\f\u00103\u001a\u00020\u0015*\u00020\u0015H\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver;", "", "typeApproximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "trivialConstraintTypeInferenceOracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "isTypeInferenceForSelfTypesSupported", "", "()Z", "getTrivialConstraintTypeInferenceOracle", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "checkSingleLowerNullabilityConstraint", "constraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "findResultIfThereIsEqualsConstraint", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver$Context;", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "findResultType", "direction", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "findResultTypeOrNull", "computeCommonSuperType", "types", "computeUpperType", "upperConstraints", "findSubType", "findSuperType", "getDefaultType", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "getDefaultTypeForSelfType", "isProperTypeForFixation", "type", "isSuitableType", "resultType", "makeFlexibleIfNecessary", "prepareLowerConstraints", "representativeFromEqualityConstraints", "firstCandidate", "secondCandidate", "sinkIntegerLiteralTypes", "specialResultForIntersectionType", "toPublicType", "Context", "resolution.common"})
@SourceDebugExtension(value={"SMAP\nResultTypeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResultTypeResolver.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 VariableFixationFinder.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinderKt\n*L\n1#1,314:1\n1603#2,9:315\n1855#2:324\n1856#2:326\n1612#2:327\n1747#2,3:329\n766#2:332\n857#2,2:333\n661#2,11:335\n766#2:346\n857#2,2:347\n1549#2:349\n1620#2,3:350\n1045#2:353\n1549#2:354\n1620#2,3:355\n1774#2,4:358\n1747#2,3:362\n819#2:365\n847#2,2:366\n1549#2:368\n1620#2,3:369\n1549#2:372\n1620#2,3:373\n766#2:376\n857#2,2:377\n1726#2,3:380\n766#2:383\n857#2,2:384\n1549#2:386\n1620#2,3:387\n766#2:390\n857#2,2:391\n1#3:325\n1#3:328\n225#4:379\n*S KotlinDebug\n*F\n+ 1 ResultTypeResolver.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver\n*L\n38#1:315,9\n38#1:324\n38#1:326\n38#1:327\n100#1:329,3\n145#1:332\n145#1:333,2\n158#1:335,11\n169#1:346\n169#1:347,2\n232#1:349\n232#1:350,3\n236#1:353\n246#1:354\n246#1:355,3\n251#1:358,4\n254#1:362,3\n266#1:365\n266#1:366,2\n266#1:368\n266#1:369,3\n271#1:372\n271#1:373,3\n277#1:376\n277#1:377,2\n292#1:380,3\n296#1:383\n296#1:384,2\n307#1:386\n307#1:387,3\n308#1:390\n308#1:391,2\n38#1:325\n292#1:379\n*E\n"})
public final class ResultTypeResolver {
    @NotNull
    private final AbstractTypeApproximator typeApproximator;
    @NotNull
    private final TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public ResultTypeResolver(@NotNull AbstractTypeApproximator typeApproximator, @NotNull TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)typeApproximator, (String)"typeApproximator");
        Intrinsics.checkNotNullParameter((Object)trivialConstraintTypeInferenceOracle, (String)"trivialConstraintTypeInferenceOracle");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.typeApproximator = typeApproximator;
        this.trivialConstraintTypeInferenceOracle = trivialConstraintTypeInferenceOracle;
        this.languageVersionSettings = languageVersionSettings2;
    }

    @NotNull
    public final AbstractTypeApproximator getTypeApproximator() {
        return this.typeApproximator;
    }

    @NotNull
    public final TrivialConstraintTypeInferenceOracle getTrivialConstraintTypeInferenceOracle() {
        return this.trivialConstraintTypeInferenceOracle;
    }

    private final boolean isTypeInferenceForSelfTypesSupported() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.TypeInferenceOnCallsWithSelfTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker getDefaultTypeForSelfType(Context $this$getDefaultTypeForSelfType, List<Constraint> constraints, TypeVariableMarker typeVariable2) {
        List list2;
        void $this$mapNotNullTo$iv$iv;
        TypeConstructorMarker typeConstructorMarker = $this$getDefaultTypeForSelfType.freshTypeConstructor(typeVariable2);
        Intrinsics.checkNotNull((Object)typeConstructorMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker");
        TypeVariableTypeConstructorMarker typeVariableConstructor = (TypeVariableTypeConstructorMarker)typeConstructorMarker;
        Iterable $this$mapNotNull$iv = constraints;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTypeMarker it$iv$iv;
            TypeParameterMarker typeParameter2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Constraint constraint2 = (Constraint)element$iv$iv;
            boolean bl2 = false;
            if ((!(constraint2.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition) ? null : ($this$getDefaultTypeForSelfType.getTypeParameter(typeVariableConstructor) == null ? null : InferenceUtilsKt.extractTypeForGivenRecursiveTypeParameter($this$getDefaultTypeForSelfType, constraint2.getType(), typeParameter2))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list2 = (List)destination$iv$iv;
        boolean bl = false;
        List list3 = !((Collection)it).isEmpty() ? list2 : null;
        if (list3 == null) {
            return null;
        }
        List typesForRecursiveTypeParameters = list3;
        return $this$getDefaultTypeForSelfType.createCapturedStarProjectionForSelfType(typeVariableConstructor, typesForRecursiveTypeParameters);
    }

    private final KotlinTypeMarker getDefaultType(Context $this$getDefaultType, TypeVariableDirectionCalculator.ResolveDirection direction, List<Constraint> constraints, TypeVariableMarker typeVariable2) {
        KotlinTypeMarker kotlinTypeMarker;
        if (this.isTypeInferenceForSelfTypesSupported() && (kotlinTypeMarker = this.getDefaultTypeForSelfType($this$getDefaultType, constraints, typeVariable2)) != null) {
            KotlinTypeMarker it = kotlinTypeMarker;
            boolean bl = false;
            return it;
        }
        return direction == TypeVariableDirectionCalculator.ResolveDirection.TO_SUBTYPE ? (KotlinTypeMarker)$this$getDefaultType.nothingType() : (KotlinTypeMarker)$this$getDefaultType.nullableAnyType();
    }

    @NotNull
    public final KotlinTypeMarker findResultType(@NotNull Context c, @NotNull VariableWithConstraints variableWithConstraints, @NotNull TypeVariableDirectionCalculator.ResolveDirection direction) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)variableWithConstraints, (String)"variableWithConstraints");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        KotlinTypeMarker kotlinTypeMarker = this.findResultTypeOrNull(c, variableWithConstraints, direction);
        if (kotlinTypeMarker != null) {
            KotlinTypeMarker it = kotlinTypeMarker;
            boolean bl = false;
            return it;
        }
        return this.getDefaultType(c, direction, variableWithConstraints.getConstraints(), variableWithConstraints.getTypeVariable());
    }

    private final KotlinTypeMarker findResultTypeOrNull(Context c, VariableWithConstraints variableWithConstraints, TypeVariableDirectionCalculator.ResolveDirection direction) {
        KotlinTypeMarker kotlinTypeMarker = this.findResultIfThereIsEqualsConstraint(c, variableWithConstraints);
        if (kotlinTypeMarker != null) {
            KotlinTypeMarker it = kotlinTypeMarker;
            boolean bl = false;
            return it;
        }
        KotlinTypeMarker subType = this.findSubType(c, variableWithConstraints);
        KotlinTypeMarker superType2 = this.makeFlexibleIfNecessary(this.findSuperType(c, variableWithConstraints), c, variableWithConstraints.getConstraints());
        return direction == TypeVariableDirectionCalculator.ResolveDirection.TO_SUBTYPE || direction == TypeVariableDirectionCalculator.ResolveDirection.UNKNOWN ? this.resultType(c, subType, superType2, variableWithConstraints) : this.resultType(c, superType2, subType, variableWithConstraints);
    }

    private final KotlinTypeMarker makeFlexibleIfNecessary(KotlinTypeMarker $this$makeFlexibleIfNecessary, Context c, List<Constraint> constraints) {
        KotlinTypeMarker kotlinTypeMarker;
        Context $this$makeFlexibleIfNecessary_u24lambda_u246 = c;
        boolean bl = false;
        KotlinTypeMarker type2 = $this$makeFlexibleIfNecessary;
        if (type2 instanceof SimpleTypeMarker) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = constraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint it = (Constraint)element$iv;
                        boolean bl3 = false;
                        if (!($this$makeFlexibleIfNecessary_u24lambda_u246.isTypeVariable($this$makeFlexibleIfNecessary_u24lambda_u246.typeConstructor(it.getType())) && $this$makeFlexibleIfNecessary_u24lambda_u246.hasFlexibleNullability(it.getType()))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            kotlinTypeMarker = bl2 ? $this$makeFlexibleIfNecessary_u24lambda_u246.createFlexibleType($this$makeFlexibleIfNecessary_u24lambda_u246.makeSimpleTypeDefinitelyNotNullOrNotNull((SimpleTypeMarker)type2), $this$makeFlexibleIfNecessary_u24lambda_u246.withNullability((SimpleTypeMarker)type2, true)) : type2;
        } else {
            kotlinTypeMarker = type2;
        }
        return kotlinTypeMarker;
    }

    private final KotlinTypeMarker resultType(Context $this$resultType, KotlinTypeMarker firstCandidate, KotlinTypeMarker secondCandidate, VariableWithConstraints variableWithConstraints) {
        if (firstCandidate == null || secondCandidate == null) {
            KotlinTypeMarker kotlinTypeMarker = firstCandidate;
            if (kotlinTypeMarker == null) {
                kotlinTypeMarker = secondCandidate;
            }
            return kotlinTypeMarker;
        }
        KotlinTypeMarker kotlinTypeMarker = this.specialResultForIntersectionType($this$resultType, firstCandidate, secondCandidate);
        if (kotlinTypeMarker != null) {
            KotlinTypeMarker intersectionWithAlternative = kotlinTypeMarker;
            boolean bl = false;
            return intersectionWithAlternative;
        }
        if (this.isSuitableType($this$resultType, firstCandidate, variableWithConstraints)) {
            return firstCandidate;
        }
        return this.isSuitableType($this$resultType, secondCandidate, variableWithConstraints) ? secondCandidate : firstCandidate;
    }

    private final KotlinTypeMarker specialResultForIntersectionType(Context $this$specialResultForIntersectionType, KotlinTypeMarker firstCandidate, KotlinTypeMarker secondCandidate) {
        if ($this$specialResultForIntersectionType.isIntersection($this$specialResultForIntersectionType.typeConstructor(firstCandidate)) && !AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, $this$specialResultForIntersectionType, this.toPublicType(firstCandidate), this.toPublicType(secondCandidate), false, 8, null)) {
            return $this$specialResultForIntersectionType.createTypeWithAlternativeForIntersectionResult(firstCandidate, secondCandidate);
        }
        return null;
    }

    private final KotlinTypeMarker toPublicType(KotlinTypeMarker $this$toPublicType) {
        KotlinTypeMarker kotlinTypeMarker = this.typeApproximator.approximateToSuperType($this$toPublicType, TypeApproximatorConfiguration.PublicDeclaration.SaveAnonymousTypes.INSTANCE);
        if (kotlinTypeMarker == null) {
            kotlinTypeMarker = $this$toPublicType;
        }
        return kotlinTypeMarker;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSuitableType(Context $this$isSuitableType, KotlinTypeMarker resultType, VariableWithConstraints variableWithConstraints) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = variableWithConstraints.getConstraints();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            boolean bl = false;
            if (!this.isProperTypeForFixation($this$isSuitableType, it.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredConstraints = (List)destination$iv$iv;
        for (Constraint constraint2 : filteredConstraints) {
            if (ConstraintStorageKt.checkConstraint($this$isSuitableType, constraint2.getType(), constraint2.getKind(), resultType)) continue;
            return false;
        }
        if (!this.trivialConstraintTypeInferenceOracle.isSuitableResultedType(resultType)) {
            if ($this$isSuitableType.isNullableType(resultType) && this.checkSingleLowerNullabilityConstraint(filteredConstraints)) {
                return false;
            }
            if ($this$isSuitableType.isReified(variableWithConstraints.getTypeVariable())) {
                return false;
            }
        }
        return true;
    }

    private final boolean checkSingleLowerNullabilityConstraint(List<Constraint> constraints) {
        Object v0;
        block2: {
            Iterable $this$singleOrNull$iv = constraints;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Constraint it = (Constraint)element$iv;
                boolean bl = false;
                if (!it.getKind().isLower()) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        Constraint constraint2 = v0;
        return constraint2 != null ? constraint2.isNullabilityConstraint() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker findSubType(Context $this$findSubType, VariableWithConstraints variableWithConstraints) {
        List<KotlinTypeMarker> lowerConstraintTypes = this.prepareLowerConstraints($this$findSubType, variableWithConstraints.getConstraints());
        if (!((Collection)lowerConstraintTypes).isEmpty()) {
            KotlinTypeMarker kotlinTypeMarker;
            List<KotlinTypeMarker> types2 = this.sinkIntegerLiteralTypes($this$findSubType, lowerConstraintTypes);
            KotlinTypeMarker commonSuperType = this.computeCommonSuperType($this$findSubType, types2);
            if ($this$findSubType.contains(commonSuperType, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new Function1<KotlinTypeMarker, Boolean>($this$findSubType){
                final /* synthetic */ Context $this_findSubType;
                {
                    this.$this_findSubType = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KotlinTypeMarker it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SimpleTypeMarker simpleTypeMarker = this.$this_findSubType.asSimpleType(it);
                    return simpleTypeMarker != null ? this.$this_findSubType.isStubTypeForVariableInSubtyping(simpleTypeMarker) : false;
                }
            }))) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = types2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KotlinTypeMarker lowerType = (KotlinTypeMarker)element$iv$iv;
                    boolean bl = false;
                    if (!(!$this$findSubType.contains(lowerType, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new Function1<KotlinTypeMarker, Boolean>($this$findSubType){
                        final /* synthetic */ Context $this_findSubType;
                        {
                            this.$this_findSubType = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull KotlinTypeMarker it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            SimpleTypeMarker simpleTypeMarker = this.$this_findSubType.asSimpleType(it);
                            return simpleTypeMarker != null ? this.$this_findSubType.isStubTypeForVariableInSubtyping(simpleTypeMarker) : false;
                        }
                    })))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List typesWithoutStubs2 = (List)destination$iv$iv;
                if (!((Collection)typesWithoutStubs2).isEmpty()) {
                    commonSuperType = this.computeCommonSuperType($this$findSubType, typesWithoutStubs2);
                }
            }
            if ((kotlinTypeMarker = this.typeApproximator.approximateToSuperType(commonSuperType, TypeApproximatorConfiguration.InternalTypesApproximation.INSTANCE)) == null) {
                kotlinTypeMarker = commonSuperType;
            }
            return kotlinTypeMarker;
        }
        return null;
    }

    private final KotlinTypeMarker computeCommonSuperType(Context $this$computeCommonSuperType, List<? extends KotlinTypeMarker> types2) {
        NewCommonSuperTypeCalculator $this$computeCommonSuperType_u24lambda_u2411 = NewCommonSuperTypeCalculator.INSTANCE;
        boolean bl = false;
        return $this$computeCommonSuperType_u24lambda_u2411.commonSuperType($this$computeCommonSuperType, types2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinTypeMarker> prepareLowerConstraints(Context $this$prepareLowerConstraints, List<Constraint> constraints) {
        void $this$mapTo$iv$iv;
        boolean atLeastOneProper = false;
        boolean atLeastOneNonProper = false;
        List lowerConstraintTypes = new ArrayList();
        for (Constraint constraint2 : constraints) {
            if (constraint2.getKind() != ConstraintKind.LOWER) continue;
            KotlinTypeMarker type2 = constraint2.getType();
            lowerConstraintTypes.add(type2);
            if (this.isProperTypeForFixation($this$prepareLowerConstraints, type2)) {
                atLeastOneProper = true;
                continue;
            }
            atLeastOneNonProper = true;
        }
        if (!atLeastOneProper) {
            return CollectionsKt.emptyList();
        }
        if (!atLeastOneNonProper) {
            return lowerConstraintTypes;
        }
        TypeSubstitutorMarker notFixedToStubTypesSubstitutor = $this$prepareLowerConstraints.buildNotFixedVariablesToStubTypesSubstitutor();
        Iterable $this$map$iv = lowerConstraintTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinTypeMarker kotlinTypeMarker = (KotlinTypeMarker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.isProperTypeForFixation($this$prepareLowerConstraints, (KotlinTypeMarker)it) ? it : $this$prepareLowerConstraints.safeSubstitute(notFixedToStubTypesSubstitutor, (KotlinTypeMarker)it));
        }
        return (List)destination$iv$iv;
    }

    private final List<KotlinTypeMarker> sinkIntegerLiteralTypes(Context $this$sinkIntegerLiteralTypes, List<? extends KotlinTypeMarker> types2) {
        Iterable $this$sortedBy$iv = types2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator($this$sinkIntegerLiteralTypes){
            final /* synthetic */ Context $this_sinkIntegerLiteralTypes$inlined;
            {
                this.$this_sinkIntegerLiteralTypes$inlined = context;
            }

            public final int compare(T a, T b) {
                KotlinTypeMarker type2 = (KotlinTypeMarker)a;
                boolean bl = false;
                boolean containsILT2 = this.$this_sinkIntegerLiteralTypes$inlined.contains(type2, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new Function1<KotlinTypeMarker, Boolean>(this.$this_sinkIntegerLiteralTypes$inlined){
                    final /* synthetic */ Context $this_sinkIntegerLiteralTypes;
                    {
                        this.$this_sinkIntegerLiteralTypes = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull KotlinTypeMarker it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SimpleTypeMarker simpleTypeMarker = this.$this_sinkIntegerLiteralTypes.asSimpleType(it);
                        return simpleTypeMarker != null ? this.$this_sinkIntegerLiteralTypes.isIntegerLiteralType(simpleTypeMarker) : false;
                    }
                }));
                int n = containsILT2 ? 1 : 0;
                type2 = (KotlinTypeMarker)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                containsILT2 = this.$this_sinkIntegerLiteralTypes$inlined.contains(type2, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)new /* invalid duplicate definition of identical inner class */));
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(containsILT2 ? 1 : 0));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker computeUpperType(Context $this$computeUpperType, List<Constraint> upperConstraints) {
        KotlinTypeMarker kotlinTypeMarker;
        if (!$this$computeUpperType.isK2()) {
            KotlinTypeMarker upperType;
            KotlinTypeMarker kotlinTypeMarker2;
            boolean isThereUnwantedIntersectedTypes;
            boolean bl;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = upperConstraints;
            Object object = $this$computeUpperType;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                Constraint constraint2 = (Constraint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Constraint)((Object)it)).getType());
            }
            KotlinTypeMarker intersectionUpperType = object.intersectTypes((List)destination$iv$iv);
            boolean resultIsActuallyIntersection = $this$computeUpperType.isIntersection($this$computeUpperType.typeConstructor(intersectionUpperType));
            if (resultIsActuallyIntersection) {
                boolean areThereIntersectionFinalClasses;
                int intersectionClasses;
                block16: {
                    boolean bl3;
                    KotlinTypeMarker it;
                    int n;
                    Collection<KotlinTypeMarker> intersectionSupertypes = $this$computeUpperType.supertypes($this$computeUpperType.typeConstructor(intersectionUpperType));
                    Iterable $this$count$iv = intersectionSupertypes;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            it = (KotlinTypeMarker)element$iv;
                            boolean bl4 = false;
                            if (!($this$computeUpperType.isClassTypeConstructor($this$computeUpperType.typeConstructor(it)) && !$this$computeUpperType.isInterface($this$computeUpperType.typeConstructor(it))) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    intersectionClasses = n;
                    Iterable $this$any$iv = intersectionSupertypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (KotlinTypeMarker)element$iv;
                            boolean bl5 = false;
                            if (!$this$computeUpperType.isCommonFinalClassConstructor($this$computeUpperType.typeConstructor(it))) continue;
                            bl3 = true;
                            break block16;
                        }
                        bl3 = areThereIntersectionFinalClasses = false;
                    }
                }
                bl = intersectionClasses > 1 || areThereIntersectionFinalClasses;
            } else {
                bl = isThereUnwantedIntersectedTypes = false;
            }
            if (isThereUnwantedIntersectedTypes) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Constraint it;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = upperConstraints;
                boolean $i$f$filterNot = false;
                Iterable $i$f$any = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (Constraint)element$iv$iv;
                    boolean bl6 = false;
                    if (ConstraintPositionAndErrorsKt.isExpectedTypePosition(it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv2;
                boolean $i$f$map2 = false;
                $this$filterNotTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (Constraint)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl7 = false;
                    object.add(it.getType());
                }
                List filteredUpperConstraints = (List)destination$iv$iv2;
                kotlinTypeMarker2 = !((Collection)filteredUpperConstraints).isEmpty() ? $this$computeUpperType.intersectTypes(filteredUpperConstraints) : intersectionUpperType;
            } else {
                kotlinTypeMarker2 = intersectionUpperType;
            }
            kotlinTypeMarker = upperType = kotlinTypeMarker2;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable intersectionUpperType = upperConstraints;
            Context context = $this$computeUpperType;
            boolean $i$f$map = false;
            void isThereUnwantedIntersectedTypes = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Constraint $this$mapTo$iv$iv2 = (Constraint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getType());
            }
            kotlinTypeMarker = context.intersectTypes((List)destination$iv$iv);
        }
        return kotlinTypeMarker;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker findSuperType(Context $this$findSuperType, VariableWithConstraints variableWithConstraints) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = variableWithConstraints.getConstraints();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ConstraintKind.UPPER && this.isProperTypeForFixation($this$findSuperType, it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List upperConstraints = (List)destination$iv$iv;
        if (!((Collection)upperConstraints).isEmpty()) {
            KotlinTypeMarker upperType = this.computeUpperType($this$findSuperType, upperConstraints);
            KotlinTypeMarker kotlinTypeMarker = this.typeApproximator.approximateToSubType(upperType, TypeApproximatorConfiguration.InternalTypesApproximation.INSTANCE);
            if (kotlinTypeMarker == null) {
                kotlinTypeMarker = upperType;
            }
            return kotlinTypeMarker;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProperTypeForFixation(Context $this$isProperTypeForFixation, KotlinTypeMarker type2) {
        KotlinTypeMarker it;
        TypeSystemInferenceExtensionContext $this$isProperTypeForFixation$iv = $this$isProperTypeForFixation;
        boolean $i$f$isProperTypeForFixation = false;
        KotlinTypeMarker it2 = type2;
        boolean bl = false;
        if (!$this$isProperTypeForFixation.isProperType(it2)) return false;
        Iterable $this$all$iv$iv = VariableFixationFinderKt.extractProjectionsForAllCapturedTypes($this$isProperTypeForFixation$iv, type2);
        boolean $i$f$all = false;
        if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv$iv = iterator2.next();
            it = (KotlinTypeMarker)element$iv$iv;
            $i$a$-isProperTypeForFixation-ResultTypeResolver$isProperTypeForFixation$1 = false;
        } while ($this$isProperTypeForFixation.isProperType(it));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker findResultIfThereIsEqualsConstraint(Context c, VariableWithConstraints variableWithConstraints) {
        void $this$filterTo$iv$iv;
        Context $this$findResultIfThereIsEqualsConstraint_u24lambda_u2423 = c;
        boolean bl = false;
        Iterable $this$filter$iv = variableWithConstraints.getConstraints();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKind() == ConstraintKind.EQUALITY && this.isProperTypeForFixation(c, it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properEqualityConstraints = (List)destination$iv$iv;
        return this.representativeFromEqualityConstraints(c, properEqualityConstraints);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinTypeMarker representativeFromEqualityConstraints(Context $this$representativeFromEqualityConstraints, List<Constraint> constraints) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (constraints.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = constraints;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Constraint constraint2 = (Constraint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        List constraintTypes = (List)destination$iv$iv;
        Iterable $this$filter$iv = constraintTypes;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinTypeMarker it = (KotlinTypeMarker)element$iv$iv;
            boolean bl = false;
            if (!(!$this$representativeFromEqualityConstraints.isIntegerLiteralTypeConstructor($this$representativeFromEqualityConstraints.typeConstructor(it)))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonLiteralTypes = (List)destination$iv$iv2;
        KotlinTypeMarker kotlinTypeMarker = $this$representativeFromEqualityConstraints.singleBestRepresentative(nonLiteralTypes);
        if (kotlinTypeMarker == null && (kotlinTypeMarker = $this$representativeFromEqualityConstraints.singleBestRepresentative(constraintTypes)) == null) {
            kotlinTypeMarker = (KotlinTypeMarker)CollectionsKt.first((List)constraintTypes);
        }
        return kotlinTypeMarker;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "buildNotFixedVariablesToStubTypesSubstitutor", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "isProperType", "", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "isReified", "variable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "resolution.common"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext {
        public boolean isProperType(@NotNull KotlinTypeMarker var1);

        @NotNull
        public TypeSubstitutorMarker buildNotFixedVariablesToStubTypesSubstitutor();

        public boolean isReified(@NotNull TypeVariableMarker var1);
    }
}

