/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ErrorInConstrainingType;
import org.jetbrains.kotlin.resolve.calls.inference.ParameterConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.SubstitutionFilteringInternalResolveAnnotations;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeInferenceError;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubstitutionWithCapturedTypeApproximation;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bc\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\u0002\u0010\u0011JD\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\u00032\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*H\u0002J$\u0010+\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020(0'H\u0002J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0004H\u0016J\b\u0010/\u001a\u00020*H\u0002J\u001c\u00100\u001a\u0002012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020*0'H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "allTypeParameterBounds", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl;", "usedInBounds", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "errors", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintError;", "initialConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderImpl$Constraint;", "typeVariableSubstitutors", "Lorg/jetbrains/kotlin/resolve/calls/inference/CallHandle;", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "currentSubstitutor", "getCurrentSubstitutor", "()Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "localTypeParameterBounds", "getLocalTypeParameterBounds", "()Ljava/util/Map;", "resultingSubstitutor", "getResultingSubstitutor", "status", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemStatus;", "getStatus", "()Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemStatus;", "typeVariables", "", "getTypeVariables", "()Ljava/util/Set;", "getParameterToInferredValueMap", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeParameterBounds", "getDefaultType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "substituteOriginal", "", "getSubstitutor", "getDefaultValue", "getTypeBounds", "typeVariable", "satisfyInitialConstraints", "toBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "filterConstraintPosition", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "frontend"})
@SourceDebugExtension(value={"SMAP\nConstraintSystemImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintSystemImpl.kt\norg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,202:1\n551#2:203\n536#2,6:204\n1726#3,3:210\n857#3,2:216\n766#3:219\n857#3,2:220\n766#3:222\n857#3,2:223\n125#4:213\n152#4,2:214\n154#4:218\n*S KotlinDebug\n*F\n+ 1 ConstraintSystemImpl.kt\norg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemImpl\n*L\n45#1:203\n45#1:204,6\n164#1:210,3\n185#1:216,2\n187#1:219\n187#1:220,2\n189#1:222\n189#1:223,2\n183#1:213\n183#1:214,2\n183#1:218\n*E\n"})
public final class ConstraintSystemImpl
implements ConstraintSystem {
    @NotNull
    private final Map<TypeVariable, TypeBoundsImpl> allTypeParameterBounds;
    @NotNull
    private final Map<TypeVariable, List<TypeBounds.Bound>> usedInBounds;
    @NotNull
    private final List<ConstraintError> errors;
    @NotNull
    private final List<ConstraintSystemBuilderImpl.Constraint> initialConstraints;
    @NotNull
    private final Map<CallHandle, TypeSubstitutor> typeVariableSubstitutors;
    @NotNull
    private final ConstraintSystemStatus status;

    public ConstraintSystemImpl(@NotNull Map<TypeVariable, TypeBoundsImpl> allTypeParameterBounds, @NotNull Map<TypeVariable, ? extends List<TypeBounds.Bound>> usedInBounds, @NotNull List<? extends ConstraintError> errors2, @NotNull List<ConstraintSystemBuilderImpl.Constraint> initialConstraints, @NotNull Map<CallHandle, ? extends TypeSubstitutor> typeVariableSubstitutors) {
        Intrinsics.checkNotNullParameter(allTypeParameterBounds, (String)"allTypeParameterBounds");
        Intrinsics.checkNotNullParameter(usedInBounds, (String)"usedInBounds");
        Intrinsics.checkNotNullParameter(errors2, (String)"errors");
        Intrinsics.checkNotNullParameter(initialConstraints, (String)"initialConstraints");
        Intrinsics.checkNotNullParameter(typeVariableSubstitutors, (String)"typeVariableSubstitutors");
        this.allTypeParameterBounds = allTypeParameterBounds;
        this.usedInBounds = usedInBounds;
        this.errors = errors2;
        this.initialConstraints = initialConstraints;
        this.typeVariableSubstitutors = typeVariableSubstitutors;
        this.status = new ConstraintSystemStatus(this){
            final /* synthetic */ ConstraintSystemImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isSuccessful() {
                return !this.hasContradiction() && !this.hasUnknownParameters() && ConstraintSystemImpl.access$satisfyInitialConstraints(this.this$0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasContradiction() {
                ConstraintError it;
                if (this.hasParameterConstraintError()) return true;
                if (this.hasConflictingConstraints()) return true;
                if (this.hasCannotCaptureTypesError()) return true;
                Iterable $this$any$iv = ConstraintSystemImpl.access$getErrors$p(this.this$0);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    T element$iv = iterator2.next();
                    it = (ConstraintError)element$iv;
                    boolean bl = false;
                } while (!(it instanceof TypeInferenceError));
                return true;
            }

            public boolean hasViolatedUpperBound() {
                return !this.isSuccessful() && ConstraintSystemUtilsKt.filterConstraintsOut(this.this$0, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus().isSuccessful();
            }

            public boolean hasConflictingConstraints() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = ConstraintSystemImpl.access$getLocalTypeParameterBounds(this.this$0).values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TypeBoundsImpl it = (TypeBoundsImpl)element$iv;
                            boolean bl2 = false;
                            if (!(it.getValues().size() > 1)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public boolean hasUnknownParameters() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = ConstraintSystemImpl.access$getLocalTypeParameterBounds(this.this$0).values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TypeBoundsImpl it = (TypeBoundsImpl)element$iv;
                            boolean bl2 = false;
                            if (!it.getValues().isEmpty()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl || this.hasTypeParameterWithUnsatisfiedOnlyInputTypesError();
            }

            public boolean hasParameterConstraintError() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = ConstraintSystemImpl.access$getErrors$p(this.this$0);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            ConstraintError it = (ConstraintError)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof ParameterConstraintError)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasOnlyErrorsDerivedFrom(@NotNull ConstraintPositionKind kind) {
                ConstraintError it;
                Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                if (this.isSuccessful()) {
                    return false;
                }
                if (ConstraintSystemUtilsKt.filterConstraintsOut(this.this$0, kind).getStatus().isSuccessful()) {
                    return true;
                }
                if (((Collection)ConstraintSystemImpl.access$getErrors$p(this.this$0)).isEmpty()) return false;
                boolean bl = true;
                if (!bl) return false;
                Iterable $this$all$iv = ConstraintSystemImpl.access$getErrors$p(this.this$0);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator<T> iterator2 = $this$all$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return true;
                    T element$iv = iterator2.next();
                    it = (ConstraintError)element$iv;
                    boolean bl2 = false;
                } while (ConstraintPositionKt.derivedFrom(it.getConstraintPosition(), kind));
                return false;
            }

            public boolean hasErrorInConstrainingTypes() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = ConstraintSystemImpl.access$getErrors$p(this.this$0);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            ConstraintError it = (ConstraintError)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof ErrorInConstrainingType)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public boolean hasCannotCaptureTypesError() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = ConstraintSystemImpl.access$getErrors$p(this.this$0);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            ConstraintError it = (ConstraintError)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof CannotCapture)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public boolean hasTypeInferenceIncorporationError() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = ConstraintSystemImpl.access$getErrors$p(this.this$0);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            ConstraintError it = (ConstraintError)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof TypeInferenceError)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl || !ConstraintSystemImpl.access$satisfyInitialConstraints(this.this$0);
            }

            public boolean hasTypeParameterWithUnsatisfiedOnlyInputTypesError() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = ConstraintSystemImpl.access$getLocalTypeParameterBounds(this.this$0).values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TypeBoundsImpl it = (TypeBoundsImpl)element$iv;
                            boolean bl2 = false;
                            if (!(it.getTypeVariable().hasOnlyInputTypesAnnotation() && it.getValue() == null)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            @NotNull
            public List<ConstraintError> getConstraintErrors() {
                return ConstraintSystemImpl.access$getErrors$p(this.this$0);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TypeVariable, TypeBoundsImpl> getLocalTypeParameterBounds() {
        void $this$filterNotTo$iv$iv;
        Map<TypeVariable, TypeBoundsImpl> $this$filterNot$iv = this.allTypeParameterBounds;
        boolean $i$f$filterNot = false;
        Map<TypeVariable, TypeBoundsImpl> map = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (((TypeVariable)it.getKey()).isExternal()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public ConstraintSystemStatus getStatus() {
        return this.status;
    }

    private final Map<TypeConstructor, TypeProjection> getParameterToInferredValueMap(Map<TypeVariable, TypeBoundsImpl> typeParameterBounds, Function1<? super TypeVariable, ? extends KotlinType> getDefaultType, boolean substituteOriginal) {
        HashMap<TypeConstructor, TypeProjectionImpl> substitutionContext = new HashMap<TypeConstructor, TypeProjectionImpl>();
        for (Map.Entry<TypeVariable, TypeBoundsImpl> entry : typeParameterBounds.entrySet()) {
            TypeConstructor typeConstructor2;
            TypeVariable variable2 = entry.getKey();
            TypeBoundsImpl typeBounds = entry.getValue();
            KotlinType value2 = typeBounds.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)(substituteOriginal ? variable2.getOriginalTypeParameter().getTypeConstructor() : variable2.getType().getConstructor()), (String)"if (substituteOriginal) \u2026variable.type.constructor");
            typeConstructor2 = typeConstructor2;
            KotlinType type2 = value2 != null && !TypeUtils.contains(value2, TypeUtils.DONT_CARE) ? value2 : (KotlinType)getDefaultType.invoke((Object)variable2);
            substitutionContext.put(typeConstructor2, new TypeProjectionImpl(type2));
        }
        return substitutionContext;
    }

    @Override
    @NotNull
    public Set<TypeVariable> getTypeVariables() {
        return this.allTypeParameterBounds.keySet();
    }

    @Override
    @NotNull
    public TypeBoundsImpl getTypeBounds(@NotNull TypeVariable typeVariable2) {
        Intrinsics.checkNotNullParameter((Object)typeVariable2, (String)"typeVariable");
        TypeBoundsImpl typeBoundsImpl = this.allTypeParameterBounds.get(typeVariable2);
        if (typeBoundsImpl == null) {
            throw new IllegalArgumentException("TypeParameterDescriptor is not a type variable for constraint system: " + typeVariable2);
        }
        return typeBoundsImpl;
    }

    @Override
    @NotNull
    public TypeSubstitutor getResultingSubstitutor() {
        return this.getSubstitutor(true, (Function1<? super TypeVariable, ? extends KotlinType>)((Function1)resultingSubstitutor.1.INSTANCE));
    }

    @Override
    @NotNull
    public TypeSubstitutor getCurrentSubstitutor() {
        return this.getSubstitutor(true, (Function1<? super TypeVariable, ? extends KotlinType>)((Function1)currentSubstitutor.1.INSTANCE));
    }

    private final TypeSubstitutor getSubstitutor(boolean substituteOriginal, Function1<? super TypeVariable, ? extends KotlinType> getDefaultValue) {
        Map<TypeConstructor, TypeProjection> parameterToInferredValueMap = this.getParameterToInferredValueMap(this.allTypeParameterBounds, getDefaultValue, substituteOriginal);
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new SubstitutionWithCapturedTypeApproximation(new SubstitutionFilteringInternalResolveAnnotations(TypeConstructorSubstitution.Companion.createByConstructorsMap$default(TypeConstructorSubstitution.Companion, parameterToInferredValueMap, false, 2, null))));
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(\n            Subs\u2026)\n            )\n        )");
        return typeSubstitutor2;
    }

    private final boolean satisfyInitialConstraints() {
        boolean bl;
        block9: {
            Iterable $this$all$iv;
            TypeSubstitutor substitutor2;
            block10: {
                substitutor2 = this.getSubstitutor(false, (Function1<? super TypeVariable, ? extends KotlinType>)((Function1)satisfyInitialConstraints.substitutor.1.INSTANCE));
                $this$all$iv = this.initialConstraints;
                boolean $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block10;
                bl = true;
                break block9;
            }
            for (Object element$iv : $this$all$iv) {
                boolean bl2;
                KotlinType kotlinType;
                KotlinType superType2;
                ConstraintSystemBuilderImpl.ConstraintKind kind;
                block12: {
                    block11: {
                        ConstraintSystemBuilderImpl.Constraint constraint2 = (ConstraintSystemBuilderImpl.Constraint)element$iv;
                        boolean bl3 = false;
                        kind = constraint2.component1();
                        KotlinType subtype = constraint2.component2();
                        superType2 = constraint2.component3();
                        ConstraintPosition position = constraint2.component4();
                        kotlinType = ConstraintSystemImpl.satisfyInitialConstraints$substitute(subtype, substitutor2);
                        if (kotlinType == null) break block11;
                        KotlinType it = kotlinType;
                        boolean bl4 = false;
                        KotlinType kotlinType2 = position.getKind() != ConstraintPositionKind.RECEIVER_POSITION ? it : TypeUtilsKt.makeNotNullable(it);
                        kotlinType = kotlinType2;
                        if (kotlinType2 != null) break block12;
                    }
                    return false;
                }
                KotlinType resultSubType = kotlinType;
                if (ConstraintSystemImpl.satisfyInitialConstraints$substitute(superType2, substitutor2) == null) {
                    return false;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                    case 1: {
                        KotlinType resultSuperType;
                        bl2 = KotlinTypeChecker.DEFAULT.isSubtypeOf(resultSubType, resultSuperType);
                        break;
                    }
                    case 2: {
                        KotlinType resultSuperType;
                        bl2 = KotlinTypeChecker.DEFAULT.equalTypes(resultSubType, resultSuperType);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (bl2) continue;
                bl = false;
                break block9;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstraintSystem.Builder toBuilder(@NotNull Function1<? super ConstraintPosition, Boolean> filterConstraintPosition) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        TypeVariable typeParameter2;
        Intrinsics.checkNotNullParameter(filterConstraintPosition, (String)"filterConstraintPosition");
        ConstraintSystemBuilderImpl result2 = new ConstraintSystemBuilderImpl(null, 1, null);
        for (Map.Entry<TypeVariable, TypeBoundsImpl> entry : this.allTypeParameterBounds.entrySet()) {
            typeParameter2 = entry.getKey();
            TypeBoundsImpl typeBounds = entry.getValue();
            result2.getAllTypeParameterBounds$frontend().put(typeParameter2, typeBounds.filter(filterConstraintPosition));
        }
        Map<TypeVariable, List<TypeBounds.Bound>> map = this.usedInBounds;
        Cloneable cloneable2 = result2.getUsedInBounds$frontend();
        boolean $i$f$map = false;
        typeParameter2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void destination$iv;
            void $this$filterTo$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeVariable variable2 = (TypeVariable)it.getKey();
            List bounds = (List)it.getValue();
            Iterable iterable = bounds;
            Collection collection2 = new ArrayList();
            TypeVariable typeVariable2 = variable2;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                TypeBounds.Bound it2 = (TypeBounds.Bound)element$iv;
                boolean bl2 = false;
                if (!((Boolean)filterConstraintPosition.invoke((Object)it2.getPosition())).booleanValue()) continue;
                destination$iv.add(element$iv);
            }
            collection.add(TuplesKt.to((Object)typeVariable2, (Object)destination$iv));
        }
        ((HashMap)cloneable2).putAll(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
        $this$map$iv = this.errors;
        cloneable2 = result2.getErrors$frontend();
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintError)((Object)element$iv$iv);
            boolean bl = false;
            if (!((Boolean)filterConstraintPosition.invoke((Object)((ConstraintError)it).getConstraintPosition())).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((ArrayList)cloneable2).addAll((List)destination$iv$iv);
        $this$filter$iv = this.initialConstraints;
        cloneable2 = result2.getInitialConstraints$frontend();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintSystemBuilderImpl.Constraint)((Object)element$iv$iv);
            boolean bl = false;
            if (!((Boolean)filterConstraintPosition.invoke((Object)((ConstraintSystemBuilderImpl.Constraint)it).getPosition())).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((ArrayList)cloneable2).addAll((List)destination$iv$iv);
        ((HashMap)result2.getTypeVariableSubstitutors()).putAll(this.typeVariableSubstitutors);
        return result2;
    }

    private static final KotlinType satisfyInitialConstraints$substitute(KotlinType $this$satisfyInitialConstraints_u24substitute, TypeSubstitutor substitutor2) {
        return substitutor2.substitute($this$satisfyInitialConstraints_u24substitute, Variance.INVARIANT);
    }

    public static final /* synthetic */ boolean access$satisfyInitialConstraints(ConstraintSystemImpl $this) {
        return $this.satisfyInitialConstraints();
    }

    public static final /* synthetic */ List access$getErrors$p(ConstraintSystemImpl $this) {
        return $this.errors;
    }

    public static final /* synthetic */ Map access$getLocalTypeParameterBounds(ConstraintSystemImpl $this) {
        return $this.getLocalTypeParameterBounds();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintSystemBuilderImpl.ConstraintKind.values().length];
            try {
                nArray[ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemBuilderImpl.ConstraintKind.EQUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

