/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.one.util.streamex.EntryStream;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.RecordComponentVisitor;

class FirstPassData
implements Function<String, String> {
    private static final Logger LOG = Logger.getInstance(FirstPassData.class);
    private static final FirstPassData NO_DATA = new FirstPassData(Collections.emptyMap(), null, Collections.emptySet(), true);
    private static final FirstPassData EMPTY = new FirstPassData(Collections.emptyMap(), null, Collections.emptySet(), true);
    @NotNull
    private final Map<String, InnerClassEntry> myMap;
    @NotNull
    private final Set<String> myNonStatic;
    @NotNull
    private final Set<ObjectMethod> mySyntheticMethods;
    @Nullable
    private final String myVarArgRecordComponent;
    private final boolean myTrustInnerClasses;

    private FirstPassData(@NotNull Map<String, InnerClassEntry> map, @Nullable String component, @NotNull Set<ObjectMethod> syntheticMethods, boolean trustInnerClasses) {
        if (map == null) {
            FirstPassData.$$$reportNull$$$0(0);
        }
        if (syntheticMethods == null) {
            FirstPassData.$$$reportNull$$$0(1);
        }
        this.myMap = map;
        this.myVarArgRecordComponent = component;
        this.mySyntheticMethods = syntheticMethods;
        this.myTrustInnerClasses = trustInnerClasses;
        if (!map.isEmpty()) {
            List jvmNames = EntryStream.of(map).filterValues(e -> !e.myStatic).keys().toList();
            this.myNonStatic = ContainerUtil.map2Set(jvmNames, this::mapJvmClassNameToJava);
        } else {
            this.myNonStatic = Collections.emptySet();
        }
    }

    @Override
    @NotNull
    public String fun(@NotNull String jvmName) {
        if (jvmName == null) {
            FirstPassData.$$$reportNull$$$0(2);
        }
        String string2 = this.mapJvmClassNameToJava(jvmName);
        if (string2 == null) {
            FirstPassData.$$$reportNull$$$0(3);
        }
        return string2;
    }

    int getInnerDepth(@NotNull String javaName) {
        if (javaName == null) {
            FirstPassData.$$$reportNull$$$0(4);
        }
        int depth = 0;
        while (!javaName.isEmpty() && this.myNonStatic.contains(javaName)) {
            ++depth;
            javaName = StringUtil.getPackageName(javaName);
        }
        return depth;
    }

    boolean isVarArgComponent(@NotNull String componentName) {
        if (componentName == null) {
            FirstPassData.$$$reportNull$$$0(5);
        }
        return componentName.equals(this.myVarArgRecordComponent);
    }

    boolean isSyntheticRecordMethod(@NotNull String methodName, @NotNull String methodDesc) {
        if (methodName == null) {
            FirstPassData.$$$reportNull$$$0(6);
        }
        if (methodDesc == null) {
            FirstPassData.$$$reportNull$$$0(7);
        }
        return !this.mySyntheticMethods.isEmpty() && this.mySyntheticMethods.contains((Object)ObjectMethod.from(methodName, methodDesc));
    }

    @Contract(value="null -> null; !null -> !null")
    List<TypeInfo> createTypes(String @Nullable [] jvmNames) {
        return jvmNames == null ? null : ContainerUtil.map(jvmNames, jvmName -> new TypeInfo(this.mapJvmClassNameToJava((String)jvmName, false)));
    }

    @NotNull
    String mapJvmClassNameToJava(@NotNull String jvmName) {
        if (jvmName == null) {
            FirstPassData.$$$reportNull$$$0(8);
        }
        String string2 = this.mapJvmClassNameToJava(jvmName, true);
        if (string2 == null) {
            FirstPassData.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    String mapJvmClassNameToJava(@NotNull String jvmName, boolean useGuesser) {
        String className;
        if (jvmName == null) {
            FirstPassData.$$$reportNull$$$0(10);
        }
        if ((className = jvmName).indexOf(36) >= 0) {
            InnerClassEntry p = this.myMap.get(className);
            if (p != null) {
                className = p.myOuterName;
                if (p.myInnerName != null) {
                    className = this.mapJvmClassNameToJava(p.myOuterName) + '.' + p.myInnerName;
                    this.myMap.put(className, new InnerClassEntry(className, null, true));
                }
            } else if (useGuesser || !this.myTrustInnerClasses) {
                String string2 = StubBuildingVisitor.GUESSING_MAPPER.fun(jvmName);
                if (string2 == null) {
                    FirstPassData.$$$reportNull$$$0(11);
                }
                return string2;
            }
        }
        String string3 = className.replace('/', '.');
        if (string3 == null) {
            FirstPassData.$$$reportNull$$$0(12);
        }
        return string3;
    }

    @NotNull
    static FirstPassData create(Object classSource) {
        byte[] bytes = null;
        if (classSource instanceof ClsFileImpl.FileContentPair) {
            bytes = ((ClsFileImpl.FileContentPair)classSource).getContent();
        } else if (classSource instanceof VirtualFile) {
            try {
                bytes = ((VirtualFile)classSource).contentsToByteArray(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bytes != null) {
            return FirstPassData.fromClassBytes(bytes);
        }
        FirstPassData firstPassData = NO_DATA;
        if (firstPassData == null) {
            FirstPassData.$$$reportNull$$$0(13);
        }
        return firstPassData;
    }

    @NotNull
    private static FirstPassData fromClassBytes(byte[] classBytes) {
        Set<Object> syntheticMethods;
        class FirstPassVisitor
        extends ClassVisitor {
            final Map<String, InnerClassEntry> mapping = new HashMap<String, InnerClassEntry>();
            Set<String> varArgConstructors;
            Set<ObjectMethod> syntheticSignatures;
            StringBuilder canonicalSignature;
            String lastComponent;
            boolean trustInnerClasses = true;

            FirstPassVisitor() {
                super(589824);
            }

            @Override
            public void visit(int version2, int access, String name2, String signature, String superName, String[] interfaces) {
                if (BitUtil.isSet(access, 65536)) {
                    this.varArgConstructors = new HashSet<String>();
                    this.canonicalSignature = new StringBuilder("(");
                    this.syntheticSignatures = EnumSet.noneOf(ObjectMethod.class);
                }
            }

            @Override
            public void visitSource(String source, String debug) {
                if (source != null && StringUtil.endsWithIgnoreCase(source, ".groovy")) {
                    this.trustInnerClasses = false;
                }
                super.visitSource(source, debug);
            }

            @Override
            public RecordComponentVisitor visitRecordComponent(String name2, String descriptor, String signature) {
                if (this.isRecord()) {
                    this.canonicalSignature.append(descriptor);
                    this.lastComponent = name2;
                }
                return null;
            }

            private boolean isRecord() {
                return this.varArgConstructors != null;
            }

            @Override
            public MethodVisitor visitMethod(int access, final String name2, String descriptor, String signature, String[] exceptions) {
                if (this.isRecord()) {
                    ObjectMethod method;
                    if (name2.equals("<init>") && BitUtil.isSet(access, 128)) {
                        this.varArgConstructors.add(descriptor);
                    }
                    if ((method = ObjectMethod.from(name2, descriptor)) != null) {
                        return new MethodVisitor(589824){

                            @Override
                            public void visitInvokeDynamicInsn(String indyName, String indyDescriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                                if (indyName.equals(name2) && bootstrapMethodHandle.getName().equals("bootstrap") && bootstrapMethodHandle.getOwner().equals("java/lang/runtime/ObjectMethods")) {
                                    syntheticSignatures.add(method);
                                }
                            }
                        };
                    }
                }
                return null;
            }

            @Override
            public void visitInnerClass(String name2, String outerName, String innerName, int access) {
                if (outerName != null && innerName != null) {
                    this.mapping.put(name2, new InnerClassEntry(outerName, innerName, BitUtil.isSet(access, 8)));
                }
            }
        }
        FirstPassVisitor visitor2 = new FirstPassVisitor();
        try {
            new ClassReader(classBytes).accept(visitor2, ClsFileImpl.EMPTY_ATTRIBUTES, 4);
        }
        catch (Exception ex) {
            LOG.debug(ex);
        }
        String varArgComponent = null;
        if (visitor2.isRecord()) {
            visitor2.canonicalSignature.append(")V");
            if (visitor2.varArgConstructors.contains(visitor2.canonicalSignature.toString())) {
                varArgComponent = visitor2.lastComponent;
            }
        }
        Set<Object> set = syntheticMethods = visitor2.syntheticSignatures == null ? Collections.emptySet() : visitor2.syntheticSignatures;
        if (varArgComponent == null && visitor2.mapping.isEmpty() && syntheticMethods.isEmpty() && visitor2.trustInnerClasses) {
            FirstPassData firstPassData = EMPTY;
            if (firstPassData == null) {
                FirstPassData.$$$reportNull$$$0(14);
            }
            return firstPassData;
        }
        return new FirstPassData(visitor2.mapping, varArgComponent, syntheticMethods, visitor2.trustInnerClasses);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntheticMethods";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmName";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/FirstPassData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/FirstPassData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fun";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapJvmClassNameToJava";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fromClassBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInnerDepth";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isVarArgComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSyntheticRecordMethod";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mapJvmClassNameToJava";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ObjectMethod {
        EQUALS("equals", "(Ljava/lang/Object;)Z"),
        HASH_CODE("hashCode", "()I"),
        TO_STRING("toString", "()Ljava/lang/String;");

        @NotNull
        private final String myName;
        @NotNull
        private final String myDesc;

        private ObjectMethod(String name2, String desc) {
            if (name2 == null) {
                ObjectMethod.$$$reportNull$$$0(0);
            }
            if (desc == null) {
                ObjectMethod.$$$reportNull$$$0(1);
            }
            this.myName = name2;
            this.myDesc = desc;
        }

        @Nullable
        static ObjectMethod from(@NotNull String name2, @NotNull String desc) {
            if (name2 == null) {
                ObjectMethod.$$$reportNull$$$0(2);
            }
            if (desc == null) {
                ObjectMethod.$$$reportNull$$$0(3);
            }
            for (ObjectMethod method : ObjectMethod.values()) {
                if (!method.myName.equals(name2) || !method.myDesc.equals(desc)) continue;
                return method;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/FirstPassData$ObjectMethod";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InnerClassEntry {
        @NotNull
        final String myOuterName;
        @Nullable
        final String myInnerName;
        final boolean myStatic;

        private InnerClassEntry(@NotNull String outerName, @Nullable String innerName, boolean aStatic) {
            if (outerName == null) {
                InnerClassEntry.$$$reportNull$$$0(0);
            }
            this.myOuterName = outerName;
            this.myInnerName = innerName;
            this.myStatic = aStatic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerName", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/FirstPassData$InnerClassEntry", "<init>"));
        }
    }
}

