/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.ClsStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.SourceStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.StubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;

public class PsiJavaFileStubImpl
extends PsiFileStubImpl<PsiJavaFile>
implements PsiJavaFileStub {
    private final String myPackageName;
    private final LanguageLevel myLanguageLevel;
    private final boolean myCompiled;
    private StubPsiFactory myFactory;

    public PsiJavaFileStubImpl(String packageName2, boolean compiled) {
        this(null, packageName2, null, compiled);
    }

    public PsiJavaFileStubImpl(PsiJavaFile file2, String packageName2, LanguageLevel languageLevel, boolean compiled) {
        super(file2);
        this.myPackageName = packageName2;
        this.myLanguageLevel = languageLevel;
        this.myCompiled = compiled;
        this.myFactory = compiled ? ClsStubPsiFactory.INSTANCE : SourceStubPsiFactory.INSTANCE;
    }

    @Override
    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = JavaParserDefinition.JAVA_FILE;
        if (iStubFileElementType == null) {
            PsiJavaFileStubImpl.$$$reportNull$$$0(0);
        }
        return iStubFileElementType;
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        PsiClass[] psiClassArray = (PsiClass[])this.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            PsiJavaFileStubImpl.$$$reportNull$$$0(1);
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaModule getModule() {
        PsiJavaModuleStub moduleStub = this.findChildStubByType(JavaStubElementTypes.MODULE);
        return moduleStub != null ? (PsiJavaModule)moduleStub.getPsi() : null;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    @Override
    public boolean isCompiled() {
        return this.myCompiled;
    }

    @Override
    public StubPsiFactory getPsiFactory() {
        return this.myFactory;
    }

    @Override
    public void setPsiFactory(StubPsiFactory factory2) {
        this.myFactory = factory2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiJavaFileStubImpl stub = (PsiJavaFileStubImpl)o;
        if (this.myCompiled != stub.myCompiled) {
            return false;
        }
        if (this.myPackageName != null ? !this.myPackageName.equals(stub.myPackageName) : stub.myPackageName != null) {
            return false;
        }
        return this.myLanguageLevel == stub.myLanguageLevel;
    }

    public int hashCode() {
        int result2 = this.myPackageName != null ? this.myPackageName.hashCode() : 0;
        result2 = 31 * result2 + (this.myLanguageLevel != null ? this.myLanguageLevel.hashCode() : 0);
        result2 = 31 * result2 + (this.myCompiled ? 1 : 0);
        return result2;
    }

    @Override
    public String toString() {
        return "PsiJavaFileStub [" + this.myPackageName + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

